/*
 * Decompiled with CFR 0.152.
 */
package sampdistv3;

public class Utility {
    final int[] data = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32};
    int[] frequency = new int[33];
    int[] accum_Frequency = new int[33];
    double sum;
    double ss;
    double median_point;
    double mean;
    double median;
    double sd;
    double variance;
    double range;
    double skew;
    double kurtosis;
    int i;
    int n;

    public void setFrequency(int[] f) {
        for (int i = 0; i < 33; ++i) {
            this.frequency[i] = f[i];
        }
        this.calc_Stats();
    }

    public void calc_Stats() {
        int min = 0;
        int max = 0;
        this.i = 0;
        this.sum = 0.0;
        this.n = 0;
        this.ss = 0.0;
        while (this.i < this.frequency.length) {
            this.sum += (double)(this.data[this.i] * this.frequency[this.i]);
            this.n += this.frequency[this.i];
            this.accum_Frequency[this.i] = this.n;
            this.ss += (double)(this.data[this.i] * this.data[this.i] * this.frequency[this.i]);
            ++this.i;
        }
        this.mean = this.sum / (double)this.n;
        this.variance = (this.ss - this.sum * this.sum / (double)this.n) / (double)(this.n - 1);
        this.sd = Math.sqrt(this.variance);
        this.median_point = this.n % 2 != 0 ? (double)(this.n / 2 + 1) : (double)(this.n / 2) + 0.5;
        this.i = 0;
        while (this.i < this.frequency.length && !((double)this.accum_Frequency[this.i] >= this.median_point)) {
            ++this.i;
        }
        this.median = this.data[this.i];
        this.i = 0;
        this.skew = 0.0;
        this.kurtosis = -3.0;
        while (this.i < this.frequency.length) {
            double delta = (double)this.data[this.i] - this.mean;
            this.skew += (double)this.frequency[this.i] * delta * delta * delta / ((double)this.n * this.sd * this.sd * this.sd);
            this.kurtosis += (double)this.frequency[this.i] * delta * delta * delta * delta / ((double)this.n * this.sd * this.sd * this.sd * this.sd);
            ++this.i;
        }
        this.i = 0;
        while (this.i < 33) {
            if (this.frequency[this.i] > 0) {
                min = this.i;
                break;
            }
            ++this.i;
        }
        this.i = 32;
        while (this.i >= 0) {
            if (this.frequency[this.i] > 0) {
                max = this.i;
                break;
            }
            --this.i;
        }
        this.range = max - min;
    }

    public double get_Mean() {
        return this.mean;
    }

    public double get_Median() {
        return this.median;
    }

    public double get_Range() {
        return this.range;
    }

    public double get_SD() {
        return this.sd;
    }

    public double get_Variance() {
        return this.variance;
    }

    public double get_Skew() {
        return this.skew;
    }

    public double get_Kurtosis() {
        return this.kurtosis;
    }

    public static String format(double d, int i) {
        int n = (int)Math.pow(10.0, i);
        d = (double)Math.round(d * (double)n) / (double)n;
        String s = Double.toString(d);
        for (n = s.length() - s.indexOf(46); n < i + 1; ++n) {
            s = String.valueOf(String.valueOf(s)).concat("0");
        }
        return s;
    }

    public static double[] intlabels(double y1, double y2, int n) {
        double[] R = new double[3];
        double diff = y2 - y1;
        double x = Utility.intervals(diff, n);
        double adj = 0.0;
        R[0] = x;
        R[1] = Math.floor((y1 - adj) / x) * x;
        R[2] = Math.ceil((y2 + adj) / x) * x;
        return R;
    }

    public static double intervals(double diff, int NumCats) {
        double t3;
        int[] A = new int[4];
        double[] T = new double[4];
        T[3] = t3 = Math.pow(10.0, Math.floor(Math.log(diff) * 0.4342945));
        T[2] = t3 / (double)2;
        T[1] = t3 / (double)5;
        T[0] = t3 / (double)10;
        for (int i = 0; i < 4; ++i) {
            A[i] = (int)(Math.floor(diff / T[i]) + 1.0);
        }
        int D = Math.abs(NumCats - A[0]);
        int IN = 0;
        for (int i = 1; i < 4; ++i) {
            int X;
            if (A[i] > 25 || A[i] <= 2 || (X = Math.abs(NumCats - A[i])) >= D) continue;
            D = X;
            IN = i;
        }
        return T[IN];
    }

    public static double getMean(int[] data, int size) {
        int sum = 0;
        for (int i = 0; i < size; ++i) {
            sum += data[i];
        }
        return (double)sum / (double)size;
    }

    public static double getMedian(int[] _data, int size) {
        int i;
        int[] data = new int[25];
        for (i = 0; i < size; ++i) {
            data[i] = _data[i];
        }
        for (i = 0; i < size - 1; ++i) {
            for (int j = i + 1; j < size; ++j) {
                if (data[i] <= data[j]) continue;
                int temp = data[j];
                data[j] = data[i];
                data[i] = temp;
            }
        }
        if (size % 2 == 0) {
            return (data[size / 2] + data[size / 2 - 1]) / 2;
        }
        return data[size / 2];
    }

    public static double getRange(int[] data, int size) {
        int max = data[0];
        int min = data[0];
        for (int i = 1; i < size; ++i) {
            if (data[i] > max) {
                max = data[i];
                continue;
            }
            if (data[i] >= min) continue;
            min = data[i];
        }
        return max - min;
    }

    public static double getVariance(int[] data, int size) {
        int sum = 0;
        int ss = 0;
        for (int i = 0; i < size; ++i) {
            sum += data[i];
            ss += data[i] * data[i];
        }
        return ((double)ss - (double)sum * (double)sum / (double)size) / (double)(size - 1);
    }
}

