/*
 * Decompiled with CFR 0.152.
 */
package sampdistv3;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import sampdistv3.Ball1;
import sampdistv3.Notify2;
import sampdistv3.Utility;
import sampdistv3.histogram;
import sampdistv3.sampDist;

public class distribution
extends histogram
implements Notify2 {
    int animData = 0;
    int n = 0;
    double mean = 0.0;
    double sd = 0.0;
    double skew = 0.0;
    double kurtosis = 0.0;
    String statistics = "mean";
    sampDist theApp;
    int id;
    Ball1 b;
    int Xdivider = 460;
    boolean XdividerSelected = false;

    public distribution() {
        this.labelY = true;
        this.foreground = Color.blue;
    }

    void MousePressed(MouseEvent event) {
        int x = event.getX() - this.Xdivider;
        int y = event.getY() - 30;
        if (x >= 0 && x <= 3 && y >= 0 && y <= 70 && this.dataAvailable) {
            this.XdividerSelected = true;
        }
    }

    void MouseDragged(MouseEvent event) {
        int x = event.getX();
        if (x < 130) {
            x = 130;
        } else if (x > 460) {
            x = 460;
        }
        if (this.XdividerSelected) {
            Graphics g = this.getGraphics();
            g.setXORMode(this.getBackground());
            g.fillRect(this.Xdivider, 30, 3, 70);
            g.fillRect(x, 30, 3, 70);
            this.Xdivider = x;
        }
    }

    void MouseReleased(MouseEvent event) {
        if (this.XdividerSelected) {
            this.repaint();
            this.XdividerSelected = false;
        }
    }

    public void setApp(sampDist _theApp) {
        this.theApp = _theApp;
    }

    public void setId(int _id) {
        this.id = _id;
    }

    public void setData(int[] _data) {
        super.setData(_data);
    }

    public void setAnimationData(int i) {
        this.animData = i;
    }

    public void setStats(int _n, double _mean, double _sd, double _skew, double _kurtosis) {
        this.n = _n;
        this.mean = _mean;
        this.sd = _sd;
        this.skew = _skew;
        this.kurtosis = _kurtosis;
        super.setStats(this.mean, this.sd);
        super.setTotal(_n);
    }

    public void setStatistics(String s) {
        this.statistics = s;
    }

    public void reset() {
        if (this.b != null && this.b.isAlive()) {
            this.b.stop();
        }
        this.Xdivider = 460;
        this.maxBinHeight = 5;
        this.setDataAvailable(false);
        this.repaint();
    }

    public void runAnimation() {
        this.b = new Ball1(this);
        this.b.setForeground(this.foreground);
        this.b.setDistribution(this);
        this.b.start();
    }

    public void animComplete() {
        this.dataAvailable = true;
        this.repaint();
        this.theApp.distComplete(this.id);
    }

    double getLeftArea(int x) {
        double pctg;
        if ((x = (x - 130) / 10) == 0) {
            pctg = 0.0;
        } else if (x >= 32) {
            pctg = 100.0;
        } else {
            int i;
            int sum = 0;
            for (i = 0; i < x; ++i) {
                sum += this.data[i];
            }
            pctg = (double)(sum += this.data[i] / 2) / (double)this.n * (double)100;
        }
        return pctg;
    }

    public void paint(Graphics g) {
        Image offscreenImg = this.createImage(this.getSize().width, this.getSize().height);
        Graphics offscreenG = offscreenImg.getGraphics();
        super.paint(offscreenG);
        if (this.dataAvailable) {
            int y = 32;
            offscreenG.setFont(new Font("Times", 0, 11));
            FontMetrics fm = offscreenG.getFontMetrics();
            offscreenG.setColor(Color.black);
            offscreenG.drawString("Reps=", 10, y);
            String s = Integer.toString(this.n);
            int x = 85 - fm.stringWidth(s);
            offscreenG.drawString(s, x, y);
            offscreenG.setColor(Color.blue);
            offscreenG.drawString(String.valueOf(String.valueOf(this.statistics)).concat("="), 10, y += 16);
            s = Utility.format(this.mean, 2);
            x = 85 - fm.stringWidth(s);
            offscreenG.drawString(s, x, y);
            offscreenG.setColor(Color.red);
            offscreenG.drawString("sd=", 10, y += 16);
            s = Utility.format(this.sd, 2);
            x = 85 - fm.stringWidth(s);
            offscreenG.drawString(s, x, y);
            offscreenG.setColor(Color.black);
            offscreenG.drawString("skew=", 10, y += 16);
            s = Utility.format(this.skew, 2);
            x = 85 - fm.stringWidth(s);
            offscreenG.drawString(s, x, y);
            offscreenG.setColor(Color.darkGray);
            offscreenG.drawString("kurtosis=", 10, y += 16);
            s = Utility.format(this.kurtosis, 2);
            x = 85 - fm.stringWidth(s);
            offscreenG.drawString(s, x, y);
        }
        g.drawImage(offscreenImg, 0, 0, this);
        offscreenG.dispose();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    class SymMouseMotion
    extends MouseMotionAdapter {
        SymMouseMotion() {
        }

        public void mouseDragged(MouseEvent event) {
            Object object = event.getSource();
            if (object == distribution.this) {
                distribution.this.MouseDragged(event);
            }
        }
    }

    class SymMouse
    extends MouseAdapter {
        SymMouse() {
        }

        public void mouseReleased(MouseEvent event) {
            Object object = event.getSource();
            if (object == distribution.this) {
                distribution.this.MouseReleased(event);
            }
        }

        public void mousePressed(MouseEvent event) {
            Object object = event.getSource();
            if (object == distribution.this) {
                distribution.this.MousePressed(event);
            }
        }
    }
}

