/*
 * Decompiled with CFR 0.152.
 */
package sampdistv3;

import java.applet.Applet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import sampdistv3.Message;
import sampdistv3.Notify1;
import sampdistv3.Utility;
import sampdistv3.distribution;
import sampdistv3.population;
import sampdistv3.sample;
import symantec.itools.util.Timer;

public class sampDist
extends Applet
implements Notify1 {
    Timer timer1;
    Checkbox fitNormal;
    Label label2;
    Label label7;
    Label label6;
    Label label5;
    Button button5;
    Button button3;
    Button button2;
    Choice choice5;
    Choice choice4;
    Label label4;
    Choice choice3;
    Choice choice2;
    Label label3;
    Label label1;
    Choice choice1;
    population population1;
    sample sample1;
    distribution distribution1;
    distribution distribution2;
    int pop_id = 0;
    int xScale = 32;
    int maxBinHeight = 5;
    int[] stat_selection = new int[]{1, 1};
    int[] size_selection = new int[]{2, 10};
    int[] dist1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    int[] dist2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    int[] reps = new int[]{0, 0};
    double[] reps_stat = new double[]{0.0, 0.0};
    double[] reps_sd = new double[]{0.0, 0.0};
    double[] reps_skew = new double[]{0.0, 0.0};
    double[] reps_kurtosis = new double[]{0.0, 0.0};
    double[] sum = new double[]{0.0, 0.0};
    double[] sumOfSquares = new double[]{0.0, 0.0};
    double[] S_Sum = new double[]{0.0, 0.0};
    double[] K_Sum = new double[]{0.0, 0.0};
    final double[] mu = new double[]{16.0, 16.0, 9.79, 0.0};
    final double[] sigma = new double[]{9.52, 5.0, 6.82, 0.0};
    double[] stat_value = new double[2];
    int[][] sampleData = new int[2][25];
    boolean inSim = false;

    public void init() {
        this.setLayout(null);
        this.setSize(600, 465);
        this.setFont(new Font("Times", 0, 12));
        this.setBackground(new Color(-3129));
        this.timer1 = new Timer(1000, true);
        this.fitNormal = new Checkbox("Fit normal");
        this.fitNormal.setVisible(false);
        this.fitNormal.setBounds(485, 205, 100, 20);
        this.add(this.fitNormal);
        this.label2 = new Label("Statistic:");
        this.label2.setVisible(false);
        this.label2.setBounds(486, 335, 100, 20);
        this.add(this.label2);
        this.label7 = new Label("Statistic: Mean");
        this.label7.setBounds(486, 185, 93, 20);
        this.add(this.label7);
        this.label6 = new Label("Sample Size:");
        this.label6.setBounds(485, 380, 100, 20);
        this.add(this.label6);
        this.label5 = new Label("Sample size:");
        this.label5.setBounds(486, 230, 100, 20);
        this.add(this.label5);
        this.button5 = new Button();
        this.button5.setLabel("10000 Samples");
        this.button5.setBounds(486, 85, 100, 20);
        this.button5.setFont(new Font("Times", 0, 12));
        this.add(this.button5);
        this.button3 = new Button();
        this.button3.setLabel("5 Samples");
        this.button3.setBounds(486, 60, 100, 20);
        this.button3.setFont(new Font("Times", 0, 12));
        this.add(this.button3);
        this.button2 = new Button();
        this.button2.setLabel("Reset");
        this.button2.setBounds(486, 110, 100, 20);
        this.button2.setFont(new Font("Times", 0, 12));
        this.add(this.button2);
        this.choice5 = new Choice();
        this.choice5.addItem("None");
        this.choice5.addItem("Mean");
        this.choice5.addItem("Median");
        this.choice5.addItem("Range");
        this.choice5.setVisible(false);
        this.add(this.choice5);
        this.choice5.setBounds(484, 355, 100, 20);
        this.choice5.setFont(new Font("Times", 0, 12));
        this.choice4 = new Choice();
        this.choice4.addItem("Mean");
        this.choice4.addItem("Median");
        this.choice4.setVisible(false);
        this.add(this.choice4);
        this.choice4.setBounds(486, 185, 100, 20);
        this.choice4.setFont(new Font("Times", 0, 12));
        this.label4 = new Label("Distribution of Sample Mean, N=10");
        this.label4.setBounds(130, 325, 200, 20);
        this.add(this.label4);
        this.choice3 = new Choice();
        this.choice3.addItem("N=1");
        this.choice3.addItem("N=2");
        this.choice3.addItem("N=5");
        this.choice3.addItem("N=10");
        this.choice3.addItem("N=15");
        this.choice3.addItem("N=25");
        try {
            this.choice3.select(3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.add(this.choice3);
        this.choice3.setBounds(485, 400, 100, 20);
        this.choice3.setFont(new Font("Times", 0, 12));
        this.choice2 = new Choice();
        this.choice2.addItem("N=1");
        this.choice2.addItem("N=2");
        this.choice2.addItem("N=5");
        this.choice2.addItem("N=10");
        this.choice2.addItem("N=15");
        this.choice2.addItem("N=25");
        try {
            this.choice2.select(1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.add(this.choice2);
        this.choice2.setBounds(486, 250, 100, 20);
        this.choice2.setFont(new Font("Times", 0, 12));
        this.label3 = new Label("Distribution of Sample Mean, N=2");
        this.label3.setBounds(130, 175, 200, 20);
        this.add(this.label3);
        this.label1 = new Label("Population");
        this.label1.setBounds(130, 25, 280, 18);
        this.add(this.label1);
        this.choice1 = new Choice();
        this.choice1.addItem("Uniform");
        this.choice1.addItem("Normal");
        this.choice1.addItem("Skewed");
        this.choice1.addItem("Custom");
        this.add(this.choice1);
        this.choice1.setBounds(486, 35, 100, 20);
        this.choice1.setFont(new Font("Times", 0, 12));
        SymItem lSymItem = new SymItem();
        this.choice1.addItemListener(lSymItem);
        SymAction lSymAction = new SymAction();
        this.choice2.addItemListener(lSymItem);
        this.choice3.addItemListener(lSymItem);
        this.choice4.addItemListener(lSymItem);
        this.choice5.addItemListener(lSymItem);
        this.button2.addActionListener(lSymAction);
        this.button3.addActionListener(lSymAction);
        this.button5.addActionListener(lSymAction);
        this.timer1.addActionListener(lSymAction);
        this.fitNormal.addItemListener(lSymItem);
        this.population1 = new population();
        this.population1.setBounds(0, 40, 480, 140);
        this.add(this.population1);
        this.population1.setApp(this);
        this.distribution1 = new distribution();
        this.distribution1.setBounds(0, 190, 480, 140);
        this.add(this.distribution1);
        this.distribution1.setApp(this);
        this.distribution1.setId(0);
        this.distribution2 = new distribution();
        this.distribution2.setBounds(0, 340, 480, 140);
        this.add(this.distribution2);
        this.distribution2.setApp(this);
        this.distribution2.setId(1);
        this.population1.setData(0);
        this.population1.repaint();
    }

    void repeatSampling(int num) {
        double stat = 0.0;
        double[] localSum = new double[]{0.0, 0.0};
        double[] localSumOfSquares = new double[]{0.0, 0.0};
        double[] localS_Sum = new double[]{0.0, 0.0};
        double[] localK_Sum = new double[]{0.0, 0.0};
        boolean xMaximum = false;
        for (int i = 0; i < num; ++i) {
            int id = 0;
            do {
                double r;
                this.sampleData[id] = id == 1 && this.size_selection[id] == this.size_selection[id - 1] ? this.sampleData[id - 1] : this.population1.getSampleData(this.size_selection[id]);
                switch (this.stat_selection[id]) {
                    case 1: {
                        stat = Utility.getMean(this.sampleData[id], this.size_selection[id]);
                        break;
                    }
                    case 2: {
                        stat = Utility.getMedian(this.sampleData[id], this.size_selection[id]);
                        break;
                    }
                    case 3: {
                        stat = Utility.getRange(this.sampleData[id], this.size_selection[id]);
                        break;
                    }
                    case 4: {
                        stat = Utility.getVariance(this.sampleData[id], this.size_selection[id]);
                        break;
                    }
                    default: {
                        System.out.println("statistics choice out of range");
                        break;
                    }
                }
                int temp = (int)(stat / (double)(this.xScale / 32)) * (this.xScale / 32);
                int result = stat - (double)temp < 0.5 * (double)this.xScale / (double)32 ? (int)(stat / (double)(this.xScale / 32)) : (stat - (double)temp > 0.5 * (double)this.xScale / (double)32 ? (int)(stat / (double)(this.xScale / 32)) + 1 : ((r = Math.random() * (double)10) >= 5.0 ? (int)(stat / (double)(this.xScale / 32)) : (int)(stat / (double)(this.xScale / 32)) + 1));
                if (result <= 32) {
                    if (id == 0) {
                        int n = result;
                        this.dist1[n] = this.dist1[n] + 1;
                    } else {
                        int n = result;
                        this.dist2[n] = this.dist2[n] + 1;
                    }
                }
                int n = id;
                localSum[n] = localSum[n] + stat;
                int n2 = id;
                localSumOfSquares[n2] = localSumOfSquares[n2] + stat * stat;
                int n3 = id;
                localS_Sum[n3] = localS_Sum[n3] + Math.pow(stat - this.mu[this.pop_id], 3.0);
                int n4 = id++;
                localK_Sum[n4] = localK_Sum[n4] + Math.pow(stat - this.mu[this.pop_id], 4.0);
            } while (id < 2 && this.stat_selection[id] > 0);
        }
        this.updateStat(0, localSum[0], localSumOfSquares[0], localS_Sum[0], localK_Sum[0], num);
        if (this.stat_selection[1] > 0) {
            this.updateStat(1, localSum[1], localSumOfSquares[1], localS_Sum[1], localK_Sum[1], num);
        }
        if (this.stat_selection[1] == 0) {
            int max = this.getMaxFreq(this.dist1);
            if (max >= this.maxBinHeight) {
                this.maxBinHeight = (int)Math.ceil((double)(max + 1) / (double)5) * 5;
                this.distribution1.setMaxBinHeight(this.maxBinHeight);
            }
            this.distribution1.setStats(this.reps[0], this.reps_stat[0], this.reps_sd[0], this.reps_skew[0], this.reps_kurtosis[0]);
            this.distribution1.setData(this.dist1);
            this.distribution1.setDataAvailable(true);
            this.distribution1.repaint();
        } else {
            int max2;
            int max;
            int max1 = this.getMaxFreq(this.dist1);
            int n = max = max1 > (max2 = this.getMaxFreq(this.dist2)) ? max1 : max2;
            if (max >= this.maxBinHeight) {
                this.maxBinHeight = (int)Math.ceil((double)(max + 1) / (double)5) * 5;
                this.distribution1.setMaxBinHeight(this.maxBinHeight);
                this.distribution2.setMaxBinHeight(this.maxBinHeight);
            }
            this.distribution1.setStats(this.reps[0], this.reps_stat[0], this.reps_sd[0], this.reps_skew[0], this.reps_kurtosis[0]);
            this.distribution1.setData(this.dist1);
            this.distribution1.setDataAvailable(true);
            this.distribution1.repaint();
            this.distribution2.setStats(this.reps[1], this.reps_stat[1], this.reps_sd[1], this.reps_skew[1], this.reps_kurtosis[1]);
            this.distribution2.setData(this.dist2);
            this.distribution2.setDataAvailable(true);
            this.distribution2.repaint();
        }
    }

    int getMaxFreq(int[] d) {
        int max = 0;
        for (int i = 0; i < 33; ++i) {
            if (d[i] <= max) continue;
            max = d[i];
        }
        return max;
    }

    void updateStat(int i, double new_sum, double new_sumOfSquares, double new_S_Sum, double new_K_Sum, int new_size) {
        int n = i;
        this.sum[n] = this.sum[n] + new_sum;
        int n2 = i;
        this.sumOfSquares[n2] = this.sumOfSquares[n2] + new_sumOfSquares;
        int n3 = i;
        this.S_Sum[n3] = this.S_Sum[n3] + new_S_Sum;
        int n4 = i;
        this.K_Sum[n4] = this.K_Sum[n4] + new_K_Sum;
        int n5 = i;
        this.reps[n5] = this.reps[n5] + new_size;
        this.reps_stat[i] = this.sum[i] / (double)this.reps[i];
        this.reps_sd[i] = this.reps[i] == 1 ? 0.0 : Math.sqrt((this.sumOfSquares[i] - this.sum[i] * this.sum[i] / (double)this.reps[i]) / (double)(this.reps[i] - 1));
        double temp = this.sigma[this.pop_id] / Math.sqrt(this.size_selection[i]);
        this.reps_skew[i] = this.S_Sum[i] / ((double)this.reps[i] * Math.pow(temp, 3.0));
        this.reps_kurtosis[i] = this.K_Sum[i] / ((double)this.reps[i] * Math.pow(temp, 4.0)) - (double)3;
    }

    boolean dataExist() {
        boolean b = false;
        if (this.population1.dataAvailable) {
            b = true;
        } else {
            Message message1 = new Message();
            ((Component)message1).setBounds(180, 100, 260, 160);
            ((Component)message1).setVisible(true);
        }
        return b;
    }

    void animStart(int id, boolean showAni) {
        String stat = "";
        switch (this.stat_selection[id]) {
            case 1: {
                stat = "mean";
                break;
            }
            case 2: {
                stat = "median";
                break;
            }
            case 3: {
                stat = "range";
                break;
            }
            case 4: {
                stat = "variance";
                break;
            }
            default: {
                System.out.println("out of range in animStart()");
            }
        }
        if (showAni) {
            this.sample1.reset();
            this.sample1.setProcId(id);
            this.sample1.setSampleData(this.size_selection[id], this.sampleData[id]);
            this.sample1.setSampleStat(stat, Utility.format(this.stat_value[id], 2));
            this.sample1.runAnimation();
        } else {
            this.sample1.setSampleStat(stat, Utility.format(this.stat_value[id], 2));
            this.sample1.repaint();
        }
    }

    public void animComplete(int id) {
        if (id == 0) {
            this.distribution1.setStats(this.reps[0], this.reps_stat[0], this.reps_sd[0], this.reps_skew[0], this.reps_kurtosis[0]);
            this.distribution1.setData(this.dist1);
            this.distribution1.runAnimation();
        } else {
            this.distribution2.setStats(this.reps[1], this.reps_stat[1], this.reps_sd[1], this.reps_skew[1], this.reps_kurtosis[1]);
            this.distribution2.setData(this.dist2);
            this.distribution2.runAnimation();
        }
    }

    public void distComplete(int id) {
        if (id == 0 && this.stat_selection[1] != 0) {
            if (this.size_selection[0] != this.size_selection[1]) {
                this.animStart(1, true);
            }
        } else {
            this.inSim = false;
        }
    }

    void reset() {
        int i;
        this.distribution1.reset();
        this.distribution2.reset();
        this.inSim = false;
        this.maxBinHeight = 5;
        for (i = 0; i < 33; ++i) {
            this.dist1[i] = 0;
            this.dist2[i] = 0;
        }
        for (i = 0; i < 2; ++i) {
            this.reps[i] = 0;
            this.sum[i] = 0.0;
            this.sumOfSquares[i] = 0.0;
            this.S_Sum[i] = 0.0;
            this.K_Sum[i] = 0.0;
        }
    }

    void choice1_ItemStateChanged(ItemEvent event) {
        try {
            this.pop_id = this.choice1.getSelectedIndex();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.population1.setData(this.pop_id);
        this.population1.repaint();
        if (this.pop_id < 3) {
            this.label1.setText("Population");
        } else {
            this.label1.setText("Population (click and drag with mouse to construct)");
        }
        this.changeXScope();
        this.reset();
    }

    void choice2_ItemStateChanged(ItemEvent event) {
        int[] presetSize = new int[]{1, 2, 5, 10, 15, 25};
        int i = 0;
        try {
            i = this.choice2.getSelectedIndex();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.size_selection[0] = presetSize[i];
        String temp = this.label3.getText();
        int m = temp.indexOf("N=");
        temp = temp.substring(0, m);
        this.label3.setText(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(temp))).append("N=").append(this.size_selection[0]))));
        this.reset();
    }

    void choice3_ItemStateChanged(ItemEvent event) {
        int[] presetSize = new int[]{1, 2, 5, 10, 15, 25};
        int i = 0;
        try {
            i = this.choice3.getSelectedIndex();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (presetSize[i] == 0) {
            this.stat_selection[1] = 0;
            this.label4.setText("");
        } else {
            this.stat_selection[1] = 1;
            this.size_selection[1] = presetSize[i];
            this.label4.setText("Distribution of Sample Mean, N=".concat(String.valueOf(String.valueOf(this.size_selection[1]))));
        }
        this.reset();
    }

    void changeXScope() {
        if (this.choice4.getSelectedItem().compareTo("Variance") == 0) {
            if (this.choice1.getSelectedItem().compareTo("Uniform") == 0) {
                this.xScale = 256;
            } else if (this.choice1.getSelectedItem().compareTo("Normal") == 0) {
                this.xScale = 128;
            }
        } else {
            this.xScale = 32;
        }
        this.distribution1.setXScale(this.xScale);
        this.distribution1.repaint();
    }

    void choice4_ItemStateChanged(ItemEvent event) {
        int i = 0;
        try {
            i = this.choice4.getSelectedIndex();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.stat_selection[0] = i + 1;
        this.label3.setText(String.valueOf(String.valueOf(new StringBuffer("Distribution of Sample ").append(this.choice4.getSelectedItem()).append(", ").append(this.choice2.getSelectedItem()))));
        this.stat_selection[1] = i + 1;
        this.label4.setText(String.valueOf(String.valueOf(new StringBuffer("Distribution of Sample ").append(this.choice4.getSelectedItem()).append(", ").append(this.choice3.getSelectedItem()))));
        this.changeXScope();
        this.reset();
    }

    void button2_ActionPerformed(ActionEvent event) {
        this.reset();
    }

    void button3_ActionPerformed(ActionEvent event) {
        if (this.dataExist() && !this.inSim) {
            this.repeatSampling(5);
        }
    }

    void button5_ActionPerformed(ActionEvent event) {
        if (this.dataExist() && !this.inSim) {
            this.repeatSampling(10000);
        }
    }

    void fitNormal_ItemStateChanged(ItemEvent event) {
        this.distribution1.setFitNormal(this.fitNormal.getState());
        this.distribution2.setFitNormal(this.fitNormal.getState());
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == sampDist.this.button2) {
                sampDist.this.button2_ActionPerformed(event);
            } else if (object == sampDist.this.button3) {
                sampDist.this.button3_ActionPerformed(event);
            }
            if (object == sampDist.this.button5) {
                sampDist.this.button5_ActionPerformed(event);
            }
        }
    }

    class SymItem
    implements ItemListener {
        SymItem() {
        }

        public void itemStateChanged(ItemEvent event) {
            Object object = event.getSource();
            if (object == sampDist.this.choice1) {
                sampDist.this.choice1_ItemStateChanged(event);
            } else if (object == sampDist.this.choice2) {
                sampDist.this.choice2_ItemStateChanged(event);
            } else if (object == sampDist.this.choice3) {
                sampDist.this.choice3_ItemStateChanged(event);
            } else if (object == sampDist.this.choice4) {
                sampDist.this.choice4_ItemStateChanged(event);
            } else if (object == sampDist.this.fitNormal) {
                sampDist.this.fitNormal_ItemStateChanged(event);
            }
        }
    }
}

