/*
 * Decompiled with CFR 0.152.
 */
package qqgraph;

import RVLS.Sort;

public class desc {
    public double min;
    public double max;
    public double p25;
    public double p50;
    public double p75;
    public double mean;
    public double sd;
    public double sem;
    public double skew;
    public double kurt;
    public double triMean;
    public double adjacentLow;
    public double adjacentHigh;
    public int n;
    public String name = " ";

    public desc() {
    }

    public desc(double[] x, String name) {
        this(x);
        this.name = name;
    }

    public double[] getStats() {
        double[] r = new double[]{this.n, this.mean, this.p50, this.triMean, this.min, this.max, this.p25, this.p75, this.adjacentLow, this.adjacentHigh, this.sd, this.sem, this.skew, this.kurt};
        return r;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public desc(double[] x) {
        int i;
        int i2;
        Sort.sort(x);
        this.n = x.length;
        this.p50 = this.percentile(0.5, x);
        this.p25 = this.percentile(0.25, x);
        this.p75 = this.percentile(0.75, x);
        this.min = x[0];
        this.max = x[this.n - 1];
        this.mean = 0.0;
        this.sd = 0.0;
        this.skew = 0.0;
        this.kurt = 0.0;
        for (i2 = 0; i2 < this.n; ++i2) {
            this.mean += x[i2];
        }
        this.mean /= (double)this.n;
        for (i2 = 0; i2 < this.n; ++i2) {
            double d = x[i2] - this.mean;
            double dsq = d * d;
            this.sd += dsq;
            this.skew += dsq * d;
            this.kurt += dsq * dsq;
        }
        this.sd = Math.sqrt(this.sd / (double)(this.n - 1));
        this.sem = this.sd / Math.sqrt(this.n);
        this.skew = this.skew / (this.sd * this.sd * this.sd) * (double)this.n / (double)((this.n - 1) * (this.n - 2));
        this.kurt /= this.sd * this.sd * this.sd * this.sd;
        double rat1 = (double)(this.n * (this.n + 1)) / (double)((this.n - 2) * (this.n - 3));
        this.kurt = this.kurt * rat1 / (double)(this.n - 1) - 3.0 * (double)(this.n - 1) * (double)(this.n - 1) / ((double)(this.n - 2) * (double)(this.n - 3));
        this.triMean = (this.p25 + (double)2 * this.p50 + this.p75) / (double)4;
        double step = 1.5 * (this.p75 - this.p25);
        for (i = 0; i < this.n; ++i) {
            if (!(x[i] >= this.p25 - step)) continue;
            this.adjacentLow = x[i];
            break;
        }
        for (i = this.n - 1; i > 0; --i) {
            if (!(x[i] <= this.p75 + step)) continue;
            this.adjacentHigh = x[i];
            break;
        }
    }

    public double percentile(double p, double[] x) {
        double R = p * (double)(this.n + 1);
        int IR = (int)Math.floor(R);
        double ptl = x[IR - 1] + (R - (double)IR) * (x[IR] - x[IR - 1]);
        return ptl;
    }
}

