/*
 * Decompiled with CFR 0.152.
 */
package qqgraph;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

public class hist
extends Canvas {
    public boolean frame = true;
    protected int gap;
    protected boolean clickable;
    protected boolean drawYaxis = true;
    protected String title;
    protected int numSamples;
    protected double fmax;
    protected Color color;
    public int[] f;
    public int yinc;
    final int yoffset = 30;
    public final int yoffset2 = 16;
    public int xoffset = 20;
    public int offset2 = 0;
    public int rightMargin = 10;
    public int[] fdata;
    public int[] mRect;
    public int yintervals;
    public int xaxisDec = 0;
    public int rWidth;
    public int theBin;
    public int width;
    public int numInt;
    public int rHeight;
    public int inter;
    public double fmin;
    public double sp2v;
    public double sv2p;
    public double ip2v;
    public double iv2p;
    float[] xdata;
    boolean top;
    boolean labelXaxis;
    boolean endsOnly;
    boolean autoRepaint = true;
    Font font;
    Font fontN;
    Label testlabel;

    public hist() {
        int nn = 5;
        float[] xxdata = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f};
        int[] data = new int[]{1, 2, 3, 2, 1};
        String _title = "";
        int _yintervals = 5;
        boolean yticks = true;
        this.endsOnly = false;
        int _rWidth = 200;
        int _rHeight = 100;
        boolean _clickable = false;
        boolean _labelXaxis = true;
        int _gap = 0;
        this.color = Color.black;
        this.initialize(_title, xxdata, data, nn, yticks, _rWidth, _rHeight, _yintervals, _clickable, _labelXaxis, _gap);
        SymMouseMotion aSymMouseMotion = new SymMouseMotion();
        this.addMouseMotionListener(aSymMouseMotion);
        SymMouse aSymMouse = new SymMouse();
        this.addMouseListener(aSymMouse);
    }

    public void setClickable(boolean clickable) {
        this.clickable = clickable;
    }

    public boolean isClickable() {
        return this.clickable;
    }

    public void setGap(int gap) {
        this.gap = gap;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public int getGap() {
        return this.gap;
    }

    public void setEndsOnly(boolean endsOnly) {
        this.endsOnly = endsOnly;
    }

    public boolean getEndsOnly() {
        return this.endsOnly;
    }

    public void setXaxisDec(int xaxisDec) {
        this.xaxisDec = xaxisDec;
    }

    public int getXaxisDec() {
        return this.xaxisDec;
    }

    public void setTitle(String title) {
        this.title = title;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setNumSamples(int numSamples) {
        this.numSamples = numSamples;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setAutoRepaint(boolean autoRepaint) {
        this.autoRepaint = autoRepaint;
    }

    public boolean getAutoRepaint() {
        return this.autoRepaint;
    }

    public boolean getDrawYaxis() {
        return this.drawYaxis;
    }

    public void setDrawYaxis(boolean drawYaxis) {
        this.drawYaxis = drawYaxis;
    }

    public void setFrame(boolean frame) {
        this.frame = frame;
    }

    public boolean getFrame() {
        return this.frame;
    }

    public void setFreq(int[] _f) {
        this.setData(_f, _f.length, false);
    }

    public int[] getFreq() {
        return this.fdata;
    }

    public void setFmax(double fmax) {
        this.fmax = fmax;
        this.yintervals = (int)fmax;
        this.setSlopes();
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void clear() {
        for (int i = 0; i < this.numInt; ++i) {
            this.fdata[i] = 0;
        }
        this.setData(this.fdata, this.numInt, false);
        this.numSamples = 0;
    }

    public void setFmaxClear(int Fmax) {
        int i;
        for (i = 0; i < this.numInt; ++i) {
            this.fdata[i] = 0;
        }
        for (i = 0; i < this.numInt; ++i) {
            this.f[i] = (int)Math.round(this.sv2p * (double)this.fdata[i] + this.iv2p);
        }
        this.fmax = Fmax;
        this.fmin = 0.0;
        this.setSlopes();
        this.repaint();
    }

    public double getFmax() {
        return this.fmax;
    }

    public void setData(float[] _xdata) {
        this.setMidPoints(_xdata);
    }

    public void setData(int[] data, int nn, boolean add) {
        int i;
        if (this.numInt != nn) {
            this.newNumInt(nn);
        }
        this.fmax = this.yintervals;
        int tmax = 0;
        for (i = 0; i < nn; ++i) {
            if (add) {
                int n = i;
                this.fdata[n] = this.fdata[n] + data[i];
            } else {
                this.fdata[i] = data[i];
            }
            if (this.fdata[i] <= tmax) continue;
            tmax = this.fdata[i];
        }
        if ((double)tmax > this.fmax) {
            this.fmax = Math.floor(tmax / this.yintervals) * (double)this.yintervals + (double)this.yintervals;
        }
        this.setSlopes();
        for (i = 0; i < this.numInt; ++i) {
            this.f[i] = (int)Math.round(this.sv2p * (double)this.fdata[i] + this.iv2p);
        }
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void setMidPoints(float[] _xdata) {
        int nn = _xdata.length;
        if (this.numInt != nn) {
            this.newNumInt(nn);
        }
        for (int i = 0; i < this.numInt; ++i) {
            this.xdata[i] = _xdata[i];
        }
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void setFreqAndMidPoints(int[] _f, float[] _xdata) {
        boolean b = this.autoRepaint;
        this.autoRepaint = false;
        this.setMidPoints(_xdata);
        this.setFreq(_f);
        this.autoRepaint = b;
        this.repaint();
    }

    void newNumInt(int nn) {
        this.numInt = nn;
        this.fdata = new int[nn];
        this.f = new int[nn];
        this.xdata = new float[nn];
        this.numInt = nn;
        Dimension d = this.getSize();
        this.rHeight = d.height - 16 - 30;
        this.width = (d.width - this.xoffset + this.offset2 - this.rightMargin) / this.numInt;
        this.setSlopes();
    }

    void initialize(String _title, float[] xxdata, int[] data, int nn, boolean yticks, int _rWidth, int _rHeight, int _yintervals, boolean _clickable, boolean _labelXaxis, int _gap) {
        this.font = new Font("TimesRoman", 0, 12);
        this.fontN = new Font("TimesRoman", 0, 9);
        this.title = _title;
        this.labelXaxis = _labelXaxis;
        this.xaxisDec = 0;
        this.clickable = _clickable;
        this.yintervals = _yintervals;
        this.numSamples = 0;
        this.top = yticks;
        this.gap = _gap;
        this.numInt = nn;
        this.f = new int[nn];
        this.mRect = new int[4];
        this.mRect[0] = 0;
        this.mRect[1] = 0;
        this.mRect[2] = this.width;
        this.mRect[3] = 0;
        this.fdata = new int[nn];
        this.xdata = new float[nn];
        this.fmin = 0.0;
        this.fmax = 0.0;
        boolean theSame = this.initDataLoop(nn, data, xxdata);
        if (this.fmax == 0.0) {
            this.fmax = this.yintervals;
        } else if (theSame) {
            this.fmax += (double)5;
        }
        if (this.fmax < (double)this.yintervals) {
            this.fmax = this.yintervals;
        }
        this.rWidth = _rWidth;
        this.width = (this.rWidth - this.xoffset + this.offset2 - this.rightMargin) / this.numInt;
        this.rHeight = _rHeight - 16 - 30;
        this.setSlopes();
    }

    boolean initDataLoop(int nn, int[] data, float[] xxdata) {
        boolean theSame = true;
        for (int i = 0; i < nn; ++i) {
            this.fdata[i] = data[i];
            this.xdata[i] = xxdata[i];
            this.fmin = Math.min(this.fmin, (double)this.fdata[i]);
            this.fmax = Math.max(this.fmax, (double)this.fdata[i]);
            this.numSamples += this.fdata[i];
            if (this.fdata[i] == this.fdata[0]) continue;
            theSame = false;
        }
        return theSame;
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.rHeight = h - 16 - 30;
        this.width = (w - this.xoffset + this.offset2 - this.rightMargin) / this.numInt;
        this.setSlopes();
    }

    void setSlopes() {
        this.sp2v = (this.fmax - this.fmin) / (double)(0 - this.rHeight);
        this.ip2v = (this.fmax + this.fmin) / (double)2 - this.sp2v * (double)(0 + this.rHeight) / (double)2;
        this.sv2p = 1.0 / this.sp2v;
        this.iv2p = (double)((0 + this.rHeight) / 2) - this.sv2p * (this.fmax + this.fmin) / (double)2;
        this.yinc = (int)Math.round(this.sv2p);
        this.yinc = -this.yinc;
        this.inter = (int)Math.round(this.iv2p) + 1;
        this.numSamples = 0;
        for (int i = 0; i < this.numInt; ++i) {
            this.numSamples += this.fdata[i];
            this.f[i] = (int)(this.sv2p * (double)this.fdata[i] + (double)this.inter);
        }
    }

    public void paint(Graphics g) {
        g.setFont(this.font);
        int x1 = this.xoffset + this.offset2 + this.gap / 2;
        int xadd = this.width + this.gap;
        g.setColor(Color.black);
        g.drawString(this.title, this.xoffset + 4, 12);
        g.setColor(this.color);
        for (int i = 0; i < this.numInt; ++i) {
            g.fillRect(x1, this.f[i] + 16, this.width, this.rHeight - this.f[i]);
            x1 += xadd;
        }
        this.drawAxes(g);
        if (this.frame) {
            g.drawRect(0, 0, this.getBounds().width - 1, this.getBounds().height - 1);
        }
    }

    public void drawAxes(Graphics g) {
        int SL;
        g.setColor(Color.black);
        g.setFont(this.font);
        FontMetrics met = g.getFontMetrics(this.font);
        FontMetrics metN = g.getFontMetrics(this.fontN);
        int h = met.getAscent();
        h /= 2;
        int x1 = this.xoffset - this.gap / 2;
        int x2 = x1 - 4;
        g.drawLine(x1 - 1, this.rHeight + 16, x1 - 1, 11);
        if (this.drawYaxis) {
            int iadd = (int)Math.round(this.fmax / (double)this.yintervals);
            double fadd = this.fmax / (double)this.yintervals;
            int topline = this.yintervals * iadd;
            int y = this.rHeight + 16;
            int tickDiff = (int)Math.rint(this.sv2p * fadd);
            boolean doAll = true;
            doAll = Math.abs(tickDiff) - 4 > met.getMaxAscent();
            if (this.top) {
                for (int i = 0; i <= this.yintervals; ++i) {
                    y = (int)Math.round((double)i * this.sv2p * fadd + (double)this.rHeight + (double)16);
                    g.setColor(Color.lightGray);
                    g.drawLine(x1 - 2, y, x2, y);
                    g.setColor(Color.black);
                    String yLabel = String.valueOf(String.valueOf(i * iadd)).concat(" ");
                    if (!doAll && i % 2 != 0) continue;
                    SL = met.stringWidth(yLabel) + 3;
                    g.drawString(yLabel, x1 - SL, y + h);
                }
            }
        }
        int xa = this.xoffset + this.offset2 + this.gap / 2;
        int xinc = this.width + this.gap;
        xa -= xinc;
        int xx = this.rHeight + 16 + 4;
        int xx2 = xx + 6;
        g.setFont(this.fontN);
        int lastXpixel = 0;
        for (int i = 0; i < this.numInt; ++i) {
            double xd;
            String num;
            int adj;
            if (this.labelXaxis && (!this.endsOnly || i == 0 || i == this.numInt - 1) && (xa += xinc) + (adj = (xinc - (SL = metN.stringWidth(num = hist.format(xd = (double)this.xdata[i], this.xaxisDec)))) / 2 + 1) - 3 > lastXpixel) {
                g.drawString(num, xa + adj, xx2);
                lastXpixel = xa + adj + SL;
            }
            g.setColor(Color.lightGray);
            g.drawLine(xa, this.rHeight + 16, xa, xx);
            g.setColor(Color.black);
        }
        g.setColor(Color.lightGray);
        g.drawLine(xa += xinc, this.rHeight + 16, xa, xx);
        g.setColor(Color.black);
        g.drawLine(x1 - 1, this.rHeight + 16, xa, this.rHeight + 16);
    }

    public static String format(double X, int nd) {
        String Rstr;
        String sign = X < 0.0 ? "-" : "";
        if (nd == 0) {
            int RR = (int)Math.rint(Math.abs(X));
            Rstr = String.valueOf(String.valueOf(RR)).concat("");
        } else {
            double xx = Math.pow(10.0, nd);
            int RR = (int)Math.rint(xx * Math.abs(X));
            if (RR == 0) {
                Rstr = "0.";
                for (int i = 0; i < nd; ++i) {
                    Rstr = String.valueOf(String.valueOf(Rstr)).concat("0");
                }
            } else {
                Rstr = String.valueOf(String.valueOf(RR)).concat("");
                int L = Rstr.length();
                if (L < nd) {
                    Rstr = ".";
                    for (int i = 0; i < nd - L; ++i) {
                        Rstr = String.valueOf(String.valueOf(Rstr)).concat("0");
                    }
                    Rstr = String.valueOf(String.valueOf(Rstr)).concat(String.valueOf(String.valueOf(RR)));
                } else {
                    String sa = Rstr.substring(0, L - nd);
                    String sb = Rstr.substring(L - nd);
                    Rstr = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(sa))).append(".").append(sb)));
                }
            }
        }
        if (Rstr.indexOf(".") == 0) {
            Rstr = "0".concat(String.valueOf(String.valueOf(Rstr)));
        }
        Rstr = String.valueOf(String.valueOf(sign)).concat(String.valueOf(String.valueOf(Rstr)));
        return Rstr;
    }

    public void changeDist(int x, int y) {
        int xadd = this.width + this.gap;
        Graphics g = this.getGraphics();
        g.setColor(this.color);
        int theBin = (x - this.xoffset + this.offset2 - this.gap / 2) / this.width;
        if (theBin >= 0 && theBin < this.numInt) {
            y = Math.max(y, 16);
            int ff = y - 16 + 5;
            this.fdata[theBin] = Math.max(0, (int)Math.ceil(this.sp2v * (double)ff + this.ip2v));
            this.f[theBin] = (int)((double)this.fdata[theBin] * this.sv2p + (double)this.inter);
            int x1 = this.xoffset + this.offset2 + this.gap / 2 + theBin * xadd;
            g.fillRect(x1, this.f[theBin] + 16, this.width, this.rHeight - this.f[theBin]);
            g.clearRect(x1, 16, this.width, Math.min(this.f[theBin], this.rHeight));
        }
    }

    void hist_MouseDragged(MouseEvent event) {
        if (this.clickable) {
            this.changeDist(event.getX(), event.getY());
        }
    }

    void hist_MousePressed(MouseEvent event) {
        if (this.clickable) {
            this.changeDist(event.getX(), event.getY());
        }
    }

    void hist_MouseReleased(MouseEvent event) {
        if (this.clickable) {
            this.numSamples = 0;
            for (int i = 0; i < this.numInt; ++i) {
                this.numSamples += this.fdata[i];
            }
            this.repaint();
        }
    }

    class SymMouse
    extends MouseAdapter {
        SymMouse() {
        }

        public void mouseReleased(MouseEvent event) {
            Object object = event.getSource();
            if (object == hist.this) {
                hist.this.hist_MouseReleased(event);
            }
        }

        public void mousePressed(MouseEvent event) {
            Object object = event.getSource();
            if (object == hist.this) {
                hist.this.hist_MousePressed(event);
            }
        }
    }

    class SymMouseMotion
    extends MouseMotionAdapter {
        SymMouseMotion() {
        }

        public void mouseDragged(MouseEvent event) {
            Object object = event.getSource();
            if (object == hist.this) {
                hist.this.hist_MouseDragged(event);
            }
        }
    }
}

