/*
 * Decompiled with CFR 0.152.
 */
package qqgraph;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import qqgraph.hist;
import qqgraph.modes;

public class histStat
extends hist {
    double sum = 0.0;
    double ssq = 0.0;
    double s = 0.0;
    double sq = 0.0;
    double med = 0.0;
    double range = 0.0;
    double skew = 0.0;
    double MAD = 0.0;
    double kurt = 0.0;
    modes mode;
    int N = 0;
    protected boolean[] stats = new boolean[]{true, true, true, false, false, false, false, false, false};
    protected boolean showStat = true;
    protected Color[] colors = new Color[]{Color.blue, Color.magenta, Color.red, Color.darkGray, new Color(50, 50, 50), Color.cyan, Color.magenta, new Color(50, 50, 50), Color.green};

    public histStat() {
        this.xoffset = 130;
        this.computeStats();
    }

    public double getMean() {
        return this.s;
    }

    public double getSd() {
        return this.sq;
    }

    public double getMedian() {
        return this.med;
    }

    public double getRange() {
        return this.range;
    }

    public double getSkew() {
        return this.skew;
    }

    public double getMad() {
        return this.MAD;
    }

    public modes getMode() {
        return this.mode;
    }

    boolean initDataLoop(int nn, int[] data, float[] xxdata) {
        this.sum = 0.0;
        this.ssq = 0.0;
        boolean theSame = true;
        for (int i = 0; i < nn; ++i) {
            this.fdata[i] = data[i];
            this.xdata[i] = xxdata[i];
            this.fmin = Math.min(this.fmin, (double)this.fdata[i]);
            this.fmax = Math.max(this.fmax, (double)this.fdata[i]);
            this.sum += (double)(this.xdata[i] * (float)this.fdata[i]);
            this.ssq += (double)(this.xdata[i] * this.xdata[i] * (float)this.fdata[i]);
            this.numSamples += this.fdata[i];
            if (this.fdata[i] == this.fdata[0]) continue;
            theSame = false;
        }
        return theSame;
    }

    public void setData(int[] data, int nn, boolean add, double _sum, double _ssq) {
        int i;
        if (this.numInt != nn) {
            this.newNumInt(nn);
        }
        this.fmax = this.yintervals;
        int tmax = 0;
        if (add) {
            this.sum += _sum;
            this.ssq += _ssq;
        } else {
            this.sum = _sum;
            this.ssq = _ssq;
        }
        for (i = 0; i < nn; ++i) {
            if (add) {
                int n = i;
                this.fdata[n] = this.fdata[n] + data[i];
            } else {
                this.fdata[i] = data[i];
            }
            if (this.fdata[i] <= tmax) continue;
            tmax = this.fdata[i];
        }
        if ((double)tmax > this.fmax) {
            this.fmax = Math.floor(tmax / this.yintervals) * (double)this.yintervals + (double)this.yintervals;
        }
        this.setSlopes();
        for (i = 0; i < this.numInt; ++i) {
            this.f[i] = (int)Math.round(this.sv2p * (double)this.fdata[i] + this.iv2p);
        }
        this.computeStats();
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.showStat) {
            this.plotStats(g);
        }
    }

    public void setStats(boolean stats) {
        this.showStat = stats;
        this.repaint();
    }

    public boolean isStats() {
        return this.showStat;
    }

    public void setAllStats(boolean[] s) {
        for (int i = 0; i < this.stats.length; ++i) {
            this.stats[i] = s[i];
        }
        this.computeStats();
        this.repaint();
    }

    public void setFreq(int[] _f) {
        double s = 0.0;
        double ssq = 0.0;
        for (int i = 0; i < _f.length; ++i) {
            s += (double)this.xdata[i] * (double)_f[i];
            ssq += (double)(this.xdata[i] * this.xdata[i]) * (double)_f[i];
        }
        this.setData(_f, _f.length, false, s, ssq);
    }

    public void computeStats() {
        this.s = 0.0;
        this.N = 0;
        this.sq = 0.0;
        for (int i = 0; i < this.numInt; ++i) {
            this.N += this.fdata[i];
        }
        this.s = this.sum / (double)this.numSamples;
        if (this.stats[1]) {
            this.med = this.stats[0] && this.N <= 2 ? this.s : this.ComputeGroupedMedian(this.fdata, this.numInt, this.N);
        }
        if (this.stats[2]) {
            this.sq = this.numSamples == 1 ? 0.0 : Math.sqrt((this.ssq - this.sum * this.sum / (double)this.numSamples) / (double)this.numSamples);
        }
        if (this.stats[3]) {
            this.range = this.ComputeGroupedRange(this.fdata, this.xdata, this.numInt);
        }
        if (this.stats[4]) {
            this.skew = this.ComputeSkew(this.fdata, this.xdata, this.numInt, this.s);
        }
        if (this.stats[5]) {
            this.MAD = this.ComputeMAD(this.fdata, this.xdata, this.numInt);
        }
        if (this.stats[7]) {
            this.kurt = this.ComputeKurt(this.fdata, this.xdata, this.numInt, this.s);
        }
        if (this.stats[8]) {
            this.mode = this.ComputeGroupedMode(this.fdata, this.xdata, this.numInt);
        }
    }

    public void plotStats(Graphics g) {
        block14: {
            g.setFont(this.font);
            FontMetrics met = g.getFontMetrics(this.font);
            int maxA = met.getMaxAscent() + 4;
            float xstep = this.xdata[1] - this.xdata[0];
            float pixstep = (float)(this.width + this.gap) / xstep;
            int L = 12;
            int in = 0;
            int Y = this.rHeight + 16;
            int Y1 = Y + 10;
            int Y2 = Y1 + 8;
            int xmn = this.xoffset + (int)Math.round((this.s - (double)this.xdata[0] + (double)xstep / 2.0) * (double)pixstep);
            if (this.drawYaxis) {
                String fstr = "".concat(String.valueOf(String.valueOf(this.numSamples)));
                int LL = 90 - met.stringWidth(fstr);
                g.drawString("N=", 1, L);
                g.drawString(fstr, LL, L);
                L += maxA;
            }
            if (this.numSamples <= 0) break block14;
            if (this.stats[in]) {
                this.printStat(this.s, true, xstep, pixstep, L, in, Y1, Y2, "mean=", g, met);
                L += maxA;
            }
            if (this.stats[++in]) {
                int Yx = (int)Math.round((this.med + (double)xstep / 2.0) * (double)pixstep) == (int)Math.round((this.s + (double)xstep / 2.0) * (double)pixstep) && this.stats[0] ? Y1 + 4 : Y1;
                this.printStat(this.med, true, xstep, pixstep, L, in, Yx, Y2, "median=", g, met);
                L += maxA;
            }
            if (this.stats[++in]) {
                boolean drawLine = !this.stats[0];
                int xsd = (int)Math.round(this.sq * (double)pixstep);
                g.setColor(this.colors[in]);
                if (this.sq > 0.0) {
                    g.drawLine(xmn - xsd, Y + 10, xmn + xsd, Y + 10);
                    g.drawLine(xmn - xsd, Y, xmn - xsd, Y + 10);
                    g.drawLine(xmn + xsd, Y, xmn + xsd, Y + 10);
                } else {
                    drawLine = false;
                }
                this.printStat(this.sq, drawLine, xstep, pixstep, L, in, Y1, Y2, "sd=", g, met);
                L += maxA;
            }
            if (this.stats[++in]) {
                this.printStat(this.range, false, xstep, pixstep, L, in, Y1, Y2, "range=", g, met);
                L += maxA;
            }
            if (this.stats[++in]) {
                this.printStat(this.skew, false, xstep, pixstep, L, in, Y1, Y2, "skew=", g, met);
                L += maxA;
            }
            if (this.stats[++in]) {
                this.printStat(this.MAD, false, xstep, pixstep, L, in, Y1, Y2, "MAD=", g, met);
                L += maxA;
            }
            if (this.stats[++in]) {
                double vv = this.sq * this.sq;
                this.printStat(vv, false, xstep, pixstep, L, in, Y1, Y2, "variance=", g, met);
                L += maxA;
            }
            if (this.stats[++in]) {
                this.printStat(this.kurt, false, xstep, pixstep, L, in, Y1, Y2, "kurtosis=", g, met);
                L += maxA;
            }
            if (this.stats[++in]) {
                int yx = Y1;
                int xx = (int)Math.round((this.mode.mode + (double)xstep / 2.0) * (double)pixstep);
                if (xx == (int)Math.round((this.s + (double)xstep / 2.0) * (double)pixstep) && this.stats[0]) {
                    yx = Y1 + 6;
                }
                if (xx == (int)Math.round((this.med + (double)xstep / 2.0) * (double)pixstep) && this.stats[1]) {
                    yx = Y1 + 6;
                }
                this.printStat(this.mode.mode, true, xstep, pixstep, L, in, yx, Y2, "mode=", g, met);
                L += maxA;
            }
            g.setColor(Color.darkGray);
        }
    }

    public void printStat(double stat, boolean drawLine, float xstep, float pixstep, int L, int in, int Y1, int Y2, String tstring, Graphics g, FontMetrics met) {
        g.setColor(this.colors[in]);
        int x = this.xoffset + (int)Math.round((stat - (double)this.xdata[0] + (double)xstep / 2.0) * (double)pixstep);
        String fstr = in == 8 ? (this.mode.number == 1 ? hist.format(stat, 2) : (this.mode.number == 2 ? "bimodal" : "multi")) : hist.format(stat, 2);
        String statStr = String.valueOf(String.valueOf(tstring)).concat(String.valueOf(String.valueOf(fstr)));
        if (drawLine) {
            g.drawLine(x, Y1, x, Y2);
        }
        int LL = 90 - met.stringWidth(fstr);
        g.drawString(tstring, 1, L);
        g.drawString(fstr, LL, L);
    }

    public double ComputeGroupedRange(int[] freq, float[] xdata, int k) {
        int min = 0;
        int max = 0;
        int count = 0;
        int in = -1;
        while (count == 0 && in < k - 1) {
            count = freq[++in];
        }
        min = in;
        count = freq[k - 1];
        in = k - 1;
        while (count <= 0 && in > 0) {
            count = freq[--in];
        }
        max = in;
        double r = xdata[max] - xdata[min];
        return r;
    }

    public double ComputeGroupedMean(int[] freq, float[] xdata, int k) {
        double s = 0.0;
        int N = 0;
        for (int i = 0; i < k; ++i) {
            s += (double)(xdata[i] * (float)freq[i]);
            N += freq[i];
        }
        if (N > 0) {
            s /= (double)N;
        }
        return s;
    }

    public modes ComputeGroupedMode(int[] freq, float[] xdata, int k) {
        double mode = xdata[0];
        int maxFreq = freq[0];
        boolean[] modeF = new boolean[k];
        this.setFalse(modeF);
        int nModes = 1;
        modeF[0] = true;
        for (int i = 1; i < k; ++i) {
            if (freq[i] == maxFreq) {
                ++nModes;
                modeF[i] = true;
                continue;
            }
            if (freq[i] <= maxFreq) continue;
            this.setFalse(modeF);
            nModes = 1;
            modeF[i] = true;
            maxFreq = freq[i];
            mode = xdata[i];
        }
        return new modes(mode, nModes, modeF);
    }

    void setFalse(boolean[] modeF) {
        for (int i = 0; i < modeF.length; ++i) {
            modeF[i] = false;
        }
    }

    public double ComputeGroupedsd(int[] freq, float[] xdata, int k) {
        double s = 0.0;
        double sq = 0.0;
        int N = 0;
        for (int i = 0; i < k; ++i) {
            s += (double)(xdata[i] * (float)freq[i]);
            sq += (double)(xdata[i] * xdata[i] * (float)freq[i]);
            N += freq[i];
        }
        sq = Math.sqrt((sq - s * s / (double)N) / (double)N);
        return sq;
    }

    public double ComputeSkew(int[] freq, float[] xdata, int k, double m) {
        double sd = this.ComputeGroupedsd(freq, xdata, k);
        double sq = 0.0;
        int N = 0;
        for (int i = 0; i < k; ++i) {
            sq += Math.pow((double)xdata[i] - m, 3.0) * (double)freq[i];
            N += freq[i];
        }
        sq = sd == 0.0 || N < 2 ? 0.0 : sq / (double)N / Math.pow(sd, 3.0);
        return sq;
    }

    public double ComputeKurt(int[] freq, float[] xdata, int k, double m) {
        double sd = this.ComputeGroupedsd(freq, xdata, k);
        double sq = 0.0;
        int N = 0;
        for (int i = 0; i < k; ++i) {
            sq += Math.pow((double)xdata[i] - m, 4.0) * (double)freq[i];
            N += freq[i];
        }
        if (sd == 0.0 || N < 2) {
            sq = 0.0;
        } else {
            sq /= Math.pow(sd, 4.0);
            double rat1 = (double)(N * (N + 1)) / (double)((N - 2) * (N - 3));
            sq = sq * rat1 / (double)(N - 1) - 3.0 * (double)(N - 1) * (double)(N - 1) / (double)((N - 2) * (N - 3));
        }
        return sq;
    }

    public double ComputeMAD(int[] freq, float[] xdata, int k) {
        int i;
        int N = 0;
        double m = 0.0;
        double MAD = 0.0;
        for (i = 0; i < k; ++i) {
            N += freq[i];
            m += (double)(xdata[i] * (float)freq[i]);
        }
        m /= (double)N;
        for (i = 0; i < k; ++i) {
            MAD += Math.abs((double)xdata[i] - m) * (double)freq[i];
        }
        return MAD /= (double)N;
    }

    public double ComputeGroupedMedian(int[] fd, int k, int N) {
        int i;
        boolean even;
        double med = 0.0;
        int nc = 0;
        int h = N / 2;
        if (h * 2 == N) {
            even = true;
        } else {
            even = false;
            ++h;
        }
        nc = 0;
        int j = 0;
        for (i = 0; i < k; ++i) {
            if ((nc += fd[i]) < h) continue;
            j = i;
            break;
        }
        if (even) {
            if (nc == h) {
                int jj;
                for (i = jj = j + 1; i < k; ++i) {
                    if (fd[i] == 0) continue;
                    jj = i;
                    break;
                }
                med = (double)(this.xdata[j] + this.xdata[jj]) / (double)2;
            } else {
                med = this.xdata[j];
            }
        } else {
            med = this.xdata[j];
        }
        return med;
    }
}

