/*
 * Decompiled with CFR 0.152.
 */
package qqgraph;

import VisualNumerics.math.Statistics;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Font;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Random;
import qqgraph.desc;
import qqgraph.histStat;
import qqgraph.qqplot;

public class qqgraph
extends Applet {
    Choice choice1;
    Label label1;
    Label label2;
    Label label22;
    Label label212;
    Label label3;
    Label label4;
    Label label42;
    Label label5;
    Button button1;
    int[] norm = new int[37];
    double[] rawdata = new double[2000];
    boolean positiveSkew = true;
    Random rg;
    float[] mp = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f, 11.0f, 12.0f, 13.0f, 14.0f, 15.0f, 16.0f, 17.0f, 18.0f, 19.0f, 20.0f, 21.0f, 22.0f, 23.0f, 24.0f, 25.0f, 26.0f, 27.0f, 28.0f, 29.0f, 30.0f, 31.0f, 32.0f, 33.0f, 34.0f, 35.0f, 36.0f, 37.0f};
    float[] mpposskew = new float[]{2.0f, 4.0f, 6.0f, 8.0f, 10.0f, 12.0f, 14.0f, 16.0f, 18.0f, 20.0f, 22.0f, 24.0f, 26.0f, 28.0f, 30.0f, 32.0f, 34.0f, 36.0f, 39.0f, 40.0f, 42.0f, 44.0f, 46.0f, 48.0f, 50.0f, 52.0f, 54.0f, 56.0f, 58.0f, 60.0f, 62.0f, 64.0f, 66.0f, 68.0f, 70.0f, 72.0f, 74.0f};
    float[] mpnegskew = new float[]{-39.0f, -37.0f, -35.0f, -33.0f, -31.0f, -29.0f, -27.0f, -25.0f, -23.0f, -21.0f, -19.0f, -17.0f, -15.0f, -13.0f, -11.0f, -9.0f, -7.0f, -5.0f, -3.0f, -1.0f, 1.0f, 3.0f, 5.0f, 7.0f, 9.0f, 11.0f, 13.0f, 15.0f, 17.0f, 19.0f, 21.0f, 23.0f, 25.0f, 27.0f, 29.0f, 31.0f, 33.0f};
    float[] mplepto = new float[]{-19.0f, -17.0f, -15.0f, -13.0f, -11.0f, -9.0f, -7.0f, -5.0f, -3.0f, -1.0f, 1.0f, 3.0f, 5.0f, 7.0f, 9.0f, 11.0f, 13.0f, 15.0f, 17.0f, 19.0f, 21.0f, 23.0f, 25.0f, 27.0f, 29.0f, 31.0f, 33.0f, 35.0f, 37.0f, 39.0f, 41.0f, 43.0f, 45.0f, 47.0f, 49.0f, 51.0f, 53.0f};
    histStat bh;
    qqplot qqplot1;
    qqplot qqplot2;
    double[] normalX;
    double[] quantile;
    double[] reference;
    double[] standard;
    double mean;
    double sd;
    double num;
    desc d;

    public void init() {
        this.setLayout(null);
        this.setSize(610, 500);
        this.setBackground(Color.white);
        this.choice1 = new Choice();
        this.choice1.addItem("Random data from normal distribution");
        this.choice1.addItem("Random positive skewed");
        this.choice1.addItem("Random negative skewed");
        this.choice1.addItem("Random data from uniform distribution");
        this.choice1.addItem("Random data from leptokurtic distribution");
        try {
            this.choice1.select(0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.add(this.choice1);
        this.choice1.setFont(new Font(this.getFont().getName(), 0, 11));
        this.choice1.setBounds(150, 25, 270, 30);
        this.label1 = new Label("Distribution data:", 0);
        this.label1.setFont(new Font(this.getFont().getName(), 0, 11));
        this.label1.setBounds(150, 10, 270, 15);
        this.add(this.label1);
        this.button1 = new Button();
        this.button1.setLabel("New data");
        this.button1.setBounds(440, 28, 90, 20);
        this.add(this.button1);
        this.button1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                qqgraph.this.button1_actionPerformed(e);
            }
        });
        this.bh = new histStat();
        this.add(this.bh);
        this.bh.setBounds(20, 45, 530, 200);
        this.bh.setClickable(false);
        this.bh.setFrame(false);
        this.bh.setTitle("");
        boolean[] stats = new boolean[]{true, true, true, false, true, false, false, true, false};
        this.bh.setAllStats(stats);
        this.bh.setColor(Color.blue);
        this.rg = new Random();
        SymItem lSymItem = new SymItem();
        this.choice1.addItemListener(lSymItem);
        this.label2 = new Label("Raw", 1);
        this.label2.setFont(new Font(this.getFont().getName(), 0, 11));
        this.label2.setBounds(2, 255, 60, 16);
        this.add(this.label2);
        this.label3 = new Label("Scores", 1);
        this.label3.setFont(new Font(this.getFont().getName(), 0, 11));
        this.label3.setBounds(2, 275, 60, 16);
        this.add(this.label3);
        this.label212 = new Label("Standardized", 1);
        this.label212.setFont(new Font(this.getFont().getName(), 0, 11));
        this.label212.setBounds(302, 255, 72, 16);
        this.add(this.label212);
        this.label22 = new Label("Scores", 1);
        this.label22.setFont(new Font(this.getFont().getName(), 0, 11));
        this.label22.setBounds(302, 275, 72, 16);
        this.add(this.label22);
        this.label4 = new Label("Normal Quantiles", 1);
        this.label4.setFont(new Font(this.getFont().getName(), 0, 11));
        this.label4.setBounds(60, 460, 260, 20);
        this.add(this.label4);
        this.label42 = new Label("Normal Quantiles", 1);
        this.label42.setFont(new Font(this.getFont().getName(), 0, 11));
        this.label42.setBounds(370, 460, 260, 20);
        this.add(this.label42);
        this.label5 = new Label("____", 1);
        this.label5.setFont(new Font(this.getFont().getName(), 1, 14));
        this.label5.setForeground(Color.orange);
        this.label5.setBounds(145, 475, 40, 20);
        this.add(this.label5);
        this.label5 = new Label("Estimated normal reference line from distribution's mean and sd.", 0);
        this.label5.setFont(new Font(this.getFont().getName(), 0, 11));
        this.label5.setBounds(185, 480, 400, 20);
        this.add(this.label5);
        this.genNorm();
        this.qqplot1 = new qqplot();
        this.qqplot1.setBounds(35, 250, 260, 210);
        this.add(this.qqplot1);
        this.qqplot2 = new qqplot();
        this.qqplot2.setBounds(350, 250, 260, 210);
        this.add(this.qqplot2);
        this.setGraph(this.mp);
    }

    public double[] standize(double[] input) {
        double[] s = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            s[i] = (input[i] - this.d.mean) / this.d.sd;
        }
        return s;
    }

    public double[] getNormalquantile(double[] rawdata) {
        this.d = new desc(rawdata);
        this.mean = this.d.mean;
        this.sd = this.d.sd;
        this.num = rawdata.length;
        double[] q = new double[(int)this.num - 1];
        for (int i = 0; i < (int)(this.num - 1.0); ++i) {
            q[i] = this.d.percentile((double)(i + 1) / this.num, rawdata);
        }
        return q;
    }

    public double[] getNormalX(double[] quantile) {
        double[] normalX = new double[quantile.length];
        for (int i = 0; i < normalX.length; ++i) {
            normalX[i] = Statistics.inverseNormalCdf((double)(i + 1) / this.num);
        }
        return normalX;
    }

    public double[] getReference(double[] quantile) {
        double[] reference = new double[quantile.length];
        for (int i = 0; i < quantile.length; ++i) {
            reference[i] = Statistics.inverseNormalCdf((double)(i + 1) / this.num) * this.sd + this.mean;
        }
        return reference;
    }

    public double[] getSReference(double[] quantile) {
        double[] reference = new double[quantile.length];
        for (int i = 0; i < quantile.length; ++i) {
            reference[i] = Statistics.inverseNormalCdf((double)(i + 1) / this.num);
        }
        return reference;
    }

    public void genNorm() {
        this.norm = new int[37];
        this.rawdata = new double[2000];
        for (int i = 0; i < 2000; ++i) {
            this.rawdata[i] = 4.0 * this.rg.nextGaussian() + 19.0;
            try {
                int n = (int)Math.floor(this.rawdata[i] - 0.5);
                this.norm[n] = this.norm[n] + 1;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void genLepto() {
        this.norm = new int[37];
        this.rawdata = new double[2000];
        for (int i = 0; i < 2000; ++i) {
            this.rawdata[i] = i % 4 == 0 ? 9.0 * this.rg.nextGaussian() + 19.0 : 3.0 * this.rg.nextGaussian() + 19.0;
            try {
                int k;
                int n = k = (int)Math.floor((this.rawdata[i] + 20.0) / 2.0);
                this.norm[n] = this.norm[n] + 1;
                continue;
            }
            catch (Exception e) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("exception: rawdata[").append(i).append("]=").append(this.rawdata[i]))));
            }
        }
    }

    public void genUniform() {
        this.norm = new int[37];
        this.rawdata = new double[2000];
        for (int i = 0; i < 2000; ++i) {
            this.rawdata[i] = this.rg.nextDouble() * 37.0;
            try {
                int n = (int)Math.floor(this.rawdata[i]);
                this.norm[n] = this.norm[n] + 1;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void genPositiveSkew() {
        this.norm = new int[37];
        this.rawdata = new double[2000];
        double mean = 11.0;
        double sd = 7.0;
        double df = 4.0;
        double k = sd / Math.sqrt(2.0 * df);
        double u = mean - sd * Math.sqrt(df / 2.0);
        for (int i = 0; i < 2000; ++i) {
            int kk = 0;
            double x = 0.0;
            for (int j = 0; j < (int)df; ++j) {
                x += Math.pow(this.rg.nextGaussian(), 2.0);
            }
            this.rawdata[i] = k * x + u;
            try {
                int n = kk = (int)Math.floor((this.rawdata[i] - 1.0) / 2.0);
                this.norm[n] = this.norm[n] + 1;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void genNegativeSkew() {
        this.norm = new int[37];
        this.rawdata = new double[2000];
        double mean = 11.0;
        double sd = 7.0;
        double df = 4.0;
        double k = sd / Math.sqrt(2.0 * df);
        double u = mean - sd * Math.sqrt(df / 2.0);
        for (int i = 0; i < 2000; ++i) {
            int kk = 0;
            double x = 0.0;
            for (int j = 0; j < (int)df; ++j) {
                x += Math.pow(this.rg.nextGaussian(), 2.0);
            }
            this.rawdata[i] = (double)34 - k * x - u;
            try {
                int n = kk = (int)Math.floor((this.rawdata[i] + 40.0) / 2.0);
                this.norm[n] = this.norm[n] + 1;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setGraph(float[] _mp) {
        this.quantile = this.getNormalquantile(this.rawdata);
        this.bh.setFreqAndMidPoints(this.norm, _mp);
        this.standard = this.standize(this.quantile);
        this.normalX = this.getNormalX(this.quantile);
        this.reference = this.getReference(this.quantile);
        this.qqplot1.setData(this.normalX, this.quantile, this.reference);
        this.qqplot2.setData(this.normalX, this.standard, this.getSReference(this.quantile));
    }

    void choice1_ItemStateChanged(ItemEvent event) {
        this.newData();
    }

    void button1_actionPerformed(ActionEvent e) {
        this.newData();
    }

    void newData() {
        if (this.choice1.getSelectedItem().equals("Random data from normal distribution")) {
            this.genNorm();
            this.setGraph(this.mp);
        } else if (this.choice1.getSelectedItem().equals("Random positive skewed")) {
            this.genPositiveSkew();
            this.setGraph(this.mpposskew);
        } else if (this.choice1.getSelectedItem().equals("Random negative skewed")) {
            this.genNegativeSkew();
            this.setGraph(this.mpnegskew);
        } else if (this.choice1.getSelectedItem().equals("Random data from uniform distribution")) {
            this.genUniform();
            this.setGraph(this.mp);
        } else if (this.choice1.getSelectedItem().equals("Random data from leptokurtic distribution")) {
            this.genLepto();
            this.setGraph(this.mplepto);
        }
    }

    class SymItem
    implements ItemListener {
        SymItem() {
        }

        public void itemStateChanged(ItemEvent event) {
            Object object = event.getSource();
            if (object == qqgraph.this.choice1) {
                qqgraph.this.choice1_ItemStateChanged(event);
            }
        }
    }
}

