/*
 * Decompiled with CFR 0.152.
 */
package qqgraph;

import RVLS.LT;
import RVLS.graphUtilities;
import RVLS.reg;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.beans.Beans;

public class qqplot
extends Canvas {
    public static final int RECT = 0;
    public static final int CIRCLE = 1;
    public int N;
    public int shape;
    public int ndecx;
    public int ndecy;
    public int px0;
    public int py0;
    public int pxf;
    public int pyf;
    public int[] X;
    public int[] Y;
    public int[] YNormal;
    public boolean filled;
    public boolean reference = false;
    public LT Lx;
    public LT Ly;
    public double[] XX;
    public double[] YY;
    public double[] YYNormal;
    public double minX;
    public double maxX;
    public double minY;
    public double maxY;
    double x0;
    double xf;
    double y0;
    double yf;
    double xinc;
    double yinc;
    double b;
    double A;
    double r;
    Graphics g;
    Color c = Color.blue;
    Color regColor = Color.black;
    boolean doreg;
    boolean drawError = false;
    Point reg0;
    Point regf;
    Font font;
    reg reg1;

    public void setData(double[] X, double[] Y, double[] YY) {
        int N = X.length;
        this.setData(X, Y, YY, N);
    }

    public void setData(double[] X, double[] Y, double[] YY, int N) {
        this.minX = X[0];
        this.maxX = X[0];
        this.minY = Y[0];
        this.maxY = Y[0];
        for (int i = 1; i < N; ++i) {
            this.minX = Math.min(this.minX, X[i]);
            this.minY = Math.min(this.minY, Y[i]);
            this.minY = Math.min(this.minY, YY[i]);
            this.maxX = Math.max(this.maxX, X[i]);
            this.maxY = Math.max(this.maxY, Y[i]);
            this.maxY = Math.max(this.maxY, YY[i]);
        }
        this.setData(X, Y, YY, this.minX, this.maxX, this.minY, this.maxY, N);
    }

    public void setData(double[] X, double[] Y, double[] YY, double _minX, double _maxX, double _minY, double _maxY, int _N) {
        int[] location = new int[4];
        Dimension d = this.getSize();
        location[0] = 50;
        location[1] = d.width - 20;
        location[2] = 10;
        location[3] = d.height - 25;
        this.minX = _minX;
        this.maxX = _maxX;
        this.minY = _minY;
        this.maxY = _maxY;
        int N = _N;
        double[] XL = new double[3];
        int numLabs = 10;
        if (d.width < 150) {
            numLabs = 5;
        }
        XL = graphUtilities.intlabels(this.minX, this.maxX, numLabs);
        int stepsX = (int)Math.rint((XL[2] - XL[1]) / XL[0]);
        double x0 = XL[1];
        double xf = XL[2];
        double[] YL = new double[3];
        numLabs = 10;
        if (d.height < 150) {
            numLabs = 5;
        }
        YL = graphUtilities.intlabels(this.minY, this.maxY, numLabs);
        int stepsY = (int)Math.rint((YL[2] - YL[1]) / YL[0]);
        int decX = XL[0] >= 1.0 ? 0 : (XL[0] >= 0.1 ? 1 : (XL[0] > 0.01 ? 2 : 3));
        int decY = YL[0] >= 1.0 ? 0 : (YL[0] >= 0.1 ? 1 : (YL[0] > 0.01 ? 2 : 3));
        this.initialize(X, Y, YY, XL[1], XL[2], YL[1], YL[2], stepsX, stepsY, location, true, 1, this.c, decX, decY, N);
        this.repaint();
    }

    public void setShape(int _shape) {
        this.shape = _shape;
    }

    public void setFilled(boolean _filled) {
        this.filled = _filled;
    }

    void initialize(double[] _X, double[] _Y, double[] _YY, double _x0, double _xf, double _y0, double _yf, int xticks, int yticks, int[] _location, boolean _filled, int _shape, Color _c, int _ndecx, int _ndecy, int _N) {
        this.N = _N;
        this.XX = new double[this.N];
        this.XX = _X;
        this.YY = new double[this.N];
        this.YY = _Y;
        if (this.N == 1) {
            this.b = 0.0;
            this.A = this.YY[0];
            this.r = 0.0;
            _x0 = (int)(this.XX[0] - 1.0);
            _xf = (int)(this.XX[0] + 1.0);
            _y0 = (int)(this.YY[0] - 1.0);
            _yf = (int)(this.YY[0] + 1.0);
            xticks = 5;
            yticks = 5;
        } else {
            this.reg1 = new reg(this.XX, this.YY, this.N);
            this.b = this.reg1.getSlope();
            this.A = this.reg1.getIntercept();
            this.r = this.reg1.getr();
        }
        this.filled = _filled;
        this.x0 = _x0;
        this.y0 = _y0;
        this.xf = _xf;
        this.yf = _yf;
        this.ndecx = _ndecx;
        this.ndecy = _ndecy;
        if (this.y0 < this.yf) {
            double temp = this.y0;
            this.y0 = this.yf;
            this.yf = temp;
        }
        this.xinc = (_xf - _x0) / (double)xticks;
        this.yinc = (this.y0 - this.yf) / (double)yticks;
        this.shape = _shape;
        this.X = new int[this.N];
        this.Y = new int[this.N];
        this.Lx = new LT(this.x0, this.xf, _location[0], _location[1]);
        this.Ly = new LT(this.y0, this.yf, _location[2], _location[3]);
        this.Y = this.Ly.ItransformArray(_Y);
        this.YNormal = this.Ly.ItransformArray(_YY);
        this.X = this.Lx.ItransformArray(_X);
        this.reference = true;
        this.c = _c;
        this.font = new Font("TimesRoman", 0, 10);
        double xOrigin = _x0 - this.xinc / (double)4;
        this.px0 = (int)Math.rint(this.Lx.transform(xOrigin));
        double xEnd = _xf + this.xinc / (double)4;
        this.pxf = (int)Math.rint(this.Lx.transform(xEnd));
        this.py0 = (int)Math.rint(this.Ly.transform(this.y0 + this.yinc / (double)8));
        this.pyf = (int)Math.rint(this.Ly.transform(this.yf - this.yinc / (double)8));
        double yv1 = this.b * xOrigin + this.A;
        double yv2 = this.b * xEnd + this.A;
        int x1 = (int)Math.rint(this.Lx.transform(xOrigin));
        int x2 = (int)Math.rint(this.Lx.transform(xEnd));
        int y1 = (int)Math.rint(this.Ly.transform(yv1));
        int y2 = (int)Math.rint(this.Ly.transform(yv2));
        this.reg0 = new Point(x1, y1);
        this.regf = new Point(x2, y2);
    }

    public void drawPoints(Graphics g) {
        g.setColor(this.c);
        block4: for (int i = 0; i < this.N; ++i) {
            switch (this.shape) {
                case 0: {
                    if (this.filled) {
                        g.fillRect(this.X[i], this.Y[i], 1, 1);
                        continue block4;
                    }
                    g.drawRect(this.X[i], this.Y[i], 1, 1);
                    continue block4;
                }
                case 1: {
                    if (this.filled) {
                        g.drawOval(this.X[i], this.Y[i], 1, 1);
                        continue block4;
                    }
                    g.drawOval(this.X[i], this.Y[i], 1, 1);
                }
            }
        }
    }

    public void paint(Graphics g) {
        if (this.N == 0 || Beans.isDesignTime()) {
            Dimension d = this.getSize();
            g.drawRect(50, 10, d.width - 51, d.height - 11);
            g.drawRect(0, 0, d.width - 1, d.height - 1);
        } else {
            int i;
            if (this.reference) {
                g.setColor(Color.orange);
                for (i = 0; i < this.N; ++i) {
                    if (this.YNormal[i] <= this.py0 || this.YNormal[i] >= this.pyf) continue;
                    g.drawOval(this.X[i], this.YNormal[i], 1, 1);
                }
            }
            this.drawPoints(g);
            if (this.drawError) {
                g.setColor(Color.red);
                for (i = 0; i < this.N; ++i) {
                    double yp = this.b * this.XX[i] + this.A;
                    int ypi = (int)this.Ly.transform(yp);
                    g.drawLine(this.X[i], this.Y[i], this.X[i], ypi);
                }
            }
            g.setColor(Color.black);
            graphUtilities.plotAxes(g, this.px0, this.pxf, this.py0, this.pyf, this.x0, this.xf, this.y0, this.yf, this.font, this.Lx, this.Ly, this.xinc, this.yinc, this.ndecx, this.ndecy, false);
            if (this.doreg) {
                g.setColor(this.regColor);
                g.clipRect(this.px0, this.py0, this.pxf - this.px0, this.pyf - this.py0);
                g.drawLine(this.reg0.x, this.reg0.y, this.regf.x, this.regf.y);
            }
        }
    }

    public void upDateStats() {
        this.reg1 = new reg(this.XX, this.YY);
        this.b = this.reg1.getSlope();
        this.A = this.reg1.getIntercept();
        this.r = this.reg1.getr();
    }

    public void setY(double[] _YY) {
        for (int i = 0; i < this.Y.length; ++i) {
            this.YY[i] = _YY[i];
        }
        this.Y = this.Ly.ItransformArray(this.YY);
    }

    public void setX(double[] _XX) {
        for (int i = 0; i < this.X.length; ++i) {
            this.XX[i] = _XX[i];
        }
        this.X = this.Lx.ItransformArray(this.XX);
    }

    public void setSlope(double b) {
        double yv1 = b * this.x0 + this.A;
        double yv2 = b * this.xf + this.A;
        int x1 = (int)Math.rint(this.Lx.transform(this.x0));
        int x2 = (int)Math.rint(this.Lx.transform(this.xf));
        int y1 = (int)Math.rint(this.Ly.transform(yv1));
        int y2 = (int)Math.rint(this.Ly.transform(yv2));
        this.reg0 = new Point(x1, y1);
        this.regf = new Point(x2, y2);
    }

    public void update(Graphics g) {
        Dimension dim = this.getSize();
        Image osi = this.createImage(dim.width, dim.height);
        Graphics osg = osi.getGraphics();
        osg.setColor(this.getBackground());
        osg.fillRect(0, 0, dim.width, dim.height);
        osg.setColor(g.getColor());
        this.paint(osg);
        g.drawImage(osi, 0, 0, this);
    }

    public Point getUpperLeft() {
        Point p = new Point(this.px0, this.py0);
        return p;
    }

    public Point getLowerRight() {
        Point p = new Point(this.pxf, this.pyf);
        return p;
    }

    static {
        RECT = 0;
        CIRCLE = 1;
    }
}

