/*
 * Decompiled with CFR 0.152.
 */
package reg_scatter;

import RVLS.graphUtilities;
import RVLS.reg;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.Beans;
import reg_scatter.regGraphOwner;
import reg_scatter.scatter;

public class regLines
extends scatter {
    double sse;
    double mse;
    boolean left = false;
    boolean right = false;
    boolean middle = false;
    Point start;
    Point end;
    public double bdraw;
    public double Adraw;
    regGraphOwner regGraphOwner1 = null;

    public regLines() {
        SymMouse aSymMouse = new SymMouse();
        this.addMouseListener(aSymMouse);
        SymMouseMotion aSymMouseMotion = new SymMouseMotion();
        this.addMouseMotionListener(aSymMouseMotion);
    }

    void setOwner(regGraphOwner regGraphOwner1) {
        this.regGraphOwner1 = regGraphOwner1;
    }

    void initialize(double[] _X, double[] _Y, double _x0, double _xf, double _y0, double _yf, int xticks, int yticks, int[] _location, boolean _filled, int _shape, Color _c, int _ndecx, int _ndecy, int _N) {
        super.initialize(_X, _Y, _x0, _xf, _y0, _yf, xticks, yticks, _location, _filled, _shape, _c, _ndecx, _ndecy, _N);
        this.bdraw = 0.0;
        this.Adraw = this.reg1.getYmean();
        this.start = new Point(this.px0, this.Ly.Itransform(this.Adraw));
        this.end = new Point(this.pxf, this.start.y);
    }

    void regLines_MousePressed(MouseEvent event) {
        int xp = event.getX();
        int yp = event.getY();
        this.left = false;
        this.right = false;
        this.middle = false;
        if (xp < this.px0 || xp > this.pxf || yp < this.py0 || yp > this.pyf) {
            return;
        }
        double xpv = this.Lx.transformToValue(xp);
        int lxpv = (int)Math.rint(this.Ly.transform(this.bdraw * xpv + this.Adraw));
        if (Math.abs(yp - lxpv) < 5) {
            if (xp < this.px0 + (this.pxf - this.px0) / 3) {
                this.left = true;
            } else if (xp > this.px0 + 2 * (this.pxf - this.px0) / 3) {
                this.right = true;
            } else {
                this.middle = true;
            }
        }
    }

    void regLines_MouseDragged(MouseEvent event) {
        int currentY = event.getY();
        int currentX = event.getX();
        if (currentX < this.px0 || currentX > this.pxf || currentY < this.py0 || currentY > this.pyf) {
            return;
        }
        double xpv = this.Lx.transformToValue(currentX);
        double ypv = this.Ly.transformToValue(currentY);
        if (this.left) {
            double x2 = this.Lx.transformToValue(this.end.x);
            double y2 = this.Ly.transformToValue(this.end.y);
            this.bdraw = (y2 - ypv) / (x2 - xpv);
            this.Adraw = ypv - this.bdraw * xpv;
            this.start.x = (int)Math.rint(this.Lx.transform(this.x0 - this.xinc / (double)4));
            this.start.y = (int)Math.rint(this.Ly.transform(this.bdraw * (this.x0 - this.xinc / (double)4) + this.Adraw));
            this.repaint();
            this.regGraphOwner1.valueChanged(this.getSSELine(), this.N, this.bdraw, this.Adraw, false);
        } else if (this.right) {
            double x1 = this.Lx.transformToValue(this.start.x);
            double y1 = this.Ly.transformToValue(this.start.y);
            this.bdraw = (y1 - ypv) / (x1 - xpv);
            this.Adraw = ypv - this.bdraw * xpv;
            this.end.x = (int)Math.rint(this.Lx.transform(this.xf + this.xinc / (double)4));
            this.end.y = (int)Math.rint(this.Ly.transform(this.bdraw * (this.xf + this.xinc / (double)4) + this.Adraw));
            this.repaint();
            this.regGraphOwner1.valueChanged(this.getSSELine(), this.N, this.bdraw, this.Adraw, false);
        } else if (this.middle) {
            this.Adraw = ypv - this.bdraw * xpv;
            this.start.x = (int)Math.rint(this.Lx.transform(this.x0 - this.xinc / (double)4));
            this.start.y = (int)Math.rint(this.Ly.transform(this.bdraw * (this.x0 - this.xinc / (double)4) + this.Adraw));
            this.end.x = (int)Math.rint(this.Lx.transform(this.xf + this.xinc / (double)4));
            this.end.y = (int)Math.rint(this.Ly.transform(this.bdraw * (this.xf + this.xinc / (double)4) + this.Adraw));
            this.repaint();
            this.regGraphOwner1.valueChanged(this.getSSELine(), this.N, this.bdraw, this.Adraw, false);
        }
    }

    void regLines_MouseReleased(MouseEvent event) {
        this.repaint();
    }

    public void drawReg() {
        this.reg1 = new reg(this.XX, this.YY);
        this.b = this.reg1.getSlope();
        this.A = this.reg1.getIntercept();
        this.start.x = (int)Math.rint(this.Lx.transform(this.x0 - this.xinc / (double)4));
        this.start.y = (int)Math.rint(this.Ly.transform(this.b * (this.x0 - this.xinc / (double)4) + this.A));
        this.end.x = (int)Math.rint(this.Lx.transform(this.xf + this.xinc / (double)4));
        this.end.y = (int)Math.rint(this.Ly.transform(this.b * (this.xf + this.xinc / (double)4) + this.A));
        this.repaint();
        this.regGraphOwner1.valueChanged(this.getSSE(), this.N, this.b, this.A, true);
    }

    public void paint(Graphics g) {
        if (this.N == 0 || Beans.isDesignTime()) {
            Dimension d = this.getSize();
            g.drawRect(50, 10, d.width - 51, d.height - 11);
            g.drawRect(0, 0, d.width - 1, d.height - 1);
        } else {
            this.drawPoints(g);
            if (this.drawError) {
                g.setColor(Color.red);
                for (int i = 0; i < this.N; ++i) {
                    double yp = this.b * this.XX[i] + this.A;
                    int ypi = (int)this.Ly.transform(yp);
                    g.drawLine(this.X[i], this.Y[i], this.X[i], ypi);
                }
            }
            g.setColor(Color.black);
            graphUtilities.plotAxes(g, this.px0, this.pxf, this.py0, this.pyf, this.x0, this.xf, this.y0, this.yf, this.font, this.Lx, this.Ly, this.xinc, this.yinc, this.ndecx, this.ndecy, false);
            g.clipRect(this.px0, this.py0, this.pxf - this.px0, this.pyf - this.py0);
            if (this.doreg) {
                g.setColor(this.regColor);
                g.drawLine(this.reg0.x, this.reg0.y, this.regf.x, this.regf.y);
            }
            g.setColor(Color.black);
            g.drawLine(this.start.x, this.start.y, this.end.x, this.end.y);
        }
    }

    double getSSELine() {
        double sse = 0.0;
        for (int i = 0; i < this.N; ++i) {
            double yp = this.bdraw * this.XX[i] + this.Adraw;
            sse += Math.pow(this.YY[i] - yp, 2.0);
        }
        return sse;
    }

    class SymMouseMotion
    extends MouseMotionAdapter {
        SymMouseMotion() {
        }

        public void mouseDragged(MouseEvent event) {
            Object object = event.getSource();
            if (object == regLines.this) {
                regLines.this.regLines_MouseDragged(event);
            }
        }
    }

    class SymMouse
    extends MouseAdapter {
        SymMouse() {
        }

        public void mouseReleased(MouseEvent event) {
            Object object = event.getSource();
            if (object == regLines.this) {
                regLines.this.regLines_MouseReleased(event);
            }
        }

        public void mousePressed(MouseEvent event) {
            Object object = event.getSource();
            if (object == regLines.this) {
                regLines.this.regLines_MousePressed(event);
            }
        }
    }
}

