/*
 * Decompiled with CFR 0.152.
 */
package median;

import RVLS.LT;
import RVLS.Sort;
import RVLS.Utility;
import RVLS.Yaxis;
import java.awt.Button;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import median.medainGraphOwner;

public class medainGraph
extends Panel {
    Label label1;
    Button button1;
    Button button2;
    int width;
    int height;
    int currentY;
    boolean[] ondot = new boolean[]{false, false, false, false, false};
    boolean online = false;
    int Yaxis;
    public int[] x = new int[5];
    public int[] y = new int[5];
    public Color[] color = new Color[]{Color.red, Color.blue, Color.green, Color.orange, Color.magenta};
    medainGraphOwner owner = null;
    public int adjWidth = 0;
    public int adjAcent;
    public int labelMin;
    double scale = 5.0;
    Color backgroundColor = new Color(0xF9FFF3);
    public LT lt;

    public medainGraph() {
        this.setLayout(null);
        this.setSize(200, 150);
        this.setFont(new Font("Dialog", 0, 10));
        SymMouse aSymMouse = new SymMouse();
        this.addMouseListener(aSymMouse);
        SymMouseMotion aSymMouseMotion = new SymMouseMotion();
        this.addMouseMotionListener(aSymMouseMotion);
    }

    public medainGraph(int _width, int _height) {
        this.width = _width;
        this.height = _height;
        this.setSize(this.width, this.height);
        this.setFont(new Font("Dialog", 0, 10));
    }

    public void setOwner(medainGraphOwner owner1) {
        this.owner = owner1;
        this.width = this.getSize().width;
        this.height = this.getSize().height;
        this.label1 = new Label("Drag the line or the dots below to change the data.", 0);
        this.label1.setBounds(30, 0, this.width - 30, 16);
        this.label1.setFont(new Font("Dialog", 0, 10));
        this.add(this.label1);
        Graphics g = this.getGraphics();
        this.getXY(g);
        this.addButtons();
        this.owner.valueChanged(22, this.height - 60 - 3, this.Yaxis, this.y);
    }

    public void addButtons() {
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public void setColor(Color[] color) {
        this.color = color;
    }

    public void getXY(Graphics g) {
        FontMetrics fm = g.getFontMetrics();
        this.adjWidth = fm.stringWidth("4.99") + 2;
        this.labelMin = fm.stringWidth("Minimize sum of absolute deviations") + 2;
        int step = (int)Math.rint((double)(this.width - this.adjWidth - 30) / 6.0);
        for (int i = 0; i < 5; ++i) {
            this.x[i] = 30 + Math.round(step * (i + 1));
        }
        step = (int)Math.round((double)(this.height - 5 - 60) / 5.0);
        this.y[0] = this.height - 3 - 60 - (int)Math.round(0.2 * (double)(this.height - 5 - 80));
        this.y[1] = this.height - 3 - 60 - (int)Math.round(0.4 * (double)(this.height - 5 - 80));
        this.y[2] = this.height - 3 - 60 - (int)Math.round(0.6 * (double)(this.height - 5 - 80));
        this.y[3] = this.height - 3 - 60 - (int)Math.round(0.8 * (double)(this.height - 5 - 80));
        this.y[4] = 22;
        if (this.lt == null) {
            this.lt = new LT(0.0, this.scale, this.height - 3 - 60, 22.0);
        }
        this.Yaxis = this.lt.Itransform(0.25);
    }

    public void setXY(int[] x, int[] y) {
        if (x.length > 5 || y.length > 5) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            if (x[i] >= 0 && x[i] <= this.width - 1 && y[i] >= 0 && y[i] <= this.height - 1) continue;
            return;
        }
        this.x = x;
        this.y = y;
    }

    public void paint(Graphics g) {
        int i;
        Image offscreenImg = this.createImage(this.getSize().width, this.getSize().height);
        Graphics offscreenG = offscreenImg.getGraphics();
        FontMetrics fm = offscreenG.getFontMetrics();
        this.adjAcent = (int)Math.round((double)fm.getAscent() / 2.0);
        offscreenG.setColor(this.backgroundColor);
        offscreenG.fillRect(30, 20, this.width - this.adjWidth - 30, this.height - 80);
        offscreenG.setColor(Color.black);
        offscreenG.fillRect(30, this.Yaxis - 1, this.width - this.adjWidth - 30, 3);
        double[] YL1 = new double[(int)this.scale + 1];
        for (i = 0; i < (int)this.scale + 1; ++i) {
            YL1[i] = i;
        }
        RVLS.Yaxis.drawYaxis(22, this.height - 60 - 3, 28, YL1, 0, offscreenG);
        this.drawYaxisPosition(offscreenG, this.Yaxis);
        for (i = 0; i < 5; ++i) {
            offscreenG.setColor(this.color[i]);
            offscreenG.drawLine(this.x[i], this.Yaxis, this.x[i], this.y[i]);
            offscreenG.fillOval(this.x[i] - 2, this.y[i] - 2, 5, 5);
        }
        this.paintData(offscreenG);
        g.drawImage(offscreenImg, 0, 0, this);
        offscreenG.dispose();
    }

    public void paintData(Graphics g) {
        String currentHeight = "";
        int[] xx = new int[5];
        FontMetrics fm = g.getFontMetrics();
        this.adjAcent = (int)Math.round((double)fm.getAscent() / 2.0);
        for (int i = 0; i < this.y.length; ++i) {
            int Yheight;
            double distance = this.lt.transformToValue(this.y[i]);
            currentHeight = Utility.format(distance, 2);
            if (this.y[i] < 30) {
                Yheight = 32;
                xx[i] = this.x[i] + fm.stringWidth(currentHeight) / 2 + 4;
            } else if (this.y[i] > this.height - 60 - 10) {
                Yheight = this.height - 60 - 2 - 2;
                xx[i] = this.x[i] + fm.stringWidth(currentHeight) / 2 + 4;
            } else if (this.Yaxis >= this.y[i]) {
                Yheight = this.y[i] - this.adjAcent;
                xx[i] = this.x[i];
            } else {
                Yheight = this.y[i] + 2 * this.adjAcent + 3;
                xx[i] = this.x[i];
            }
            g.setColor(this.color[i]);
            g.drawString(currentHeight, xx[i] - fm.stringWidth(currentHeight) / 2, Yheight);
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    void medainGraph_MousePressed(MouseEvent event) {
        int xp = event.getX();
        int yp = event.getY();
        boolean found = false;
        for (int i = 0; i < 5; ++i) {
            if (Math.abs(xp - this.x[i]) < 5 && Math.abs(yp - this.y[i]) < 5) {
                this.ondot[i] = true;
                this.online = false;
                found = true;
                continue;
            }
            this.ondot[i] = false;
        }
        if (Math.abs(yp - this.Yaxis) < 5 && !found) {
            this.online = true;
        }
    }

    void medainGraph_MouseDragged(MouseEvent event) {
        this.currentY = event.getY();
        if (this.currentY >= this.height - 3 - 60) {
            this.currentY = this.height - 3 - 60;
        } else if (this.currentY <= 22) {
            this.currentY = 22;
        }
        for (int i = 0; i < 5; ++i) {
            if (!this.ondot[i]) continue;
            Graphics g = this.getGraphics();
            this.y[i] = this.currentY;
            this.repaint();
            this.owner.valueChanged(22, this.height - 60 - 3, this.Yaxis, this.y);
            return;
        }
        if (this.online) {
            Graphics g = this.getGraphics();
            this.Yaxis = this.currentY;
            this.repaint();
            this.owner.valueChanged(22, this.height - 60 - 3, this.Yaxis, this.y);
        }
    }

    void medainGraph_MouseReleased(MouseEvent event) {
        this.repaint();
    }

    public void drawYaxisPosition(Graphics g, int Y) {
        g.setFont(new Font("Dialog", 0, 10));
        FontMetrics fm = g.getFontMetrics();
        int adj = (int)Math.round((double)fm.getAscent() / 2.0);
        double y = this.lt.transformToValue(Y);
        if (Y <= 22) {
            g.drawString(Utility.format(y, 2), this.width - this.adjWidth + 2, 20 + adj + 2);
        } else if (Y >= this.height - 3 - 60) {
            g.drawString(Utility.format(y, 2), this.width - this.adjWidth + 2, Y + adj - 2);
        } else {
            g.drawString(Utility.format(y, 2), this.width - this.adjWidth + 2, Y + adj - 1);
        }
    }

    public int median(int[] y) {
        double[] dy = new double[]{y[0], y[1], y[2], y[3], y[4]};
        Sort.sort(dy);
        int n = y.length;
        if (n % 2 == 0) {
            int n2 = n / 2;
            return (int)Math.round((dy[n2] + dy[n2 - 1]) / 2.0);
        }
        return (int)Math.round(dy[n / 2]);
    }

    public double mean(int[] y) {
        double sum = 0.0;
        for (int i = 0; i < y.length; ++i) {
            sum += (double)y[i];
        }
        if (y.length > 0) {
            sum /= (double)y.length;
        }
        return sum;
    }

    class SymMouseMotion
    extends MouseMotionAdapter {
        SymMouseMotion() {
        }

        public void mouseDragged(MouseEvent event) {
            Object object = event.getSource();
            if (object == medainGraph.this) {
                medainGraph.this.medainGraph_MouseDragged(event);
            }
        }
    }

    class SymMouse
    extends MouseAdapter {
        SymMouse() {
        }

        public void mouseReleased(MouseEvent event) {
            Object object = event.getSource();
            if (object == medainGraph.this) {
                medainGraph.this.medainGraph_MouseReleased(event);
            }
        }

        public void mousePressed(MouseEvent event) {
            Object object = event.getSource();
            if (object == medainGraph.this) {
                medainGraph.this.medainGraph_MousePressed(event);
            }
        }
    }
}

