/*
 * Decompiled with CFR 0.152.
 */
package RVLS;

import RVLS.Sort;

public class desc {
    public double min;
    public double max;
    public double p25;
    public double p50;
    public double p75;
    public double mean;
    public double sd;
    public double sem;
    public double skew;
    public double kurt;
    public double triMean;
    public double adjacentLow;
    public double adjacentHigh;
    public int n;
    public String name = " ";

    public desc() {
    }

    public desc(double[] dArray, String string) {
        this(dArray);
        this.name = string;
    }

    public double[] getStats() {
        double[] dArray = new double[]{this.n, this.mean, this.p50, this.triMean, this.min, this.max, this.p25, this.p75, this.adjacentLow, this.adjacentHigh, this.sd, this.sem, this.skew, this.kurt};
        return dArray;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public desc(double[] dArray) {
        double d;
        Sort.sort(dArray);
        this.n = dArray.length;
        this.p50 = this.percentile(0.5, dArray);
        this.p25 = this.percentile(0.25, dArray);
        this.p75 = this.percentile(0.75, dArray);
        this.min = dArray[0];
        this.max = dArray[this.n - 1];
        this.mean = 0.0;
        this.sd = 0.0;
        this.skew = 0.0;
        this.kurt = 0.0;
        int n = 0;
        while (n < this.n) {
            this.mean += dArray[n];
            ++n;
        }
        this.mean /= (double)this.n;
        int n2 = 0;
        while (n2 < this.n) {
            d = dArray[n2] - this.mean;
            double d2 = d * d;
            this.sd += d2;
            this.skew += d2 * d;
            this.kurt += d2 * d2;
            ++n2;
        }
        this.sd = Math.sqrt(this.sd / (double)(this.n - 1));
        this.sem = this.sd / Math.sqrt(this.n);
        this.skew = this.skew / (this.sd * this.sd * this.sd) * (double)this.n / (double)((this.n - 1) * (this.n - 2));
        this.kurt /= this.sd * this.sd * this.sd * this.sd;
        this.kurt = this.kurt * (double)this.n * (double)(this.n + 1) / (double)((this.n - 1) * (this.n - 2) * (this.n - 3)) - 3.0 * (double)(this.n - 1) * (double)(this.n - 1) / (double)((this.n - 2) * (this.n - 3));
        this.triMean = (this.p25 + 2.0 * this.p50 + this.p75) / 4.0;
        d = 1.5 * (this.p75 - this.p25);
        int n3 = 0;
        while (n3 < this.n) {
            if (dArray[n3] >= this.p25 - d) {
                this.adjacentLow = dArray[n3];
                break;
            }
            ++n3;
        }
        int n4 = this.n - 1;
        while (n4 > 0) {
            if (dArray[n4] <= this.p75 + d) {
                this.adjacentHigh = dArray[n4];
                return;
            }
            --n4;
        }
    }

    public double percentile(double d, double[] dArray) {
        double d2 = d * (double)(this.n + 1);
        int n = (int)Math.floor(d2);
        double d3 = dArray[n - 1] + (d2 - (double)n) * (dArray[n] - dArray[n - 1]);
        return d3;
    }
}

