/*
 * Decompiled with CFR 0.152.
 */
package onewayanova;

import RVLS.probFandT;

public class anova {
    final int groupNumber = 3;
    double[][] data = new double[3][1];
    int[] groupSize = new int[4];
    double[] means = new double[4];
    double[] ssB = new double[4];
    double[] ssW = new double[4];
    double[] ssT = new double[4];
    double grandMean;
    int N;
    int dn;
    probFandT probFandT1;

    public void setData(double[] d, int id) {
        this.data[id] = d;
        this.groupSize[id] = d.length;
        this.calc_Stats();
    }

    public void calc_Stats() {
        int i;
        this.N = 0;
        double total = 0.0;
        this.dn = -1;
        for (i = 0; i < 3; ++i) {
            if (this.groupSize[i] > 0) {
                int j;
                double groupSum = 0.0;
                double groupSS = 0.0;
                for (j = 0; j < this.data[i].length; ++j) {
                    groupSum += this.data[i][j];
                    groupSS += this.data[i][j] * this.data[i][j];
                }
                total += groupSum;
                this.means[i] = groupSum / (double)j;
                this.ssW[i] = groupSS - groupSum * groupSum / (double)j;
                this.N += j;
                ++this.dn;
                continue;
            }
            this.means[i] = 0.0;
            this.ssB[i] = 0.0;
            this.ssW[i] = 0.0;
            this.ssT[i] = 0.0;
        }
        this.means[3] = this.N == 0 ? 0.0 : total / (double)this.N;
        this.grandMean = this.means[3];
        this.groupSize[3] = 0;
        this.ssB[3] = 0.0;
        this.ssW[3] = 0.0;
        this.ssT[3] = 0.0;
        for (i = 0; i < 3; ++i) {
            if (this.groupSize[i] <= 0) continue;
            double delta = this.means[i] - this.grandMean;
            this.ssB[i] = delta * delta * (double)this.groupSize[i];
            this.ssT[i] = this.ssB[i] + this.ssW[i];
            this.groupSize[3] = this.groupSize[3] + this.groupSize[i];
            this.ssB[3] = this.ssB[3] + this.ssB[i];
            this.ssW[3] = this.ssW[3] + this.ssW[i];
            this.ssT[3] = this.ssT[3] + this.ssT[i];
        }
    }

    public void clear_Stats() {
        for (int i = 0; i <= 3; ++i) {
            this.groupSize[i] = 0;
            this.means[i] = 0.0;
            this.ssB[i] = 0.0;
            this.ssW[i] = 0.0;
            this.ssT[i] = 0.0;
            this.dn = -1;
        }
    }

    public double get_SSTotal() {
        return this.ssT[3];
    }

    public double get_Proportion() {
        return Math.abs(this.ssT[3] - 0.0) < 0.001 ? 0.0 : this.ssB[3] / this.ssT[3];
    }

    public int get_groupSize(int id) {
        return this.groupSize[id];
    }

    public double get_Means(int id) {
        return this.means[id];
    }

    public double get_ssB(int id) {
        return this.ssB[id];
    }

    public double get_ssW(int id) {
        return this.ssW[id];
    }

    public double get_ssT(int id) {
        return this.ssT[id];
    }

    public int get_dn() {
        return this.dn;
    }

    public int get_dd() {
        return this.N - this.dn - 1;
    }

    public double get_FValue() {
        return this.ssB[3] / (double)this.dn / (this.ssW[3] / (double)(this.N - this.dn - 1));
    }

    public double get_PValue() {
        double fr = this.ssB[3] / (double)this.dn / (this.ssW[3] / (double)(this.N - this.dn - 1));
        return probFandT.probF(fr, this.dn, this.N - this.dn - 1);
    }
}

