/*
 * Decompiled with CFR 0.152.
 */
package onewayanova;

import RVLS.desc;
import RVLS.notified;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Enumeration;
import java.util.Vector;
import onewayanova.LT;

public class dataPanel
extends Panel {
    int ymax;
    int ymin = 10;
    int xmax;
    int xx;
    int OvalSize = 3;
    int current;
    double dmax;
    double dmin;
    double yy;
    Double d;
    int[] y = new int[0];
    int id = 0;
    int lastY;
    int anchor;
    boolean found;
    boolean drawMean = false;
    boolean drawMedian = false;
    Color cc = new Color(0, 0, 0);
    LT lt = null;
    notified myNotify;
    private Vector dataVector = new Vector();

    public dataPanel() {
        this.setSize(150, 300);
        SymMouse aSymMouse = new SymMouse();
        this.addMouseListener(aSymMouse);
        SymMouseMotion aSymMouseMotion = new SymMouseMotion();
        this.addMouseMotionListener(aSymMouseMotion);
    }

    public void setData(double[] dd, int n, double min, double max) {
        this.dmax = max;
        this.dmin = min;
        this.ymax = this.getSize().height - this.ymin;
        this.xmax = this.getSize().width;
        this.xx = this.xmax / 2;
        this.dataVector.removeAllElements();
        if (this.dmax > this.dmin & n >= 0) {
            this.setEnabled(true);
            for (int i = 0; i < dd.length; ++i) {
                this.d = new Double(dd[i]);
                this.dataVector.addElement(this.d);
            }
            this.lt = new LT(min, max, this.ymax, this.ymin);
            this.y = this.lt.ItransformArray(dd);
            this.lt = new LT(this.ymax, this.ymin, min, max);
        } else {
            this.setEnabled(false);
        }
        this.repaint();
        this.myNotify.dataChanged(this.id);
    }

    public void setFig(double[] dd, int n, double min, double max) {
        this.dmax = max;
        this.dmin = min;
        this.ymax = this.getSize().height - this.ymin;
        this.xmax = this.getSize().width;
        this.xx = this.xmax / 2;
        this.dataVector.removeAllElements();
        if (dd.length == 0) {
            this.setLine(0.0, 10.0);
            this.setEnabled(true);
        } else if (this.dmax > this.dmin & n >= 0) {
            this.setEnabled(true);
            for (int i = 0; i < dd.length; ++i) {
                this.d = new Double(dd[i]);
                this.dataVector.addElement(this.d);
            }
            this.lt = new LT(min, max, this.ymax, this.ymin);
            this.y = this.lt.ItransformArray(dd);
            this.lt = new LT(this.ymax, this.ymin, min, max);
        } else {
            this.setEnabled(false);
        }
        this.repaint();
    }

    public void setLine(double min, double max) {
        this.dmax = max;
        this.dmin = min;
        this.ymax = this.getSize().height - this.ymin;
        this.xmax = this.getSize().width;
        this.xx = this.xmax / 2;
        this.dataVector.removeAllElements();
        if (this.dmax > this.dmin) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
        this.repaint();
        this.myNotify.dataChanged(this.id);
    }

    public void setId(int ind) {
        this.id = ind;
    }

    public void setColor(Color c) {
        this.cc = c;
    }

    public void setOvalSize(int size) {
        this.OvalSize = size;
    }

    public void setInform(notified myNotify) {
        this.myNotify = myNotify;
    }

    public void setDrawMean(boolean draw) {
        this.drawMean = draw;
    }

    public void setDrawMedian(boolean draw) {
        this.drawMedian = draw;
    }

    public double[] getData() {
        int k = 0;
        double[] dd = new double[this.dataVector.size()];
        Enumeration e = this.dataVector.elements();
        while (e.hasMoreElements()) {
            dd[k] = (Double)e.nextElement();
            ++k;
        }
        return dd;
    }

    void dataPanel_MousePressed(MouseEvent event) {
        if (event.getX() >= 0 & event.getX() <= this.xmax & event.getY() >= this.ymin & event.getY() <= this.ymax) {
            this.current = event.getY();
            this.found = false;
            int j = 0;
            while (j < this.y.length & !this.found) {
                if (Math.abs(this.y[j] - this.current) < 4) {
                    this.found = true;
                }
                ++j;
            }
            if (this.found) {
                this.anchor = j - 1;
            } else {
                int[] ynew = new int[this.y.length + 1];
                for (int i = 0; i < this.y.length; ++i) {
                    ynew[i] = this.y[i];
                }
                this.y = ynew;
                this.anchor = this.y.length - 1;
            }
        }
    }

    void dataPanel_MouseDragged(MouseEvent event) {
        if (event.getX() >= 0 & event.getX() <= this.xmax & event.getY() >= this.ymin & event.getY() <= this.ymax) {
            if (this.anchor >= 0) {
                this.y[this.anchor] = event.getY();
                if (this.found) {
                    this.dataVector.setElementAt(new Double(this.lt.transform(this.y[this.anchor])), this.anchor);
                } else {
                    this.found = true;
                    this.dataVector.addElement(new Double(this.lt.transform(this.y[this.anchor])));
                }
            }
        } else if (this.anchor >= 0) {
            if (this.y.length - 1 == 0) {
                this.y = new int[0];
                this.dataVector.removeElementAt(this.anchor);
                this.anchor = -1;
            } else {
                int i;
                int[] ynew = new int[this.y.length - 1];
                for (i = 0; i < this.anchor; ++i) {
                    ynew[i] = this.y[i];
                }
                for (i = this.anchor + 1; i < this.y.length; ++i) {
                    ynew[i - 1] = this.y[i];
                }
                this.y = ynew;
                this.dataVector.removeElementAt(this.anchor);
                this.anchor = -1;
            }
        }
        this.repaint();
        this.myNotify.dataChanged(this.id);
    }

    void dataPanel_MouseReleased(MouseEvent event) {
        if (event.getX() >= 0 & event.getX() <= this.xmax & event.getY() >= this.ymin & event.getY() <= this.ymax) {
            if (this.anchor >= 0) {
                this.y[this.anchor] = event.getY();
                if (this.found) {
                    this.dataVector.setElementAt(new Double(this.lt.transform(this.y[this.anchor])), this.anchor);
                } else {
                    this.dataVector.addElement(new Double(this.lt.transform(this.y[this.anchor])));
                }
            }
        } else if (this.anchor >= 0) {
            if (this.y.length - 1 == 0) {
                this.y = new int[0];
                this.dataVector.removeElementAt(this.anchor);
            } else {
                int i;
                int[] ynew = new int[this.y.length - 1];
                for (i = 0; i < this.anchor; ++i) {
                    ynew[i] = this.y[i];
                }
                for (i = this.anchor + 1; i < this.y.length; ++i) {
                    ynew[i - 1] = this.y[i];
                }
                this.y = ynew;
                this.dataVector.removeElementAt(this.anchor);
            }
        }
        this.repaint();
        this.myNotify.dataChanged(this.id);
    }

    public void paint(Graphics g) {
        block6: {
            double mean = 0.0;
            boolean kk = false;
            boolean kx = false;
            int meanCenter = 0;
            g.setColor(Color.black);
            g.setFont(new Font("TimesRoman", 1, 10));
            FontMetrics fm = g.getFontMetrics();
            if (this.dmax > 0.0) {
                g.drawLine(this.xx, this.ymin, this.xx, this.ymax);
                String lmax = this.formString(this.dmax);
                g.drawString(lmax, this.xx - fm.stringWidth(lmax) / 2, 9);
                String lmin = this.formString(this.dmin);
                g.drawString(lmin, this.xx - fm.stringWidth(lmin) / 2, this.ymax + 9);
                g.setColor(new Color(135, 135, 135));
                g.drawLine(1, this.ymin, 1, this.ymax);
                g.drawLine(this.xmax - 1, this.ymin, this.xmax - 1, this.ymax);
                g.drawLine(1, this.ymin, this.xmax / 4, this.ymin);
                g.drawLine(this.xmax - this.xmax / 4, this.ymin, this.xmax, this.ymin);
                g.drawLine(1, this.ymin + (this.ymax - this.ymin) / 4, this.xmax / 6, this.ymin + (this.ymax - this.ymin) / 4);
                g.drawLine(this.xmax - this.xmax / 6, this.ymin + (this.ymax - this.ymin) / 4, this.xmax, this.ymin + (this.ymax - this.ymin) / 4);
                g.drawLine(1, (this.ymin + this.ymax) / 2, this.xmax / 4, (this.ymin + this.ymax) / 2);
                g.drawLine(this.xmax - this.xmax / 4, (this.ymin + this.ymax) / 2, this.xmax, (this.ymin + this.ymax) / 2);
                g.drawLine(1, this.ymin + 3 * (this.ymax - this.ymin) / 4, this.xmax / 6, this.ymin + 3 * (this.ymax - this.ymin) / 4);
                g.drawLine(this.xmax - this.xmax / 6, this.ymin + 3 * (this.ymax - this.ymin) / 4, this.xmax, this.ymin + 3 * (this.ymax - this.ymin) / 4);
                g.drawLine(1, this.ymax, this.xmax / 4, this.ymax);
                g.drawLine(this.xmax - this.xmax / 4, this.ymax, this.xmax, this.ymax);
            }
            g.setColor(this.cc);
            if (this.y == null) break block6;
            for (int k = 0; k < this.y.length; ++k) {
                g.fillOval(this.xx - (this.OvalSize - 1) / 2, this.y[k] - (this.OvalSize - 1) / 2, this.OvalSize, this.OvalSize);
            }
            if (this.drawMean || this.drawMedian) {
                double[] yy = new double[this.y.length];
                double sum = 0.0;
                for (int i = 0; i < this.y.length; ++i) {
                    yy[i] = this.y[i];
                    sum += yy[i];
                }
                if (this.drawMean && this.y.length > 0) {
                    g.setColor(new Color(255, 0, 0));
                    meanCenter = (int)Math.round(sum / (double)this.y.length);
                    g.drawLine(this.xx, meanCenter - this.OvalSize - 1, this.xx, meanCenter + this.OvalSize + 1);
                    g.drawLine(this.xx - this.OvalSize - 1, meanCenter, this.xx + this.OvalSize + 1, meanCenter);
                }
                if (this.drawMedian && this.y.length > 4) {
                    desc d = new desc(yy);
                    g.setColor(new Color(0, 255, 0));
                    int dmedian = (int)Math.round(d.p50);
                    g.drawLine(this.xx - this.OvalSize - 1, dmedian, this.xx + this.OvalSize + 1, dmedian);
                }
            }
        }
    }

    public String formString(double d) {
        String s;
        if (d == (double)Math.round(d)) {
            int dd = (int)Math.round(d);
            s = Integer.toString(dd);
        } else {
            s = Double.toString(d);
        }
        return s;
    }

    public void clear() {
        this.dataVector.removeAllElements();
        this.y = new int[0];
        this.repaint();
    }

    class SymMouseMotion
    extends MouseMotionAdapter {
        SymMouseMotion() {
        }

        public void mouseDragged(MouseEvent event) {
            Object object = event.getSource();
            if (object == dataPanel.this) {
                dataPanel.this.dataPanel_MouseDragged(event);
            }
        }
    }

    class SymMouse
    extends MouseAdapter {
        SymMouse() {
        }

        public void mouseReleased(MouseEvent event) {
            Object object = event.getSource();
            if (object == dataPanel.this) {
                dataPanel.this.dataPanel_MouseReleased(event);
            }
        }

        public void mousePressed(MouseEvent event) {
            Object object = event.getSource();
            if (object == dataPanel.this) {
                dataPanel.this.dataPanel_MousePressed(event);
            }
        }
    }
}

