/*
 * Decompiled with CFR 0.152.
 */
package onewayanova;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;

public class diagram
extends Canvas {
    int degreeOfSSB;
    int degreeOfSSW;
    boolean DispDiag = false;
    double ssTotal = 0.0;
    int diameter;
    final double ssStd = 10.0;
    final int diameterStd = 10;
    Image offscreenImg;
    Graphics offscreenG;

    public diagram() {
        this.setSize(200, 215);
        this.setBackground(Color.lightGray);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        this.diameter = (int)((double)10 * Math.sqrt(this.ssTotal / 10.0));
        this.offscreenImg = this.createImage(this.getSize().width, this.getSize().height);
        this.offscreenG = this.offscreenImg.getGraphics();
        if (this.DispDiag) {
            if (this.diameter >= this.getSize().width) {
                this.offscreenG.setColor(Color.red);
                this.offscreenG.drawString("SS Total too big to display", 30, 60);
            } else {
                int x = (this.getSize().width - this.diameter) / 2;
                int y = (this.getSize().height - this.diameter) / 2 - 10;
                this.offscreenG.setColor(new Color(4585983));
                this.offscreenG.fillArc(x, y, this.diameter, this.diameter, 90, this.degreeOfSSB);
                this.offscreenG.setColor(Color.darkGray);
                this.offscreenG.fillArc(x, y, this.diameter, this.diameter, 90 + this.degreeOfSSB, this.degreeOfSSW);
            }
        }
        this.offscreenG.setFont(new Font("TimesRoman", 0, 12));
        this.offscreenG.setColor(new Color(4585983));
        this.offscreenG.fillRect(40, 193, 12, 12);
        this.offscreenG.setColor(Color.black);
        this.offscreenG.drawString("SS Between", 55, 203);
        this.offscreenG.setColor(Color.darkGray);
        this.offscreenG.fillRect(125, 193, 12, 12);
        this.offscreenG.setColor(Color.black);
        this.offscreenG.drawString("SS Within", 140, 203);
        this.offscreenG.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        g.drawImage(this.offscreenImg, 0, 0, this);
        this.offscreenG.dispose();
    }

    public void setDispDiag(boolean d) {
        this.DispDiag = d;
    }

    public void setSSTotal(double ss) {
        this.ssTotal = ss;
    }

    public void setProportion(double p) {
        this.degreeOfSSB = (int)(p * (double)360);
        this.degreeOfSSW = 360 - this.degreeOfSSB;
    }
}

