/*
 * Decompiled with CFR 0.152.
 */
package twowayanova;

import RVLS.LT;
import RVLS.Yaxis;
import RVLS.graphUtilities;
import RVLS.notified;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;

public class MeanFig
extends Canvas {
    double[] mean = new double[6];
    double[] YL;
    LT Ly;
    int[] y = new int[6];
    boolean drawFig = false;
    boolean fade = false;
    double dmax;
    double dmin;
    int ymax;
    int ymin = 15;
    int xmax;
    int xmin = 30;
    int imax = 0;
    int imin = 0;
    int x0;
    int x1;
    int x2;
    FontMetrics fm;
    Image offscreenImg;
    Graphics offscreenG;
    int id;
    Color colorA1 = new Color(255, 0, 0);
    Color colorA2 = new Color(0, 255, 0);
    String A = "A";
    String B = "B";
    notified myNotify;

    public MeanFig() {
        this.setSize(426, 266);
    }

    public void setData(double[] x) {
        this.setData(x, false);
    }

    public void setData(double[] x, boolean fade) {
        this.fade = fade;
        this.dmax = x[0];
        this.dmin = x[0];
        int i = x.length;
        if (i == 6) {
            this.drawFig = true;
            for (int j = 0; j < i; ++j) {
                this.mean[j] = x[j];
                if (this.mean[j] > this.dmax) {
                    this.dmax = this.mean[j];
                    this.imax = j;
                }
                if (!(this.mean[j] < this.dmin)) continue;
                this.dmin = this.mean[j];
                this.imin = j;
            }
            if (Math.abs(this.dmax - this.dmin) < 0.005) {
                this.dmax += (double)5;
                this.dmin -= (double)5;
            }
            this.ymax = this.getSize().height - this.ymin;
            this.xmax = this.getSize().width - this.xmin;
            this.repaint();
        } else {
            this.drawFig = false;
        }
    }

    public void setClear() {
        double[] d = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        this.setData(d);
    }

    public void clear() {
        this.drawFig = false;
        this.repaint();
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setZero() {
        double[] d = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        this.setData(d, this.fade);
    }

    public void setColor(Color A, Color B) {
        this.colorA1 = A;
        this.colorA2 = B;
    }

    public void setInform(notified myNotify) {
        this.myNotify = myNotify;
    }

    public void setString(String A, String B) {
        this.A = A;
        this.B = B;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        this.offscreenImg = this.createImage(this.getSize().width, this.getSize().height);
        this.offscreenG = this.offscreenImg.getGraphics();
        this.fm = this.offscreenG.getFontMetrics();
        if (this.drawFig) {
            this.drawAxis();
            this.offscreenG.setColor(this.colorA1);
            if (this.fade) {
                this.offscreenG.setColor(new Color(255, 128, 128));
            }
            this.offscreenG.fillOval(this.x0 - 2, this.y[0] - 2, 5, 5);
            this.offscreenG.drawLine(this.x0, this.y[0], this.x1, this.y[1]);
            this.offscreenG.fillOval(this.x1 - 2, this.y[1] - 2, 5, 5);
            this.offscreenG.drawLine(this.x1, this.y[1], this.x2, this.y[2]);
            this.offscreenG.fillOval(this.x2 - 2, this.y[2] - 2, 5, 5);
            this.offscreenG.setColor(this.colorA2);
            if (this.fade) {
                this.offscreenG.setColor(new Color(128, 128, 255));
            }
            this.offscreenG.fillOval(this.x0 - 2, this.y[3] - 2, 5, 5);
            this.offscreenG.drawLine(this.x0, this.y[3], this.x1, this.y[4]);
            this.offscreenG.fillOval(this.x1 - 2, this.y[4] - 2, 5, 5);
            this.offscreenG.drawLine(this.x1, this.y[4], this.x2, this.y[5]);
            this.offscreenG.fillOval(this.x2 - 2, this.y[5] - 2, 5, 5);
            if (this.fade) {
                this.offscreenG.setColor(Color.lightGray);
            } else {
                this.offscreenG.setColor(Color.black);
            }
            this.offscreenG.drawString(String.valueOf(String.valueOf(this.A)).concat("1"), this.x2 + 11 - this.fm.stringWidth(String.valueOf(String.valueOf(this.A)).concat("1")) / 2, this.y[2] + 5);
            this.offscreenG.drawString(String.valueOf(String.valueOf(this.A)).concat("2"), this.x2 + 11 - this.fm.stringWidth(String.valueOf(String.valueOf(this.A)).concat("2")) / 2, this.y[5] + 5);
            g.drawImage(this.offscreenImg, 0, 0, this);
            this.offscreenG.dispose();
        } else {
            this.offscreenG.setColor(new Color(180, 0, 0));
            String sTemp = "Sample size must >= 1 in";
            this.offscreenG.drawString(sTemp, 15, 30);
            sTemp = "each group to do two-way";
            this.offscreenG.drawString(sTemp, 15, 45);
            sTemp = "ANOVA analysis!";
            this.offscreenG.drawString(sTemp, 15, 60);
            g.drawImage(this.offscreenImg, 0, 0, this);
            this.offscreenG.dispose();
        }
    }

    public void drawAxis() {
        this.offscreenG.setFont(new Font("TimesRoman", 1, 12));
        String sTemp = "Figure of Means";
        this.offscreenG.drawString(sTemp, (this.xmax + this.xmin) / 2 - this.fm.stringWidth(sTemp) / 2, this.ymin);
        if (this.fade) {
            this.offscreenG.setColor(Color.lightGray);
        }
        this.offscreenG.drawLine(this.xmin, this.ymin, this.xmin, this.ymax);
        this.offscreenG.drawLine(this.xmin, this.ymax, this.xmax, this.ymax);
        this.offscreenG.setFont(new Font("TimesRoman", 0, 12));
        double d = (double)(this.xmax - this.xmin) / 6.0 + (double)this.xmin;
        this.x0 = (int)Math.round(d);
        this.offscreenG.drawLine(this.x0, this.ymax - 3, this.x0, this.ymax);
        this.offscreenG.drawString(String.valueOf(String.valueOf(this.B)).concat("1"), this.x0 - this.fm.stringWidth(String.valueOf(String.valueOf(this.B)).concat("1")) / 2, this.ymax + this.ymin);
        d = (double)(this.xmax - this.xmin) / 2.0 + (double)this.xmin;
        this.x1 = (int)Math.round(d);
        this.offscreenG.drawLine(this.x1, this.ymax - 3, this.x1, this.ymax);
        this.offscreenG.drawString(String.valueOf(String.valueOf(this.B)).concat("2"), this.x1 - this.fm.stringWidth(String.valueOf(String.valueOf(this.B)).concat("2")) / 2, this.ymax + this.ymin);
        d = (double)((this.xmax - this.xmin) * 5) / 6.0 + (double)this.xmin;
        this.x2 = (int)Math.round(d);
        this.offscreenG.drawLine(this.x2, this.ymax - 3, this.x2, this.ymax);
        this.offscreenG.drawString(String.valueOf(String.valueOf(this.B)).concat("3"), this.x2 - this.fm.stringWidth(String.valueOf(String.valueOf(this.B)).concat("3")) / 2, this.ymax + this.ymin);
        this.YL = Yaxis.ticks(this.dmin - 0.1 * (this.dmax - this.dmin), this.dmax + 0.05 * (this.dmax - this.dmin), this.ymin, this.ymax, this.offscreenG);
        int decY = this.YL[1] - this.YL[0] >= 1.0 ? 0 : (this.YL[1] - this.YL[0] >= 0.1 ? 1 : (this.YL[1] - this.YL[0] >= 0.01 ? 2 : 3));
        this.Ly = new LT(this.YL[this.YL.length - 1], this.YL[0], this.ymin, this.ymax);
        this.y = this.Ly.ItransformArray(this.mean);
        int[] labelp = this.Ly.ItransformArray(this.YL);
        this.offscreenG.setFont(new Font("TimesRoman", 0, 10));
        this.fm = this.offscreenG.getFontMetrics();
        int adj = this.fm.getAscent() / 2;
        String lastLab = "";
        for (int i = 0; i < labelp.length; ++i) {
            sTemp = graphUtilities.format(this.YL[i] - 1.0E-7, decY);
            this.offscreenG.drawLine(this.xmin, labelp[i], this.xmin + 3, labelp[i]);
            if (!sTemp.equals(lastLab)) {
                this.offscreenG.drawString(sTemp, this.xmin - 6 - this.fm.stringWidth(sTemp), labelp[i] + adj);
            }
            lastLab = sTemp;
        }
    }

    public String format(double d, int i) {
        int n = (int)Math.pow(10.0, i);
        d = (double)Math.round(d * (double)n) / (double)n;
        String s = Double.toString(d);
        for (n = s.length() - s.indexOf(46); n < i + 1; ++n) {
            s = String.valueOf(String.valueOf(s)).concat("0");
        }
        return s;
    }
}

