/*
 * Decompiled with CFR 0.152.
 */
package twowayanova;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;

public class diagram2way
extends Canvas {
    int degreeOfSSA;
    int degreeOfSSB;
    int degreeOfSSAB;
    boolean DispDiag;
    double ssTotal = 0.0;
    double ssStd = 20.0;
    int diameter;
    final int diameterStd = 6;
    Image offscreenImg;
    Graphics offscreenG;

    public diagram2way() {
        this.setSize(260, 190);
        this.setBackground(new Color(-1973791));
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        this.offscreenImg = this.createImage(this.getSize().width, this.getSize().height);
        this.offscreenG = this.offscreenImg.getGraphics();
        this.diameter = (int)((double)6 * Math.rint(Math.sqrt(this.ssTotal / this.ssStd)));
        if (this.DispDiag) {
            if (this.diameter >= this.getSize().height) {
                this.offscreenG.setColor(Color.red);
                this.offscreenG.drawString("SS Total too big to display", 40, 60);
            } else {
                int x = (this.getSize().width - 60 - this.diameter) / 2;
                int y = (this.getSize().height - this.diameter) / 2;
                this.offscreenG.setColor(Color.yellow);
                this.offscreenG.fillArc(x, y, this.diameter, this.diameter, 90, this.degreeOfSSA);
                this.offscreenG.setColor(Color.pink);
                this.offscreenG.fillArc(x, y, this.diameter, this.diameter, 90 + this.degreeOfSSA, this.degreeOfSSB);
                this.offscreenG.setColor(Color.cyan);
                this.offscreenG.fillArc(x, y, this.diameter, this.diameter, 90 + this.degreeOfSSA + this.degreeOfSSB, this.degreeOfSSAB);
                this.offscreenG.setColor(Color.darkGray);
                this.offscreenG.fillArc(x, y, this.diameter, this.diameter, 90 + this.degreeOfSSA + this.degreeOfSSB + this.degreeOfSSAB, 360 - this.degreeOfSSA - this.degreeOfSSB - this.degreeOfSSAB);
            }
        }
        this.offscreenG.setColor(Color.darkGray);
        this.offscreenG.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        this.offscreenG.setFont(new Font("TimesRoman", 0, 10));
        this.offscreenG.setColor(Color.yellow);
        this.offscreenG.fillRect(195, 40, 6, 6);
        this.offscreenG.setColor(Color.black);
        this.offscreenG.drawString("SSA", 205, 46);
        this.offscreenG.setColor(Color.pink);
        this.offscreenG.fillRect(195, 75, 6, 6);
        this.offscreenG.setColor(Color.black);
        this.offscreenG.drawString("SSB", 205, 81);
        this.offscreenG.setColor(Color.cyan);
        this.offscreenG.fillRect(195, 110, 6, 6);
        this.offscreenG.setColor(Color.black);
        this.offscreenG.drawString("SS A*B", 205, 116);
        this.offscreenG.setColor(Color.darkGray);
        this.offscreenG.fillRect(195, 145, 6, 6);
        this.offscreenG.setColor(Color.black);
        this.offscreenG.drawString("SS Error", 205, 151);
        g.drawImage(this.offscreenImg, 0, 0, this);
        this.offscreenG.dispose();
    }

    public void setDispDiag(boolean d) {
        this.DispDiag = d;
    }

    public void setProportion(double a, double b, double ab, double t) {
        this.ssTotal = t;
        this.degreeOfSSA = (int)(a / t * (double)360);
        this.degreeOfSSB = (int)(b / t * (double)360);
        this.degreeOfSSAB = (int)(ab / t * (double)360);
    }
}

