/*
 * Decompiled with CFR 0.152.
 */
package binomial;

import RVLS.LT;
import binomial.graphUtilities;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;

public class binomialDraw
extends Canvas {
    public int barWidth = 2;
    public int N;
    public int shape;
    public int ndecx;
    public int ndecy;
    public int px0;
    public int py0;
    public int pxf;
    public int pyf;
    public int[] X;
    public int[] Y;
    public boolean filled;
    public LT Lx;
    public LT Ly;
    public double[] XX;
    public double[] YY;
    public double minX;
    public double maxX;
    public double minY;
    public double maxY;
    double x0;
    double xf;
    double y0;
    double yf;
    double xinc;
    double yinc;
    double b;
    double A;
    double r;
    Graphics g;
    Color barColor = Color.blue;
    boolean doreg;
    boolean drawError = false;
    Font font;

    public void setData(double[] X, double[] Y) {
        int N = X.length;
        this.setData(X, Y, N);
    }

    public void setData(double[] X, double[] Y, int N) {
        this.minX = X[0];
        this.maxX = X[0];
        this.minY = Y[0];
        this.maxY = Y[0];
        for (int i = 1; i < N; ++i) {
            this.minX = Math.min(this.minX, X[i]);
            this.minY = Math.min(this.minY, Y[i]);
            this.maxX = Math.max(this.maxX, X[i]);
            this.maxY = Math.max(this.maxY, Y[i]);
        }
        this.setData(X, Y, this.minX, this.maxX, this.minY, this.maxY, N);
    }

    public void setData(double[] X, double[] Y, double minX, double maxX, double minY, double maxY) {
        int N = X.length;
        this.setData(X, Y, minX, maxX, minY, maxY, N);
    }

    public void setData(double[] X, double[] Y, double _minX, double _maxX, double _minY, double _maxY, int _N) {
        int[] location = new int[4];
        Dimension d = this.getSize();
        location[0] = 50;
        location[1] = d.width - 20;
        location[2] = 10;
        location[3] = d.height - 25;
        this.minX = _minX;
        this.maxX = _maxX;
        this.minY = _minY;
        this.maxY = _maxY;
        int N = _N;
        double[] XL = new double[3];
        int numLabs = 10;
        if (d.width < 150) {
            numLabs = 5;
        }
        XL = graphUtilities.intlabels(this.minX, this.maxX, numLabs);
        int stepsX = (int)Math.rint((XL[2] - XL[1]) / XL[0]);
        double x0 = XL[0];
        double xf = XL[1];
        double YaxisMax = Math.ceil(this.maxY * 20.0) / 20.0;
        if (Math.abs(YaxisMax - this.maxY) < 0.005) {
            YaxisMax += 0.05;
        }
        int stepsY = (int)Math.rint(YaxisMax / 0.05);
        int decX = 0;
        decX = XL[0] >= 1.0 ? 0 : (XL[0] >= 0.1 ? 1 : (XL[0] > 0.01 ? 2 : 3));
        if (decX > 0) {
            x0 = 0.0;
            xf = this.maxX;
            stepsX = (int)this.maxX;
            decX = 0;
        }
        int decY = 2;
        this.initialize(X, Y, XL[1], XL[2], 0.0, YaxisMax, stepsX, stepsY, location, true, decX, decY, N);
        this.repaint();
    }

    void initialize(double[] _X, double[] _Y, double _x0, double _xf, double _y0, double _yf, int xticks, int yticks, int[] _location, boolean _filled, int _ndecx, int _ndecy, int _N) {
        this.N = _N;
        this.XX = new double[this.N];
        this.XX = _X;
        this.YY = new double[this.N];
        this.YY = _Y;
        if (this.N == 1) {
            this.b = 0.0;
            this.A = this.YY[0];
            this.r = 0.0;
            _x0 = (int)(this.XX[0] - 1.0);
            _xf = (int)(this.XX[0] + 1.0);
            _y0 = (int)(this.YY[0] - 1.0);
            _yf = (int)(this.YY[0] + 1.0);
            xticks = 5;
            yticks = 5;
        }
        this.x0 = _x0;
        this.y0 = _y0;
        this.xf = _xf;
        this.yf = _yf;
        this.ndecx = _ndecx;
        this.ndecy = _ndecy;
        if (this.y0 < this.yf) {
            double temp = this.y0;
            this.y0 = this.yf;
            this.yf = temp;
        }
        this.xinc = (_xf - _x0) / (double)xticks;
        this.yinc = (this.y0 - this.yf) / (double)yticks;
        this.X = new int[this.N];
        this.Y = new int[this.N];
        this.Lx = new LT(this.x0, this.xf, _location[0], _location[1]);
        this.Ly = new LT(this.y0, this.yf, _location[2], _location[3]);
        this.Y = this.Ly.ItransformArray(_Y);
        this.X = this.Lx.ItransformArray(_X);
        this.font = new Font("TimesRoman", 0, 10);
        double xOrigin = _x0 - this.xinc / (double)8;
        this.px0 = (int)Math.rint(this.Lx.transform(xOrigin));
        double xEnd = _xf + this.xinc / (double)8;
        this.pxf = (int)Math.rint(this.Lx.transform(xEnd));
        this.py0 = (int)Math.rint(this.Ly.transform(this.y0));
        this.pyf = (int)Math.rint(this.Ly.transform(this.yf));
    }

    public void update(Graphics g) {
        Dimension dim = this.getSize();
        Image osi = this.createImage(dim.width, dim.height);
        Graphics osg = osi.getGraphics();
        osg.setColor(this.getBackground());
        osg.fillRect(0, 0, dim.width, dim.height);
        osg.setColor(g.getColor());
        this.paint(osg);
        g.drawImage(osi, 0, 0, this);
        osg.dispose();
    }

    public void paint(Graphics g) {
        g.setColor(Color.black);
        graphUtilities.plotAxes(g, this.px0, this.pxf, this.py0, this.pyf, this.x0, this.xf, this.y0, this.yf, this.font, this.Lx, this.Ly, this.xinc, this.yinc, this.ndecx, this.ndecy, false);
        g.setColor(this.barColor);
        for (int i = 0; i < this.N; ++i) {
            g.fillRect(this.X[i] - this.barWidth / 2, this.Y[i], this.barWidth, this.pyf - this.Y[i]);
        }
    }
}

