/*
 * Decompiled with CFR 0.152.
 */
package binomial;

import RVLS.LT;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class graphUtilities {
    public static void plotAxes(Graphics g, int px0, int pxf, int py0, int pyf, double x0, double xf, double y0, double yf, Font font, LT xt, LT yt, double tickStep, double tickStepy, int _XaxisDec, int _YaxisDec, boolean xonly) {
        block4: {
            int adj;
            String num;
            double i;
            if (yf > y0) {
                double temp = y0;
                y0 = yf;
                yf = temp;
                int t2 = py0;
                py0 = pyf;
                pyf = t2;
            }
            int XaxisDec = _XaxisDec;
            int YaxisDec = _YaxisDec;
            g.setFont(font);
            FontMetrics met = g.getFontMetrics(font);
            int h = met.getAscent();
            g.drawLine(px0, pyf, pxf, pyf);
            if (!xonly) {
                g.drawLine(px0, py0, px0, pyf);
            }
            int tickDest = pyf + 3;
            int tickDesty = px0 - 3;
            int xLabel = tickDest + h + 2;
            int lastXpix = 0;
            for (i = x0; i <= xf; i += tickStep) {
                int x = (int)Math.rint(xt.transform(i));
                g.drawLine(x, pyf, x, tickDest);
                num = graphUtilities.format(i, XaxisDec);
                adj = met.stringWidth(num) / 2;
                if (x - adj - 2 <= lastXpix) continue;
                g.drawString(num, x - adj, xLabel);
                lastXpix = x + adj;
            }
            if (xonly) break block4;
            for (i = yf; i <= y0; i += tickStepy) {
                int y = (int)Math.rint(yt.transform(i));
                g.drawLine(px0, y, tickDesty, y);
                num = graphUtilities.format(i, YaxisDec);
                adj = h / 2;
                g.drawString(num, tickDesty - met.stringWidth(num) - 2, y + adj);
            }
            g.drawLine(px0, py0, pxf, py0);
            g.drawLine(pxf, py0, pxf, pyf);
        }
    }

    public static synchronized double[] intlabels(double y1, double y2, int n) {
        double[] R = new double[3];
        double diff = y2 - y1;
        double x = graphUtilities.intervals(diff, n);
        double adj = 0.0;
        R[0] = x;
        R[1] = Math.floor((y1 - adj) / x) * x;
        R[2] = Math.ceil((y2 + adj) / x) * x;
        return R;
    }

    public static synchronized double intervals(double diff, int NumCats) {
        double t3;
        double[] T = new double[4];
        int[] A = new int[4];
        T[3] = t3 = Math.pow(10.0, Math.floor(Math.log(diff) * 0.4342945));
        T[2] = t3 / (double)2;
        T[1] = t3 / (double)5;
        T[0] = t3 / (double)10;
        for (int i = 0; i < 4; ++i) {
            A[i] = (int)(Math.floor(diff / T[i]) + 1.0);
        }
        int D = Math.abs(NumCats - A[0]);
        int IN = 0;
        for (int i = 1; i < 4; ++i) {
            int X;
            if (A[i] > 25 || A[i] <= 2 || (X = Math.abs(NumCats - A[i])) >= D) continue;
            D = X;
            IN = i;
        }
        return T[IN];
    }

    public static String format(double X, int nd) {
        String Rstr;
        block11: {
            String sign;
            if (X < 0.0) {
                sign = "-";
                X = Math.abs(X);
            } else {
                sign = "";
            }
            if (nd == 0) {
                long RR = (long)Math.rint(X);
                Rstr = String.valueOf(String.valueOf(RR)).concat("");
            } else {
                double xx = Math.pow(10.0, nd);
                long RR = (long)Math.rint(xx * X);
                if (RR == (long)0) {
                    Rstr = "0.";
                    for (int i = 0; i < nd; ++i) {
                        Rstr = String.valueOf(String.valueOf(Rstr)).concat("0");
                    }
                } else {
                    Rstr = String.valueOf(String.valueOf(RR)).concat("");
                    int L = Rstr.length();
                    if (L < nd) {
                        Rstr = ".";
                        for (int i = 0; i < nd - L; ++i) {
                            Rstr = String.valueOf(String.valueOf(Rstr)).concat("0");
                        }
                        Rstr = String.valueOf(String.valueOf(Rstr)).concat(String.valueOf(String.valueOf(RR)));
                    } else {
                        String sa = Rstr.substring(0, L - nd);
                        String sb = Rstr.substring(L - nd);
                        Rstr = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(sa))).append(".").append(sb)));
                    }
                }
            }
            if (Rstr.indexOf(".") == 0) {
                Rstr = "0".concat(String.valueOf(String.valueOf(Rstr)));
            }
            if (Rstr.equals("0")) break block11;
            Rstr = String.valueOf(String.valueOf(sign)).concat(String.valueOf(String.valueOf(Rstr)));
        }
        return Rstr;
    }
}

