/*
 * Decompiled with CFR 0.152.
 */
package confinterval;

import RVLS.LT;
import RVLS.graphUtilities;
import confinterval.ci;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Random;

public class ConfidePlot
extends Canvas {
    ci aa;
    int w;
    int h;
    int cumulM;
    int outt1Mean;
    int outt2Mean;
    double X;
    double t1Proport;
    double t2proport;
    final int M = 100;
    double[] Xmint1 = new double[100];
    double[] Xmaxt1 = new double[100];
    double[] Xmint2 = new double[100];
    double[] Xmaxt2 = new double[100];
    double gMin = 30.0;
    double gMax = 70.0;
    double t1 = 0.0;
    double t2 = 0.0;
    LT Lx;
    Color Xt1Color = Color.red;
    Color Xt2Color = Color.blue;
    Random rg = new Random();

    public void setBounds(int a, int b, int x, int y) {
        this.w = x;
        this.h = y;
        super.setBounds(a, b, x, y);
    }

    public void setLx() {
        this.Lx = new LT(this.gMin, this.gMax, 0.0, this.w);
        this.repaint();
    }

    public void setData(int N, double mean, double sd) {
        for (int i = 0; i < 100; ++i) {
            double Xbar = 0.0;
            double s = 0.0;
            for (int ii = 0; ii < N; ++ii) {
                this.X = sd * this.rg.nextGaussian() + mean;
                Xbar += this.X;
                s += this.X * this.X;
            }
            s = Math.sqrt((s - Xbar * Xbar / (double)N) / (double)(N - 1));
            Xbar /= (double)N;
            switch (N) {
                case 10: {
                    this.t1 = 3.25;
                    this.t2 = 2.262;
                    break;
                }
                case 15: {
                    this.t1 = 2.977;
                    this.t2 = 2.145;
                    break;
                }
                case 20: {
                    this.t1 = 2.861;
                    this.t2 = 2.093;
                }
            }
            this.Xmint1[i] = Xbar - this.t1 * s / Math.sqrt(N);
            this.Xmaxt1[i] = Xbar + this.t1 * s / Math.sqrt(N);
            if (this.Xmint1[i] > mean) {
                ++this.outt1Mean;
            } else if (this.Xmaxt1[i] < mean) {
                ++this.outt1Mean;
            }
            this.Xmint2[i] = Xbar - this.t2 * s / Math.sqrt(N);
            this.Xmaxt2[i] = Xbar + this.t2 * s / Math.sqrt(N);
            if (this.Xmint2[i] > mean) {
                ++this.outt2Mean;
                continue;
            }
            if (!(this.Xmaxt2[i] < mean)) continue;
            ++this.outt2Mean;
        }
        this.cumulM += 100;
        this.repaint();
    }

    public void clearGraph() {
        for (int i = 0; i < 100; ++i) {
            this.Xmint1[i] = 0.0;
            this.Xmaxt1[i] = 0.0;
            this.Xmint2[i] = 0.0;
            this.Xmaxt2[i] = 0.0;
        }
        this.repaint();
    }

    public void clearDisplay() {
        this.outt1Mean = 0;
        this.outt2Mean = 0;
        this.cumulM = 0;
        this.clearGraph();
    }

    public void paint(Graphics g) {
        g.setFont(new Font("Monospaced", 0, 12));
        Font f = g.getFont();
        FontMetrics fm = g.getFontMetrics(f);
        int w50 = fm.stringWidth("50") / 2;
        int w70 = fm.stringWidth("70");
        int verMarg = fm.getHeight();
        int xMiddle = (int)Math.rint(0.5 * (double)this.w);
        g.drawString("30", 0, verMarg - 3);
        g.drawString("50", xMiddle - w50, verMarg - 3);
        g.drawString("70", this.w - w70, verMarg - 3);
        for (int i = 0; i < 100; ++i) {
            int Xminpix = this.Lx.Itransform(this.Xmint1[i]);
            int Xmaxpix = this.Lx.Itransform(this.Xmaxt1[i]);
            if (this.Xmint1[i] > (double)50 || this.Xmaxt1[i] < (double)50) {
                g.setColor(Color.white);
            } else {
                g.setColor(Color.blue);
            }
            g.drawLine(Xminpix, verMarg + 4 * i, Xmaxpix, verMarg + 4 * i);
            g.drawLine(Xminpix, verMarg + 4 * i + 1, Xmaxpix, verMarg + 4 * i + 1);
            Xminpix = this.Lx.Itransform(this.Xmint2[i]);
            Xmaxpix = this.Lx.Itransform(this.Xmaxt2[i]);
            if (this.Xmint2[i] > (double)50 || this.Xmaxt2[i] < (double)50) {
                g.setColor(Color.red);
            } else {
                g.setColor(Color.orange);
            }
            g.drawLine(Xminpix, verMarg + 4 * i, Xmaxpix, verMarg + 4 * i);
            g.drawLine(Xminpix, verMarg + 4 * i + 1, Xmaxpix, verMarg + 4 * i + 1);
            g.setColor(Color.black);
            g.drawLine(xMiddle, verMarg, xMiddle, verMarg + 4 * i);
        }
        this.aa.textField1.setText(String.valueOf(String.valueOf(this.cumulM - this.outt1Mean)).concat(""));
        this.aa.textField2.setText(String.valueOf(String.valueOf(this.outt1Mean)).concat(""));
        this.aa.textField3.setText(String.valueOf(String.valueOf(graphUtilities.format((double)(this.cumulM - this.outt1Mean) / (double)this.cumulM, 3))).concat(""));
        this.aa.textField4.setText(String.valueOf(String.valueOf(this.cumulM - this.outt2Mean)).concat(""));
        this.aa.textField5.setText(String.valueOf(String.valueOf(this.outt2Mean)).concat(""));
        this.aa.textField6.setText(String.valueOf(String.valueOf(graphUtilities.format((double)(this.cumulM - this.outt2Mean) / (double)this.cumulM, 3))).concat(""));
    }

    public void setApp(ci appl) {
        this.aa = appl;
    }
}

