/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt.util;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import symantec.itools.awt.AlignStyle;
import symantec.itools.awt.BevelStyle;
import symantec.itools.awt.util.ColorUtils;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.util.GeneralUtils;

public class ProgressBar
extends Canvas
implements BevelStyle,
AlignStyle {
    public static final int INDENT_ZERO = 0;
    public static final int INDENT_ONE = 1;
    public static final int INDENT_TWO = 2;
    protected transient Image bufferImage;
    protected Color bevelLighterColor;
    protected Color bevelDarkerColor;
    protected Color cachedBackground;
    protected Color borderColor;
    protected Color progressColor;
    protected boolean bShowProgress = true;
    protected boolean bDrawBoxes = false;
    protected int progress = 0;
    protected int boxWidth = 8;
    protected int gapWidth = 2;
    protected int indent;
    protected int align;
    protected int type;
    private BoxVeto boxVeto;
    private GapVeto gapVeto;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public ProgressBar() {
        this(1, 2, 0);
    }

    public ProgressBar(int align, int bevel, int indent) {
        this.borderColor = Color.black;
        this.progressColor = Color.blue;
        this.cachedBackground = this.getBackground();
        try {
            this.setBorderIndent(indent, false);
            this.setBevelStyle(bevel);
            this.setAlignStyle(align);
        }
        catch (PropertyVetoException propertyVetoException) {}
        if (this.boxVeto == null) {
            this.boxVeto = new BoxVeto();
            this.addBoxWidthListener(this.boxVeto);
        }
        if (this.gapVeto == null) {
            this.gapVeto = new GapVeto();
            this.addGapWidthListener(this.gapVeto);
        }
    }

    public void setProgressBarColor(Color c) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.progressColor, c)) {
            Color oldValue = this.progressColor;
            this.vetos.fireVetoableChange("progressBarColor", oldValue, c);
            this.progressColor = c;
            this.repaint();
            this.changes.firePropertyChange("progressBarColor", oldValue, c);
        }
    }

    public Color getProgressBarColor() {
        return this.progressColor;
    }

    public void setProgressBarTextColor(Color c) throws PropertyVetoException {
        this.setForeground(c);
    }

    public Color getProgressBarTextColor() {
        return this.getForeground();
    }

    public void setDrawBoxes(boolean b) throws PropertyVetoException {
        if (this.bDrawBoxes != b) {
            Boolean oldDrawBoxesBoolean = new Boolean(this.bDrawBoxes);
            Boolean newDrawBoxesBoolean = new Boolean(b);
            this.vetos.fireVetoableChange("drawBoxes", oldDrawBoxesBoolean, newDrawBoxesBoolean);
            this.bDrawBoxes = b;
            this.repaint();
            this.changes.firePropertyChange("drawBoxes", oldDrawBoxesBoolean, newDrawBoxesBoolean);
        }
    }

    public boolean isDrawBoxes() {
        return this.bDrawBoxes;
    }

    public boolean getDrawBoxes() {
        return this.isDrawBoxes();
    }

    public void setBoxWidth(int i) throws PropertyVetoException {
        Integer newValue = new Integer(i);
        Integer oldValue = new Integer(this.boxWidth);
        this.vetos.fireVetoableChange("boxWidth", oldValue, newValue);
        this.boxWidth = i;
        this.repaint();
        this.changes.firePropertyChange("boxWidth", oldValue, newValue);
    }

    public int getBoxWidth() {
        return this.boxWidth;
    }

    public void setGapWidth(int i) throws PropertyVetoException {
        Integer newValue = new Integer(i);
        Integer oldValue = new Integer(this.gapWidth);
        this.vetos.fireVetoableChange("gapWidth", oldValue, newValue);
        this.gapWidth = i;
        this.repaint();
        this.changes.firePropertyChange("gapWidth", oldValue, newValue);
    }

    public int getGapWidth() {
        return this.gapWidth;
    }

    public boolean getShowProgress() {
        return this.isShowProgress();
    }

    public void setShowProgress(boolean b) throws PropertyVetoException {
        if (this.bShowProgress != b) {
            Boolean oldValue = new Boolean(this.bShowProgress);
            Boolean newValue = new Boolean(b);
            this.vetos.fireVetoableChange("showProgress", oldValue, newValue);
            this.bShowProgress = b;
            this.repaint();
            this.changes.firePropertyChange("showProgress", oldValue, newValue);
        }
    }

    public boolean isShowProgress() {
        return this.bShowProgress;
    }

    public void setAlignStyle(int style) throws PropertyVetoException {
        Integer newValue = new Integer(style);
        Integer oldValue = new Integer(this.align);
        this.vetos.fireVetoableChange("alignStyle", oldValue, newValue);
        this.align = style;
        this.repaint();
        this.changes.firePropertyChange("alignStyle", oldValue, newValue);
    }

    public int getAlignStyle() {
        return this.align;
    }

    public void setBevelStyle(int style) throws PropertyVetoException {
        if (this.type != style) {
            Integer oldValue = new Integer(this.type);
            Integer newValue = new Integer(style);
            this.vetos.fireVetoableChange("bevelStyle", oldValue, newValue);
            this.type = style;
            this.repaint();
            this.changes.firePropertyChange("bevelStyle", oldValue, newValue);
        }
    }

    public int getBevelStyle() {
        return this.type;
    }

    public void setBorderIndent(int indent) throws PropertyVetoException {
        this.setBorderIndent(indent, true);
    }

    public int getBorderIndent() {
        return this.indent;
    }

    public void setBorderColor(Color color) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.borderColor, color)) {
            Color oldValue = this.getBorderColor();
            this.vetos.fireVetoableChange("borderColor", oldValue, color);
            this.borderColor = color;
            this.repaint();
            this.changes.firePropertyChange("borderColor", oldValue, color);
        }
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderedColor(Color color) throws PropertyVetoException {
        this.setBorderColor(color);
    }

    public Color getBorderedColor() {
        return this.getBorderColor();
    }

    public void setProgressPercent(int p) throws PropertyVetoException {
        if (p < 0) {
            p = 0;
        }
        if (p > 100) {
            p = 100;
        }
        if (this.progress != p) {
            Integer oldValue = new Integer(this.progress);
            Integer newValue = new Integer(p);
            this.vetos.fireVetoableChange("progressPercent", oldValue, newValue);
            this.progress = p;
            this.repaint();
            this.changes.firePropertyChange("progressPercent", oldValue, newValue);
        }
    }

    public void updateProgress(int p) throws PropertyVetoException {
        this.setProgressPercent(p);
    }

    public int getProgressPercent() {
        return this.progress;
    }

    public void setValue(int p) throws PropertyVetoException {
        this.setProgressPercent(p);
    }

    public int getValue() {
        return this.progress;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Color curBackground = this.getBackground();
        if (!GeneralUtils.objectsEqual(curBackground, this.cachedBackground)) {
            this.cachedBackground = curBackground;
            this.calculateHilightColors(curBackground);
        }
        this.updateBufferImage();
        g.drawImage(this.bufferImage, 0, 0, this);
    }

    public Dimension getPreferredSize() {
        Dimension s = this.getSize();
        Dimension m = this.getMinimumSize();
        return new Dimension(Math.max(s.width, m.width), Math.max(s.height, m.height));
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        Font f = null;
        FontMetrics fm = null;
        f = this.getFont();
        if (f != null) {
            fm = this.getFontMetrics(f);
        }
        if (fm != null) {
            return new Dimension(50, fm.getHeight() + 4);
        }
        return new Dimension(50, 20);
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public synchronized void addNotify() {
        if (this.boxVeto == null) {
            this.boxVeto = new BoxVeto();
            this.addBoxWidthListener(this.boxVeto);
        }
        if (this.gapVeto == null) {
            this.gapVeto = new GapVeto();
            this.addGapWidthListener(this.gapVeto);
        }
        super.addNotify();
    }

    public synchronized void removeNotify() {
        if (this.boxVeto != null) {
            this.removeBoxWidthListener(this.boxVeto);
            this.boxVeto = null;
        }
        if (this.gapVeto != null) {
            this.removeGapWidthListener(this.gapVeto);
            this.gapVeto = null;
        }
        super.removeNotify();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener(listener);
    }

    public void addGapWidthListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener("gapWidth", listener);
    }

    public void removeGapWidthListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener("gapWidth", listener);
    }

    public void addGapWidthListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener("gapWidth", listener);
    }

    public void removeGapWidthListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener("gapWidth", listener);
    }

    public void addBoxWidthListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener("boxWidth", listener);
    }

    public void removeBoxWidthListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener("boxWidth", listener);
    }

    public void addBoxWidthListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener("boxWidth", listener);
    }

    public void removeBoxWidthListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener("boxWidth", listener);
    }

    protected boolean isValidBoxWidth(int i) {
        return i > 0;
    }

    protected boolean isValidGapWidth(int i) {
        return i >= 0;
    }

    protected void updateBufferImage() {
        Dimension s = this.getSize();
        int width = s.width - 1;
        int height = s.height - 1;
        int barHeight = height - this.indent - this.indent - 1;
        int barOffset = this.indent + 1;
        Color color1 = null;
        Color color2 = null;
        if (this.isBufferImageInvalid()) {
            this.bufferImage = this.createImage(s.width, s.height);
            try {
                MediaTracker tracker = new MediaTracker(this);
                tracker.addImage(this.bufferImage, 0);
                tracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {}
        }
        Graphics g = this.bufferImage.getGraphics();
        Color oldColor = g.getColor();
        g.setColor(this.cachedBackground);
        g.fillRect(0, 0, s.width, s.height);
        g.setColor(this.progressColor);
        int position = (s.width - this.indent - this.indent - 2) * this.progress / 100;
        g.fillRect(barOffset, barOffset, position, barHeight);
        if (this.bDrawBoxes) {
            int offsetConstant;
            int totalWidth = this.boxWidth + this.gapWidth;
            int offset = offsetConstant = this.boxWidth + barOffset;
            int i = 0;
            int internalPos = position + barOffset;
            g.setColor(this.cachedBackground);
            while (offset <= internalPos) {
                g.fillRect(offset, barOffset, this.gapWidth, barHeight);
                offset = totalWidth * ++i + offsetConstant;
            }
            int xpos = totalWidth * (i - 1) + offsetConstant + this.gapWidth;
            int rWidth = internalPos - xpos;
            if (rWidth < this.boxWidth) {
                g.fillRect(xpos, barOffset, rWidth, barHeight);
            }
        }
        if (this.type != 3) {
            switch (this.type) {
                case 2: {
                    color1 = color2 = this.borderColor;
                    break;
                }
                case 1: {
                    color1 = this.bevelLighterColor;
                    color2 = this.bevelDarkerColor;
                    break;
                }
                case 0: {
                    color1 = this.bevelDarkerColor;
                    color2 = this.bevelLighterColor;
                    break;
                }
            }
            g.setColor(color1);
            g.drawLine(this.indent, this.indent, width - this.indent, this.indent);
            g.setColor(color2);
            g.drawLine(this.indent, height - this.indent, width - this.indent, height - this.indent);
            g.setColor(color1);
            g.drawLine(this.indent, this.indent, this.indent, height - this.indent);
            g.setColor(color2);
            g.drawLine(width - this.indent, this.indent, width - this.indent, height - this.indent);
        }
        if (this.bShowProgress) {
            g.setColor(this.getForeground());
            FontMetrics fm = this.getFontMetrics(this.getFont());
            String sz = String.valueOf(Integer.toString(this.progress)) + "%";
            int yTemp = (s.height + fm.getAscent()) / 2 - 2;
            switch (this.align) {
                case 0: {
                    if (this.type == 3) {
                        g.drawString(sz, 4, yTemp);
                        break;
                    }
                    g.drawString(sz, 8, yTemp);
                    break;
                }
                case 2: {
                    int xTemp = s.width - fm.stringWidth(sz);
                    if (this.type == 3) {
                        g.drawString(sz, xTemp - 6, yTemp);
                        break;
                    }
                    g.drawString(sz, xTemp - 10, yTemp);
                    break;
                }
                case 1: {
                    int xTemp = (s.width - fm.stringWidth(sz)) / 2;
                    if (this.type == 3) {
                        g.drawString(sz, xTemp, yTemp);
                        break;
                    }
                    g.drawString(sz, xTemp, yTemp);
                    break;
                }
            }
        }
        g.setColor(oldColor);
    }

    protected boolean isBufferImageInvalid() {
        Dimension s = this.getSize();
        return this.bufferImage == null || s.width != this.bufferImage.getWidth(this) || s.height != this.bufferImage.getHeight(this);
    }

    protected void calculateHilightColors(Color c) {
        this.bevelLighterColor = ColorUtils.calculateHilightColor(c);
        this.bevelDarkerColor = ColorUtils.calculateShadowColor(c);
    }

    protected void setBorderIndent(int indent, boolean bRepaint) throws PropertyVetoException {
        if (this.indent != indent) {
            Integer oldValue = new Integer(this.indent);
            Integer newValue = new Integer(indent);
            this.vetos.fireVetoableChange("borderIndent", oldValue, newValue);
            this.indent = indent < 0 ? 0 : (indent > 2 ? 2 : indent);
            if (bRepaint) {
                this.repaint();
            }
            this.changes.firePropertyChange("borderIndent", oldValue, new Integer(this.indent));
        }
    }

    class BoxVeto
    implements VetoableChangeListener,
    Serializable {
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            int i = (Integer)e.getNewValue();
            if (!ProgressBar.this.isValidBoxWidth(i)) {
                throw new PropertyVetoException("Invalid box width: " + i, e);
            }
        }

        BoxVeto() {
            ProgressBar.this = ProgressBar.this;
        }
    }

    class GapVeto
    implements VetoableChangeListener,
    Serializable {
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            int i = (Integer)e.getNewValue();
            if (!ProgressBar.this.isValidGapWidth(i)) {
                throw new PropertyVetoException("Invalid gap width: " + i, e);
            }
        }

        GapVeto() {
            ProgressBar.this = ProgressBar.this;
        }
    }
}

