/*
 * Decompiled with CFR 0.152.
 */
package districomapre;

import RVLS.message;
import districomapre.chisquare;

public class chisquareAdjust
extends chisquare {
    protected double mean;
    protected double sd;
    protected double k = 1.0;
    protected double u = 0.0;
    boolean positiveSkew = true;

    public chisquareAdjust() {
        this.setTitle(String.valueOf(String.valueOf(new StringBuffer("Chi-square adjusted, df=").append(this.df).append(", mean=").append(this.mean).append(", sd=").append(this.sd))));
    }

    public void setSkewDegree(int degree) {
        this.positiveSkew = degree >= 0;
        degree = Math.abs(degree);
        this.setDf(degree);
    }

    public void setMeanSd(double mean, double sd) {
        if (Math.abs(sd - 0.0) < 0.001) {
            message m = new message("\r\r\rStandard Error should not be 0");
            m.show();
            return;
        }
        this.mean = mean;
        this.sd = sd;
        this.k = sd / Math.sqrt(2.0 * (double)this.df);
        this.u = mean - sd * Math.sqrt((double)this.df / 2.0);
        this.paramChange();
    }

    public void setLimits(double lowLimit, double upLimit, int numTicks) {
        this.lowLimit = lowLimit;
        this.upLimit = upLimit;
        this.range = upLimit - lowLimit;
        this.numTicks = numTicks;
        this.firstTick = lowLimit;
        if (!this.positiveSkew) {
            this.u = upLimit + lowLimit - this.k * (double)this.df - this.mean;
        }
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void paramChange() {
        if (this.autoSetLimits) {
            this.firstTick = this.lowLimit = this.u;
            this.upLimit = (double)this.df + (double)4 * Math.sqrt(2.0 * (double)this.df);
            this.upLimit = this.k * this.upLimit + this.u;
            if (!this.positiveSkew) {
                if (Math.abs(this.sd - 1.0) < 5.0E-5) {
                    this.lowLimit = -4.2;
                    this.upLimit = 6.0;
                } else if (Math.abs(this.sd - 2.0) < 5.0E-5) {
                    this.lowLimit = -7.2;
                    this.upLimit = 8.0;
                } else if (Math.abs(this.sd - 3.0) < 5.0E-5) {
                    this.lowLimit = -10.0;
                    this.upLimit = 10.1;
                } else if (Math.abs(this.sd - 4.0) < 5.0E-5) {
                    this.lowLimit = -11.0;
                    this.upLimit = 12.0;
                } else if (Math.abs(this.sd - 5.0) < 5.0E-5) {
                    this.lowLimit = -12.0;
                    this.upLimit = 13.0;
                }
                this.firstTick = this.lowLimit;
                this.u = this.upLimit + this.lowLimit - this.k * (double)this.df - this.mean;
            }
            this.range = this.upLimit - this.lowLimit;
        }
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public double getDensity(double x) {
        int vv = 1;
        int v = 1;
        x = !this.positiveSkew ? (this.upLimit + this.lowLimit - this.u - x) / this.k : (x - this.u) / this.k;
        for (int i = 1; i < this.df / 2 - 1; ++i) {
            vv *= v + 1;
            ++v;
        }
        double y = x > 0.0 ? Math.pow(x, this.df / 2 - 1) * Math.exp(-x / 2.0) / (Math.pow(2.0, this.df / 2) * (double)vv * this.k) : 0.0;
        return y;
    }

    public double getYmax() {
        int vv = 1;
        int v = 1;
        double ymax = 0.0;
        for (int i = 1; i < this.df / 2 - 1; ++i) {
            vv *= v + 1;
            ++v;
        }
        for (double x = 0.0; x < (double)30; x += 1.0) {
            if (!(x > 0.0)) continue;
            double y = Math.pow(x, this.df / 2 - 1) * Math.exp(-x / 2.0) / (Math.pow(2.0, this.df / 2) * (double)vv * this.k);
            ymax = Math.max(ymax, y);
        }
        return ymax;
    }
}

