/*
 * Decompiled with CFR 0.152.
 */
import RVLS.LT;
import RVLS.Sort;
import RVLS.Yaxis;
import java.awt.Button;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

public class medainGraph
extends Panel {
    Label label1;
    Button button1;
    Button button2;
    int width;
    int height;
    int currentY;
    boolean[] ondot = new boolean[5];
    boolean online = false;
    int Yaxis;
    public int[] x = new int[5];
    public int[] y = new int[5];
    public Color[] color = new Color[]{Color.red, Color.blue, Color.green, Color.orange, Color.magenta};
    medainGraphOwner owner = null;
    public int adjWidth = 0;
    public int adjAcent;
    public int labelMin;
    double scale = 5.0;
    Color backgroundColor = new Color(0xF9FFF3);
    public LT lt;

    public medainGraph() {
        this.setLayout(null);
        this.setSize(200, 150);
        this.setFont(new Font("Dialog", 0, 10));
        SymMouse symMouse = new SymMouse();
        this.addMouseListener(symMouse);
        SymMouseMotion symMouseMotion = new SymMouseMotion();
        this.addMouseMotionListener(symMouseMotion);
    }

    public medainGraph(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.setSize(this.width, this.height);
        this.setFont(new Font("Dialog", 0, 10));
    }

    public void addButtons() {
    }

    public void drawYaxisPosition(Graphics graphics, int n) {
        graphics.setFont(new Font("Dialog", 0, 10));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = (int)Math.round((double)fontMetrics.getAscent() / 2.0);
        double d = this.lt.transformToValue(n);
        if (n <= 22) {
            graphics.drawString(Utility.format(d, 2), this.width - this.adjWidth + 2, 20 + n2 + 2);
        } else if (n >= this.height - 3 - 60) {
            graphics.drawString(Utility.format(d, 2), this.width - this.adjWidth + 2, n + n2 - 2);
        } else {
            graphics.drawString(Utility.format(d, 2), this.width - this.adjWidth + 2, n + n2 - 1);
        }
    }

    public void getXY(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        this.adjWidth = fontMetrics.stringWidth(String.valueOf(4.99)) + 2;
        this.labelMin = fontMetrics.stringWidth("Minimize sum of absolute deviations") + 2;
        int n = (int)Math.rint((double)(this.width - this.adjWidth - 30) / 6.0);
        int n2 = 0;
        while (n2 < 5) {
            this.x[n2] = 30 + Math.round(n * (n2 + 1));
            ++n2;
        }
        n = (int)Math.round((double)(this.height - 5 - 60) / 5.0);
        this.y[0] = this.height - 3 - 60 - (int)Math.round(0.2 * (double)(this.height - 5 - 80));
        this.y[1] = this.height - 3 - 60 - (int)Math.round(0.4 * (double)(this.height - 5 - 80));
        this.y[2] = this.height - 3 - 60 - (int)Math.round(0.6 * (double)(this.height - 5 - 80));
        this.y[3] = this.height - 3 - 60 - (int)Math.round(0.8 * (double)(this.height - 5 - 80));
        this.y[4] = 22;
        if (this.lt == null) {
            this.lt = new LT(0.0, this.scale, this.height - 3 - 60, 22.0);
        }
        this.Yaxis = this.lt.Itransform(0.25);
    }

    public double mean(int[] nArray) {
        double d = 0.0;
        int n = 0;
        while (n < nArray.length) {
            d += (double)nArray[n];
            ++n;
        }
        if (nArray.length > 0) {
            d /= (double)nArray.length;
        }
        return d;
    }

    void medainGraph_MouseDragged(MouseEvent mouseEvent) {
        this.currentY = mouseEvent.getY();
        if (this.currentY >= this.height - 3 - 60) {
            this.currentY = this.height - 3 - 60;
        } else if (this.currentY <= 22) {
            this.currentY = 22;
        }
        int n = 0;
        while (n < 5) {
            if (this.ondot[n]) {
                Graphics graphics = this.getGraphics();
                this.y[n] = this.currentY;
                this.repaint();
                this.owner.valueChanged(22, this.height - 60 - 3, this.Yaxis, this.y);
                return;
            }
            ++n;
        }
        if (this.online) {
            Graphics graphics = this.getGraphics();
            this.Yaxis = this.currentY;
            this.repaint();
            this.owner.valueChanged(22, this.height - 60 - 3, this.Yaxis, this.y);
        }
    }

    void medainGraph_MousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        boolean bl = false;
        int n3 = 0;
        while (n3 < 5) {
            if (Math.abs(n - this.x[n3]) < 5 && Math.abs(n2 - this.y[n3]) < 5) {
                this.ondot[n3] = true;
                this.online = false;
                bl = true;
            } else {
                this.ondot[n3] = false;
            }
            ++n3;
        }
        if (Math.abs(n2 - this.Yaxis) < 5 && !bl) {
            this.online = true;
        }
    }

    void medainGraph_MouseReleased(MouseEvent mouseEvent) {
        this.repaint();
    }

    public int median(int[] nArray) {
        double[] dArray = new double[]{nArray[0], nArray[1], nArray[2], nArray[3], nArray[4]};
        Sort.sort(dArray);
        int n = nArray.length;
        if (n % 2 == 0) {
            int n2 = n / 2;
            return (int)Math.round((dArray[n2] + dArray[n2 - 1]) / 2.0);
        }
        return (int)Math.round(dArray[n / 2]);
    }

    public void paint(Graphics graphics) {
        Image image = this.createImage(this.getSize().width, this.getSize().height);
        Graphics graphics2 = image.getGraphics();
        FontMetrics fontMetrics = graphics2.getFontMetrics();
        this.adjAcent = (int)Math.round((double)fontMetrics.getAscent() / 2.0);
        graphics2.setColor(this.backgroundColor);
        graphics2.fillRect(30, 20, this.width - this.adjWidth - 30, this.height - 80);
        graphics2.setColor(Color.black);
        graphics2.fillRect(30, this.Yaxis - 1, this.width - this.adjWidth - 30, 3);
        double[] dArray = new double[(int)this.scale + 1];
        int n = 0;
        while (n < (int)this.scale + 1) {
            dArray[n] = n;
            ++n;
        }
        RVLS.Yaxis.drawYaxis(22, this.height - 60 - 3, 28, dArray, 0, graphics2);
        this.drawYaxisPosition(graphics2, this.Yaxis);
        int n2 = 0;
        while (n2 < 5) {
            graphics2.setColor(this.color[n2]);
            graphics2.drawLine(this.x[n2], this.Yaxis, this.x[n2], this.y[n2]);
            graphics2.fillOval(this.x[n2] - 2, this.y[n2] - 2, 5, 5);
            ++n2;
        }
        this.paintData(graphics2);
        graphics.drawImage(image, 0, 0, this);
        graphics2.dispose();
    }

    public void paintData(Graphics graphics) {
        String string = "";
        int[] nArray = new int[5];
        FontMetrics fontMetrics = graphics.getFontMetrics();
        this.adjAcent = (int)Math.round((double)fontMetrics.getAscent() / 2.0);
        int n = 0;
        while (n < this.y.length) {
            int n2;
            double d = this.lt.transformToValue(this.y[n]);
            string = Utility.format(d, 2);
            if (this.y[n] < 30) {
                n2 = 32;
                nArray[n] = this.x[n] + fontMetrics.stringWidth(string) / 2 + 4;
            } else if (this.y[n] > this.height - 60 - 10) {
                n2 = this.height - 60 - 2 - 2;
                nArray[n] = this.x[n] + fontMetrics.stringWidth(string) / 2 + 4;
            } else if (this.Yaxis >= this.y[n]) {
                n2 = this.y[n] - this.adjAcent;
                nArray[n] = this.x[n];
            } else {
                n2 = this.y[n] + 2 * this.adjAcent + 3;
                nArray[n] = this.x[n];
            }
            graphics.setColor(this.color[n]);
            graphics.drawString(string, nArray[n] - fontMetrics.stringWidth(string) / 2, n2);
            ++n;
        }
    }

    public void setColor(Color[] colorArray) {
        this.color = colorArray;
    }

    public void setOwner(medainGraphOwner medainGraphOwner2) {
        this.owner = medainGraphOwner2;
        this.width = this.getSize().width;
        this.height = this.getSize().height;
        this.label1 = new Label("Drag the line or the dots below to change the data.", 0);
        this.label1.setBounds(30, 0, this.width - 30, 16);
        this.label1.setFont(new Font("Dialog", 0, 10));
        this.add(this.label1);
        Graphics graphics = this.getGraphics();
        this.getXY(graphics);
        this.addButtons();
        this.owner.valueChanged(22, this.height - 60 - 3, this.Yaxis, this.y);
    }

    public void setScale(double d) {
        this.scale = d;
    }

    public void setXY(int[] nArray, int[] nArray2) {
        if (nArray.length > 5 || nArray2.length > 5) {
            return;
        }
        int n = 0;
        while (n < 5) {
            if (nArray[n] < 0 || nArray[n] > this.width - 1 || nArray2[n] < 0 || nArray2[n] > this.height - 1) {
                return;
            }
            ++n;
        }
        this.x = nArray;
        this.y = nArray2;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    class SymMouse
    extends MouseAdapter {
        SymMouse() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object == medainGraph.this) {
                medainGraph.this.medainGraph_MousePressed(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object == medainGraph.this) {
                medainGraph.this.medainGraph_MouseReleased(mouseEvent);
            }
        }
    }

    class SymMouseMotion
    extends MouseMotionAdapter {
        SymMouseMotion() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object == medainGraph.this) {
                medainGraph.this.medainGraph_MouseDragged(mouseEvent);
            }
        }
    }
}

