/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.ResourceBundle;
import symantec.itools.awt.AlignStyle;
import symantec.itools.awt.ButtonBase;
import symantec.itools.awt.util.ColorUtils;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.util.GeneralUtils;

public class LabelButton
extends ButtonBase
implements AlignStyle {
    public static final int ALIGN_TOP = 0;
    public static final int ALIGN_BOTTOM = 2;
    protected String sLabelButton;
    protected int vAlignStyle;
    protected int hAlignStyle;
    protected Color textColor;
    protected Color pressedTextColor;
    protected Color disabledTextColor;
    protected transient ResourceBundle errors;
    private HAVeto horizontalVeto;
    private VAVeto verticalVeto;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public LabelButton() {
        this("", 1, 1, Color.black);
    }

    public LabelButton(String string) {
        this(string, 1, 1, Color.black);
    }

    public LabelButton(String string, Color color) {
        this(string, 1, 1, color);
    }

    public LabelButton(String string, int n) {
        this(string, n, 1, Color.black);
    }

    public LabelButton(String string, int n, int n2, Color color) {
        try {
            this.setText(string);
            this.setTextColor(color);
            this.setAlignStyle(n);
            this.setVerticalAlignStyle(n2);
            return;
        }
        catch (PropertyVetoException propertyVetoException) {
            return;
        }
    }

    public void setAlignStyle(int n) throws PropertyVetoException {
        if (this.hAlignStyle != n) {
            Integer n2 = new Integer(this.hAlignStyle);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("AlignStyle", n2, n3);
            this.hAlignStyle = n;
            this.repaint();
            this.changes.firePropertyChange("AlignStyle", n2, n3);
        }
    }

    public int getAlignStyle() {
        return this.hAlignStyle;
    }

    public void setVerticalAlignStyle(int n) throws PropertyVetoException {
        if (this.vAlignStyle != n) {
            Integer n2 = new Integer(this.vAlignStyle);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("VerticalAlignStyle", n2, n3);
            this.vAlignStyle = n;
            this.repaint();
            this.changes.firePropertyChange("VerticalAlignStyle", n2, n3);
        }
    }

    public int getVerticalAlignStyle() {
        return this.vAlignStyle;
    }

    public void setText(String string) throws PropertyVetoException {
        if (this.sLabelButton == null || !this.sLabelButton.equals(string)) {
            String string2 = this.sLabelButton == null ? null : new String(this.sLabelButton);
            this.vetos.fireVetoableChange("Text", string2, string);
            this.sLabelButton = string;
            this.repaint();
            this.changes.firePropertyChange("Text", string2, string);
        }
    }

    public String getText() {
        return this.sLabelButton;
    }

    public void setTextColor(Color color) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.textColor, color)) {
            Color color2 = this.textColor;
            this.vetos.fireVetoableChange("TextColor", color2, color);
            this.textColor = color;
            try {
                this.disabledTextColor = ColorUtils.lighten(this.textColor, 0.333);
                this.pressedTextColor = ColorUtils.darken(this.textColor, 0.25);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            this.repaint();
            this.changes.firePropertyChange("TextColor", color2, color);
        }
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public Dimension getPreferredSize() {
        if (this.isAdded) {
            this.size();
            Graphics graphics = this.getGraphics();
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = 0;
            if (this.sLabelButton != null && !this.sLabelButton.equals("")) {
                n = fontMetrics.stringWidth(this.sLabelButton);
            }
            if (graphics != null) {
                graphics.dispose();
            }
            return new Dimension(n + this.bevel + this.bevel + 4, fontMetrics.getAscent() + fontMetrics.getDescent() + this.bevel + this.bevel + 4);
        }
        return super.getPreferredSize();
    }

    public synchronized void addNotify() {
        super.addNotify();
        this.errors = ResourceBundle.getBundle("symantec.itools.resources.ErrorsBundle");
        if (this.horizontalVeto == null) {
            this.horizontalVeto = new HAVeto();
            this.addAlignStyleListener(this.horizontalVeto);
        }
        if (this.verticalVeto == null) {
            this.verticalVeto = new VAVeto();
            this.addVerticalAlignStyleListener(this.verticalVeto);
        }
    }

    public synchronized void removeNotify() {
        if (this.horizontalVeto != null) {
            this.removeAlignStyleListener(this.horizontalVeto);
            this.horizontalVeto = null;
        }
        if (this.verticalVeto != null) {
            this.removeVerticalAlignStyleListener(this.verticalVeto);
            this.verticalVeto = null;
        }
        super.removeNotify();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        super.addVetoableChangeListener(vetoableChangeListener);
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        super.removeVetoableChangeListener(vetoableChangeListener);
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void addAlignStyleListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener("AlignStyle", propertyChangeListener);
    }

    public synchronized void removeAlignStyleListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener("AlignStyle", propertyChangeListener);
    }

    public synchronized void addAlignStyleListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener("AlignStyle", vetoableChangeListener);
    }

    public synchronized void removeAlignStyleListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener("AlignStyle", vetoableChangeListener);
    }

    public synchronized void addVerticalAlignStyleListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener("VerticalAlignStyle", propertyChangeListener);
    }

    public synchronized void removeVerticalAlignStyleListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener("VerticalAlignStyle", propertyChangeListener);
    }

    public synchronized void addVerticalAlignStyleListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener("VerticalAlignStyle", vetoableChangeListener);
    }

    public synchronized void removeVerticalAlignStyleListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener("VerticalAlignStyle", vetoableChangeListener);
    }

    protected boolean isValidHorizontalAlignStyle(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    protected boolean isValidVerticalAlignStyle(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    protected void updateButtonImage() {
        super.updateButtonImage();
        FontMetrics fontMetrics = this.buttonImageGraphics.getFontMetrics();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Dimension dimension = this.size();
        if (this.sLabelButton != null && !this.sLabelButton.equals("")) {
            n3 = fontMetrics.stringWidth(this.sLabelButton);
        }
        Color color = this.isEnabled() ? (this.pressed ? this.pressedTextColor : this.textColor) : this.disabledTextColor;
        switch (this.hAlignStyle) {
            case 0: {
                n = this.bevel + 2;
                break;
            }
            case 2: {
                n = dimension.width - 3 - this.bevel - n3;
                break;
            }
            case 1: {
                n = dimension.width - n3 >> 1;
                break;
            }
        }
        switch (this.vAlignStyle) {
            case 0: {
                n2 = this.bevel + 2 + fontMetrics.getAscent();
                break;
            }
            case 2: {
                n2 = dimension.height - 3 - this.bevel - fontMetrics.getDescent();
                break;
            }
            case 1: {
                n2 = dimension.height + fontMetrics.getAscent() >> 1;
                break;
            }
        }
        this.buttonImageGraphics.setColor(color);
        this.buttonImageGraphics.drawString(this.sLabelButton, n + this.pressedAdjustment, n2 + this.pressedAdjustment);
    }

    class HAVeto
    implements VetoableChangeListener,
    Serializable {
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            int n = (Integer)propertyChangeEvent.getNewValue();
            if (!LabelButton.this.isValidHorizontalAlignStyle(n)) {
                throw new PropertyVetoException(String.valueOf(LabelButton.this.errors.getString("InvalidAlignStyle")) + n, propertyChangeEvent);
            }
        }

        HAVeto() {
            LabelButton.this = LabelButton.this;
        }
    }

    class VAVeto
    implements VetoableChangeListener,
    Serializable {
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            int n = (Integer)propertyChangeEvent.getNewValue();
            if (!LabelButton.this.isValidVerticalAlignStyle(n)) {
                throw new PropertyVetoException(String.valueOf(LabelButton.this.errors.getString("InvalidVerticalAlignStyle")) + n, propertyChangeEvent);
            }
        }

        VAVeto() {
            LabelButton.this = LabelButton.this;
        }
    }
}

