/*
 * Decompiled with CFR 0.152.
 */
package binomialnorm;

import RVLS.LT;
import binomialnorm.binomialDraw;
import binomialnorm.graphUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;

public class binomialDrawNorm
extends binomialDraw {
    public double mean;
    public double sd;
    public double p;
    public double MultConst = 1.0 / Math.sqrt(Math.PI * 2);
    Color fillColor = Color.green;
    double lowCutOff;
    double upCutOff;
    boolean shadeBetween = false;
    boolean shadeBelow = false;
    boolean shadeAbove = false;

    public void setParameter(double _p, int _N) {
        int i;
        this.N = _N + 1;
        this.p = _p;
        this.mean = (double)_N * _p;
        this.sd = Math.sqrt((double)_N * _p * (1.0 - _p));
        this.MultConst = 1.0 / (Math.sqrt(Math.PI * 2) * this.sd);
        this.XX = new double[this.N];
        for (i = 0; i < this.XX.length; ++i) {
            this.XX[i] = i;
        }
        this.YY = new double[this.N];
        for (i = 0; i < this.YY.length; ++i) {
            this.YY[i] = this.b(this.p, this.YY.length - 1, i);
        }
        this.shadeColor = new Color[this.N];
        for (i = 0; i < this.N; ++i) {
            this.shadeColor[i] = this.barColor;
        }
        Dimension d = this.getSize();
        int[] location = new int[]{50, d.width - 20, 10, d.height - 25};
        this.minX = this.mean - 4.0 * this.sd;
        this.maxX = this.mean + 4.0 * this.sd;
        this.minY = 0.0;
        this.maxY = this.MultConst;
        for (int i2 = 1; i2 < this.XX.length - 1; ++i2) {
            this.minX = Math.min(this.minX, this.XX[i2]);
            this.minY = Math.min(this.minY, this.YY[i2]);
            this.maxX = Math.max(this.maxX, this.XX[i2]);
            this.maxY = Math.max(this.maxY, this.YY[i2]);
        }
        double[] XL = new double[3];
        int numLabs = 10;
        if (d.width < 150) {
            numLabs = 5;
        }
        XL = graphUtilities.intlabels(this.minX, this.maxX, numLabs);
        int xticks = (int)Math.rint((XL[2] - XL[1]) / XL[0]);
        this.ndecx = XL[0] >= 1.0 ? 0 : (XL[0] >= 0.1 ? 1 : (XL[0] > 0.01 ? 2 : 2));
        this.ndecy = 2;
        this.x0 = XL[1];
        this.xf = XL[2];
        if (this.ndecx > 0) {
            this.x0 = Math.floor(this.minX);
            this.xf = Math.ceil(this.maxX);
            xticks = (int)(this.xf - this.x0);
            this.ndecx = 0;
        }
        this.y0 = 0.0;
        this.yf = Math.ceil(this.maxY * 20.0) / 20.0;
        if (Math.abs(this.yf - this.maxY) < 0.005) {
            this.yf += 0.05;
        }
        int yticks = (int)Math.rint(this.yf / 0.05);
        if (this.y0 < this.yf) {
            double temp = this.y0;
            this.y0 = this.yf;
            this.yf = temp;
        }
        this.xinc = (this.xf - this.x0) / (double)xticks;
        this.yinc = (this.y0 - this.yf) / (double)yticks;
        this.X = new int[this.N];
        this.Y = new int[this.N];
        this.Lx = new LT(this.x0, this.xf, location[0], location[1]);
        this.Ly = new LT(this.y0, this.yf, location[2], location[3]);
        this.Y = this.Ly.ItransformArray(this.YY);
        this.X = this.Lx.ItransformArray(this.XX);
        this.font = new Font("TimesRoman", 0, 10);
        double xOrigin = this.x0 - this.xinc / (double)8;
        this.px0 = (int)Math.rint(this.Lx.transform(xOrigin));
        double xEnd = this.xf + this.xinc / (double)8;
        this.pxf = (int)Math.rint(this.Lx.transform(xEnd));
        this.py0 = (int)Math.rint(this.Ly.transform(this.y0));
        this.pyf = (int)Math.rint(this.Ly.transform(this.yf));
        this.repaint();
    }

    void initialize(double[] _X, double[] _Y, double _x0, double _xf, double _y0, double _yf, int xticks, int yticks, int[] _location, boolean _filled, int _ndecx, int _ndecy, int _N) {
        this.N = _N;
        this.XX = new double[this.N];
        this.XX = _X;
        this.YY = new double[this.N];
        this.YY = _Y;
        this.shadeColor = new Color[this.N];
        for (int i = 0; i < this.N; ++i) {
            this.shadeColor[i] = this.barColor;
        }
        if (this.N == 1) {
            this.b = 0.0;
            this.A = this.YY[0];
            this.r = 0.0;
            _x0 = (int)(this.XX[0] - 1.0);
            _xf = (int)(this.XX[0] + 1.0);
            _y0 = (int)(this.YY[0] - 1.0);
            _yf = (int)(this.YY[0] + 1.0);
            xticks = 5;
            yticks = 5;
        }
        this.x0 = _x0;
        this.y0 = _y0;
        this.xf = _xf;
        this.yf = _yf;
        this.ndecx = _ndecx;
        this.ndecy = _ndecy;
        if (this.y0 < this.yf) {
            double temp = this.y0;
            this.y0 = this.yf;
            this.yf = temp;
        }
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("y0=").append(this.y0).append(",yf=").append(this.yf))));
        if (this.y0 < this.MultConst) {
            this.y0 = this.MultConst;
        }
        this.xinc = (_xf - _x0) / (double)xticks;
        this.yinc = (this.y0 - this.yf) / (double)yticks;
        this.X = new int[this.N];
        this.Y = new int[this.N];
        this.Lx = new LT(this.x0, this.xf, _location[0], _location[1]);
        this.Ly = new LT(this.y0, this.yf, _location[2], _location[3]);
        this.Y = this.Ly.ItransformArray(_Y);
        this.X = this.Lx.ItransformArray(_X);
        this.font = new Font("TimesRoman", 0, 10);
        double xOrigin = _x0 - this.xinc / (double)8;
        this.px0 = (int)Math.rint(this.Lx.transform(xOrigin));
        double xEnd = _xf + this.xinc / (double)8;
        this.pxf = (int)Math.rint(this.Lx.transform(xEnd));
        this.py0 = (int)Math.rint(this.Ly.transform(this.y0 + this.yinc / (double)8));
        this.pyf = (int)Math.rint(this.Ly.transform(this.yf - this.yinc / (double)8));
    }

    public double getDensity(double x) {
        double z = (x - this.mean) / this.sd;
        return this.MultConst * Math.exp(-z * z / (double)2);
    }

    public void paint(Graphics g) {
        int lastx = this.px0;
        double x = this.Lx.transformToValue(this.px0);
        double y = this.getDensity(x);
        int lasty = this.Ly.Itransform(y);
        int i = this.px0 + 1;
        while (i <= this.pxf) {
            x = this.Lx.transformToValue(i);
            y = this.getDensity(x);
            int ypx = this.Ly.Itransform(y);
            if (this.shadeBetween) {
                if (x >= this.lowCutOff && x <= this.upCutOff) {
                    g.setColor(this.fillColor);
                    g.drawLine(i, ypx, i, this.pyf);
                }
            } else if (this.shadeBelow) {
                if (x <= this.lowCutOff) {
                    g.setColor(this.fillColor);
                    g.drawLine(i, ypx, i, this.pyf);
                }
            } else if (this.shadeAbove && x >= this.upCutOff) {
                g.setColor(this.fillColor);
                g.drawLine(i, ypx, i, this.pyf);
            }
            g.setColor(Color.black);
            g.drawLine(lastx, lasty, i, ypx);
            lastx = i++;
            lasty = ypx;
        }
        super.paint(g);
    }

    public void shadeBelow(int i) {
        int j;
        for (j = 0; j <= i && j != this.N; ++j) {
            this.shadeColor[j] = Color.red;
        }
        for (j = i + 1; j < this.N; ++j) {
            this.shadeColor[j] = this.barColor;
        }
        this.shadeBelow = true;
        this.shadeAbove = false;
        this.shadeBetween = false;
        this.lowCutOff = (double)i + 0.5;
        this.repaint();
    }

    public void shadeAbove(int i) {
        int j;
        for (j = i; j <= this.N - 1; ++j) {
            this.shadeColor[j] = Color.red;
        }
        for (j = 0; j < i && j < this.N; ++j) {
            this.shadeColor[j] = this.barColor;
        }
        this.shadeBelow = false;
        this.shadeAbove = true;
        this.shadeBetween = false;
        this.upCutOff = (double)i - 0.5;
        this.repaint();
    }

    public void shadeBetween(int i, int j) {
        int k;
        for (k = 0; k < i && k < this.N; ++k) {
            this.shadeColor[k] = this.barColor;
        }
        for (k = i; k <= j && k < this.N && k != this.N; ++k) {
            this.shadeColor[k] = Color.red;
        }
        for (k = j + 1; k < this.N; ++k) {
            this.shadeColor[k] = this.barColor;
        }
        this.shadeBelow = false;
        this.shadeAbove = false;
        this.shadeBetween = true;
        this.upCutOff = (double)j + 0.5;
        this.lowCutOff = (double)i - 0.5;
        this.repaint();
    }

    public void noShade() {
        for (int i = 0; i < this.N; ++i) {
            this.shadeColor[i] = this.barColor;
        }
        this.shadeBelow = false;
        this.shadeAbove = false;
        this.shadeBetween = false;
        this.repaint();
    }

    public double b(double p, int n, int x) {
        double px = Math.pow(p, x) * Math.pow(1.0 - p, n - x);
        return this.nper(n, x) * px;
    }

    public double nper(int n, int x) {
        int n1 = n + 1;
        double r = 1.0;
        int xx = Math.min(x, n - x);
        for (int i = 1; i < xx + 1; ++i) {
            r *= (double)(n1 - i);
            r /= (double)i;
        }
        return r;
    }

    public double B(int x1, int x2, double p, int n) {
        double cum = 0.0;
        x2 = Math.min(x2, n);
        for (int i = x1 = Math.max(x1, 0); i <= x2; ++i) {
            cum += this.b(p, n, i);
        }
        return cum;
    }

    public double B(int x1, int x2) {
        return this.B(x1, x2, this.p, this.X.length - 1);
    }
}

