/*
 * Decompiled with CFR 0.152.
 */
package normalpower;

import RVLS.graphUtilities;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;

public class normDist2
extends Canvas {
    protected double mean1;
    protected double sd1;
    protected double mean2;
    protected double sd2;
    protected double lowLimit;
    protected double firstTick;
    protected double upLimit;
    protected double lowCutoff1 = -99999.0;
    protected double lowCutoff2 = -99999.0;
    protected double upCutoff1 = 99999.0;
    protected double upCutoff2 = 99999.0;
    protected boolean shade1;
    protected boolean shade2;
    protected boolean shadeBetween1;
    protected boolean shadeBetween2;
    protected boolean yaxis;
    protected boolean autoRepaint = true;
    public boolean autoSetLimits = true;
    public boolean setYmax = false;
    protected Color fillColor1;
    protected Color fillColor2;
    protected Color titleColor = Color.black;
    protected final int BOTTOM = 55;
    protected final int HADJ = 35;
    protected final int XOFFSET = 35;
    protected double MultConst1;
    protected double MultConst2;
    protected double Ymax;
    protected double range;
    protected int w;
    protected int h;
    protected int pinc;
    protected int lastX;
    protected int lastY;
    protected int numTicks;
    protected int ndec;
    protected int hh;
    protected int ndx;
    protected Font font;
    protected String title;
    protected double sx2p;
    protected double sp2x;
    protected double sp2y;
    protected double sy2p;
    protected double step = 1.0;

    public normDist2() {
        this.initialize(9, -4.0, 4.0, 0.0, 1.0, -4.0, 4.0, true, "Normal Distribution", Color.blue);
    }

    public void setMean1(double mean1) {
        this.mean1 = mean1;
        this.paramChange();
    }

    public void setMean2(double mean2) {
        this.mean2 = mean2;
        this.paramChange();
    }

    public void setSd1(double sd1) {
        if (sd1 > 0.0) {
            this.sd1 = sd1;
            this.MultConst1 = 1.0 / (Math.sqrt(Math.PI * 2) * sd1);
            this.paramChange();
        }
    }

    public void setSd2(double sd2) {
        if (sd2 > 0.0) {
            this.sd2 = sd2;
            this.MultConst2 = 1.0 / (Math.sqrt(Math.PI * 2) * sd2);
            this.paramChange();
        }
    }

    public void setMeanSd1(double mean1, double sd1, boolean autoRepaint) {
        this.autoRepaint = autoRepaint;
        this.mean1 = mean1;
        if (sd1 > 0.0) {
            this.sd1 = sd1;
            this.MultConst1 = 1.0 / (Math.sqrt(Math.PI * 2) * sd1);
        }
        this.paramChange();
    }

    public void setMeanSd2(double mean2, double sd2, boolean autoRepaint) {
        this.autoRepaint = autoRepaint;
        this.mean2 = mean2;
        if (sd2 > 0.0) {
            this.sd2 = sd2;
            this.MultConst2 = 1.0 / (Math.sqrt(Math.PI * 2) * sd2);
        }
        this.paramChange();
    }

    public double getSd1() {
        return this.sd1;
    }

    public double getSd2() {
        return this.sd2;
    }

    public void setShade1(boolean shade) {
        this.shade1 = shade;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void setShade2(boolean shade) {
        this.shade2 = shade;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public boolean isShade1() {
        return this.shade1;
    }

    public boolean isShade2() {
        return this.shade2;
    }

    public void setShadeBetween1(boolean _between) {
        this.shadeBetween1 = _between;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void setShadeBetween2(boolean _between) {
        this.shadeBetween2 = _between;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public boolean isShadeBetween1() {
        return this.shadeBetween1;
    }

    public boolean isShadeBetween2() {
        return this.shadeBetween2;
    }

    public void setYaxis(boolean yaxis) {
        this.yaxis = yaxis;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public boolean isYaxis() {
        return this.yaxis;
    }

    public void setTitle(String title) {
        this.title = title;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setUpLimit(double upLimit) {
        this.upLimit = upLimit;
        this.range = upLimit - this.lowLimit;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public double getUpLimit() {
        return this.upLimit;
    }

    public void setLowLimit(double lowLimit) {
        this.lowLimit = lowLimit;
        this.range = this.upLimit - lowLimit;
        this.firstTick = lowLimit;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public double getLowLimit() {
        return this.lowLimit;
    }

    public void setUpCutoff1(double upCutoff) {
        this.upCutoff1 = upCutoff;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void setUpCutoff2(double upCutoff) {
        this.upCutoff2 = upCutoff;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void setLowCutoff1(double lowCutoff) {
        this.lowCutoff1 = lowCutoff;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void setLowCutoff2(double lowCutoff) {
        this.lowCutoff2 = lowCutoff;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void setCutoff1(double lowCutoff, double upCutoff) {
        this.lowCutoff1 = lowCutoff;
        this.upCutoff1 = upCutoff;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void setCutoff2(double lowCutoff, double upCutoff) {
        this.lowCutoff2 = lowCutoff;
        this.upCutoff2 = upCutoff;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void setCutoff12(double lowCutoff1, double upCutoff1, double lowCutoff2, double upCutoff2) {
        this.lowCutoff1 = lowCutoff1;
        this.upCutoff1 = upCutoff1;
        this.lowCutoff2 = lowCutoff2;
        this.upCutoff2 = upCutoff2;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void setFillColor1(Color fillColor) {
        this.fillColor1 = fillColor;
    }

    public void setFillColor2(Color fillColor) {
        this.fillColor2 = fillColor;
    }

    public void setTitleColor(Color fillColor) {
        this.titleColor = fillColor;
    }

    public void setLimits(double lowLimit, double upLimit, int numTicks, boolean autoRepaint) {
        this.autoRepaint = autoRepaint;
        this.lowLimit = lowLimit;
        this.upLimit = upLimit;
        this.range = upLimit - lowLimit;
        this.numTicks = numTicks;
        this.firstTick = lowLimit;
        if (autoRepaint) {
            this.repaint();
        }
    }

    public void setAutoRepaint(boolean autoRepaint) {
        this.autoRepaint = autoRepaint;
    }

    public boolean isAutoRepaint() {
        return this.autoRepaint;
    }

    public void initialize(int _numTicks, double _LL, double _UL, double _mean, double _sd, double _LC, double _UC, boolean _between, String _title, Color _fillColor) {
        this.ndx = 0;
        this.yaxis = false;
        this.shade1 = false;
        this.shade2 = false;
        this.title = _title;
        this.fillColor1 = _fillColor;
        this.fillColor2 = _fillColor;
        this.ndec = 0;
        this.numTicks = _numTicks - 1;
        this.pinc = 1;
        this.sd1 = _sd;
        this.mean1 = _mean;
        this.sd2 = _sd;
        this.mean2 = _mean;
        this.lowLimit = _LL;
        this.firstTick = _LL;
        this.upLimit = _UL;
        this.lowCutoff1 = _LC;
        this.upCutoff1 = _UC;
        this.shadeBetween1 = _between;
        this.shadeBetween2 = _between;
        this.range = _UL - _LL;
        this.w -= 70;
        this.MultConst1 = 1.0 / (Math.sqrt(Math.PI * 2) * this.sd1);
        this.MultConst2 = 1.0 / (Math.sqrt(Math.PI * 2) * this.sd2);
        this.Ymax = Math.max(this.MultConst1, this.MultConst2);
        this.font = new Font("TimesRoman", 0, 10);
    }

    public void paint(Graphics g) {
        int x;
        String num;
        Dimension dim = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, dim.width, dim.height);
        g.setColor(g.getColor());
        int y = 0;
        this.w = this.getSize().width - 70;
        this.h = this.getSize().height - 55;
        this.hh = this.h + 35;
        if (!this.setYmax) {
            this.Ymax = Math.max(this.MultConst1, this.MultConst2);
        }
        this.sp2x = this.range / (double)this.w;
        this.sx2p = 1.0 / this.sp2x;
        this.sp2y = this.Ymax / (double)this.h;
        this.sy2p = 1.0 / this.sp2y;
        g.setFont(this.font);
        g.setColor(Color.black);
        g.drawLine(35, this.hh, 35 + this.w, this.hh);
        FontMetrics met = g.getFontMetrics(this.font);
        int fh = met.getAscent();
        if (this.autoSetLimits) {
            this.step = (this.upLimit - this.lowLimit) / (double)this.numTicks;
        }
        double c = this.firstTick - this.step;
        int adj = (this.w - met.stringWidth(this.title)) / 2;
        g.setColor(this.titleColor);
        g.drawString(this.title, 35 + adj, fh + 5);
        g.setColor(Color.black);
        if (this.yaxis) {
            int yt;
            double[] r = new double[3];
            r = graphUtilities.intlabels(0.0, this.Ymax, 5);
            for (double yy = 0.0; yy <= this.Ymax + r[0] && (yt = (int)Math.round((double)this.hh - this.sy2p * yy)) > 5; yy += r[0]) {
                y = yt;
                g.drawLine(29, y, 32, y);
                num = graphUtilities.format(yy, 2);
                x = 35 - met.stringWidth(num) - 8;
                g.drawString(num, x, y + fh / 2);
            }
            g.drawLine(33, y, 33, this.hh);
        }
        if (this.autoSetLimits) {
            if (this.step >= 1.0) {
                this.ndx = 0;
            }
            if (this.step < 1.0) {
                this.ndx = 1;
            }
            if (Math.floor(this.sd1) != this.sd1 || Math.floor(this.sd2) != this.sd2) {
                this.ndx = 1;
            }
            if (this.step < 0.05) {
                this.ndx = 2;
            }
        }
        double tickAdj = this.sx2p * (this.firstTick - this.lowLimit);
        num = graphUtilities.format(this.upLimit, this.ndx);
        float SL = met.stringWidth(num);
        double w = this.step * this.sx2p;
        int r = (int)Math.ceil((double)SL / (w - (double)2));
        for (int i = 0; i <= this.numTicks; ++i) {
            c += this.step;
            if (i % r != 0) continue;
            x = (int)Math.rint((double)35 + this.sx2p * (double)i * this.step + tickAdj);
            num = graphUtilities.format(c, this.ndx);
            g.drawLine(x, this.hh, x, this.hh + 4);
            SL = met.stringWidth(num);
            adj = (int)Math.rint(SL / (float)2);
            g.drawString(num, x - adj, this.hh + fh + 6);
        }
        this.drawDist(g);
    }

    public void update(Graphics g) {
        Dimension dim = this.getSize();
        Image osi = this.createImage(dim.width, dim.height);
        Graphics osg = osi.getGraphics();
        osg.setColor(this.getBackground());
        osg.fillRect(0, 0, dim.width, dim.height);
        osg.setColor(g.getColor());
        this.paint(osg);
        g.drawImage(osi, 0, 0, this);
    }

    public void paramChange() {
        if (this.autoSetLimits) {
            this.firstTick = this.lowLimit = Math.min(this.mean1 - (double)4 * this.sd1, this.mean2 - (double)4 * this.sd2);
            this.upLimit = Math.max(this.mean1 + (double)4 * this.sd1, this.mean2 + (double)4 * this.sd2);
            this.range = this.upLimit - this.lowLimit;
        }
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void drawDist(Graphics g) {
        double x;
        int y;
        double x2;
        int i;
        double density;
        int h1 = this.hh - 1;
        if (this.shade1 && this.shade2 && !this.shadeBetween1 && !this.shadeBetween2) {
            boolean turn1 = false;
            boolean turn2 = false;
            boolean turn3 = false;
            boolean turn4 = false;
            this.lastX = (int)Math.rint(Math.min((this.mean1 - (double)4 * this.sd1) / this.sp2x, (this.mean2 - (double)4 * this.sd2) / this.sp2x));
            this.lastX = Math.max(0, this.lastX);
            density = this.getDensity1((double)this.lastX * this.sp2x);
            int lastY1 = (int)Math.round((double)this.hh - this.sy2p * density);
            density = this.getDensity2((double)this.lastX * this.sp2x);
            int lastY2 = (int)Math.round((double)this.hh - this.sy2p * density);
            for (int i2 = this.lastX; i2 < this.w; i2 += this.pinc) {
                double x3 = this.sp2x * (double)i2;
                density = this.getDensity1(x3);
                int y1 = (int)Math.round((double)this.hh - this.sy2p * density);
                density = this.getDensity2(x3);
                int y2 = (int)Math.round((double)this.hh - this.sy2p * density);
                if (x3 <= this.lowCutoff1 && x3 <= this.lowCutoff2) {
                    if (y1 < this.hh && y2 < this.hh) {
                        if (y1 < y2) {
                            g.setColor(this.fillColor1);
                            g.drawLine(35 + i2, y1, 35 + i2, y2);
                            if (turn1) {
                                g.setColor(this.fillColor2);
                            }
                            turn1 = !turn1;
                            g.drawLine(35 + i2, y2, 35 + i2, h1);
                        } else {
                            g.setColor(this.fillColor2);
                            g.drawLine(35 + i2, y2, 35 + i2, y1);
                            if (turn2) {
                                g.setColor(this.fillColor1);
                            }
                            turn2 = !turn2;
                            g.drawLine(35 + i2, y1, 35 + i2, h1);
                        }
                    } else if (y1 < this.hh) {
                        g.setColor(this.fillColor1);
                        g.drawLine(35 + i2, h1, 35 + i2, y1);
                    } else if (y2 < this.hh) {
                        g.setColor(this.fillColor2);
                        g.drawLine(35 + i2, h1, 35 + i2, y2);
                    }
                } else if (x3 <= this.lowCutoff1) {
                    g.setColor(this.fillColor1);
                    g.drawLine(35 + i2, h1, 35 + i2, y1);
                } else if (x3 <= this.lowCutoff2) {
                    g.setColor(this.fillColor2);
                    g.drawLine(35 + i2, h1, 35 + i2, y2);
                }
                if (x3 >= this.upCutoff1 && x3 >= this.upCutoff2) {
                    if (y1 < this.hh && y2 < this.hh) {
                        if (y1 < y2) {
                            g.setColor(this.fillColor1);
                            g.drawLine(35 + i2, y1, 35 + i2, y2);
                            if (turn3) {
                                g.setColor(this.fillColor2);
                            }
                            turn3 = !turn3;
                            g.drawLine(35 + i2, y2, 35 + i2, h1);
                            continue;
                        }
                        g.setColor(this.fillColor2);
                        g.drawLine(35 + i2, y2, 35 + i2, y1);
                        if (turn4) {
                            g.setColor(this.fillColor1);
                        }
                        turn4 = !turn4;
                        g.drawLine(35 + i2, y1, 35 + i2, h1);
                        continue;
                    }
                    if (y1 < this.hh) {
                        g.setColor(this.fillColor1);
                        g.drawLine(35 + i2, h1, 35 + i2, y1);
                        continue;
                    }
                    if (y2 >= this.hh) continue;
                    g.setColor(this.fillColor2);
                    g.drawLine(35 + i2, h1, 35 + i2, y2);
                    continue;
                }
                if (x3 >= this.upCutoff1) {
                    g.setColor(this.fillColor1);
                    g.drawLine(35 + i2, h1, 35 + i2, y1);
                    continue;
                }
                if (!(x3 >= this.upCutoff2)) continue;
                g.setColor(this.fillColor2);
                g.drawLine(35 + i2, h1, 35 + i2, y2);
            }
        }
        g.setColor(Color.blue);
        this.lastX = (int)Math.rint((this.mean1 - (double)4 * this.sd1) / this.sp2x);
        this.lastX = Math.max(0, this.lastX);
        density = this.getDensity1((double)this.lastX * this.sp2x);
        this.lastY = (int)Math.round((double)this.hh - this.sy2p * density);
        for (i = this.lastX; i < this.w && !((x2 = this.sp2x * (double)i) > this.mean1 + (double)4 * this.sd1); i += this.pinc) {
            density = this.getDensity1(x2);
            y = (int)Math.round((double)this.hh - this.sy2p * density);
            g.drawLine(35 + this.lastX, this.lastY, 35 + i, y);
            this.lastX = i;
            this.lastY = y;
            if (!this.shade1) continue;
            if (this.shadeBetween1) {
                if (!(x2 >= this.lowCutoff1) || !(x2 <= this.upCutoff1)) continue;
                g.setColor(this.fillColor1);
                g.drawLine(35 + this.lastX, h1, 35 + this.lastX, y);
                continue;
            }
            if (this.shade2 || !(x2 <= this.lowCutoff1) && !(x2 >= this.upCutoff1)) continue;
            g.setColor(this.fillColor1);
            g.drawLine(35 + this.lastX, h1, 35 + this.lastX, y);
            g.setColor(Color.blue);
        }
        g.setColor(Color.red);
        this.lastX = (int)Math.rint((this.mean2 - (double)4 * this.sd2) / this.sp2x);
        this.lastX = Math.max(0, this.lastX);
        density = this.getDensity2((double)this.lastX * this.sp2x);
        this.lastY = (int)Math.round((double)this.hh - this.sy2p * density);
        for (i = this.lastX; i < this.w && !((x = this.sp2x * (double)i) > this.mean2 + (double)4 * this.sd2); i += this.pinc) {
            density = this.getDensity2(x);
            y = (int)Math.round((double)this.hh - this.sy2p * density);
            g.drawLine(35 + this.lastX, this.lastY, 35 + i, y);
            this.lastX = i;
            this.lastY = y;
            if (!this.shade2) continue;
            if (this.shadeBetween2) {
                if (!(x >= this.lowCutoff2) || !(x <= this.upCutoff2)) continue;
                g.setColor(this.fillColor2);
                g.drawLine(35 + this.lastX, h1, 35 + this.lastX, y);
                continue;
            }
            if (this.shade1 || !(x <= this.lowCutoff2) && !(x >= this.upCutoff2)) continue;
            g.setColor(this.fillColor2);
            g.drawLine(35 + this.lastX, h1, 35 + this.lastX, y);
            g.setColor(Color.red);
        }
    }

    public double getDensity1(double x) {
        double z = (x - this.mean1) / this.sd1;
        return this.MultConst1 * Math.exp(-z * z / (double)2);
    }

    public double getDensity2(double x) {
        double z = (x - this.mean2) / this.sd2;
        return this.MultConst2 * Math.exp(-z * z / (double)2);
    }

    public void setYmax(double ymax) {
        this.Ymax = ymax;
        this.setYmax = true;
    }

    public double getYmax() {
        return Math.max(this.MultConst1, this.MultConst2);
    }
}

