/*
 * Decompiled with CFR 0.152.
 */
package lsd;

import RVLS.Yaxis;
import RVLS.reg;
import java.awt.Button;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import lsd.LT;
import lsd.Utility;
import lsd.regGraphOwner;

public class regGraph
extends Panel {
    Label label1;
    Button button1;
    Button button2;
    int width;
    int height;
    boolean[] ondot = new boolean[]{false, false, false, false, false};
    boolean left = false;
    boolean middle = false;
    boolean right = false;
    boolean ondots = false;
    boolean online = false;
    int[] Yreg = new int[2];
    int[] Xreg = new int[2];
    public int[] x = new int[5];
    public int[] y = new int[5];
    public int[] r = new int[5];
    public Color[] color = new Color[]{Color.red, Color.blue, Color.green, Color.orange, Color.magenta};
    regGraphOwner owner = null;
    public int adjWidth = 0;
    public int adjAcent;
    public int labelMin;
    double scale = 5.0;
    Color backgroundColor = new Color(0xF9FFF3);
    public LT ltx;
    public LT lty;
    double b;
    double A;
    double by;
    double Ay;
    double bx;
    double Ax;
    String line = "";
    String bdraw;
    String Adraw;
    double[] regout;

    public regGraph() {
        this.setLayout(null);
        this.setSize(200, 150);
        this.setFont(new Font("Dialog", 0, 10));
        SymMouse aSymMouse = new SymMouse();
        this.addMouseListener(aSymMouse);
        SymMouseMotion aSymMouseMotion = new SymMouseMotion();
        this.addMouseMotionListener(aSymMouseMotion);
    }

    public regGraph(int _width, int _height) {
        this.width = _width;
        this.height = _height;
        this.setSize(this.width, this.height);
        this.setFont(new Font("Dialog", 0, 10));
    }

    public void setOwner(regGraphOwner owner1) {
        this.owner = owner1;
        this.width = this.getSize().width;
        this.height = this.getSize().height;
        this.label1 = new Label("Drag or rotate the line, or drag the dots to change the data.", 1);
        this.label1.setBounds(20, 0, this.width - 20, 16);
        this.label1.setFont(new Font("Dialog", 0, 10));
        this.add(this.label1);
        Graphics g = this.getGraphics();
        this.getXY(g);
        this.addButtons();
        this.owner.valueChanged(22, this.height - 60 - 3, this.b, this.A, this.x, this.y, false);
    }

    public void addButtons() {
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public void setColor(Color[] color) {
        this.color = color;
    }

    public void getXY(Graphics g) {
        double step = (double)(this.width - 30) / 6.0;
        for (int i = 0; i < 5; ++i) {
            this.x[i] = 30 + (int)Math.round(step * ((double)i + 1.0));
        }
        this.y[0] = this.height - 3 - 60 - (int)Math.round(0.2 * (double)(this.height - 5 - 80));
        this.y[1] = this.height - 3 - 60 - (int)Math.round(0.4 * (double)(this.height - 5 - 80));
        this.y[2] = this.height - 3 - 60 - (int)Math.round(0.6 * (double)(this.height - 5 - 80));
        this.y[3] = this.height - 3 - 60 - (int)Math.round(0.8 * (double)(this.height - 5 - 80));
        this.y[4] = 22;
        if (this.lty == null) {
            this.lty = new LT(0.0, this.scale, this.height - 3 - 60, 22.0);
        }
        if (this.ltx == null) {
            this.ltx = new LT(0.0, 6.0, 30.0, this.width);
        }
        this.by = this.lty.getSlope();
        this.Ay = this.lty.getIntercept();
        this.bx = this.ltx.getSlope();
        this.Ax = this.ltx.getIntercept();
        this.regout = this.getReg(this.x, this.y);
        this.b = this.regout[0];
        this.A = this.regout[1];
        this.owner.setMin(22, this.height - 60 - 3, this.b, this.A, this.x, this.y);
        this.b = 0.0;
        this.A = this.lty.transform(3.0);
        this.bdraw = "0.00";
        this.Adraw = Utility.sformat((this.b * this.Ax + this.A - this.Ay) / this.by, 2);
        this.Xreg[0] = 30;
        this.Yreg[0] = this.lty.Itransform(3.0);
        this.Xreg[1] = this.width;
        this.Yreg[1] = this.Yreg[0];
        this.line = String.valueOf(String.valueOf(new StringBuffer("The equation for the line is: Y'=").append(this.bdraw).append("X").append(this.Adraw)));
    }

    public void setXY(int[] x, int[] y) {
        if (x.length > 5 || y.length > 5) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            if (x[i] >= 0 && x[i] <= this.width - 1 && y[i] >= 0 && y[i] <= this.height - 1) continue;
            return;
        }
        this.x = x;
        this.y = y;
    }

    public void paint(Graphics g) {
        int i;
        Image offscreenImg = this.createImage(this.getSize().width, this.getSize().height);
        Graphics offscreenG = offscreenImg.getGraphics();
        FontMetrics fm = offscreenG.getFontMetrics();
        this.adjAcent = (int)Math.round((double)fm.getAscent() / 2.0);
        offscreenG.setColor(this.backgroundColor);
        offscreenG.fillRect(30, 20, this.width - 30, this.height - 80);
        offscreenG.setColor(Color.black);
        offscreenG.drawLine(this.Xreg[0], this.Yreg[0], this.Xreg[1], this.Yreg[1]);
        offscreenG.drawLine(30, this.height - 60, this.width, this.height - 60);
        int xlabHeight = this.height - 60 + 10 + this.adjAcent;
        String xlab = "";
        for (int i2 = 0; i2 < 5; ++i2) {
            xlab = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(i2 + 1))).append("")));
            offscreenG.drawString(xlab, this.x[i2] - fm.stringWidth(xlab) / 2, xlabHeight);
            offscreenG.drawLine(this.x[i2], this.height - 60, this.x[i2], this.height - 60 + 5);
        }
        double[] YL1 = new double[(int)this.scale + 1];
        for (i = 0; i < (int)this.scale + 1; ++i) {
            YL1[i] = i;
        }
        Yaxis.drawYaxis(22, this.height - 60 - 3, 28, YL1, 0, offscreenG);
        for (i = 0; i < 5; ++i) {
            offscreenG.setColor(this.color[i]);
            this.r[i] = (int)Math.rint(this.b * (double)this.x[i] + this.A);
            if (this.r[i] > this.height - 60) {
                this.r[i] = this.height - 60;
            } else if (this.r[i] < 20) {
                this.r[i] = 20;
            }
            offscreenG.drawLine(this.x[i], this.r[i], this.x[i], this.y[i]);
            offscreenG.fillOval(this.x[i] - 2, this.y[i] - 2, 5, 5);
        }
        this.paintData(offscreenG);
        offscreenG.setColor(Color.black);
        offscreenG.drawString(this.line, (this.width - 30 - fm.stringWidth(this.line)) / 2 + 30, this.height - 40 + 1 + 10 + this.adjAcent);
        g.drawImage(offscreenImg, 0, 0, this);
        offscreenG.dispose();
    }

    public void paintData(Graphics g) {
        String currentHeight = "";
        int[] xx = new int[5];
        FontMetrics fm = g.getFontMetrics();
        this.adjAcent = (int)Math.round((double)fm.getAscent() / 2.0);
        for (int i = 0; i < this.y.length; ++i) {
            int Yheight;
            double distance = this.lty.transformToValue(this.y[i]);
            currentHeight = Utility.format(distance, 2);
            if (this.y[i] < 30) {
                Yheight = 30;
                xx[i] = this.x[i] + fm.stringWidth(currentHeight) / 2 + 4;
            } else if (this.y[i] > this.height - 60 - 10) {
                Yheight = this.height - 60 - 2;
                xx[i] = this.x[i] + fm.stringWidth(currentHeight) / 2 + 4;
            } else if (this.r[i] >= this.y[i]) {
                Yheight = this.y[i] - this.adjAcent;
                xx[i] = this.x[i];
            } else {
                Yheight = this.y[i] + 2 * this.adjAcent + 3;
                xx[i] = this.x[i];
            }
            g.setColor(this.color[i]);
            g.drawString(currentHeight, xx[i] - fm.stringWidth(currentHeight) / 2, Yheight);
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    void regGrapg_MousePressed(MouseEvent event) {
        int xp = event.getX();
        int yp = event.getY();
        this.ondots = false;
        this.online = false;
        for (int i = 0; i < 5; ++i) {
            if (Math.abs(xp - this.x[i]) < 5 && Math.abs(yp - this.y[i]) < 5) {
                this.ondot[i] = true;
                this.ondots = true;
                continue;
            }
            this.ondot[i] = false;
        }
        if (Math.abs(yp - (int)Math.rint(this.b * (double)xp + this.A)) < 5 && !this.ondots) {
            this.left = false;
            this.right = false;
            this.middle = false;
            this.online = true;
            if (xp < (int)(30.0 + (double)(this.Xreg[1] - this.Xreg[0]) / 3.0)) {
                this.left = true;
            } else if (xp > (int)(30.0 + (double)(2 * (this.Xreg[1] - this.Xreg[0])) / 3.0)) {
                this.right = true;
            } else {
                this.middle = true;
            }
        }
    }

    void regGraph_MouseDragged(MouseEvent event) {
        int currentY = event.getY();
        int currentX = event.getX();
        if (currentX < 30) {
            return;
        }
        if (currentY >= this.height - 3 - 60) {
            currentY = this.height - 3 - 60;
        } else if (currentY <= 22) {
            currentY = 22;
        }
        if (this.ondots) {
            for (int i = 0; i < 5; ++i) {
                if (!this.ondot[i]) continue;
                this.y[i] = currentY;
                this.regout = this.getReg(this.x, this.y);
                this.owner.setMin(22, this.height - 60 - 3, this.regout[0], this.regout[1], this.x, this.y);
                this.line = String.valueOf(String.valueOf(new StringBuffer("The equation for the line is: Y'=").append(this.bdraw).append("X").append(this.Adraw)));
                this.repaint();
                this.owner.valueChanged(22, this.height - 60 - 3, this.b, this.A, this.x, this.y, false);
                return;
            }
        }
        if (this.online) {
            double x1 = currentX;
            double y1 = currentY;
            if (this.left) {
                double x2 = this.Xreg[1];
                double y2 = this.Yreg[1];
                this.b = (y2 - y1) / (x2 - x1);
                this.A = y1 - this.b * x1;
                this.Xreg[0] = 30;
                this.Yreg[0] = (int)Math.rint(this.b * (double)30 + this.A);
                this.Xreg[1] = this.width;
                this.Yreg[1] = (int)Math.rint(this.b * (double)this.width + this.A);
            } else if (this.right) {
                double x2 = this.Xreg[0];
                double y2 = this.Yreg[0];
                this.b = (y2 - y1) / (x2 - x1);
                this.A = y1 - this.b * x1;
                this.Xreg[0] = 30;
                this.Yreg[0] = (int)Math.rint(this.b * (double)30 + this.A);
                this.Xreg[1] = this.width;
                this.Yreg[1] = (int)Math.rint(this.b * (double)this.width + this.A);
            } else if (this.middle) {
                this.A = y1 - this.b * x1;
                this.Xreg[0] = 30;
                this.Yreg[0] = (int)Math.rint(this.b * (double)30 + this.A);
                this.Xreg[1] = this.width;
                this.Yreg[1] = (int)Math.rint(this.b * (double)this.width + this.A);
            }
            this.bdraw = Utility.format(this.b * this.bx / this.by, 2);
            this.Adraw = Utility.sformat((this.b * this.Ax + this.A - this.Ay) / this.by, 2);
            this.line = String.valueOf(String.valueOf(new StringBuffer("The equation for the line is: Y'=").append(this.bdraw).append("X").append(this.Adraw)));
            this.checkTopandBottom(this.Xreg, this.Yreg);
            this.repaint();
            this.owner.valueChanged(22, this.height - 60 - 3, this.b, this.A, this.x, this.y, false);
        }
    }

    void regGrapg_MouseReleased(MouseEvent event) {
        this.repaint();
    }

    public double[] getReg(int[] x, int[] y) {
        double[] regout = new double[2];
        boolean doReg = false;
        if (x.length != y.length) {
            return null;
        }
        double[] X = new double[x.length];
        double[] Y = new double[y.length];
        int preY = y[0];
        for (int i = 0; i < x.length; ++i) {
            X[i] = x[i];
            Y[i] = y[i];
            if (y[i] != preY) {
                doReg = true;
            }
            preY = y[i];
        }
        if (doReg) {
            reg reg1 = new reg(X, Y);
            regout[0] = reg1.getSlope();
            regout[1] = reg1.getIntercept();
        } else {
            regout[0] = 0.0;
            regout[1] = preY;
        }
        return regout;
    }

    public void checkTopandBottom(int[] Xreg, int[] Yreg) {
        if (Yreg[0] > this.height - 60) {
            Yreg[0] = this.height - 60;
            Xreg[0] = (int)Math.rint(((double)Yreg[0] - this.A) / this.b);
        } else if (Yreg[0] < 20) {
            Yreg[0] = 20;
            Xreg[0] = (int)Math.rint(((double)Yreg[0] - this.A) / this.b);
        }
        if (Yreg[1] > this.height - 60) {
            Yreg[1] = this.height - 60;
            Xreg[1] = (int)Math.rint(((double)Yreg[1] - this.A) / this.b);
        } else if (Yreg[1] < 20) {
            Yreg[1] = 20;
            Xreg[1] = (int)Math.rint(((double)Yreg[1] - this.A) / this.b);
        }
    }

    class SymMouseMotion
    extends MouseMotionAdapter {
        SymMouseMotion() {
        }

        public void mouseDragged(MouseEvent event) {
            Object object = event.getSource();
            if (object == regGraph.this) {
                regGraph.this.regGraph_MouseDragged(event);
            }
        }
    }

    class SymMouse
    extends MouseAdapter {
        SymMouse() {
        }

        public void mouseReleased(MouseEvent event) {
            Object object = event.getSource();
            if (object == regGraph.this) {
                regGraph.this.regGrapg_MouseReleased(event);
            }
        }

        public void mousePressed(MouseEvent event) {
            Object object = event.getSource();
            if (object == regGraph.this) {
                regGraph.this.regGrapg_MousePressed(event);
            }
        }
    }
}

