/*
 * Decompiled with CFR 0.152.
 */
package corrpower;

import RVLS.graphUtilities;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import rvl.stat.dist.T;

public class powerplot
extends Canvas {
    protected double mean = 1.85;
    protected double var = 4.0;
    protected double lowLimit = -1.0;
    protected double firstTick = -1.0;
    protected int n = 10;
    protected double upLimit = 1.0;
    protected double[] alphi = new double[]{0.1, 0.05, 0.01};
    protected boolean yaxis = true;
    protected boolean autoRepaint = true;
    public boolean autoSetLimits = true;
    public boolean setYmax = true;
    protected Color fillColor1 = Color.red;
    protected Color fillColor2 = Color.blue;
    protected Color fillColor3 = Color.magenta;
    protected Color titleColor = Color.black;
    int tail = 0;
    protected final int BOTTOM = 55;
    protected final int HADJ = 35;
    protected final int XOFFSET = 35;
    protected double Ymax = 1.0;
    protected double range = this.upLimit - this.lowLimit;
    protected int w;
    protected int h;
    protected int pinc = 1;
    protected int lastX;
    protected int lastY;
    protected int numTicks = 8;
    protected int ndec;
    protected int hh;
    protected int ndx;
    protected Font font = new Font("TimesRoman", 0, 10);
    protected String title = "";
    protected double sx2p;
    protected double sp2x;
    protected double sp2y;
    protected double sy2p;
    protected double step = 1.0;

    public powerplot() {
        if (!this.setYmax) {
            this.Ymax = this.getYmax();
            this.repaint();
        }
    }

    public void setMean(double mean) {
        this.mean = mean;
        this.repaint();
    }

    public void setVar(double var) {
        if (var > 0.0) {
            this.var = var;
            this.repaint();
        }
    }

    public void setN(int n) {
        this.n = n;
        this.repaint();
    }

    public void setLowDf(double lowLimit) {
        this.lowLimit = lowLimit;
        this.firstTick = lowLimit;
        this.repaint();
    }

    public void setTail(int tail) {
        this.tail = tail;
        this.repaint();
    }

    public void setHighDf(double lowLimit) {
        this.upLimit = this.upLimit;
        this.repaint();
    }

    public void setYaxis(boolean yaxis) {
        this.yaxis = yaxis;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void setTitle(String title) {
        this.title = title;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void setFillColor1(Color fillColor) {
        this.fillColor1 = fillColor;
    }

    public void setFillColor2(Color fillColor) {
        this.fillColor2 = fillColor;
    }

    public void setFillColor3(Color fillColor) {
        this.fillColor3 = fillColor;
    }

    public void setTitleColor(Color fillColor) {
        this.titleColor = fillColor;
    }

    public void paint(Graphics g) {
        int x;
        String num;
        Dimension dim = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, dim.width, dim.height);
        g.setColor(g.getColor());
        int y = 0;
        this.w = this.getSize().width - 70;
        this.h = this.getSize().height - 55;
        this.hh = this.h + 35;
        this.sp2x = this.range / (double)this.w;
        this.sx2p = 1.0 / this.sp2x;
        this.sp2y = this.Ymax / (double)this.h;
        this.sy2p = 1.0 / this.sp2y;
        g.setFont(this.font);
        g.setColor(Color.black);
        g.drawLine(35, this.hh, 35 + this.w, this.hh);
        FontMetrics met = g.getFontMetrics(this.font);
        int fh = met.getAscent();
        if (this.autoSetLimits) {
            this.step = (this.upLimit - this.lowLimit) / (double)this.numTicks;
        }
        double c = this.firstTick - this.step;
        int adj = (this.w - met.stringWidth(this.title)) / 2;
        g.setColor(this.titleColor);
        g.drawString(this.title, 35 + adj, fh + 5);
        g.setColor(Color.black);
        if (this.yaxis) {
            int yt;
            if (Math.abs(this.mean) < 1.0E-6 || this.mean < 0.0 && this.tail == 1) {
                g.drawString("Type I error rate", 2, 26);
            } else {
                g.drawString("Power", 10, 26);
            }
            double[] r = new double[3];
            r = graphUtilities.intlabels(0.0, this.Ymax, 5);
            for (double yy = 0.0; yy <= this.Ymax + r[0] && (yt = (int)Math.round((double)this.hh - this.sy2p * yy)) > 5; yy += r[0]) {
                y = yt;
                g.drawLine(29, y, 32, y);
                num = graphUtilities.format(yy, 2);
                x = 35 - met.stringWidth(num) - 8;
                g.drawString(num, x, y + fh / 2);
            }
            g.drawLine(33, y, 33, this.hh);
        }
        if (this.autoSetLimits) {
            if (this.step >= 1.0) {
                this.ndx = 0;
            }
            if (this.step < 1.0) {
                this.ndx = 1;
            }
            if (this.step < 0.05) {
                this.ndx = 2;
            }
        }
        double tickAdj = this.sx2p * (this.firstTick - this.lowLimit);
        num = graphUtilities.format(this.upLimit, this.ndx);
        float SL = met.stringWidth(num);
        double w = this.step * this.sx2p;
        int r = (int)Math.ceil((double)SL / (w - (double)2));
        for (int i = 0; i <= this.numTicks; ++i) {
            c += this.step;
            if (i % r != 0) continue;
            x = (int)Math.rint((double)35 + this.sx2p * (double)i * this.step + tickAdj);
            num = graphUtilities.format(c, this.ndx);
            g.drawLine(x, this.hh, x, this.hh + 4);
            SL = met.stringWidth(num);
            adj = (int)Math.rint(SL / (float)2);
            g.drawString(num, x - adj, this.hh + fh + 6);
        }
        this.drawDist(g);
    }

    public void update(Graphics g) {
        Dimension dim = this.getSize();
        Image osi = this.createImage(dim.width, dim.height);
        Graphics osg = osi.getGraphics();
        osg.setColor(this.getBackground());
        osg.fillRect(0, 0, dim.width, dim.height);
        osg.setColor(g.getColor());
        this.paint(osg);
        g.drawImage(osi, 0, 0, this);
    }

    public void drawDist(Graphics g) {
        int y;
        double x;
        int i;
        g.setColor(this.fillColor1);
        FontMetrics f = g.getFontMetrics();
        int stringheight = f.getAscent();
        this.lastX = 0;
        double power = this.getPower(this.lowLimit, 0);
        String p = "".concat(String.valueOf(String.valueOf(power)));
        if (p.equals("NaN")) {
            power = this.Ymax;
        }
        this.lastY = (int)Math.round((double)this.hh - this.sy2p * power);
        for (i = this.lastX; i < this.w && !((x = this.sp2x * (double)i + this.lowLimit) > this.upLimit); i += this.pinc) {
            power = this.getPower(x, 0);
            p = "".concat(String.valueOf(String.valueOf(power)));
            if (p.equals("NaN")) {
                power = this.Ymax;
            }
            y = (int)Math.round((double)this.hh - this.sy2p * power);
            if (Math.abs(x) > 0.01) {
                g.drawLine(35 + this.lastX, this.lastY, 35 + i, y);
            }
            this.lastX = i;
            this.lastY = y;
        }
        g.drawString("x", 35 + (int)Math.rint(-this.lowLimit / this.sp2x) - f.stringWidth("x") / 2, (int)Math.round((double)this.hh - this.sy2p * this.getPower(0.0, 0)) + stringheight / 2 - 2);
        g.setColor(this.fillColor2);
        this.lastX = 0;
        power = this.getPower(this.lowLimit, 1);
        p = "".concat(String.valueOf(String.valueOf(power)));
        if (p.equals("NaN")) {
            power = this.Ymax;
        }
        this.lastY = (int)Math.round((double)this.hh - this.sy2p * power);
        for (i = this.lastX; i < this.w && !((x = this.sp2x * (double)i + this.lowLimit) > this.upLimit); i += this.pinc) {
            power = this.getPower(x, 1);
            p = "".concat(String.valueOf(String.valueOf(power)));
            if (p.equals("NaN")) {
                power = this.Ymax;
            }
            y = (int)Math.round((double)this.hh - this.sy2p * power);
            if (Math.abs(x) > 0.01) {
                g.drawLine(35 + this.lastX, this.lastY, 35 + i, y);
            }
            this.lastX = i;
            this.lastY = y;
        }
        g.drawString("x", 35 + (int)Math.rint(-this.lowLimit / this.sp2x) - f.stringWidth("x") / 2, (int)Math.round((double)this.hh - this.sy2p * this.getPower(0.0, 1)) + stringheight / 2 - 2);
        g.setColor(this.fillColor3);
        this.lastX = 0;
        power = this.getPower(this.lowLimit, 2);
        p = "".concat(String.valueOf(String.valueOf(power)));
        if (p.equals("NaN")) {
            power = this.Ymax;
        }
        this.lastY = (int)Math.round((double)this.hh - this.sy2p * power);
        for (i = this.lastX; i < this.w && !((x = this.sp2x * (double)i + this.lowLimit) > this.upLimit); i += this.pinc) {
            power = this.getPower(x, 2);
            p = "".concat(String.valueOf(String.valueOf(power)));
            if (p.equals("NaN")) {
                power = this.Ymax;
            }
            y = (int)Math.round((double)this.hh - this.sy2p * power);
            if (Math.abs(x) > 0.01) {
                g.drawLine(35 + this.lastX, this.lastY, 35 + i, y);
            }
            this.lastX = i;
            this.lastY = y;
        }
        g.drawString("x", 35 + (int)Math.rint(-this.lowLimit / this.sp2x) - f.stringWidth("x") / 2, (int)Math.round((double)this.hh - this.sy2p * this.getPower(0.0, 2)) + stringheight / 2 - 2);
    }

    public double getPower(double r, int i) {
        double t = this.mean / Math.sqrt(2.0 * this.var * (1.0 - r) / (double)this.n);
        if (Math.abs(this.mean) < 1.0E-5) {
            return this.alphi[i];
        }
        if (Math.abs(r) < 1.0E-6) {
            return T.power(t, 2 * this.n - 2, this.tail, this.alphi[i]);
        }
        return T.power(t, this.n - 1, this.tail, this.alphi[i]);
    }

    public void setYmax(double ymax) {
        this.Ymax = ymax;
        this.setYmax = true;
    }

    public double getYmax() {
        double ymax = 0.0;
        for (int i = (int)this.lowLimit; i < (int)this.upLimit; ++i) {
            for (int j = 0; j < 3; ++j) {
                ymax = Math.max(ymax, this.getPower(i, j));
            }
        }
        return ymax;
    }
}

