/*
 * Decompiled with CFR 0.152.
 */
package rvl.awt;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import rvl.stat.Stat;
import rvl.util.Sort;
import rvl.util.Utility;

public class Dotplot
extends Component
implements MouseListener,
MouseMotionListener {
    private double[] values;
    private double[] tick;
    private int n;
    private int em;
    private int w;
    private int y;
    private int which = -1;
    private double min;
    private double max;
    private double mean;
    private double binW;
    private double prevVal;
    private String[] tickLab;
    private Cursor pointer = Cursor.getDefaultCursor();
    private Cursor finger = Cursor.getPredefinedCursor(12);
    private Cursor crosshairs = Cursor.getPredefinedCursor(1);
    private transient ActionListener actionListener = null;

    public Dotplot(double[] dArray) {
        this.setValues(dArray);
        Font font = new Font("SansSerif", 0, 9);
        this.setFont(font);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setValues(double[] dArray) {
        if (dArray == null) {
            dArray = new double[]{0.0};
        }
        this.n = dArray.length;
        this.values = new double[this.n];
        int n = 0;
        while (n < this.n) {
            this.values[n] = dArray[n];
            ++n;
        }
        this.setRange();
    }

    public double[] getValues() {
        return this.values;
    }

    private void setRange() {
        Sort.qsort(this.values);
        this.min = this.values[0];
        this.max = this.values[this.n - 1];
        if (this.min == this.max) {
            this.min -= 0.5;
            this.max += 0.5;
        }
        double d = 0.05 * (this.max - this.min);
        this.min -= d;
        this.max += d;
        this.tick = Utility.nice(this.min, this.max, 5, false);
        this.tickLab = Utility.fmtNice(this.tick);
        this.mean = Stat.mean(this.values);
    }

    public Dimension getPreferredSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.stringWidth("m");
        int n2 = fontMetrics.getAscent();
        return new Dimension(18 * n, 6 * n2);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void paint(Graphics graphics) {
        double d;
        int n;
        int n2;
        if (!this.isVisible()) {
            return;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.em = fontMetrics.stringWidth("m");
        this.w = this.getSize().width - 2 * this.em;
        int n3 = fontMetrics.getAscent();
        int n4 = this.getSize().height;
        graphics.setFont(this.getFont());
        this.y = n4 - 2 * n3;
        graphics.setColor(Color.blue);
        graphics.drawLine(this.em, this.y, this.w + this.em, this.y);
        int n5 = this.y + n3 / 3;
        int n6 = this.y + 3 * n3 / 2;
        int n7 = (int)(((double)this.w + 0.0) * (this.tick[1] - this.tick[0]) / (this.max - this.min));
        int n8 = 0;
        while (n8 < this.tick.length) {
            n2 = this.em + (int)(((double)this.w + 0.0) * (this.tick[n8] - this.min) / (this.max - this.min));
            n = n2 - fontMetrics.stringWidth(this.tickLab[n8]) / 2;
            graphics.drawLine(n2, this.y, n2, n5);
            graphics.drawString(this.tickLab[n8], n, n6);
            ++n8;
        }
        int n9 = n7 / this.em;
        if (n9 == 0) {
            n9 = 1;
        }
        this.binW = (this.tick[1] - this.tick[0]) / (double)n9;
        n = 0;
        int n10 = 0;
        while (n10 < this.n) {
            d = this.binW * (double)Math.round(this.values[n10] / this.binW);
            n2 = this.em / 2 + 1 + (int)(((double)this.w + 0.0) * (d - this.min) / (this.max - this.min));
            n5 = n2 == n ? n5 - this.em : this.y - this.em;
            n = n2;
            if (n10 == this.which) {
                graphics.setColor(Color.lightGray);
            } else {
                graphics.setColor(Color.black);
            }
            if (n5 < -this.em / 2) {
                n5 += this.em;
                graphics.setColor(Color.red);
            }
            graphics.drawOval(n, n5, this.em - 2, this.em - 2);
            graphics.fillOval(n, n5, this.em - 2, this.em - 2);
            ++n10;
        }
        d = this.binW * (double)Math.round(this.mean / this.binW);
        n2 = this.em + (int)(((double)this.w + 0.0) * (d - this.min) / (this.max - this.min));
        Polygon polygon = new Polygon(new int[]{n2 - this.em / 2, n2, n2 + this.em / 2}, new int[]{this.y + this.em, this.y, this.y + this.em}, 3);
        if (this.which == -99) {
            graphics.setColor(Color.lightGray);
        } else {
            graphics.setColor(Color.red.darker());
        }
        graphics.drawPolygon(polygon);
        graphics.fillPolygon(polygon);
    }

    private void drawMovingDot() {
        int n = this.em / 2 + 1 + (int)(((double)this.w + 0.0) * (this.prevVal - this.min) / (this.max - this.min));
        Graphics graphics = this.getGraphics();
        graphics.setColor(Color.red);
        graphics.setXORMode(Color.green);
        if (this.which == -99) {
            graphics.drawPolygon(new int[]{(n -= 1 - this.em / 2) - this.em / 2, n, n + this.em / 2}, new int[]{this.y + this.em, this.y, this.y + this.em}, 3);
        } else {
            graphics.drawOval(n, this.y - this.em, this.em - 2, this.em - 2);
        }
    }

    private void tempRescale(double d, double d2) {
        while (d >= d2) {
            d -= 0.5;
            d2 += 0.5;
        }
        this.min = d;
        this.max = d2;
        this.tick = Utility.nice(this.min, this.max, 5, false);
        this.tickLab = Utility.fmtNice(this.tick);
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.which = -1;
        double d = this.min + (this.max - this.min) * ((double)(mouseEvent.getX() - this.em) + 0.0) / (double)this.w;
        if (mouseEvent.getY() < this.y) {
            int n = 0;
            while (n < this.n && this.which < 0) {
                if (2.0 * Math.abs(this.values[n] - d) < this.binW) {
                    this.which = n;
                    this.repaint();
                    this.prevVal = this.values[n];
                    this.drawMovingDot();
                }
                ++n;
            }
        } else if (2.0 * Math.abs(this.mean - d) < this.binW) {
            this.which = -99;
            this.repaint();
            this.prevVal = this.mean;
            this.drawMovingDot();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.which == -99) {
            this.setCursor(this.pointer);
            this.which = -1;
            double d = this.binW * (double)Math.round(this.prevVal / this.binW) - this.mean;
            int n = 0;
            while (n < this.values.length) {
                int n2 = n++;
                this.values[n2] = this.values[n2] + d;
            }
            this.setCursor(this.pointer);
            this.setRange();
            this.repaint();
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(new ActionEvent(this, 1001, "Dotplot:Shift"));
            }
            return;
        }
        if (this.which < 0) {
            return;
        }
        this.values[this.which] = this.binW * (double)Math.round(this.prevVal / this.binW);
        this.which = -1;
        this.setCursor(this.pointer);
        this.setRange();
        this.repaint();
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "Dotplot:Point"));
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.which < 0 && this.which != -99) {
            return;
        }
        double d = this.min + (this.max - this.min) * ((double)(mouseEvent.getX() - this.em) + 0.0) / (double)this.w;
        double d2 = 0.01 * (this.max - this.min);
        this.drawMovingDot();
        if (d < this.min + d2) {
            this.tempRescale(d - d2, this.max);
        }
        if (d > this.max - d2) {
            this.tempRescale(this.min, d + d2);
        }
        this.prevVal = d;
        this.drawMovingDot();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        double d = this.min + (this.max - this.min) * ((double)(mouseEvent.getX() - this.em) + 0.0) / (double)this.w;
        int n = -1;
        int n2 = mouseEvent.getY();
        Cursor cursor = this.getCursor();
        if (n2 >= this.y && n2 <= this.y + this.em) {
            if (2.0 * Math.abs(d - this.mean) < this.binW) {
                if (cursor != this.crosshairs) {
                    this.setCursor(this.crosshairs);
                }
                n = 99;
            }
        } else if (n2 < this.y && n2 > this.y - this.em) {
            int n3 = 0;
            while (n3 < this.n && n < 0) {
                if (2.0 * Math.abs(this.values[n3] - d) < this.binW) {
                    n = n3;
                    if (cursor != this.finger) {
                        this.setCursor(this.finger);
                    }
                }
                ++n3;
            }
        }
        if (n < 0 && cursor != this.pointer) {
            this.setCursor(this.pointer);
        }
    }
}

