/*
 * Decompiled with CFR 0.152.
 */
package rvl.awt;

import java.awt.Event;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import rvl.util.Utility;

public class DoubleField
extends TextField
implements FocusListener {
    private int digits;
    private double currentValue = Double.NaN;
    private String currentText = "NaN";
    private boolean hasFocus = false;

    public DoubleField(double d) {
        this(d, 3, 3);
    }

    public DoubleField(double d, int n) {
        this(d, n, 3);
    }

    public DoubleField(double d, int n, int n2) {
        super("", n);
        this.digits = n2;
        this.setValue(d);
        this.addFocusListener(this);
    }

    public DoubleField(String string, int n) {
        super(n);
        this.digits = 3;
        this.setValue(Double.NaN);
        this.setText(string);
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        this.hasFocus = true;
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        this.hasFocus = false;
        if (this.currentText != this.getText().trim()) {
            this.getValue();
            this.processEvent(new ActionEvent(this, 1001, this.currentText));
        }
    }

    public double getValue() {
        if (this.currentText == this.getText().trim()) {
            return this.currentValue;
        }
        try {
            this.currentText = this.getText().trim();
            this.currentValue = Double.valueOf(this.currentText);
            return this.currentValue;
        }
        catch (Exception exception) {
            this.currentValue = Double.NaN;
            return this.currentValue;
        }
    }

    public boolean gotFocus(Event event, Object object) {
        this.hasFocus = true;
        return true;
    }

    public boolean keyDown(Event event, int n) {
        if (n == 13) {
            this.deliverEvent(new Event(this, 1001, new Double(this.getValue())));
            return true;
        }
        return super.keyDown(event, n);
    }

    public boolean lostFocus(Event event, Object object) {
        if (this.hasFocus) {
            this.hasFocus = false;
            if (this.currentText != this.getText().trim()) {
                this.deliverEvent(new Event(this, 1001, new Double(this.getValue())));
            }
        }
        return true;
    }

    public void setValue(double d) {
        this.currentText = Utility.format(d, this.digits);
        this.setText(this.currentText);
        this.currentValue = d;
    }
}

