/*
 * Decompiled with CFR 0.152.
 */
package rvl.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.Vector;

public class RVLayout
implements LayoutManager,
Serializable {
    private int rows;
    private int cols;
    private int hGap = 6;
    private int vGap = 6;
    private int[] rowHgt;
    private int[] colWid;
    private int nvg = 0;
    private int nhg = 0;
    private int[] vGlue = new int[20];
    private int[] hGlue = new int[20];
    private boolean sizesSet = false;
    private boolean stretchRows = false;
    private boolean stretchCols = false;
    private Vector extras = new Vector();

    public RVLayout() {
        this(2);
    }

    public RVLayout(int n) {
        this.cols = n;
    }

    public RVLayout(int n, int n2, int n3) {
        this.cols = n;
        this.hGap = n2;
        this.vGap = n3;
    }

    public RVLayout(int n, boolean bl, boolean bl2) {
        this.cols = n;
        this.stretchRows = bl;
        this.stretchCols = bl2;
    }

    public RVLayout(int n, int n2, int n3, boolean bl, boolean bl2) {
        this.cols = n;
        this.hGap = n2;
        this.vGap = n3;
        this.stretchRows = bl;
        this.stretchCols = bl2;
    }

    public void setHgap(int n) {
        this.hGap = n;
    }

    public void setVgap(int n) {
        this.vGap = n;
    }

    public int getHgap() {
        return this.hGap;
    }

    public int getVgap() {
        return this.vGap;
    }

    public void setStretchable(boolean bl, boolean bl2) {
        this.stretchRows = bl;
        this.stretchCols = bl2;
    }

    public boolean[] isStretchable() {
        return new boolean[]{this.stretchRows, this.stretchCols};
    }

    public void setColWidth(int n, int n2) {
        this.extras.addElement(new Dimension(-n, n2));
        this.sizesSet = false;
    }

    public void setRowHeight(int n, int n2) {
        this.extras.addElement(new Dimension(n, n2));
        this.sizesSet = false;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.insets();
        if (!this.sizesSet) {
            this.setSizes(container);
        }
        int n = insets.left + insets.right + this.cols * this.hGap;
        int n2 = insets.top + insets.bottom + this.rows * this.vGap;
        int n3 = 0;
        while (n3 < this.rows) {
            n2 += this.rowHgt[n3++];
        }
        int n4 = 0;
        while (n4 < this.cols) {
            n += this.colWid[n4++];
        }
        return new Dimension(n, n2);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public void layoutContainer(Container container) {
        int n;
        int n2;
        if (!this.sizesSet) {
            this.setSizes(container);
        }
        Dimension dimension = this.preferredLayoutSize(container);
        int[] nArray = new int[this.cols];
        int[] nArray2 = new int[this.cols];
        double d = this.stretchCols ? (0.0 + (double)container.size().width - (double)(this.cols * this.hGap)) / (double)(dimension.width - this.cols * this.hGap) : 1.0;
        int n3 = 0;
        while (n3 < this.cols) {
            nArray[n3] = (int)(d * (double)this.colWid[n3]);
            nArray2[n3] = 0;
            ++n3;
        }
        int[] nArray3 = new int[this.rows];
        int[] nArray4 = new int[this.rows];
        d = this.stretchRows ? (0.0 + (double)container.size().height - (double)(this.rows * this.vGap)) / (double)(dimension.height - this.rows * this.vGap) : 1.0;
        int n4 = 0;
        while (n4 < this.rows) {
            nArray3[n4] = (int)(d * (double)this.rowHgt[n4]);
            nArray4[n4] = 0;
            ++n4;
        }
        Dimension dimension2 = this.preferredLayoutSize(container);
        if (this.nhg > 0 && !this.stretchCols && (n2 = (container.size().width - dimension2.width) / this.nhg) > 0) {
            n = 0;
            while (n < this.nhg) {
                if (this.hGlue[n] < this.cols) {
                    nArray2[this.hGlue[n]] = n2;
                }
                ++n;
            }
        }
        if (this.nvg > 0 && !this.stretchRows && (n2 = (container.size().height - dimension2.height) / this.nvg) > 0) {
            n = 0;
            while (n < this.nvg) {
                if (this.vGlue[n] < this.rows) {
                    nArray4[this.vGlue[n]] = n2;
                }
                ++n;
            }
        }
        Insets insets = container.insets();
        int n5 = insets.top + this.vGap / 2;
        n = container.countComponents();
        int n6 = 0;
        int n7 = 0;
        block4: while (n6 < this.rows) {
            n5 += nArray4[n6];
            int n8 = insets.left + this.hGap / 2;
            int n9 = 0;
            while (n9 < this.cols) {
                Component component = container.getComponent(n7);
                component.reshape(n8 += nArray2[n9], n5, nArray[n9], nArray3[n6]);
                n8 += nArray[n9] + this.hGap;
                if (++n7 >= n) break block4;
                ++n9;
            }
            n5 += nArray3[n6] + this.vGap;
            ++n6;
        }
    }

    private void setSizes(Container container) {
        int n = container.countComponents();
        this.rows = (n + this.cols - 1) / this.cols;
        this.colWid = new int[this.cols];
        this.rowHgt = new int[this.rows];
        int n2 = 0;
        while (n2 < this.cols) {
            this.colWid[n2++] = 0;
        }
        int n3 = 0;
        while (n3 < this.rows) {
            this.rowHgt[n3++] = 0;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n4 < n) {
            Dimension dimension = container.getComponent(n4).preferredSize();
            this.colWid[n6] = Math.max(this.colWid[n6], dimension.width);
            this.rowHgt[n5] = Math.max(this.rowHgt[n5], dimension.height);
            if (++n6 >= this.cols) {
                ++n5;
                n6 = 0;
            }
            ++n4;
        }
        int n7 = 0;
        while (n7 < this.extras.size()) {
            Dimension dimension = (Dimension)this.extras.elementAt(n7);
            if (dimension.width > 0) {
                this.rowHgt[dimension.width] = dimension.height;
            } else {
                this.colWid[-dimension.width] = dimension.height;
            }
            ++n7;
        }
    }

    public void horzFill(Container container) {
        this.hGlue[this.nhg++] = container.countComponents() % this.cols;
    }

    public void vertFill(Container container) {
        this.vGlue[this.nvg++] = container.countComponents() / this.cols;
    }
}

