/*
 * Decompiled with CFR 0.152.
 */
package rvl.awt;

import java.awt.AWTEventMulticaster;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import rvl.util.Utility;

public class Slider
extends Container
implements ActionListener,
ItemListener,
KeyListener,
FocusListener {
    private String label;
    private double value;
    private double min;
    private double max;
    private boolean minMutable = true;
    private boolean maxMutable = true;
    private boolean editable = true;
    private boolean showBar = true;
    private boolean configMode = false;
    private boolean isShifted = false;
    private boolean rescaling = false;
    private boolean adjustMax;
    private int mainInc = -1;
    private int subInc;
    private int em;
    private int digits = 4;
    private int scaleWidth = 0;
    private double roundFactor = 1.0;
    private int hotMinY = 0;
    private int hotMaxY = 0;
    private int mouseStart;
    private Color dotColor;
    private Color scaleColor;
    private Color buttonColor;
    private Font scaleFont;
    private Font labelFont;
    private Font fieldFont;
    private FontMetrics sfm;
    private transient ActionListener actionListener = null;
    private double[] tick;
    private String[] tickLab;
    private Cursor arrowCursor = Cursor.getDefaultCursor();
    private Cursor leftCursor = new Cursor(10);
    private Cursor rightCursor = new Cursor(11);
    private String[] choices = new String[]{"Value", "Min", "Max", "Min!", "Max!", "Digits"};
    private Choice choice = new Choice();
    private TextField valField;
    private Button setbutton = new Button("OK");

    public Slider(String string, double d) {
        this.label = string;
        this.value = d;
        if (d > 0.0) {
            this.min = 0.0;
            this.max = 1.25 * d;
        } else if (d < 0.0) {
            this.min = 1.25 * d;
            this.max = 0.0;
        } else {
            this.min = 0.0;
            this.max = 1.0;
        }
        this.init();
    }

    public Slider(String string, double d, double d2, double d3) {
        this.label = string;
        this.value = d;
        this.min = d2;
        this.max = d3;
        this.init();
    }

    private void init() {
        this.valField = new TextField("0");
        this.setForeground(Color.black);
        this.dotColor = Color.red;
        this.scaleColor = Color.blue;
        this.buttonColor = Color.lightGray;
        this.setFont(new Font("Serif", 0, 12));
        this.scaleFont = new Font("SansSerif", 0, 8);
        int n = 0;
        while (n < this.choices.length) {
            this.choice.add(this.choices[n]);
            ++n;
        }
        this.setConfig(false);
        this.setLayout(null);
        this.valField.setFont(this.fieldFont);
        this.setbutton.setFont(this.scaleFont);
        this.add(this.choice);
        this.add(this.valField);
        this.add(this.setbutton);
    }

    private synchronized void setConfig(boolean bl) {
        this.choice.setVisible(bl);
        this.valField.setVisible(bl);
        this.setbutton.setVisible(bl);
        this.configMode = bl;
        if (bl) {
            this.setbutton.addActionListener(this);
            this.choice.addItemListener(this);
            this.valField.addKeyListener(this);
            this.valField.addFocusListener(this);
            this.valField.setText(Utility.format(this.value, this.digits));
            this.valField.setEditable(this.editable);
            this.disableEvents(32L);
            this.choice.select(0);
        } else {
            this.setbutton.removeActionListener(this);
            this.choice.removeItemListener(this);
            this.valField.removeKeyListener(this);
            this.valField.removeFocusListener(this);
            this.enableEvents(16L);
            this.enableEvents(32L);
            this.scaleWidth = 0;
        }
    }

    private synchronized void checkRange() {
        if (Double.isNaN(this.value)) {
            if (Double.isNaN(this.min)) {
                double d = this.min = Double.isNaN(this.max) ? -1.0 : this.max - 1.0;
            }
            if (Double.isNaN(this.max)) {
                this.max = this.min + 2.0;
            }
        } else {
            if (this.minMutable) {
                this.min = Math.min(this.min, Math.min(this.value, this.max));
            }
            if (this.maxMutable) {
                this.max = Math.max(this.max, Math.max(this.value, this.min));
            }
            this.value = Math.min(this.max, Math.max(this.value, this.min));
            if (this.min == this.max) {
                this.min = this.max - Math.max(Math.abs(this.value), 0.1);
            }
        }
        this.tick = Utility.nice(this.min, this.max, 5, false);
        this.tickLab = Utility.fmtNice(this.tick);
    }

    public void setMutable(boolean bl, boolean bl2) {
        this.minMutable = bl;
        this.maxMutable = bl2;
    }

    public void setValue(double d) {
        this.value = d;
        this.checkRange();
        if (this.configMode) {
            this.valField.setText(Utility.format(this.value, this.digits));
        }
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public void setMinimum(double d) {
        if (!this.minMutable) {
            return;
        }
        this.min = d;
        this.checkRange();
        this.scaleWidth = 0;
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public void setMaximum(double d) {
        if (!this.maxMutable) {
            return;
        }
        this.max = d;
        this.checkRange();
        this.scaleWidth = 0;
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public void setDigits(int n) {
        this.digits = n;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public double getValue() {
        return this.value;
    }

    public double getMinimum() {
        return this.min;
    }

    public double getMaximum() {
        return this.max;
    }

    public void setDotColor(Color color) {
        this.dotColor = color;
    }

    public void setButtonColor(Color color) {
        this.buttonColor = color;
    }

    public void setScaleColor(Color color) {
        this.scaleColor = color;
    }

    private void setIncs() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.mainInc = fontMetrics.getAscent();
        this.em = fontMetrics.stringWidth("M");
        this.sfm = this.getFontMetrics(this.scaleFont);
        this.subInc = this.sfm.getAscent();
        this.labelFont = new Font(this.getFont().getName(), 1, this.getFont().getSize());
    }

    public Dimension getPreferredSize() {
        if (this.mainInc < 0) {
            this.setIncs();
        }
        return new Dimension(18 * this.em, 5 * (this.mainInc + this.subInc) / 2);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    private double scaleValue(int n, int n2, int n3) {
        double d;
        if (n3 != this.scaleWidth) {
            this.scaleWidth = n3;
            d = 1.5;
            double d2 = d * (double)n3 / (this.max - this.min);
            double d3 = Math.log(d2) / Math.log(10.0);
            this.roundFactor = Math.pow(10.0, Math.floor(d3));
            d3 = d2 / this.roundFactor;
            if (d3 >= 5.0) {
                this.roundFactor *= 5.0;
            } else if (d3 >= 2.0) {
                this.roundFactor *= 2.0;
            }
        }
        d = this.min + (this.max - this.min) * (double)(n - n2) / (double)n3;
        return (double)Math.round(this.roundFactor * d) / this.roundFactor;
    }

    private int scalePos(double d, int n, int n2) {
        if (Double.isNaN(d)) {
            return -1;
        }
        return (int)((double)n + (d - this.min) * (double)n2 / (this.max - this.min));
    }

    public void repaint() {
        Dimension dimension = this.getSize();
        if (dimension.width == 0) {
            super.repaint();
            return;
        }
        Image image = this.createImage(dimension.width, dimension.height);
        Graphics graphics = image.getGraphics();
        this.paint(graphics);
        graphics.dispose();
        this.getGraphics().drawImage(image, 0, 0, null);
    }

    public void paint(Graphics graphics) {
        if (!this.isVisible()) {
            return;
        }
        if (this.tick == null) {
            this.checkRange();
        }
        if (this.configMode) {
            this.paintConfig(graphics);
        } else {
            this.paintSlider(graphics);
        }
    }

    private void paintConfig(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = n / 40;
        int n3 = 2 * this.mainInc;
        graphics.setFont(this.labelFont);
        graphics.setColor(this.getForeground());
        graphics.drawString(this.label, this.em / 2, 3 * this.mainInc / 2);
        graphics.setColor(this.getBackground().darker());
        graphics.fillRect(n - this.subInc, this.subInc / 2, this.subInc, this.subInc);
        graphics.draw3DRect(n - this.subInc, this.subInc / 2, this.subInc, this.subInc, false);
        int n4 = this.subInc / 3;
        graphics.draw3DRect(n - this.subInc + n4, this.subInc / 2 + n4, n4, n4, false);
        int n5 = this.choice.getPreferredSize().width;
        int n6 = this.choice.getPreferredSize().height;
        this.choice.setBounds(0, n3, n5, n6);
        this.valField.setBounds(n5 + n2, n3, n - n5 - 8 * n2, n6);
        this.setbutton.setBounds(n - 6 * n2, n3, 6 * n2, n6);
        String string = "";
        switch (this.choice.getSelectedIndex()) {
            case 0: {
                string = Utility.format(this.value, this.digits);
                break;
            }
            case 1: 
            case 3: {
                string = Utility.format(this.min, this.digits);
                break;
            }
            case 2: 
            case 4: {
                string = Utility.format(this.max, this.digits);
                break;
            }
            case 5: {
                string = "" + this.digits;
            }
        }
        super.paint(graphics);
    }

    private void paintSlider(Graphics graphics) {
        int n;
        int n2 = 3 * this.mainInc / 2;
        int n3 = this.getSize().width;
        int n4 = n3 - 2 * this.em;
        if (this.mainInc < 0) {
            this.setIncs();
        }
        graphics.setFont(this.labelFont);
        graphics.setColor(this.getForeground());
        graphics.drawString(this.label + " = " + Utility.format(this.value, this.digits), this.em / 2, n2);
        graphics.setColor(this.getBackground().darker());
        graphics.fillRect(n3 - this.subInc, this.subInc / 2, this.subInc, this.subInc);
        graphics.setColor(this.getBackground());
        graphics.draw3DRect(n3 - this.subInc, this.subInc / 2, this.subInc, this.subInc, true);
        int n5 = this.subInc / 3;
        graphics.draw3DRect(n3 - this.subInc + n5, this.subInc / 2 + n5, n5, n5, true);
        if (Double.isNaN(this.value)) {
            return;
        }
        this.hotMinY = (n2 += (this.mainInc + this.subInc) / 2) - this.subInc / 2;
        this.hotMaxY = n2 + this.subInc / 2;
        int n6 = this.scalePos(this.value, this.em, n4);
        if (this.editable) {
            graphics.setColor(this.getBackground().darker());
            graphics.fillRect(n6 - this.subInc / 2, n2 - this.subInc, 2 * (this.subInc / 2), 2 * this.subInc);
        }
        graphics.setColor(this.scaleColor);
        graphics.drawLine(this.em, n2, n3 - this.em, n2);
        int n7 = n2 - this.subInc / 2;
        int n8 = n7 + this.subInc;
        int n9 = n8 + 3 * this.subInc / 2;
        graphics.setFont(this.scaleFont);
        int n10 = 0;
        int n11 = 0;
        while (n11 < this.tick.length) {
            n = this.scalePos(this.tick[n11], this.em, n4);
            graphics.drawLine(n, n7, n, n8);
            int n12 = this.sfm.stringWidth(this.tickLab[n11]);
            n = Math.max(this.em / 2, Math.min(n - n12 / 2, n3 - this.em / 2 - n12));
            if (n - n10 > this.subInc / 2) {
                graphics.drawString(this.tickLab[n11], n, n9);
                n10 = n + n12;
            }
            ++n11;
        }
        if (this.showBar && this.min * this.max <= 0.0) {
            n = (int)((double)this.em - (double)(n3 - 2 * this.em) * this.min / (this.max - this.min));
            graphics.setColor(this.dotColor);
            graphics.drawLine(n, n2, n6, n2);
            graphics.drawLine(n, n2 - 1, n6, n2 - 1);
            graphics.drawLine(n, n2 + 1, n6, n2 + 1);
        }
        graphics.setColor(this.getForeground());
        graphics.drawLine(n6, n2 - this.subInc, n6, n2 + this.subInc);
        if (this.editable) {
            graphics.setColor(this.getBackground());
            graphics.draw3DRect(n6 - this.subInc / 2, n2 - this.subInc, 2 * (this.subInc / 2), 2 * this.subInc, true);
        } else {
            graphics.setColor(this.getBackground().darker());
            graphics.drawRoundRect(n6 - this.subInc / 2, n2 - this.subInc, 2 * (this.subInc / 2), 2 * this.subInc, 2 * this.subInc / 3, this.subInc);
        }
        super.paint(graphics);
    }

    public String toString() {
        return "Slider: " + this.label + " = " + Utility.format(this.value, 4) + " on [" + Utility.format(this.min, 4) + "," + Utility.format(this.max, 4) + "] mutable: [" + this.minMutable + "," + this.maxMutable + "]";
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void processMouseEvent(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() - this.em;
        int n2 = this.getSize().width - 2 * this.em;
        int n3 = mouseEvent.getY();
        switch (mouseEvent.getID()) {
            case 500: {
                if (n > this.em + n2 - this.subInc && n3 < 3 * this.subInc / 2) {
                    this.setConfig(!this.configMode);
                    this.repaint();
                    return;
                }
                if (n < 0 || n > n2 || this.configMode) {
                    return;
                }
                if (n3 < this.hotMinY || n3 > this.hotMaxY) break;
                if (n > n2 || !this.editable) {
                    return;
                }
                this.setValue(this.scaleValue(n, 0, n2));
                this.repaint();
                if (this.actionListener == null) break;
                this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.label));
                break;
            }
            case 501: {
                if (n < 0 || n > n2 || this.configMode) {
                    return;
                }
                this.requestFocus();
                if (n3 < this.hotMaxY + this.subInc / 2) break;
                this.rescaling = false;
                if (!this.maxMutable) {
                    this.adjustMax = false;
                    if (!this.minMutable) {
                        return;
                    }
                } else {
                    this.adjustMax = this.minMutable ? n > n2 / 2 : true;
                }
                this.mouseStart = n;
                this.rescaling = true;
                this.setCursor(this.adjustMax ? this.rightCursor : this.leftCursor);
                break;
            }
            case 502: {
                this.setCursor(this.arrowCursor);
                if (!this.rescaling) break;
                this.rescaling = false;
                if ((n = Math.max(0, Math.min(n, n2))) == this.mouseStart) {
                    return;
                }
                double d = this.scaleValue(this.mouseStart, 0, n2);
                if (this.maxMutable && n > n2 / 2) {
                    this.max = this.min + (d - this.min) * (double)n2 / (double)n;
                } else if (this.minMutable) {
                    this.min = this.max - (this.max - d) * (double)n2 / (double)(n2 - n);
                }
                this.scaleWidth = 0;
                this.checkRange();
                this.repaint();
                break;
            }
            case 505: {
                this.rescaling = false;
            }
        }
    }

    public synchronized void processMouseMotionEvent(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() - this.em;
        int n2 = this.getSize().width - 2 * this.em;
        int n3 = mouseEvent.getY();
        if (mouseEvent.getID() == 506) {
            if (!this.editable) {
                return;
            }
            if (n < 0 && this.minMutable) {
                this.min -= 0.005 * (this.max - this.min);
                this.checkRange();
                this.repaint();
            } else if (n > n2 && this.maxMutable) {
                this.max += 0.005 * (this.max - this.min);
                this.checkRange();
                this.repaint();
            }
            if (n3 >= this.hotMinY && n3 <= this.hotMaxY) {
                this.setValue(this.scaleValue(n, 0, n2));
                this.repaint();
                if (this.actionListener != null) {
                    this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.label));
                }
            }
        }
    }

    private void updateChoice(int n, double d) {
        switch (n) {
            case 0: {
                if (!this.editable) {
                    return;
                }
                this.value = d;
                if (this.actionListener != null) {
                    this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.label));
                }
                return;
            }
            case 1: {
                this.setMutable(true, this.maxMutable);
                this.min = d;
                break;
            }
            case 2: {
                this.setMutable(this.minMutable, true);
                this.max = d;
                break;
            }
            case 3: {
                this.setMutable(false, this.maxMutable);
                this.min = d;
                break;
            }
            case 4: {
                this.setMutable(this.minMutable, false);
                this.max = d;
                break;
            }
            case 5: {
                this.digits = Math.max(1, (int)Math.round(d));
            }
        }
        this.checkRange();
        this.choice.select(0);
        this.valField.setEditable(this.editable);
        this.valField.setText(Utility.format(this.value, this.digits));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.setbutton)) {
            try {
                double d = Utility.strtod(this.valField.getText());
                this.updateChoice(this.choice.getSelectedIndex(), d);
            }
            catch (NumberFormatException numberFormatException) {
                this.valField.setText(this.valField.getText() + " - INVALID!");
                this.valField.selectAll();
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.choice)) {
            String string = "";
            this.valField.setEditable(true);
            switch (this.choice.getSelectedIndex()) {
                case 0: {
                    string = Utility.format(this.value, this.digits);
                    this.valField.setEditable(this.editable);
                    break;
                }
                case 1: 
                case 3: {
                    string = Utility.format(this.min, this.digits);
                    break;
                }
                case 2: 
                case 4: {
                    string = Utility.format(this.max, this.digits);
                    break;
                }
                case 5: {
                    string = "" + this.digits;
                }
            }
            this.valField.setText(string);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 16 || keyEvent.getKeyCode() == 18 || keyEvent.getKeyCode() == 17) {
            this.isShifted = true;
        }
        if (keyEvent.getKeyCode() == 10) {
            this.actionPerformed(new ActionEvent(this.setbutton, 1001, "OK"));
        }
        if (keyEvent.getKeyCode() == 27) {
            this.setConfig(false);
            this.repaint();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 16 || keyEvent.getKeyCode() == 18 || keyEvent.getKeyCode() == 17) {
            this.isShifted = false;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.valField)) {
            this.valField.selectAll();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.valField)) {
            this.valField.select(0, 0);
            this.actionPerformed(new ActionEvent(this.setbutton, 1001, "OK"));
        }
    }
}

