/*
 * Decompiled with CFR 0.152.
 */
package rvl.piface;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;
import rvl.awt.DoubleField;
import rvl.awt.RVLayout;
import rvl.awt.ViewWindow;
import rvl.piface.AboutPiface;
import rvl.piface.DoubleComponent;
import rvl.piface.IntComponent;
import rvl.piface.PiComponent;
import rvl.piface.PiListener;
import rvl.piface.Piface;
import rvl.util.Utility;

public class PiGraph
extends Frame
implements PiListener,
ActionListener,
WindowListener {
    Piface piface;
    Choice yChoice = new Choice();
    Choice xChoice = new Choice();
    DoubleField fromFld = new DoubleField("", 5);
    DoubleField toFld = new DoubleField("", 5);
    DoubleField byFld = new DoubleField("", 5);
    Checkbox accumChk = new Checkbox("Persistent");
    Button dataButton = new Button("Show Data");
    Button drawButton = new Button("Redraw");
    Button quitButton = new Button("Close");
    MenuBar menuBar = new MenuBar();
    Menu helpMenu = new Menu("Help");
    int cpHeight = 0;
    int xVar;
    int yVar;
    boolean init = true;
    double xMin;
    double xMax;
    double yMin;
    double yMax;
    String xName;
    String yName;
    Vector vars = new Vector();
    Vector intComps = new Vector();
    Vector labs = new Vector();
    Vector data = new Vector();
    Font scaleFont = new Font("SansSerif", 0, 10);
    static /* synthetic */ Class class$rvl$piface$PiGraph;

    public PiGraph(Piface piface) {
        Object object;
        this.piface = piface;
        Panel panel = new Panel(new RVLayout(1, true, true));
        Panel panel2 = new Panel(new RVLayout(2, false, true));
        Panel panel3 = new Panel(new RVLayout(6, false, true));
        Panel panel4 = new Panel(new RVLayout(4, false, true));
        panel2.add(new Label("Vertical (y) axis"));
        panel2.add(this.yChoice);
        panel2.add(new Label("Horizontal (x) axis"));
        panel2.add(this.xChoice);
        panel3.add(new Label("from", 2));
        panel3.add(this.fromFld);
        panel3.add(new Label("to", 2));
        panel3.add(this.toFld);
        panel3.add(new Label("by", 2));
        panel3.add(this.byFld);
        panel4.add(this.accumChk);
        panel4.add(this.dataButton);
        panel4.add(this.drawButton);
        panel4.add(this.quitButton);
        panel.add(panel2);
        panel.add(panel3);
        panel.add(panel4);
        Enumeration enumeration = this.piface.actors.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            object = (PiComponent)enumeration.nextElement();
            if (object instanceof DoubleComponent) {
                this.vars.addElement(object.getName());
                this.labs.addElement(object.getLabel());
                this.xChoice.addItem(object.getLabel());
                this.yChoice.addItem(object.getLabel());
                ++n;
                continue;
            }
            if (!(object instanceof IntComponent)) continue;
            this.intComps.addElement(object);
        }
        if (n == 0) {
            this.yChoice.addItem("Sorry,");
            this.xChoice.addItem("No variables are available!");
        } else {
            this.xChoice.select(Math.max(0, n - 2));
            this.yChoice.select(n - 1);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "South");
        this.setTitle("PiFace Graph");
        ((Component)this).setBackground(((Component)piface).getBackground());
        this.piface.addPiListener(this);
        this.quitButton.addActionListener(this);
        this.drawButton.addActionListener(this);
        this.dataButton.addActionListener(this);
        this.dataButton.setVisible(false);
        this.addWindowListener(this);
        object = new MenuItem("Help");
        MenuItem menuItem = new MenuItem("About Piface");
        ((MenuItem)object).addActionListener(this);
        menuItem.addActionListener(this);
        this.setMenuBar(this.menuBar);
        this.menuBar.setHelpMenu(this.helpMenu);
        this.helpMenu.add((MenuItem)object);
        this.helpMenu.add(menuItem);
        this.pack();
        this.drawButton.setLabel("Draw");
        this.cpHeight = panel.getSize().height;
        Point point = this.piface.getLocation();
        point.x += this.piface.getSize().width;
        ((Component)this).setLocation(point);
        this.show();
    }

    public void close() {
        this.piface.removePiListener(this);
        this.dispose();
    }

    private synchronized void computePlotData() {
        Object object;
        double d = this.fromFld.getValue();
        double d2 = this.byFld.getValue();
        double d3 = this.toFld.getValue();
        if (Double.isNaN(d + d3 + d2) || d == d3 || d2 == 0.0) {
            return;
        }
        int n = (int)Math.abs((d3 - d) / d2 + 1.0);
        if (n < 2) {
            return;
        }
        if (!this.accumChk.getState() || this.xVar != this.xChoice.getSelectedIndex() || this.yVar != this.yChoice.getSelectedIndex()) {
            this.data.removeAllElements();
        }
        this.xVar = this.xChoice.getSelectedIndex();
        this.yVar = this.yChoice.getSelectedIndex();
        String string = (String)this.vars.elementAt(this.xVar);
        String string2 = (String)this.vars.elementAt(this.yVar);
        StringBuffer stringBuffer = new StringBuffer("# " + this.yChoice.getSelectedItem() + " vs. " + this.xChoice.getSelectedItem() + "\n");
        int n2 = 0;
        while (n2 < this.intComps.size()) {
            IntComponent intComponent = (IntComponent)this.intComps.elementAt(n2);
            stringBuffer.append("#   " + intComponent.getLabel() + ": " + intComponent.getTextValue() + "\n");
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.vars.size()) {
            object = (String)this.vars.elementAt(n3);
            if (!((String)object).equals(string) && !((String)object).equals(string2)) {
                stringBuffer.append("#   " + this.labs.elementAt(n3) + " = " + Utility.format(this.piface.getDVar((String)object), 5) + "\n");
            }
            ++n3;
        }
        stringBuffer.append(string + "\t" + string2 + "\n");
        this.data.addElement(new String(stringBuffer));
        object = new double[n];
        double[] dArray = new double[n];
        double[] dArray2 = this.piface.saveVars();
        int n4 = 0;
        while (n4 < n) {
            dArray[n4] = this.piface.eval(string2, string, d + (double)n4 * d2);
            object[n4] = this.piface.getDVar(string);
            ++n4;
        }
        this.piface.restoreVars(dArray2);
        this.data.addElement(object);
        this.data.addElement(dArray);
    }

    void computeRanges() {
        boolean bl = false;
        this.yMax = 0.0;
        this.yMin = 0.0;
        this.xMax = 0.0;
        this.xMin = 0.0;
        if (this.data.size() == 0) {
            return;
        }
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            double[] dArray = (double[])enumeration.nextElement();
            double[] dArray2 = (double[])enumeration.nextElement();
            int n = dArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (!Double.isNaN(dArray[n2] + dArray2[n2])) {
                    if (!bl) {
                        this.xMin = this.xMax = dArray[n2];
                        this.yMin = this.yMax = dArray2[n2];
                        bl = true;
                    }
                    if (dArray[n2] < this.xMin) {
                        this.xMin = dArray[n2];
                    }
                    if (dArray[n2] > this.xMax) {
                        this.xMax = dArray[n2];
                    }
                    if (dArray2[n2] < this.yMin) {
                        this.yMin = dArray2[n2];
                    }
                    if (dArray2[n2] > this.yMax) {
                        this.yMax = dArray2[n2];
                    }
                }
                ++n2;
            }
        }
    }

    void showData() {
        Object object;
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("# Curve number " + ++n + "\n");
            stringBuffer.append((String)enumeration.nextElement());
            object = (double[])enumeration.nextElement();
            double[] dArray = (double[])enumeration.nextElement();
            int n2 = 0;
            while (n2 < ((Object)object).length) {
                stringBuffer.append(Utility.format((double)object[n2], 5) + "\t" + Utility.format(dArray[n2], 5) + "\n");
                ++n2;
            }
        }
        stringBuffer.append("\n");
        object = new ViewWindow("Plot data", 25, 40);
        ((ViewWindow)object).setText(new String(stringBuffer));
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        if (this.init) {
            return;
        }
        this.setTitle(this.yChoice.getSelectedItem() + " vs. " + this.xChoice.getSelectedItem());
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        int n4 = dimension.width - 10 - insets.left - insets.right;
        int n5 = dimension.height - 10 - insets.top - insets.bottom - this.cpHeight;
        int n6 = 5 + insets.left;
        int n7 = 5 + insets.top;
        if (n4 <= 0 || n5 <= 0) {
            return;
        }
        graphics.setColor(Color.white);
        graphics.fillRect(n6, n7, n4, n5);
        graphics.setColor(Color.lightGray);
        graphics.draw3DRect(n6, n7, n4, n5, false);
        graphics.setColor(Color.lightGray.darker());
        graphics.draw3DRect(n6 + 1, n7 + 1, n4 - 2, n5 - 2, false);
        if (this.xVar != this.xChoice.getSelectedIndex() || this.yVar != this.yChoice.getSelectedIndex()) {
            this.computePlotData();
        }
        if (this.data.size() == 0) {
            return;
        }
        this.computeRanges();
        if (n4 < 0 || n5 < 0) {
            return;
        }
        double d = 1.1 * (this.xMax - this.xMin);
        double d2 = 1.1 * (this.yMax - this.yMin);
        double d3 = this.xMin - 0.05 * (this.xMax - this.xMin);
        double d4 = this.yMax + 0.05 * (this.yMax - this.yMin);
        if (d == 0.0) {
            return;
        }
        if (d2 == 0.0) {
            d2 = 1.0;
            d4 += d2 / 2.0;
        }
        double[] dArray = Utility.nice(d4 - d2, d4, 5, false);
        String[] stringArray = Utility.fmtNice(dArray);
        FontMetrics fontMetrics = this.getFontMetrics(this.scaleFont);
        int n8 = fontMetrics.getAscent();
        int n9 = 2 * n8;
        int n10 = 0;
        int n11 = 0;
        while (n11 < dArray.length) {
            n3 = fontMetrics.stringWidth(stringArray[n11]);
            if (n3 > n10) {
                n10 = n3;
            }
            ++n11;
        }
        graphics.setColor(Color.blue.darker());
        graphics.drawRect(n6 += (n10 += n8), n7 += 5, n4 -= n10 + 5, n5 -= n9 + 5);
        graphics.setFont(this.scaleFont);
        int n12 = n6 - n8 / 3;
        n11 = 0;
        while (n11 < dArray.length) {
            n3 = (int)((double)n7 + (double)n5 * (d4 - dArray[n11]) / d2);
            graphics.drawLine(n6, n3, n12, n3);
            n2 = fontMetrics.stringWidth(stringArray[n11]);
            graphics.drawString(stringArray[n11], n6 - n2 - n8 / 2, n3 + n8 / 3);
            ++n11;
        }
        dArray = Utility.nice(d3, d3 + d, 5, false);
        stringArray = Utility.fmtNice(dArray);
        int n13 = n7 + n5;
        n12 = n13 + n8 / 3;
        n3 = n12 + n8;
        n11 = 0;
        while (n11 < dArray.length) {
            n2 = (int)((double)n6 + (double)n4 * (dArray[n11] - d3) / d);
            graphics.drawLine(n2, n13, n2, n12);
            n = fontMetrics.stringWidth(stringArray[n11]);
            graphics.drawString(stringArray[n11], n2 - n / 2, n3);
            ++n11;
        }
        Color[] colorArray = new Color[]{Color.black, Color.blue, Color.red, Color.orange, Color.green.darker(), Color.magenta};
        n = 0;
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            graphics.setColor(colorArray[n++ % colorArray.length]);
            double[] dArray2 = (double[])enumeration.nextElement();
            double[] dArray3 = (double[])enumeration.nextElement();
            boolean bl = false;
            int n14 = 0;
            int n15 = 0;
            n11 = 0;
            while (n11 < dArray2.length) {
                if (Double.isNaN(dArray2[n11] + dArray3[n11])) {
                    bl = false;
                } else {
                    int n16 = (int)((double)n6 + (double)n4 * (dArray2[n11] - d3) / d);
                    int n17 = (int)((double)n7 + (double)n5 * (d4 - dArray3[n11]) / d2);
                    if (!bl) {
                        n14 = n16;
                        n15 = n17;
                        bl = true;
                    }
                    graphics.drawLine(n14, n15, n16, n17);
                    n14 = n16;
                    n15 = n17;
                }
                ++n11;
            }
        }
    }

    public void piAction(String string) {
        this.computePlotData();
        this.repaint();
    }

    public static ViewWindow showText(Class clazz, String string, String string2, int n, int n2) {
        ViewWindow viewWindow = new ViewWindow(string2, n, n2);
        try {
            String string3;
            viewWindow.ta.setVisible(false);
            InputStream inputStream = clazz.getResourceAsStream(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string3 = bufferedReader.readLine()) != null) {
                viewWindow.append(string3 + "\n");
            }
            inputStream.close();
            viewWindow.setTop();
            viewWindow.ta.setVisible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return viewWindow;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand().toString();
        if (string.equals("Close")) {
            this.close();
        } else if (string.equals("Help")) {
            PiGraph.showText(class$rvl$piface$PiGraph == null ? (class$rvl$piface$PiGraph = PiGraph.class$("rvl.piface.PiGraph")) : class$rvl$piface$PiGraph, "PiGraphHelp.txt", "Graphics help", 25, 50);
        } else if (string.equals("About Piface")) {
            new AboutPiface();
        } else if (string.equals("Show Data")) {
            this.showData();
        } else if (string.equals("Draw")) {
            ((Component)this).setVisible(false);
            this.init = false;
            Dimension dimension = this.getSize();
            int n = 3 * (dimension.width - 10) / 4 + dimension.height + 10;
            ((Component)this).setSize(dimension.width, n);
            this.dataButton.setVisible(true);
            this.drawButton.setLabel("Redraw");
            ((Component)this).setVisible(true);
            this.xVar = this.xChoice.getSelectedIndex();
            this.yVar = this.yChoice.getSelectedIndex();
            this.computePlotData();
            this.repaint();
        } else if (string.equals("Redraw")) {
            this.computePlotData();
            this.repaint();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.close();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

