/*
 * Decompiled with CFR 0.152.
 */
package rvl.piface;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import rvl.awt.RVLayout;
import rvl.awt.ViewWindow;
import rvl.piface.AboutPiface;
import rvl.piface.ActionComponent;
import rvl.piface.DoubleComponent;
import rvl.piface.IntComponent;
import rvl.piface.PiActionAdapter;
import rvl.piface.PiArrayField;
import rvl.piface.PiButton;
import rvl.piface.PiCheckbox;
import rvl.piface.PiChoice;
import rvl.piface.PiComponent;
import rvl.piface.PiDotplot;
import rvl.piface.PiDoubleField;
import rvl.piface.PiDoubleText;
import rvl.piface.PiGraph;
import rvl.piface.PiListener;
import rvl.piface.PiMenuCheckbox;
import rvl.piface.PiMenuItem;
import rvl.piface.PiNumChoice;
import rvl.piface.PiPanel;
import rvl.piface.PiRadio;
import rvl.piface.PiSlider;
import rvl.piface.PifaceAux;
import rvl.util.Closeable;
import rvl.util.Solve;
import rvl.util.Utility;

public abstract class Piface
extends Frame
implements ActionListener,
WindowListener,
Closeable {
    public static final String version = "1.51 - 1 August 2001";
    private Stack subpanels = new Stack();
    private Component master = null;
    public double javaVersion = 1.0;
    protected Vector panels = new Vector();
    protected Vector actors = new Vector();
    protected Vector listeners = new Vector();
    protected PiPanel panel;
    protected MenuBar menuBar = new MenuBar();
    protected Menu optMenu = new Menu("Options");
    protected Menu helpMenu = new Menu("Help");
    protected Font boldFont = new Font("Serif", 1, 12);
    protected Font bigFont = new Font("Serif", 1, 14);
    protected String actionSource = "init";
    protected int sourceIndex = -1;
    private static final double rlog10 = 1.0 / Math.log(10.0);
    private static double theSeed = -1.0;
    private static double theMult = 63069.0;
    private static double theTerm = 0.84763521;
    private static boolean flag = true;
    private static double u1;
    private static double u2;
    private static double r;
    static /* synthetic */ Class array$D;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class class$rvl$piface$Piface;

    public Piface() {
        this("Piface dialog");
    }

    public Piface(String string) {
        super(string);
        this.build();
        Utility.setGUIWarn(true);
    }

    public Piface(String string, boolean bl) {
        super(string);
        if (bl) {
            this.build();
        }
    }

    public static String getVersion() {
        return version;
    }

    public void build() {
        try {
            Class.forName("java.awt.event.ActionListener");
            this.javaVersion = 1.1;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.errmsg("<init>", "JVM version " + this.javaVersion + " is too old." + "  Need at least version 1.1", true);
        }
        MenuItem menuItem = new MenuItem("Graph...");
        MenuItem menuItem2 = new MenuItem("Quit");
        menuItem.addActionListener(this);
        menuItem2.addActionListener(this);
        this.setMenuBar(this.menuBar);
        this.menuBar.add(this.optMenu);
        this.menuBar.setHelpMenu(this.helpMenu);
        ((Component)this).setBackground(new Color(220, 220, 255));
        this.newColumn();
        this.optMenu.add(menuItem);
        this.beforeSetup();
        this.gui();
        this.click();
        this.updateVars();
        PiPanel piPanel = new PiPanel(new RVLayout(this.panels.size(), 0, 0, false, true));
        int n = 0;
        while (n < this.panels.size()) {
            piPanel.add((PiPanel)this.panels.elementAt(n));
            ++n;
        }
        this.optMenu.addSeparator();
        this.menuItem("postHocRant", "Post hoc power...", this.optMenu);
        this.menuItem("cohenRant", "Cohen's effect sizes...", this.optMenu);
        this.optMenu.addSeparator();
        this.optMenu.add(menuItem2);
        this.helpMenu.addSeparator();
        this.menuItem("guiHelp", "GUI help", this.helpMenu);
        this.menuItem("aboutPiface", "About Piface", this.helpMenu);
        this.addWindowListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)piPanel, "Center");
        this.afterSetup();
        this.pack();
        this.show();
    }

    public void errmsg(String string, String string2, boolean bl) {
        String string3;
        String string4 = string3 = string2 == null ? string : string + ": " + string2;
        if (bl) {
            Utility.error(string3, (Closeable)this);
        } else {
            Utility.warning(string3);
        }
    }

    public void errmsg(String string, String string2) {
        this.errmsg(string, string2, false);
    }

    public void errmsg(String string) {
        this.errmsg(string, null, false);
    }

    public void stackTrace(Throwable throwable) {
        Utility.error(throwable, (Closeable)this);
    }

    public void close() {
        Enumeration enumeration = ((Vector)this.listeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            PiListener piListener = (PiListener)enumeration.nextElement();
            piListener.close();
        }
        this.dispose();
        if (this.master == null) {
            System.exit(0);
        }
    }

    public void addComponent(String string, String string2, Component component) {
        this.panel.add(component);
        PiActionAdapter piActionAdapter = new PiActionAdapter(string, string2, component);
        piActionAdapter.addActionListener(this);
    }

    public void addComponent(String string, Component component) {
        this.addComponent(string, string, component);
    }

    public void addVar(String string, DoubleComponent doubleComponent, double d) {
        this.panel.add((Component)((Object)doubleComponent));
        doubleComponent.addActionListener(this);
        this.setVar(string, d);
        this.actors.addElement(doubleComponent);
    }

    public void addVar(String string, IntComponent intComponent, int n) {
        this.panel.add((Component)((Object)intComponent));
        intComponent.addActionListener(this);
        this.setVar(string, n);
        this.actors.addElement(intComponent);
    }

    public void click() {
        this.errmsg("click()", "Method needed to handle events.", false);
    }

    public void gui() {
        this.errmsg("gui()", "Method needed to do anything useful.");
    }

    protected void beforeSetup() {
    }

    protected void afterSetup() {
    }

    Object[] parseArray(String string) {
        int n = string.indexOf("[");
        int n2 = string.indexOf("]");
        String string2 = string.substring(0, n);
        Integer n3 = new Integer(string.substring(n + 1, n2));
        return new Object[]{string2, n3};
    }

    protected void setVar(String string, double d) {
        if (string.endsWith("]")) {
            this.setVar(this.parseArray(string), d);
            return;
        }
        try {
            Field field = this.getClass().getField(string);
            field.setDouble(this, d);
        }
        catch (Exception exception) {
            this.errmsg("setVar(String, double)", "Can't set value of " + string);
            this.stackTrace(exception);
        }
    }

    protected double getDVar(String string) {
        if (string.endsWith("]")) {
            return this.getDVar(this.parseArray(string));
        }
        try {
            Field field = this.getClass().getField(string);
            return field.getDouble(this);
        }
        catch (Exception exception) {
            this.errmsg("getDVar(String)", "Can't get value of " + string);
            this.stackTrace(exception);
            return Double.NaN;
        }
    }

    protected void setVar(Object[] objectArray, double d) {
        String string = (String)objectArray[0];
        int n = (Integer)objectArray[1];
        try {
            Object object = this.getClass().getField(string).get(this);
            Array.setDouble(object, n, d);
        }
        catch (Exception exception) {
            this.errmsg("setVar(Object[], double)", "Can't set value of " + string + "[" + n + "]\n");
            this.stackTrace(exception);
        }
    }

    protected double getDVar(Object[] objectArray) {
        String string = (String)objectArray[0];
        int n = (Integer)objectArray[1];
        try {
            Object object = this.getClass().getField(string).get(this);
            return Array.getDouble(object, n);
        }
        catch (Exception exception) {
            this.errmsg("getDVar(Object[])", "Can't get value of " + string + "[" + n + "]\n");
            this.stackTrace(exception);
            return Double.NaN;
        }
    }

    protected void setVar(String string, int n) {
        if (string.endsWith("]")) {
            this.setVar(this.parseArray(string), n);
            return;
        }
        try {
            Field field = this.getClass().getField(string);
            field.setInt(this, n);
        }
        catch (Exception exception) {
            this.errmsg("setVar(String, int)", "Can't set value of " + string);
            this.stackTrace(exception);
        }
    }

    protected int getIVar(String string) {
        if (string.endsWith("]")) {
            return this.getIVar(this.parseArray(string));
        }
        try {
            Field field = this.getClass().getField(string);
            return field.getInt(this);
        }
        catch (Exception exception) {
            this.errmsg("getIVar(String)", "Can't get value of " + string);
            this.stackTrace(exception);
            return -9999;
        }
    }

    protected void setVar(Object[] objectArray, int n) {
        String string = (String)objectArray[0];
        int n2 = (Integer)objectArray[1];
        try {
            Object object = this.getClass().getField(string).get(this);
            Array.setInt(object, n2, n);
        }
        catch (Exception exception) {
            this.errmsg("setVar(Object[], int)", "Can't set value of " + string + "[" + n2 + "]");
            this.stackTrace(exception);
        }
    }

    protected int getIVar(Object[] objectArray) {
        String string = (String)objectArray[0];
        int n = (Integer)objectArray[1];
        try {
            Object object = this.getClass().getField(string).get(this);
            return Array.getInt(object, n);
        }
        catch (Exception exception) {
            this.errmsg("getIVar(Object[])", "Can't get value of " + string + "[" + n + "]");
            this.stackTrace(exception);
            return -9999;
        }
    }

    protected void setVar(String string, Piface piface) {
        if (string.endsWith("]")) {
            Object[] objectArray = this.parseArray(string);
            String string2 = (String)objectArray[0];
            try {
                Field field = this.getClass().getField(string2);
                Class<?> clazz = field.getType();
                if (clazz == (array$D == null ? (array$D = Piface.class$("[D")) : array$D)) {
                    this.setVar(objectArray, piface.getDVar(string));
                } else if (clazz == (array$I == null ? (array$I = Piface.class$("[I")) : array$I)) {
                    this.setVar(objectArray, piface.getIVar(string));
                }
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
        try {
            Field field = this.getClass().getField(string);
            Class<?> clazz = field.getType();
            if (clazz == Double.TYPE) {
                this.setVar(string, piface.getDVar(string));
            } else if (clazz == Integer.TYPE) {
                this.setVar(string, piface.getIVar(string));
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void callMethod(String string) {
        try {
            Method method = this.getClass().getMethod(string, null);
            method.invoke((Object)this, null);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.errmsg("callMethod(\"" + string + "\")", invocationTargetException.toString(), false);
            invocationTargetException.getTargetException().printStackTrace();
        }
        catch (Throwable throwable) {
            this.errmsg("callMethod(\"" + string + "\")", throwable.toString(), false);
            this.stackTrace(throwable);
        }
    }

    public void callMethodFor(String string) {
        Object object;
        if (string.endsWith("]")) {
            object = this.parseArray(string);
            this.actionSource = (String)object[0];
            this.sourceIndex = (Integer)object[1];
        } else {
            this.actionSource = string;
            this.sourceIndex = -1;
        }
        try {
            object = this.getClass().getMethod(this.actionSource + "_changed", null);
            ((Method)object).invoke((Object)this, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.click();
        }
        catch (InvocationTargetException invocationTargetException) {
            this.errmsg("callMethodFor(\"" + string + "\")", invocationTargetException.toString(), false);
            invocationTargetException.getTargetException().printStackTrace();
        }
        catch (Exception exception) {
            this.errmsg("callMethodFor(\"" + string + "\")", exception.toString(), false);
            this.stackTrace(exception);
        }
    }

    public void updateVars() {
        Enumeration enumeration = this.actors.elements();
        while (enumeration.hasMoreElements()) {
            PiComponent piComponent;
            Object e = enumeration.nextElement();
            if (e instanceof DoubleComponent) {
                piComponent = (DoubleComponent)e;
                piComponent.setValue(this.getDVar(piComponent.getName()));
                continue;
            }
            if (e instanceof IntComponent) {
                piComponent = (IntComponent)e;
                piComponent.setValue(this.getIVar(piComponent.getName()));
                continue;
            }
            this.errmsg("updateVars()", "Unsupported type: " + e.getClass());
        }
    }

    public void newColumn() {
        this.panel = new PiPanel(new RVLayout(1, false, true));
        this.panels.addElement(this.panel);
    }

    public void beginSubpanel(int n) {
        this.subpanels.push(this.panel);
        this.panel = new PiPanel(new RVLayout(n, false, true));
    }

    public void beginSubpanel(int n, Color color) {
        this.subpanels.push(this.panel);
        this.panel = new PiPanel(new RVLayout(n, false, true));
        this.border(color);
    }

    public void beginSubpanel(int n, boolean bl) {
        this.subpanels.push(this.panel);
        this.panel = new PiPanel(new RVLayout(n, false, true));
        this.set3D(bl);
    }

    public void endSubpanel() {
        if (this.subpanels.empty()) {
            this.errmsg("endSubpanel()", "Subpanel stack is empty", true);
        }
        PiPanel piPanel = this.panel;
        this.panel = (PiPanel)this.subpanels.pop();
        this.panel.add(piPanel);
    }

    public void border(Color color) {
        this.panel.setBorderColor(color);
        this.panel.setBorderType(1);
    }

    public void set3D(boolean bl) {
        this.panel.setBorderColor(null);
        this.panel.setBorderType(bl ? 2 : 3);
    }

    public void filler() {
        RVLayout rVLayout = (RVLayout)this.panel.getLayout();
        rVLayout.vertFill(this.panel);
        this.panel.setStretchable(true);
    }

    public void postHocRant() {
        this.showText(class$rvl$piface$Piface == null ? (class$rvl$piface$Piface = Piface.class$("rvl.piface.Piface")) : class$rvl$piface$Piface, "PostHocPower.txt", "Post hoc power", 25, 60);
    }

    public void cohenRant() {
        this.showText(class$rvl$piface$Piface == null ? (class$rvl$piface$Piface = Piface.class$("rvl.piface.Piface")) : class$rvl$piface$Piface, "Cohen.txt", "Cohen's effect sizes", 25, 60);
    }

    public void guiHelp() {
        this.showText(class$rvl$piface$Piface == null ? (class$rvl$piface$Piface = Piface.class$("rvl.piface.Piface")) : class$rvl$piface$Piface, "PifaceHelp.txt", "Piface Help", 25, 50);
    }

    public void aboutPiface() {
        new AboutPiface();
    }

    public ViewWindow showText(String string, String string2, int n, int n2) {
        ViewWindow viewWindow = new ViewWindow(string2, n, n2);
        viewWindow.ta.setVisible(false);
        viewWindow.setText(string);
        viewWindow.setTop();
        viewWindow.ta.setVisible(true);
        return viewWindow;
    }

    public ViewWindow showText(Class clazz, String string, String string2, int n, int n2) {
        ViewWindow viewWindow = new ViewWindow(string2, n, n2);
        try {
            String string3;
            viewWindow.ta.setVisible(false);
            InputStream inputStream = clazz.getResourceAsStream(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string3 = bufferedReader.readLine()) != null) {
                viewWindow.append(string3 + "\n");
            }
            inputStream.close();
            viewWindow.setTop();
            viewWindow.ta.setVisible(true);
        }
        catch (Exception exception) {
            this.errmsg("showText(Class,String,title,int,int)", "Can't display \"" + string + "\"", false);
        }
        return viewWindow;
    }

    public double solve(String string, String string2, double d, double d2, double d3) {
        PifaceAux pifaceAux = new PifaceAux(string, string2, this);
        return this.solve(pifaceAux, d, d2, d3);
    }

    public double solve(PifaceAux pifaceAux, double d, double d2, double d3) {
        double[] dArray = this.saveVars();
        double d4 = Solve.search(pifaceAux, d, d2, d3);
        this.restoreVars(dArray);
        return d4;
    }

    public PiComponent getComponent(String string) {
        Enumeration enumeration = this.actors.elements();
        while (enumeration.hasMoreElements()) {
            PiComponent piComponent = (PiComponent)enumeration.nextElement();
            if (!piComponent.getName().equals(string)) continue;
            return piComponent;
        }
        return null;
    }

    public void setVisible(String string, boolean bl) {
        ((Component)((Object)this.getComponent(string))).setVisible(bl);
    }

    public void relabel(String string, String string2) {
        PiComponent piComponent = this.getComponent(string);
        piComponent.setName(string, string2);
    }

    public void label(String string, Font font) {
        Label label = new Label(string);
        label.setFont(font);
        this.panel.add(label);
    }

    public void label(String string) {
        this.label(string, this.bigFont);
    }

    public void slider(String string, String string2, double d, double d2, double d3, int n, boolean bl, boolean bl2, boolean bl3) {
        PiSlider piSlider = new PiSlider(string, string2, d);
        piSlider.setMinimum(d2);
        piSlider.setMaximum(d3);
        piSlider.setMutable(!bl, !bl2);
        piSlider.setDigits(n);
        piSlider.setEditable(bl3);
        this.addVar(string, piSlider, d);
    }

    public void slider(String string, String string2, double d, int n) {
        PiSlider piSlider = new PiSlider(string, string2, d);
        piSlider.setDigits(n);
        this.addVar(string, piSlider, d);
    }

    public void slider(String string, String string2, double d) {
        this.slider(string, string2, d, 4);
    }

    public void slider(String string, double d, int n) {
        this.slider(string, string, d, n);
    }

    public void slider(String string, double d) {
        this.slider(string, string, d);
    }

    public void bar(String string, String string2, double d, int n) {
        if (d > 0.0) {
            this.slider(string, string2, d, 0.0, 1.5 * d, n, true, false, true);
        } else if (d < 0.0) {
            this.slider(string, string2, d, 1.5 * d, 0.0, n, false, true, true);
        } else {
            this.slider(string, string2, d, 0.0, 1.0, n, true, false, true);
        }
    }

    public void bar(String string, String string2, double d) {
        this.bar(string, string2, d, 4);
    }

    public void bar(String string, double d) {
        this.bar(string, string, d);
    }

    public void bar(String string, double d, int n) {
        this.bar(string, string, d, 4);
    }

    public void interval(String string, String string2, double d, double d2, double d3) {
        this.slider(string, string2, d, d2, d3, 4, true, true, true);
    }

    public void interval(String string, double d, double d2, double d3) {
        this.interval(string, string, d, d2, d3);
    }

    public void oslider(String string, String string2, double d, int n) {
        PiSlider piSlider = new PiSlider(string, string2, d);
        piSlider.setDigits(n);
        piSlider.setEditable(false);
        this.addVar(string, piSlider, d);
    }

    public void oslider(String string, double d, int n) {
        this.oslider(string, string, d, n);
    }

    public void oslider(String string, String string2, double d) {
        this.oslider(string, string2, d, 4);
    }

    public void oslider(String string, double d) {
        this.oslider(string, string, d);
    }

    public void obar(String string, String string2, double d, int n) {
        if (d > 0.0) {
            this.slider(string, string2, d, 0.0, 1.5 * d, n, true, false, false);
        } else if (d < 0.0) {
            this.slider(string, string2, d, 1.5 * d, 0.0, n, false, true, false);
        } else {
            this.slider(string, string2, d, 0.0, 1.0, n, true, false, false);
        }
    }

    public void obar(String string, String string2, double d) {
        this.obar(string, string2, d, 4);
    }

    public void obar(String string, double d) {
        this.obar(string, string, d);
    }

    public void obar(String string, double d, int n) {
        this.obar(string, string, d, n);
    }

    public void ointerval(String string, String string2, double d, double d2, double d3) {
        this.slider(string, string2, d, d2, d3, 4, true, true, false);
    }

    public void ointerval(String string, double d, double d2, double d3) {
        this.ointerval(string, string, d, d2, d3);
    }

    public void field(String string, String string2, double d, int n, int n2) {
        PiDoubleField piDoubleField = new PiDoubleField(string, string2, d, n, n2);
        this.addVar(string, piDoubleField, d);
    }

    public void field(String string, String string2, double d) {
        PiDoubleField piDoubleField = new PiDoubleField(string, string2, d);
        this.addVar(string, piDoubleField, d);
    }

    public void field(String string, double d) {
        this.field(string, string, d);
    }

    public void ofield(String string, String string2, double d, int n, int n2) {
        PiDoubleField piDoubleField = new PiDoubleField(string, string2, d, n, n2);
        piDoubleField.setEditable(false);
        this.addVar(string, piDoubleField, d);
    }

    public void ofield(String string, String string2, double d) {
        PiDoubleField piDoubleField = new PiDoubleField(string, string2, d);
        piDoubleField.setEditable(false);
        this.addVar(string, piDoubleField, d);
    }

    public void ofield(String string, double d) {
        this.ofield(string, string, d);
    }

    public void otext(String string, String string2, double d, int n) {
        PiDoubleText piDoubleText = new PiDoubleText(string, string2, d, n);
        piDoubleText.setFont(this.boldFont);
        this.addVar(string, piDoubleText, d);
    }

    public void otext(String string, String string2, double d) {
        this.otext(string, string2, d, 4);
    }

    public PiArrayField arrayField(String string, String string2, double[] dArray, int n) {
        PiArrayField piArrayField = new PiArrayField(string, string2, dArray, n);
        piArrayField.addActionListener(this);
        this.panel.add(piArrayField);
        return piArrayField;
    }

    public PiArrayField arrayField(String string, String string2, double[] dArray) {
        return this.arrayField(string, string2, dArray, 12);
    }

    public PiDotplot dotplot(String string, String string2, double[] dArray) {
        PiDotplot piDotplot = new PiDotplot(string, string2, dArray);
        piDotplot.addActionListener(this);
        this.panel.add(piDotplot);
        return piDotplot;
    }

    public void checkbox(String string, String string2, int n) {
        n = n == 0 ? 0 : 1;
        PiCheckbox piCheckbox = new PiCheckbox(string, string2, n);
        this.addVar(string, piCheckbox, n);
    }

    public void checkbox(String string, int n) {
        this.checkbox(string, string, n);
    }

    public void menuCheckbox(String string, String string2, int n, Menu menu) {
        n = n == 0 ? 0 : 1;
        PiMenuCheckbox piMenuCheckbox = new PiMenuCheckbox(string, string2, n);
        menu.add(piMenuCheckbox);
        piMenuCheckbox.addActionListener(this);
        this.setVar(string, n);
        this.actors.addElement(piMenuCheckbox);
    }

    public void menuCheckbox(String string, String string2, int n) {
        this.menuCheckbox(string, string2, n, this.optMenu);
    }

    public void menuCheckbox(String string, int n, Menu menu) {
        this.menuCheckbox(string, string, n, menu);
    }

    public void menuCheckbox(String string, int n) {
        this.menuCheckbox(string, string, n, this.optMenu);
    }

    public void choice(String string, String string2, String[] stringArray, int n) {
        PiChoice piChoice = new PiChoice(string, string2, stringArray, n);
        this.addVar(string, piChoice, n);
    }

    public void choice(String string, String[] stringArray, int n) {
        this.choice(string, string, stringArray, n);
    }

    public void choice(String string, String string2, double[] dArray, int n) {
        PiNumChoice piNumChoice = new PiNumChoice(string, string2, dArray, n);
        this.addVar(string, piNumChoice, dArray[n]);
    }

    public void choice(String string, double[] dArray, int n) {
        this.choice(string, string, dArray, n);
    }

    public void radio(String string, String string2, String[] stringArray, int n, int n2) {
        PiRadio piRadio = new PiRadio(string, string2, stringArray, n, n2);
        this.addVar(string, piRadio, n);
    }

    public void hradio(String string, String string2, String[] stringArray, int n) {
        this.radio(string, string2, stringArray, n, 1 + stringArray.length);
    }

    public void hradio(String string, String[] stringArray, int n) {
        this.hradio(string, string, stringArray, n);
    }

    public void vradio(String string, String string2, String[] stringArray, int n) {
        this.radio(string, string2, stringArray, n, 1);
    }

    public void vradio(String string, String[] stringArray, int n) {
        this.vradio(string, string, stringArray, n);
    }

    public void button(String string, String string2) {
        PiButton piButton = new PiButton(string, string2);
        piButton.addActionListener(this);
        this.panel.add(piButton);
    }

    public void menuItem(String string, String string2, Menu menu) {
        PiMenuItem piMenuItem = new PiMenuItem(string, string2);
        piMenuItem.addActionListener(this);
        menu.add(piMenuItem);
    }

    public void menuItem(String string, String string2) {
        this.menuItem(string, string2, this.optMenu);
    }

    public void component(String string, String string2, Component component) {
        this.addComponent(string, string2, component);
    }

    public void component(String string, Component component) {
        this.addComponent(string, string, component);
    }

    public void addPiListener(PiListener piListener) {
        this.listeners.addElement(piListener);
    }

    public void removePiListener(PiListener piListener) {
        this.listeners.removeElement(piListener);
    }

    public synchronized void notifyListeners(String string) {
        this.notifyListeners(string, null);
    }

    public synchronized void notifyListeners(String string, PiListener piListener) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            PiListener piListener2 = (PiListener)enumeration.nextElement();
            if (piListener2 != piListener) {
                piListener2.piAction(string);
            }
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public synchronized double[] saveVars() {
        double[] dArray = new double[this.actors.size()];
        int n = 0;
        while (n < this.actors.size()) {
            PiComponent piComponent = (PiComponent)this.actors.elementAt(n);
            dArray[n] = piComponent instanceof DoubleComponent ? this.getDVar(piComponent.getName()) : (double)this.getIVar(piComponent.getName());
            ++n;
        }
        return dArray;
    }

    public synchronized void restoreVars(double[] dArray) {
        int n = 0;
        while (n < this.actors.size()) {
            PiComponent piComponent = (PiComponent)this.actors.elementAt(n);
            if (piComponent instanceof DoubleComponent) {
                this.setVar(piComponent.getName(), dArray[n]);
                ((DoubleComponent)piComponent).setValue(dArray[n]);
            } else {
                this.setVar(piComponent.getName(), (int)dArray[n]);
                ((IntComponent)piComponent).setValue((int)dArray[n]);
            }
            ++n;
        }
    }

    protected double eval(String string, String string2, double d) {
        this.setVar(string2, d);
        this.callMethodFor(string2);
        return this.getDVar(string);
    }

    public void setMaster(Component component) {
        this.master = component;
    }

    public Component getMaster() {
        return this.master;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof DoubleComponent) {
            String string = ((DoubleComponent)object).getName();
            double d = ((DoubleComponent)object).getValue();
            if (Piface.feq(d, this.getDVar(string))) {
                return;
            }
            this.setVar(string, d);
            this.callMethodFor(string);
            this.updateVars();
            this.notifyListeners(string);
            return;
        }
        if (object instanceof IntComponent) {
            String string = ((IntComponent)object).getName();
            int n = ((IntComponent)object).getValue();
            if (n == this.getIVar(string)) {
                return;
            }
            this.setVar(string, n);
            this.callMethodFor(string);
            this.updateVars();
            this.notifyListeners(string);
            return;
        }
        if (object instanceof ActionComponent) {
            String string = ((ActionComponent)object).getName();
            this.actionSource = ((ActionComponent)object).getLabel();
            this.callMethod(string);
            this.updateVars();
            this.notifyListeners(string);
            return;
        }
        String string = actionEvent.getActionCommand().toString();
        if (string.equals("Graph...")) {
            new PiGraph(this);
        } else if (string.equals("Quit")) {
            this.close();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.close();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public static double sin(double d) {
        return Math.sin(d);
    }

    public static double cos(double d) {
        return Math.cos(d);
    }

    public static double tan(double d) {
        return Math.tan(d);
    }

    public static double asin(double d) {
        return Math.asin(d);
    }

    public static double acos(double d) {
        return Math.acos(d);
    }

    public static double atan(double d) {
        return Math.atan(d);
    }

    public static double atan(double d, double d2) {
        return Math.atan2(d, d2);
    }

    public static double atan2(double d, double d2) {
        return Math.atan2(d, d2);
    }

    public static double log(double d) {
        return Math.log(d);
    }

    public static double log10(double d) {
        return rlog10 * Math.log(d);
    }

    public static double exp(double d) {
        return Math.exp(d);
    }

    public static double sqrt(double d) {
        return Math.sqrt(d);
    }

    public static long round(double d) {
        return Math.round(d);
    }

    public static double round(double d, int n) {
        double d2 = Math.pow(10.0, n);
        return (double)Math.round(d * d2) / d2;
    }

    public static double pow(double d, double d2) {
        return Math.pow(d, d2);
    }

    public static int abs(int n) {
        return Math.abs(n);
    }

    public static double abs(double d) {
        return Math.abs(d);
    }

    public static double floor(double d) {
        return Math.floor(d);
    }

    public static double ceil(double d) {
        return Math.ceil(d);
    }

    public static double max(double d, double d2) {
        return Math.max(d, d2);
    }

    public static double min(double d, double d2) {
        return Math.min(d, d2);
    }

    public static int max(int n, int n2) {
        return Math.max(n, n2);
    }

    public static int min(int n, int n2) {
        return Math.min(n, n2);
    }

    public static int sign(double d) {
        return d == 0.0 ? 0 : (d < 0.0 ? -1 : 1);
    }

    public static boolean feq(double d, double d2, double d3) {
        return Piface.abs(d - d2) < d3;
    }

    public static boolean feq(double d, double d2) {
        return Piface.feq(d, d2, 1.0E-12);
    }

    public static double time() {
        return (double)System.currentTimeMillis() / 1000.0;
    }

    public static double random() {
        if (theSeed < 0.0) {
            Piface.seed();
        }
        double d = theMult * theSeed + theTerm;
        theSeed = d - Math.floor(d);
        return theSeed;
    }

    public static synchronized double nrand() {
        boolean bl = flag = !flag;
        if (flag) {
            return r * u2;
        }
        while ((r = (u1 = 2.0 * Piface.random() - 1.0) * u1 + (u2 = 2.0 * Piface.random() - 1.0) * u2) >= 1.0) {
        }
        r = Math.sqrt(-2.0 * Math.log(r) / r);
        return r * u1;
    }

    public static double seed(double d) {
        theSeed = d;
        return d;
    }

    public static double seed() {
        theSeed = (double)(System.currentTimeMillis() & 0xFFFFL) / 65536.0;
        return theSeed;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

