/*
 * Decompiled with CFR 0.152.
 */
package rvl.stat.dist;

import rvl.stat.dist.BetaAux;
import rvl.util.MoreMath;
import rvl.util.Solve;
import rvl.util.Utility;

public class Beta {
    public static double cdf(double d, double d2, double d3) {
        double d4;
        double d5;
        double d6;
        double d7;
        double d8 = 1.0E-8;
        int n = 500;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (d2 <= 0.0 || d3 <= 0.0) {
            Utility.warning("beta.cdf: parameters must be positive");
            return Double.NaN;
        }
        double d9 = d < 0.0 ? 0.0 : (d = d > 1.0 ? 1.0 : d);
        if (d == 0.0 || d == 1.0) {
            return d;
        }
        double d10 = Math.pow(d, d2) * Math.pow(1.0 - d, d3) * MoreMath.beta(d2, d3);
        if (d2 < 1.5) {
            bl2 = true;
            d10 *= d * (d2 + d3) / d2;
            d2 += 1.0;
        }
        if (d3 < 1.5) {
            bl3 = true;
            d10 *= (1.0 - d) * (d2 + d3) / d3;
            d3 += 1.0;
        }
        if (d >= (d2 - 1.0) / (d2 + d3 - 2.0)) {
            bl = true;
            d = 1.0 - d;
            d7 = d2;
            d2 = d3;
            d3 = d7;
        }
        double d11 = d6 = 1.0 / (1.0 - d * (d2 + d3) / (d2 + 1.0));
        double d12 = d6;
        int n2 = 1;
        do {
            d4 = d6;
            double d13 = d2 + (double)(2 * n2);
            double d14 = (double)n2 * (d3 - (double)n2) * d / (d13 * (d13 - 1.0));
            double d15 = -(d2 + (double)n2) * (d2 + d3 + (double)n2) * d / (d13 * (d13 + 1.0));
            d11 = d6 + d14 * d11;
            d6 = d11 + d15 * d6;
            d12 = 1.0 + d14 * d12;
            d5 = d12 + d15;
            d11 /= d5;
            d12 /= d5;
        } while (Math.abs((d6 /= d5) - d4) >= d8 * d6 && ++n2 <= n);
        if (n2 > n) {
            Utility.warning("Convergence failure in beta.cdf - error estimate = " + (d6 - d4) / d6);
        }
        d6 = d10 * d6 / d2;
        if (bl) {
            d7 = d2;
            d2 = d3;
            d3 = d7;
            d = 1.0 - d;
            d6 = 1.0 - d6;
        }
        if (bl3) {
            d10 = (d3 -= 1.0) * d10 / ((1.0 - d) * (d2 + d3));
            d6 -= d10 / d3;
        }
        if (bl2) {
            d6 += d10 / (d * ((d2 -= 1.0) + d3));
        }
        return d6;
    }

    public static double cdf(double d, double d2, double d3, double d4) {
        double d5;
        double d6 = 1.0E-8;
        int n = 500;
        if (d2 <= 0.0 || d3 <= 0.0 || d4 < 0.0) {
            Utility.warning("Beta.cdf: parameters must be positive");
            return Double.NaN;
        }
        double d7 = Beta.cdf(d, d2, d3);
        if (d4 == 0.0) {
            d5 = d7;
        } else {
            double d8 = Math.pow(d, d2) * Math.pow(1.0 - d, d3) * MoreMath.beta(d2, d3) / d2;
            double d9 = Math.exp(-(d4 /= 2.0));
            double d10 = 1.0 - d9;
            d5 = d9 * d7;
            int n2 = 0;
            do {
                d5 += d9 * (d7 -= (d8 *= d * (d2 + d3 + (double)(++n2) - 1.0) / (d2 + (double)n2)));
            } while ((d10 -= (d9 *= d4 / (double)n2)) * (d7 - d8) >= d6 && n2 <= n);
            if (n2 > n) {
                Utility.warning("Convergence failure in Beta.cdf - error estimate = " + d10 * (d7 - d8));
            }
        }
        return d5;
    }

    public static double quantile(double d, double d2, double d3) {
        return Beta.quantile(d, d2, d3, 0.0);
    }

    public static double quantile(double d, double d2, double d3, double d4) {
        if (d * (1.0 - d) == 0.0) {
            return d;
        }
        double d5 = 4.91 * (Math.pow(d, 0.14) - Math.pow(1.0 - d, 0.14));
        double d6 = d2 + d4 / 2.0;
        double d7 = d6 / (d6 + d3) + d5 * Math.sqrt(d6 * d3 / Math.pow(d6 + d3, 3.0));
        d7 = Math.min(0.99, Math.max(0.01, d7));
        BetaAux betaAux = new BetaAux(d2, d3, d4);
        return Solve.search(betaAux, d, d7, 0.01);
    }
}

