/*
 * Decompiled with CFR 0.152.
 */
package RVLS;

import RVLS.graphUtilities;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;

public class normDist
extends Canvas {
    protected double mean;
    protected double sd;
    protected double lowLimit;
    protected double firstTick;
    protected double upLimit;
    protected double lowCutoff;
    protected double upCutoff;
    protected boolean shade;
    protected boolean shadeBetween;
    protected boolean yaxis;
    protected boolean autoRepaint = true;
    public boolean autoSetLimits = true;
    public boolean setYmax = false;
    protected Color fillColor;
    protected final int BOTTOM = 55;
    protected final int HADJ = 35;
    protected final int XOFFSET = 35;
    protected double MultConst;
    protected double Ymax;
    protected double range;
    protected int w;
    protected int h;
    protected int pinc;
    protected int lastX;
    protected int lastY;
    protected int numTicks;
    protected int ndec;
    protected int hh;
    protected int ndx;
    protected Font font;
    protected String title;
    protected double sx2p;
    protected double sp2x;
    protected double sp2y;
    protected double sy2p;
    protected double step = 1.0;

    public normDist() {
        this.initialize(9, -4.0, 4.0, 0.0, 1.0, -4.0, 4.0, true, "Normal Distribution", Color.blue);
    }

    public void setMean(double d) {
        this.mean = d;
        this.paramChange();
    }

    public double getMean() {
        return this.mean;
    }

    public void setSd(double d) {
        if (d > 0.0) {
            this.sd = d;
            this.MultConst = 1.0 / (Math.sqrt(Math.PI * 2) * d);
            this.paramChange();
        }
    }

    public double getSd() {
        return this.sd;
    }

    public void setShade(boolean bl) {
        this.shade = bl;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public boolean isShade() {
        return this.shade;
    }

    public void setShadeBetween(boolean bl) {
        this.shadeBetween = bl;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public boolean isShadeBetween() {
        return this.shadeBetween;
    }

    public void setYaxis(boolean bl) {
        this.yaxis = bl;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public boolean isYaxis() {
        return this.yaxis;
    }

    public void setTitle(String string) {
        this.title = string;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setUpLimit(double d) {
        this.upLimit = d;
        this.range = d - this.lowLimit;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public double getUpLimit() {
        return this.upLimit;
    }

    public void setLowLimit(double d) {
        this.lowLimit = d;
        this.range = this.upLimit - d;
        this.firstTick = d;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public double getLowLimit() {
        return this.lowLimit;
    }

    public void setUpCutoff(double d) {
        this.upCutoff = d;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public double getUpCutoff() {
        return this.upCutoff;
    }

    public void setLowCutoff(double d) {
        this.lowCutoff = d;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public double getLowCutoff() {
        return this.lowCutoff;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setLimits(double d, double d2, int n) {
        this.lowLimit = d;
        this.upLimit = d2;
        this.range = d2 - d;
        this.numTicks = n;
        this.firstTick = d;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void setShadedArea(double d, double d2) {
        this.lowCutoff = d;
        this.upCutoff = d2;
        this.shade = true;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void setAutoRepaint(boolean bl) {
        this.autoRepaint = bl;
    }

    public boolean isAutoRepaint() {
        return this.autoRepaint;
    }

    public void initialize(int n, double d, double d2, double d3, double d4, double d5, double d6, boolean bl, String string, Color color) {
        this.ndx = 0;
        this.yaxis = false;
        this.shade = false;
        this.title = string;
        this.fillColor = color;
        this.ndec = 0;
        this.numTicks = n - 1;
        this.pinc = 1;
        this.sd = d4;
        this.mean = d3;
        this.firstTick = this.lowLimit = d;
        this.upLimit = d2;
        this.lowCutoff = d5;
        this.upCutoff = d6;
        this.shadeBetween = bl;
        this.range = this.upLimit - this.lowLimit;
        this.w -= 70;
        this.Ymax = this.MultConst = 1.0 / (Math.sqrt(Math.PI * 2) * this.sd);
        this.font = new Font("TimesRoman", 0, 10);
    }

    public void paint(Graphics graphics) {
        int n;
        String string;
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(graphics.getColor());
        int n2 = 0;
        this.w = this.getSize().width - 70;
        this.h = this.getSize().height - 55;
        this.hh = this.h + 35;
        if (!this.setYmax) {
            this.Ymax = this.MultConst;
        }
        this.sp2x = this.range / (double)this.w;
        this.sx2p = 1.0 / this.sp2x;
        this.sp2y = this.Ymax / (double)this.h;
        this.sy2p = 1.0 / this.sp2y;
        graphics.setColor(Color.black);
        graphics.setFont(this.font);
        graphics.drawLine(35, this.hh, 35 + this.w, this.hh);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
        int n3 = fontMetrics.getAscent();
        if (this.autoSetLimits) {
            this.step = (this.upLimit - this.lowLimit) / (double)this.numTicks;
        }
        double d = this.firstTick - this.step;
        int n4 = (this.w - fontMetrics.stringWidth(this.title)) / 2;
        graphics.drawString(this.title, 35 + n4, n3 + 5);
        if (this.yaxis) {
            double[] dArray = new double[3];
            dArray = graphUtilities.intlabels(0.0, this.Ymax, 5);
            double d2 = 0.0;
            while (d2 <= this.Ymax + dArray[0]) {
                int n5 = (int)Math.round((double)this.hh - this.sy2p * d2);
                if (n5 <= 5) break;
                n2 = n5;
                n2 = (int)Math.round((double)this.hh - this.sy2p * d2);
                graphics.drawLine(29, n2, 32, n2);
                string = graphUtilities.format(d2, 2);
                n = 35 - fontMetrics.stringWidth(string) - 8;
                graphics.drawString(string, n, n2 + n3 / 2);
                d2 += dArray[0];
            }
            graphics.drawLine(33, n2, 33, this.hh);
        }
        if (this.autoSetLimits) {
            if (this.step >= 1.0) {
                this.ndx = 0;
            }
            if (this.step < 1.0) {
                this.ndx = 1;
            }
            if (Math.floor(this.sd) != this.sd) {
                this.ndx = 1;
            }
            if (this.step < 0.05) {
                this.ndx = 2;
            }
        }
        double d3 = this.sx2p * (this.firstTick - this.lowLimit);
        string = graphUtilities.format(this.upLimit, this.ndx);
        float f = fontMetrics.stringWidth(string);
        double d4 = this.step * this.sx2p;
        int n6 = (int)Math.ceil((double)f / (d4 - 2.0));
        int n7 = 0;
        while (n7 <= this.numTicks) {
            d += this.step;
            if (n7 % n6 == 0) {
                n = (int)Math.rint(35.0 + this.sx2p * (double)n7 * this.step + d3);
                string = graphUtilities.format(d, this.ndx);
                graphics.drawLine(n, this.hh, n, this.hh + 4);
                f = fontMetrics.stringWidth(string);
                n4 = (int)Math.rint(f / 2.0f);
                graphics.drawString(string, n - n4, this.hh + n3 + 6);
            }
            ++n7;
        }
        this.drawDist(graphics);
    }

    public void update(Graphics graphics) {
        Dimension dimension = this.getSize();
        Image image = this.createImage(dimension.width, dimension.height);
        Graphics graphics2 = image.getGraphics();
        graphics2.setColor(this.getBackground());
        graphics2.fillRect(0, 0, dimension.width, dimension.height);
        graphics2.setColor(graphics.getColor());
        this.paint(graphics2);
        graphics.drawImage(image, 0, 0, this);
    }

    public void paramChange() {
        if (this.autoSetLimits) {
            this.firstTick = this.lowLimit = this.mean - 4.0 * this.sd;
            this.upLimit = this.mean + 4.0 * this.sd;
            this.range = this.upLimit - this.lowLimit;
        }
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void drawDist(Graphics graphics) {
        int n = this.hh - 1;
        double d = this.getDensity(this.lowLimit);
        this.lastY = (int)Math.round((double)this.hh - this.sy2p * d);
        this.lastX = 0;
        int n2 = this.pinc;
        while (n2 < this.w) {
            double d2 = this.sp2x * (double)n2 + this.lowLimit;
            d = this.getDensity(d2);
            int n3 = (int)Math.round((double)this.hh - this.sy2p * d);
            graphics.setColor(Color.black);
            graphics.drawLine(35 + this.lastX, this.lastY, 35 + n2, n3);
            this.lastX = n2;
            this.lastY = n3;
            if (this.shade) {
                if (this.shadeBetween) {
                    if (d2 >= this.lowCutoff && d2 <= this.upCutoff) {
                        graphics.setColor(this.fillColor);
                        graphics.drawLine(35 + this.lastX, n, 35 + this.lastX, n3);
                    }
                } else if (d2 <= this.lowCutoff || d2 >= this.upCutoff) {
                    graphics.setColor(this.fillColor);
                    graphics.drawLine(35 + this.lastX, n, 35 + this.lastX, n3);
                }
            }
            n2 += this.pinc;
        }
    }

    public double getDensity(double d) {
        double d2 = (d - this.mean) / this.sd;
        return this.MultConst * Math.exp(-d2 * d2 / 2.0);
    }

    public void setYmax(double d) {
        this.Ymax = d;
        this.setYmax = true;
    }

    public double getYmax() {
        return this.MultConst;
    }
}

