/*
 * Decompiled with CFR 0.152.
 */
package robustt;

import RVLS.message;
import robustt.chisquare;

public class chisquareAdjust
extends chisquare {
    protected double mean;
    protected double sd;
    protected double k;
    protected double u;

    public chisquareAdjust() {
        this.mean = this.df;
        this.sd = Math.sqrt(2 * this.df);
        this.k = 1.0;
        this.u = 0.0;
        this.setTitle(String.valueOf(String.valueOf(new StringBuffer("Chi-square adjusted, df=").append(this.df).append(", mean=").append(this.mean).append(", sd=").append(this.sd))));
    }

    public void setSkewDegree(int degree) {
        if (degree == 1) {
            this.setDf(4);
        } else if (degree == 2) {
            this.setDf(6);
        } else if (degree == 3) {
            this.setDf(10);
        } else {
            message m = new message("\r\r\rSkew degree=1: very skew;\rSkew degree=1: moderate skew;Skew degree=3: slight skew.");
            m.show();
        }
    }

    public void setMeanSd(double mean, double sd) {
        if (Math.abs(sd - 0.0) < 0.001) {
            message m = new message("\r\r\rStandard Error should not be 0");
            m.show();
            return;
        }
        this.k = sd / Math.sqrt(2.0 * (double)this.df);
        this.u = mean - sd * Math.sqrt((double)this.df / 2.0);
        this.paramChange();
    }

    public void paramChange() {
        if (this.autoSetLimits) {
            this.firstTick = this.lowLimit = this.u;
            this.upLimit = (double)this.df + (double)4 * Math.sqrt(2.0 * (double)this.df);
            this.upLimit = this.k * this.upLimit + this.u;
            this.range = this.upLimit - this.lowLimit;
        }
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public double getDensity(double x) {
        int vv = 1;
        int v = 1;
        x = (x - this.u) / this.k;
        for (int i = 1; i < this.df / 2 - 1; ++i) {
            vv *= v + 1;
            ++v;
        }
        double y = x > 0.0 ? Math.pow(x, this.df / 2 - 1) * Math.exp(-x / 2.0) / (Math.pow(2.0, this.df / 2) * (double)vv * this.k) : 0.0;
        return y;
    }

    public double getYmax() {
        int vv = 1;
        int v = 1;
        double ymax = 0.0;
        for (int i = 1; i < this.df / 2 - 1; ++i) {
            vv *= v + 1;
            ++v;
        }
        for (double x = (this.lowLimit - this.u) / this.k; x < (this.upLimit - this.u) / this.k; x += 1.0) {
            if (!(x > 0.0)) continue;
            double y = Math.pow(x, this.df / 2 - 1) * Math.exp(-x / 2.0) / (Math.pow(2.0, this.df / 2) * (double)vv * this.k);
            ymax = Math.max(ymax, y);
        }
        return ymax;
    }
}

