/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.Vector;
import symantec.itools.awt.AlignStyle;
import symantec.itools.awt.BevelStyle;
import symantec.itools.awt.util.ColorUtils;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.util.GeneralUtils;

public class BorderPanel
extends Panel
implements AlignStyle,
BevelStyle,
ContainerListener {
    Dimension oldSize = new Dimension();
    protected static final int labelpadx = 10;
    protected static final int labelipadx = 4;
    protected Color cachedBackground;
    protected Color borderColor;
    protected Color bevelLighterColor;
    protected Color bevelDarkerColor;
    protected Color labelColor;
    protected int padtop = 10;
    protected int padbottom = 6;
    protected int padleft = 6;
    protected int padright = 6;
    protected int ixPad = 4;
    protected int iyPadTop = 2;
    protected int iyPadBottom = 7;
    protected int style;
    protected String label;
    protected int labelAlignment;
    protected Insets internalInsets;
    protected Panel panel;
    private Vector cListeners;
    private Veto veto;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public BorderPanel() {
        this(null, 1, 2);
    }

    public BorderPanel(int style) {
        this(null, 1, style);
    }

    public BorderPanel(String s) {
        this(s, 1, 2);
    }

    public BorderPanel(String s, int alignment) {
        this(s, alignment, 2);
    }

    public BorderPanel(String s, int alignment, int style) {
        this.borderColor = Color.black;
        this.labelColor = Color.black;
        this.cachedBackground = this.getBackground();
        this.label = s != null && s.length() == 0 ? null : s;
        this.labelAlignment = alignment;
        this.internalInsets = new Insets(10, 10, 10, 10);
        this.style = style;
        super.setLayout(null);
        this.panel = new Panel();
        super.add(this.panel);
        if (this.panel != null) {
            this.panel.setLayout(null);
        }
        this.sizepanel(true);
        this.cListeners = new Vector();
    }

    public void setPaddingTop(int newPadTop) throws PropertyVetoException {
        if (this.padtop != newPadTop) {
            Integer oldPadTopInt = new Integer(this.padtop);
            Integer newPadTopInt = new Integer(newPadTop);
            this.vetos.fireVetoableChange("paddingTop", oldPadTopInt, newPadTopInt);
            this.padtop = newPadTop;
            this.sizepanel(true);
            this.invalidate();
            this.repaint();
            this.changes.firePropertyChange("paddingTop", oldPadTopInt, newPadTopInt);
        }
    }

    public int getPaddingTop() {
        return this.padtop;
    }

    public void setPaddingBottom(int newPadBottom) throws PropertyVetoException {
        if (this.padbottom != newPadBottom) {
            Integer oldPadBottomInt = new Integer(this.padbottom);
            Integer newPadBottomInt = new Integer(newPadBottom);
            this.vetos.fireVetoableChange("paddingBottom", oldPadBottomInt, newPadBottomInt);
            this.padbottom = newPadBottom;
            this.sizepanel(true);
            this.invalidate();
            this.repaint();
            this.changes.firePropertyChange("paddingBottom", oldPadBottomInt, newPadBottomInt);
        }
    }

    public int getPaddingBottom() {
        return this.padbottom;
    }

    public void setPaddingLeft(int newPadLeft) throws PropertyVetoException {
        if (this.padleft != newPadLeft) {
            Integer oldPadLeftInt = new Integer(this.padleft);
            Integer newPadLeftInt = new Integer(newPadLeft);
            this.vetos.fireVetoableChange("paddingLeft", oldPadLeftInt, newPadLeftInt);
            this.padleft = newPadLeft;
            this.sizepanel(true);
            this.invalidate();
            this.repaint();
            this.changes.firePropertyChange("paddingLeft", oldPadLeftInt, newPadLeftInt);
        }
    }

    public int getPaddingLeft() {
        return this.padleft;
    }

    public void setPaddingRight(int newPadRight) throws PropertyVetoException {
        if (this.padright != newPadRight) {
            Integer oldPadRightInt = new Integer(this.padright);
            Integer newPadRightInt = new Integer(newPadRight);
            this.vetos.fireVetoableChange("paddingRight", oldPadRightInt, newPadRightInt);
            this.padright = newPadRight;
            this.sizepanel(true);
            this.invalidate();
            this.repaint();
            this.changes.firePropertyChange("paddingRight", oldPadRightInt, newPadRightInt);
        }
    }

    public int getPaddingRight() {
        return this.padright;
    }

    public void setIPadTop(int t) throws PropertyVetoException {
        if (this.iyPadTop != t) {
            Integer oldPadTopInt = new Integer(this.iyPadTop);
            Integer newPadTopInt = new Integer(t);
            this.vetos.fireVetoableChange("iPadTop", oldPadTopInt, newPadTopInt);
            this.iyPadTop = t;
            this.changes.firePropertyChange("iPadTop", oldPadTopInt, newPadTopInt);
            this.sizepanel(true);
            this.invalidate();
        }
    }

    public int getIPadTop() {
        return this.iyPadTop;
    }

    public void setIPadBottom(int b) throws PropertyVetoException {
        if (this.iyPadBottom != b) {
            Integer oldPadBottomInt = new Integer(this.iyPadBottom);
            Integer newPadBottomInt = new Integer(b);
            this.vetos.fireVetoableChange("iPadBottom", oldPadBottomInt, newPadBottomInt);
            this.iyPadBottom = b;
            this.changes.firePropertyChange("iPadBottom", oldPadBottomInt, newPadBottomInt);
            this.sizepanel(true);
            this.invalidate();
        }
    }

    public int getIPadBottom() {
        return this.iyPadBottom;
    }

    public void setIPadSides(int s) throws PropertyVetoException {
        if (this.ixPad != s) {
            Integer oldIPadSidesInt = new Integer(this.ixPad);
            Integer newIPadSidesInt = new Integer(s);
            this.vetos.fireVetoableChange("iPadSides", oldIPadSidesInt, newIPadSidesInt);
            this.ixPad = s;
            this.changes.firePropertyChange("iPadSides", oldIPadSidesInt, newIPadSidesInt);
            this.sizepanel(true);
            this.invalidate();
        }
    }

    public int getIPadSides() {
        return this.ixPad;
    }

    public void setLabel(String newLabel) throws PropertyVetoException {
        if (newLabel != null && newLabel.length() == 0) {
            newLabel = null;
        }
        if (!GeneralUtils.objectsEqual(this.label, newLabel)) {
            String oldLabel = this.label;
            this.vetos.fireVetoableChange("label", oldLabel, newLabel);
            this.label = newLabel;
            this.changes.firePropertyChange("label", oldLabel, newLabel);
            this.sizepanel(true);
            this.repaint();
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setBorderColor(Color newBorderColor) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.borderColor, newBorderColor)) {
            Color oldBorderColor = this.borderColor;
            this.vetos.fireVetoableChange("borderColor", oldBorderColor, newBorderColor);
            this.borderColor = newBorderColor;
            this.changes.firePropertyChange("borderColor", oldBorderColor, newBorderColor);
            this.repaint();
        }
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setLabelColor(Color newLabelBorderColor) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.labelColor, newLabelBorderColor)) {
            Color oldLabelColor = this.labelColor;
            this.vetos.fireVetoableChange("labelColor", oldLabelColor, newLabelBorderColor);
            this.labelColor = newLabelBorderColor;
            this.changes.firePropertyChange("labelColor", oldLabelColor, newLabelBorderColor);
            this.repaint();
        }
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setAlignStyle(int newLabelAlignment) throws PropertyVetoException {
        if (this.labelAlignment != newLabelAlignment) {
            Integer oldLabelAlignmentInteger = new Integer(this.labelAlignment);
            Integer newLabelAlignmentInteger = new Integer(newLabelAlignment);
            this.vetos.fireVetoableChange("alignStyle", oldLabelAlignmentInteger, newLabelAlignmentInteger);
            this.labelAlignment = newLabelAlignment;
            this.changes.firePropertyChange("alignStyle", oldLabelAlignmentInteger, newLabelAlignmentInteger);
            this.sizepanel(true);
            this.repaint();
        }
    }

    public int getAlignStyle() {
        return this.labelAlignment;
    }

    public void setBevelStyle(int newBevelStyle) throws PropertyVetoException {
        if (this.style != newBevelStyle) {
            Integer oldBevelStyleInteger = new Integer(this.style);
            Integer newBevelStyleInteger = new Integer(newBevelStyle);
            this.vetos.fireVetoableChange("bevelStyle", oldBevelStyleInteger, newBevelStyleInteger);
            this.style = newBevelStyle;
            this.changes.firePropertyChange("bevelStyle", oldBevelStyleInteger, newBevelStyleInteger);
            this.repaint();
        }
    }

    public int getBevelStyle() {
        return this.style;
    }

    public void setInternalInsets(Insets newInsets) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.internalInsets, newInsets)) {
            Insets oldInsets = this.internalInsets;
            this.vetos.fireVetoableChange("internalInsets", oldInsets, newInsets);
            this.internalInsets = newInsets;
            this.changes.firePropertyChange("internalInsets", oldInsets, newInsets);
            this.sizepanel(true);
            this.invalidate();
        }
    }

    public Insets getInternalInsets() {
        return this.internalInsets;
    }

    public void setPadding(int t, int b, int l, int r) throws PropertyVetoException {
        this.setPaddingTop(t);
        this.setPaddingBottom(b);
        this.setPaddingLeft(l);
        this.setPaddingRight(r);
    }

    public void setBorderColor(Color clr, boolean useForLabel) throws PropertyVetoException {
        this.setBorderColor(clr);
        if (useForLabel) {
            this.setLabelColor(clr);
        }
    }

    public Dimension getPreferredSize() {
        Dimension p = this.size();
        Dimension m = this.getMinimumSize();
        return new Dimension(Math.max(p.width, m.width), Math.max(p.height, m.height));
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension(20, 40);
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public void setLayout(LayoutManager l) {
        if (this.panel != null) {
            this.panel.setLayout(l);
        }
    }

    public LayoutManager getLayout() {
        return this.panel.getLayout();
    }

    public Component getComponent(int i) {
        return this.panel.getComponent(i);
    }

    public Component[] getComponents() {
        return this.panel.getComponents();
    }

    public int getComponentCount() {
        return this.panel.getComponentCount();
    }

    public boolean isValidBevelStyle(int bevelStyle) {
        switch (bevelStyle) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public synchronized void addNotify() {
        super.addNotify();
        this.sizepanel(true);
        if (this.veto == null) {
            this.veto = new Veto();
            this.addBevelStyleListener(this.veto);
        }
        if (this.panel != null) {
            this.panel.addContainerListener(this);
        }
    }

    public synchronized void removeNotify() {
        if (this.veto != null) {
            this.removeBevelStyleListener(this.veto);
            this.veto = null;
        }
        if (this.panel != null) {
            this.panel.removeContainerListener(this);
        }
        super.removeNotify();
    }

    public void layout() {
        this.sizepanel(false);
        this.panel.layout();
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (comp == this.panel) {
            super.addImpl(comp, constraints, index);
        } else {
            this.panel.add(comp, constraints, index);
        }
    }

    public void remove(int index) {
        this.panel.remove(index);
    }

    public void remove(Component comp) {
        this.panel.remove(comp);
    }

    public void removeAll() {
        this.panel.removeAll();
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.sizepanel(false);
    }

    public void reshape(int x, int y, int width, int height) {
        super.reshape(x, y, width, height);
        this.sizepanel(false);
    }

    public void update(Graphics g) {
        Dimension s = this.size();
        Insets insets = this.insets();
        g.setColor(this.getBackground());
        if (insets.left > 0) {
            g.fillRect(0, 0, insets.left, s.height);
        }
        if (insets.top > 0) {
            g.fillRect(0, 0, s.width, insets.top);
        }
        if (insets.bottom > 0) {
            g.fillRect(0, s.height - insets.bottom, s.width, insets.bottom);
        }
        if (insets.right > 0) {
            g.fillRect(s.width - insets.right, 0, insets.right, s.height);
        }
        this.paint(g);
        this.panel.repaint();
    }

    public int countComponents() {
        return this.panel.countComponents();
    }

    public Insets insets() {
        int h = this.getLabelTopMargin();
        Insets insets = this.getInternalInsets();
        return new Insets(h + insets.top, insets.left, insets.bottom, insets.right);
    }

    public void paint(Graphics g) {
        this.sizepanel(false);
        Color curBackground = this.getBackground();
        if (!GeneralUtils.objectsEqual(curBackground, this.cachedBackground)) {
            this.cachedBackground = curBackground;
            this.calculateHilightColors(curBackground);
        }
        g.setColor(curBackground);
        this.draw(g);
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        this.panel.setBackground(c);
    }

    public void componentAdded(ContainerEvent e) {
        if (e.getSource() == this.panel) {
            int i = 0;
            while (i < this.cListeners.size()) {
                ((ContainerListener)this.cListeners.elementAt(i)).componentAdded(new ContainerEvent(this, 300, e.getChild()));
                ++i;
            }
        }
    }

    public void componentRemoved(ContainerEvent e) {
        if (e.getSource() == this.panel) {
            int i = 0;
            while (i < this.cListeners.size()) {
                ((ContainerListener)this.cListeners.elementAt(i)).componentRemoved(new ContainerEvent(this, 301, e.getChild()));
                ++i;
            }
        }
    }

    public void addContainerListener(ContainerListener l) {
        if (this.panel != null) {
            this.panel.addContainerListener(l);
            this.cListeners.addElement(l);
        }
    }

    public void removeContainerListener(ContainerListener l) {
        if (this.panel != null) {
            this.panel.removeContainerListener(l);
            this.cListeners.removeElement(l);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener(listener);
    }

    public void addBevelStyleListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener("bevelStyle", listener);
    }

    public void removeBevelStyleListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener("bevelStyle", listener);
    }

    public void addBevelStyleListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener("bevelStyle", listener);
    }

    public void removeBevelStyleListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener("bevelStyle", listener);
    }

    protected void sizepanel(boolean force) {
        Dimension s = this.size();
        if (force || this.oldSize.width != s.width || this.oldSize.height != s.height) {
            this.oldSize = s;
            this.panel.setBounds(this.padleft + this.ixPad, this.getLabelTopMargin() + this.iyPadTop, s.width - this.padright - this.padleft - this.ixPad * 2 - 1, s.height - this.padbottom - this.getLabelTopMargin() - this.iyPadBottom - this.iyPadTop - 1);
        }
    }

    protected void draw(Graphics g) {
        Dimension s = this.size();
        int delta = this.padtop;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        g.clipRect(0, 0, s.width, s.height);
        g.fillRect(0, 0, s.width, s.height);
        if (this.label != null && fm != null) {
            delta = (fm.getAscent() + fm.getDescent() + this.padtop) / 2;
        }
        int x = this.padleft;
        int y = delta;
        int w = s.width - this.padleft - this.padright - 1;
        int h = s.height - 1 - delta - this.padbottom;
        this.drawBorder(g, x, y, w, h);
        this.drawLabel(g, fm);
    }

    protected void drawBorder(Graphics g, int x, int y, int w, int h) {
        switch (this.style) {
            case 1: {
                g.setColor(this.bevelLighterColor);
                g.drawLine(x, y, x + w, y);
                g.drawLine(x, y, x, y + h);
                g.setColor(this.bevelDarkerColor);
                g.drawLine(x, y + h, x + w, y + h);
                g.drawLine(x + w, y, x + w, y + h);
                break;
            }
            case 0: {
                g.setColor(this.bevelDarkerColor);
                g.drawLine(x, y, x + w, y);
                g.drawLine(x, y, x, y + h);
                g.setColor(this.bevelLighterColor);
                g.drawLine(x, y + h, x + w, y + h);
                g.drawLine(x + w, y, x + w, y + h);
                break;
            }
            case 2: {
                g.setColor(this.borderColor);
                g.drawRect(x, y, w, h);
                break;
            }
            default: {
                g.setColor(this.borderColor);
                g.drawRect(x, y, w, h);
            }
            case 3: 
        }
    }

    protected void drawLabel(Graphics g, FontMetrics fm) {
        if (this.label != null && fm != null) {
            int x;
            int fWidth = 10;
            Dimension s = this.size();
            if (this.getFont().getSize() > fWidth) {
                fWidth += this.getFont().getSize() / 2;
            }
            int stringWidth = fm.stringWidth(this.label);
            int ascent = fm.getAscent();
            int descent = fm.getDescent();
            switch (this.labelAlignment) {
                case 1: {
                    x = (s.width - stringWidth) / 2;
                    break;
                }
                case 2: {
                    x = s.width - fWidth - (stringWidth + 7);
                    break;
                }
                default: {
                    x = fWidth + 7;
                }
            }
            int h = ascent + descent + this.padtop;
            int y = (fWidth - h) / 2 + (this.padtop + ascent);
            g.setColor(this.getBackground());
            g.fillRect(x - 2, y - 1 - ascent - this.padtop / 2, stringWidth + 4, h);
            g.setColor(this.labelColor);
            g.drawString(this.label, x, y - 1);
        }
    }

    protected int getLabelTopMargin() {
        if (this.label == null) {
            return this.padtop;
        }
        int top = this.padtop;
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fm = this.getFontMetrics(font);
            top = fm.getAscent() + fm.getDescent() + this.padtop;
        }
        return top;
    }

    protected int getLabelWidthMargin() {
        if (this.label == null) {
            return 0;
        }
        int w = 2 + this.internalInsets.left + this.internalInsets.right;
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fm = this.getFontMetrics(font);
            w = Math.max(w, 2 + fm.stringWidth(this.label) + 10 + 4);
        }
        return w;
    }

    protected void calculateHilightColors(Color c) {
        this.bevelLighterColor = ColorUtils.calculateHilightColor(c);
        this.bevelDarkerColor = ColorUtils.calculateShadowColor(c);
    }

    class Veto
    implements VetoableChangeListener,
    Serializable {
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            int i = (Integer)e.getNewValue();
            if (!BorderPanel.this.isValidBevelStyle(i)) {
                throw new PropertyVetoException("Invalid BevelStyle: " + i, e);
            }
        }

        Veto() {
            BorderPanel.this = BorderPanel.this;
        }
    }
}

