/*
 * Decompiled with CFR 0.152.
 */
package sampdistv2;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import sampdistv2.Utility;
import sampdistv2.histogram;
import sampdistv2.sampDist;

public class population
extends histogram {
    sampDist theApp;
    final int[] normalData = new int[]{2, 3, 3, 6, 8, 14, 19, 32, 45, 60, 78, 97, 116, 133, 147, 156, 160, 156, 147, 133, 116, 97, 78, 60, 45, 32, 19, 14, 8, 6, 3, 3, 2};
    final int[] uniformData = new int[]{160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160};
    final int[] skewedData = new int[]{118, 130, 142, 150, 156, 160, 153, 146, 139, 132, 125, 118, 111, 104, 97, 90, 83, 76, 69, 62, 55, 48, 41, 34, 27, 20, 15, 11, 9, 6, 3, 3, 2};
    final int[] customData = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    int[] data = new int[33];
    Utility utility1 = new Utility();
    double mean;
    double median;
    double range;
    double sd;
    double variance;
    double kurtosis;

    public population() {
        this.labelY = false;
        this.setMaxBinHeight(160);
        this.setData(3);
    }

    public void setApp(sampDist _theApp) {
        this.theApp = _theApp;
    }

    public int[] getSampleData(int size) {
        int i;
        int[] sampleData = new int[25];
        int[] accumuData = new int[33];
        int sum = 0;
        for (i = 0; i < 33; ++i) {
            accumuData[i] = sum += this.data[i];
        }
        block1: for (i = 0; i < size; ++i) {
            int n = (int)(Math.random() * (double)(sum + 1));
            if (n <= accumuData[0]) {
                sampleData[i] = 0;
                continue;
            }
            if (n > accumuData[31]) {
                sampleData[i] = 32;
                continue;
            }
            int lo = 0;
            int hi = 32;
            while (lo <= hi) {
                int mid = (lo + hi) / 2;
                if (n > accumuData[mid]) {
                    if (n < accumuData[mid + 1]) {
                        sampleData[i] = mid + 1;
                        continue block1;
                    }
                    lo = mid;
                    continue;
                }
                if (n > accumuData[mid - 1]) {
                    sampleData[i] = mid;
                    continue block1;
                }
                hi = mid;
            }
        }
        return sampleData;
    }

    public void setData(int id) {
        switch (id) {
            case 0: {
                this.dataAvailable = true;
                this.setCurrentData(this.uniformData);
                super.setIfDemo(false);
                break;
            }
            case 1: {
                this.dataAvailable = true;
                this.setCurrentData(this.normalData);
                super.setIfDemo(false);
            }
        }
        if (this.dataAvailable) {
            this.utility1.setFrequency(this.data);
            this.mean = this.utility1.get_Mean();
            this.median = this.utility1.get_Median();
            this.range = this.utility1.get_Range();
            this.sd = this.utility1.get_SD();
            this.variance = this.utility1.get_Variance();
            this.setStats(this.mean, this.sd);
            super.setData(this.data);
        }
    }

    void setCurrentData(int[] d) {
        for (int i = 0; i < 33; ++i) {
            this.data[i] = d[i];
        }
    }

    void updateData() {
        int sum = 0;
        for (int i = 0; i < 33; ++i) {
            sum += this.data[i];
        }
        if (sum > 0) {
            this.dataAvailable = true;
            this.utility1.setFrequency(this.data);
            this.mean = this.utility1.get_Mean();
            this.sd = this.utility1.get_SD();
            this.kurtosis = this.utility1.get_Kurtosis();
            this.setStats(this.mean, this.sd);
            super.setData(this.data);
        } else {
            this.dataAvailable = false;
        }
    }

    public void paint(Graphics g) {
        Image offscreenImg = this.createImage(this.getSize().width, this.getSize().height);
        Graphics offscreenG = offscreenImg.getGraphics();
        super.paint(offscreenG);
        if (this.dataAvailable) {
            int y = 40;
            offscreenG.setFont(new Font("Times", 0, 11));
            FontMetrics fm = offscreenG.getFontMetrics();
            offscreenG.setColor(Color.blue);
            offscreenG.drawString("mean=", 10, y);
            String s = Utility.format(this.mean, 2);
            int x = 85 - fm.stringWidth(s);
            offscreenG.drawString(s, x, y);
            offscreenG.setColor(Color.magenta);
            offscreenG.drawString("median=", 10, y += 16);
            s = Utility.format(this.median, 2);
            x = 85 - fm.stringWidth(s);
            offscreenG.drawString(s, x, y);
            offscreenG.setColor(Color.red);
            offscreenG.drawString("sd=", 10, y += 16);
            s = Utility.format(this.sd, 2);
            x = 85 - fm.stringWidth(s);
            offscreenG.drawString(s, x, y);
        }
        g.drawImage(offscreenImg, 0, 0, this);
        offscreenG.dispose();
    }

    public void update(Graphics g) {
        this.paint(g);
    }
}

