/*
 * Decompiled with CFR 0.152.
 */
package sampdistv2;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import sampdistv2.Ball;
import sampdistv2.Notify;
import sampdistv2.histogram;
import sampdistv2.sampDist;

public class sample
extends histogram
implements Notify {
    sampDist theApp;
    int proc_id = 0;
    int[] data = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    int[] sampleData = new int[25];
    int size;
    String stat = "";
    String stat_value = "";
    boolean ifShowStats = true;
    Ball b;
    int id = 0;

    public sample() {
        this.diagramX = false;
    }

    public void setApp(sampDist _theApp) {
        this.theApp = _theApp;
    }

    public void reset() {
        if (this.b != null && this.b.isAlive()) {
            this.b.stop();
        }
        this.maxBinHeight = 5;
        this.id = 0;
        for (int i = 0; i < 33; ++i) {
            this.data[i] = 0;
        }
        this.dataAvailable = false;
        this.repaint();
    }

    public void setProcId(int _id) {
        this.proc_id = _id;
    }

    public void setSampleStat(String _stat, String _value) {
        this.stat = _stat;
        this.stat_value = _value;
        this.ifShowStats = _stat.compareTo("variance") != 0;
    }

    public void setSampleData(int _size, int[] d) {
        int i;
        this.size = _size;
        for (i = 0; i < this.size; ++i) {
            this.sampleData[i] = d[i];
            int n = d[i];
            this.data[n] = this.data[n] + 1;
        }
        super.setData(this.data);
        int max = 0;
        for (i = 0; i < 33; ++i) {
            if (this.data[i] <= max) continue;
            max = this.data[i];
        }
        if (max > this.maxBinHeight) {
            this.maxBinHeight *= (int)Math.ceil((double)max / (double)this.maxBinHeight);
            this.repaint();
        }
    }

    public void runAnimation() {
        this.startNewBall();
    }

    public void startNewBall() {
        if (this.id < this.size) {
            this.b = new Ball(this, this.id);
            this.b.setSample(this);
            this.b.start();
            ++this.id;
        } else {
            this.dataAvailable = true;
            this.repaint();
            this.theApp.animComplete(this.proc_id);
        }
    }

    public void paint(Graphics g) {
        Image offscreenImg = this.createImage(this.getSize().width, this.getSize().height);
        Graphics offscreenG = offscreenImg.getGraphics();
        super.paint(offscreenG);
        if (this.dataAvailable) {
            int y = 60;
            offscreenG.setFont(new Font("Times", 0, 11));
            FontMetrics fm = offscreenG.getFontMetrics();
            offscreenG.setColor(Color.black);
            offscreenG.drawString("sample size=", 10, y);
            String s = Integer.toString(this.size);
            int x = 85 - fm.stringWidth(s);
            offscreenG.drawString(s, x, y);
            offscreenG.setColor(Color.blue);
            offscreenG.drawString(String.valueOf(String.valueOf(this.stat)).concat("="), 10, y += 16);
            x = 85 - fm.stringWidth(this.stat_value);
            offscreenG.drawString(this.stat_value, x, y);
            if (this.ifShowStats) {
                x = 130 + (int)((Double.valueOf(this.stat_value) + 0.5) * (double)10);
                y = 110;
                offscreenG.drawLine(x, y, x, y + 8);
            }
        }
        g.drawImage(offscreenImg, 0, 0, this);
        offscreenG.dispose();
    }

    public void update(Graphics g) {
        this.paint(g);
    }
}

