/*
 * Decompiled with CFR 0.152.
 */
package VisualNumerics.math;

public class Sfun {
    public static final double EPSILON_SMALL = 1.11022302462515E-16;
    public static final double EPSILON_LARGE = 2.2204460492503E-16;
    public static final double Euler = 0.5772156649015329;
    static final double aln2 = 0.6931471805599453;
    private static final double log10_loge = 0.4342944819032518;
    private static final double cot_pi2rec = 0.011619772367581343;
    private static final double cot_xmax = 4.503599627370523E15;
    private static final double cot_xsml = Math.sqrt(3.33066907387545E-16);
    private static final double cot_sqeps = Math.sqrt(2.2204460492503E-16);
    private static final double[] cot_coef = new double[]{0.2402591609829563, -0.016533031601500228, -4.299839193172402E-5, -1.5928322332754105E-7, -6.191093135129349E-10, -2.430197415072646E-12, -9.56093675880008E-15, -3.763537981945806E-17, -1.4816657464674657E-19};
    private static final double sinh_ymax = 1.0 / Math.sqrt(1.11022302462515E-16);
    private static final double sinh_sqeps = Math.sqrt(6.6613381477509E-16);
    private static final double[] sinh_coef = new double[]{0.1730421940471796, 0.08759422192276048, 0.00107947777456713, 6.37484926075E-6, 2.202366404E-8, 4.98794E-11, 7.973E-14, 9.0E-17};
    private static final double cosh_ymax = 1.0 / Math.sqrt(1.11022302462515E-16);
    private static final double tanh_xmax = -0.5 * Math.log(1.11022302462515E-16);
    private static final double tanh_sqeps = Math.sqrt(3.33066907387545E-16);
    private static final double[] tanh_coef = new double[]{-0.2582875664363471, -0.11836106330053497, 0.009869442648006398, -8.35798662344582E-4, 7.0904321198943E-5, -6.01642431812E-6, 5.105241908E-7, -4.3320729077E-8, 3.675999055E-9, -3.11928496E-10, 2.6468828E-11, -2.246023E-12, 1.90587E-13, -1.6172E-14, 1.372E-15, -1.16E-16, 9.0E-18};
    private static final double asinh_sqeps = Math.sqrt(1.11022302462515E-16);
    private static final double asinh_xmax = 1.0 / asinh_sqeps;
    private static double[] asinh_coef = new double[]{-0.12820039911738187, -0.05881176118995177, 0.004727465432212481, -4.938363162653618E-4, 5.850620705855741E-5, -7.466998328931368E-6, 1.00116935835582E-6, -1.3903543858708333E-7, 1.9823169483172795E-8, -2.8847468417848845E-9, 4.2672965467159937E-10, -6.397608465436636E-11, 9.699168608906471E-12, -1.4844276972043772E-12, 2.290373793902745E-13, -3.5588395132732646E-14, 5.563969408005679E-15, -8.746250959962468E-16, 1.381524884452669E-16, -2.1916688282900364E-17, 3.490465852482756E-18};
    private static final double acosh_xmax = 1.0 / Math.sqrt(1.11022302462515E-16);
    private static final double atanh_sqeps = Math.sqrt(3.33066907387545E-16);
    private static final double[] atanh_coef = new double[]{0.0943951023931955, 0.04919843705578616, 0.002102593522455433, 1.0735544497761166E-4, 5.978267249293031E-6, 3.505062030889135E-7, 2.1263743437653402E-8, 1.3216945357155272E-9, 8.36587550117807E-11, 5.370503749311002E-12, 3.4866594701571077E-13, 2.284549509603433E-14, 1.508407105944793E-15, 1.0024188168041091E-16, 6.69867473816507E-18};
    private static final double gamma_sq2pil = 0.9189385332046728;
    private static final double gamma_dxrel = Math.sqrt(2.2204460492503E-16);
    private static final double gamma_xsml = 5.56302416559456E-309;
    private static final double gamma_xmin = -170.56;
    private static final double gamma_xmax = 171.614;
    private static final double gamma_sqpi2l = 0.22579135264472744;
    private static final double[] gamma_coef = new double[]{0.00857119559098933, 0.004415381324841007, 0.05685043681599363, -0.00421983539641856, 0.0013268081812124603, -1.8930245297988805E-4, 3.606925327441245E-5, -6.056761904460864E-6, 1.0558295463022833E-6, -1.811967365542384E-7, 3.117724964715322E-8, -5.354219639019687E-9, 9.193275519859589E-10, -1.5779412802883398E-10, 2.7079806229349544E-11, -4.64681865382573E-12, 7.97335019200742E-13, -1.368078209830916E-13, 2.3473194865638007E-14, -4.027432614949067E-15, 6.910051747372101E-16, -1.185584500221993E-16, 2.034148542496374E-17, -3.490054341717406E-18, 5.987993856485306E-19};
    private static final double logGammaCorrection_xbig = 1.0 / Math.sqrt(1.11022302462515E-16);
    private static final double logGammaCorrection_xmax = 1.39118E11;
    private static final double[] logGammaCorrection_coef = new double[]{0.16663894804518634, -1.384948176067564E-5, 9.81082564692473E-9, -1.809129475572494E-11, 6.221098041892606E-14, -3.399615005417722E-16, 2.683181998482699E-18};
    private static final double[] erfc_coef = new double[]{-0.049046121234691806, -0.14226120510371365, 0.010035582187599796, -5.768764699767485E-4, 2.741993125219606E-5, -1.1043175507344507E-6, 3.8488755420345036E-8, -1.1808582533875466E-9, 3.2334215826050907E-11, -7.991015947004549E-13, 1.7990725113961456E-14, -3.718635487818693E-16, 7.103599003714253E-18};
    private static final double[] erfc2_coef = new double[]{-0.0696013466023095, -0.04110133936262089, 0.003914495866689627, -4.906395650548979E-4, 7.157479001377036E-5, -1.1530716341312328E-5, 1.9946705902019974E-6, -3.642666471599223E-7, 6.944372610005012E-8, -1.371220902104366E-8, 2.7883896610071373E-9, -5.814164724331161E-10, 1.2389204917527532E-10, -2.6906391453067435E-11, 5.942614350847911E-12, -1.3323867357581197E-12, 3.0280468061771323E-13, -6.966648814941033E-14, 1.620854541053923E-14, -3.809934465250492E-15, 9.040487815978831E-16, -2.1640061950896072E-16, 5.222102233995855E-17, -1.2697296023645554E-17, 3.1091455042761977E-18};
    private static final double[] erfcc_coef = new double[]{0.07151793102029248, -0.026532434337606717, 0.0017111539779208558, -1.6375166345851787E-4, 1.9871293500552038E-5, -2.843712412766555E-6, 4.6061613089631305E-7, -8.227753025879209E-8, 1.5921418727709012E-8, -3.295071362252843E-9, 7.223439760400556E-10, -1.6648558133987297E-10, 4.010392588237665E-11, -1.004816214425731E-11, 2.608275913300334E-12, -6.991110560404025E-13, 1.9294923332617072E-13, -5.470131188754331E-14, 1.5896633097626975E-14, -4.726893980197555E-15, 1.4358733767849847E-15, -4.449510561817358E-16, 1.4048108847682335E-16, -4.5138183877642106E-17, 1.474521541045133E-17, -4.8926214069457765E-18, 1.6476121414106467E-18, -5.626817176329408E-19, 1.9474433822320786E-19};
    private static final double erf_xbig = Math.sqrt(-Math.log(1.9678190753608168E-16));
    private static final double erf_sqeps = Math.sqrt(2.2204460492503E-16);
    private static final double erfc_xsml = -Math.sqrt(-Math.log(1.9678190753608168E-16));
    private static double erfc_xmax = Math.sqrt(-Math.log(1.772453850905516 * Double.MIN_VALUE));

    static {
        erfc_xmax += -0.5 * Math.log(erfc_xmax) / erfc_xmax - 0.01;
    }

    public static double acosh(double d) {
        if (d < 1.0) {
            return Double.NaN;
        }
        if (d < acosh_xmax) {
            return Math.log(d + Math.sqrt(d * d - 1.0));
        }
        return 0.6931471805599453 + Math.log(d);
    }

    public static double asinh(double d) {
        double d2 = Math.abs(d);
        double d3 = d2 <= 1.0 ? (d2 <= asinh_sqeps ? d : d * (1.0 + Sfun.csevl(2.0 * d * d - 1.0, asinh_coef))) : (d2 < asinh_xmax ? Math.log(d2 + Math.sqrt(d2 * d2 + 1.0)) : 0.6931471805599453 + Math.log(d2));
        return d3;
    }

    public static double atanh(double d) {
        double d2 = Math.abs(d);
        double d3 = d2 >= 1.0 ? Double.NaN : (d2 > atanh_sqeps && d2 <= 0.5 ? d * (1.0 + Sfun.csevl(8.0 * d * d - 1.0, atanh_coef)) : (d2 > 0.5 ? 0.5 * Math.log((1.0 + d) / (1.0 - d)) : d));
        return d3;
    }

    public static double cosh(double d) {
        double d2 = Math.exp(Math.abs(d));
        if (Double.isInfinite(d2)) {
            return d2;
        }
        return d2 >= cosh_ymax ? 0.5 * d2 : 0.5 * (d2 + 1.0 / d2);
    }

    public static double cot(double d) {
        double d2;
        double d3 = Math.abs(d);
        if (d3 > 4.503599627370523E15) {
            return Double.NaN;
        }
        double d4 = (int)d3;
        double d5 = d3 - d4;
        double d6 = 0.625 * d4;
        d4 = (int)d6;
        d3 = d6 - d4 + 0.625 * d5 + d3 * 0.011619772367581343;
        double d7 = (int)d3;
        d3 -= d7;
        int n = (int)((d4 += d7) % 2.0);
        if (n == 1) {
            d3 = 1.0 - d3;
        }
        if (d3 <= 0.25) {
            if (d3 == 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            d2 = d3 <= cot_xsml ? 1.0 / d3 : (0.5 + Sfun.csevl(32.0 * d3 * d3 - 1.0, cot_coef)) / d3;
        } else if (d3 <= 0.5) {
            d2 = (0.5 + Sfun.csevl(8.0 * d3 * d3 - 1.0, cot_coef)) / (0.5 * d3);
            d2 = (d2 * d2 - 1.0) * 0.5 / d2;
        } else {
            d2 = (0.5 + Sfun.csevl(2.0 * d3 * d3 - 1.0, cot_coef)) / (0.25 * d3);
            d2 = (d2 * d2 - 1.0) * 0.5 / d2;
            d2 = (d2 * d2 - 1.0) * 0.5 / d2;
        }
        if (d != 0.0) {
            d2 = Sfun.sign(d2, d);
        }
        if (n == 1) {
            d2 = -d2;
        }
        return d2;
    }

    static double csevl(double d, double[] dArray) {
        int n = dArray.length;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 2.0 * d;
        int n2 = n - 1;
        while (n2 >= 0) {
            d4 = d2;
            d2 = d3;
            d3 = d5 * d2 - d4 + dArray[n2];
            --n2;
        }
        return 0.5 * (d3 - d4);
    }

    public static double erf(double d) {
        double d2 = Double.NaN;
        double d3 = Math.abs(d);
        d2 = d3 <= 1.0 ? (d3 <= erf_sqeps ? 2.0 * d / 1.772453850905516 : d * (1.0 + Sfun.csevl(2.0 * d * d - 1.0, erfc_coef))) : (d3 <= erf_xbig ? Sfun.sign(1.0 - Sfun.erfc(d3), d) : Sfun.sign(1.0, d));
        return d2;
    }

    public static double erfc(double d) {
        double d2 = Double.NaN;
        if (d <= erfc_xsml) {
            d2 = 2.0;
        } else if (d <= erfc_xmax) {
            double d3 = Math.abs(d);
            if (d3 <= 1.0) {
                d2 = d3 < erf_sqeps ? 1.0 - 2.0 * d / 1.772453850905516 : 1.0 - d * (1.0 + Sfun.csevl(2.0 * d * d - 1.0, erfc_coef));
            } else {
                d2 = (d3 *= d3) <= 4.0 ? Math.exp(-d3) / Math.abs(d) * (0.5 + Sfun.csevl((8.0 / d3 - 5.0) / 3.0, erfc2_coef)) : Math.exp(-d3) / Math.abs(d) * (0.5 + Sfun.csevl(8.0 / d3 - 1.0, erfcc_coef));
                if (d < 0.0) {
                    d2 = 2.0 - d2;
                }
            }
        } else {
            d2 = 0.0;
        }
        return d2;
    }

    public static double gamma(double d) {
        double d2 = Math.abs(d);
        if (d2 <= 10.0) {
            int n = (int)d;
            if (d < 0.0) {
                --n;
            }
            double d3 = n;
            d2 = d - d3;
            double d4 = 0.9375 + Sfun.csevl(2.0 * d2 - 1.0, gamma_coef);
            if (--n == 0) {
                return d4;
            }
            if (n < 0) {
                n = -n;
                if (d == 0.0) {
                    return Double.NaN;
                }
                if (d2 < 5.56302416559456E-309) {
                    return Double.POSITIVE_INFINITY;
                }
                d3 = n - 2;
                if (d < 0.0 && d + d3 == 0.0) {
                    return Double.NaN;
                }
                double d5 = 0.0;
                int n2 = 1;
                while (n2 <= n) {
                    d4 /= d + d5;
                    d5 += 1.0;
                    ++n2;
                }
                return d4;
            }
            double d6 = 1.0;
            int n3 = 1;
            while (n3 <= n) {
                d4 *= d2 + d6;
                d6 += 1.0;
                ++n3;
            }
            return d4;
        }
        if (d > 171.614) {
            return Double.POSITIVE_INFINITY;
        }
        if (d < -170.56) {
            return 0.0;
        }
        double d7 = Math.exp((d2 - 0.5) * Math.log(d2) - d2 + 0.9189385332046728 + Sfun.logGammaCorrection(d2));
        if (d > 0.0) {
            return d7;
        }
        double d8 = Math.sin(Math.PI * d2);
        if (d8 == 0.0) {
            return Double.NaN;
        }
        d7 = -Math.PI / (d2 * d8 * d7);
        return d7;
    }

    public static double log10(double d) {
        return 0.4342944819032518 * Math.log(d);
    }

    public static double logGamma(double d) {
        double d2;
        double d3 = Math.abs(d);
        if (d3 <= 10.0) {
            d2 = Math.log(Math.abs(Sfun.gamma(d)));
        } else if (d > 0.0) {
            d2 = 0.9189385332046728 + (d - 0.5) * Math.log(d) - d + Sfun.logGammaCorrection(d3);
        } else {
            double d4 = Math.abs(Math.sin(Math.PI * d3));
            if (d4 == 0.0) {
                return Double.NaN;
            }
            d2 = 0.22579135264472744 + (d - 0.5) * Math.log(d3) - d - Math.log(d4) - Sfun.logGammaCorrection(d3);
        }
        return d2;
    }

    static double logGammaCorrection(double d) {
        if (d < 10.0) {
            return Double.NaN;
        }
        if (d < 1.39118E11) {
            if (d >= logGammaCorrection_xbig) {
                return 1.0 / (12.0 * d);
            }
            return Sfun.csevl(2.0 * Math.pow(10.0 / d, 2.0) - 1.0, logGammaCorrection_coef) / d;
        }
        return 0.0;
    }

    public static int nearestInteger(double d) {
        return (int)(d < 0.0 ? d - 0.5 : d + 0.5);
    }

    public static double sign(double d, double d2) {
        double d3 = d < 0.0 ? -d : d;
        return d2 < 0.0 ? -d3 : d3;
    }

    public static double sinh(double d) {
        double d2;
        double d3 = Math.abs(d);
        if (d3 <= 1.0) {
            d2 = d3 <= sinh_sqeps ? d : d * (1.0 + Sfun.csevl(2.0 * d * d - 1.0, sinh_coef));
        } else {
            if (Double.isInfinite(d3 = Math.exp(d3))) {
                return d < 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            }
            d2 = d3 >= sinh_ymax ? Sfun.sign(0.5 * d3, d) : Sfun.sign(0.5 * (d3 - 1.0 / d3), d);
        }
        return d2;
    }

    public static double tanh(double d) {
        double d2;
        double d3 = Math.abs(d);
        if (d3 <= 1.0) {
            d2 = d3 <= tanh_sqeps ? d : d * (1.0 + Sfun.csevl(2.0 * d * d - 1.0, tanh_coef));
        } else if (d3 <= tanh_xmax) {
            d3 = Math.exp(d3);
            d2 = Sfun.sign((d3 - 1.0 / d3) / (d3 + 1.0 / d3), d);
        } else {
            d2 = Sfun.sign(1.0, d);
        }
        return d2;
    }
}

