/*
 * Decompiled with CFR 0.152.
 */
package normalandt;

import RVLS.graphUtilities;
import VisualNumerics.math.Sfun;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;

public class normalTdist
extends Canvas {
    protected double mean;
    protected double sd = 1.0;
    protected double lowLimit;
    protected double firstTick;
    protected double upLimit;
    protected double lowCutoff;
    protected double upCutoff;
    protected double df = 5.0;
    protected boolean shade;
    protected boolean shadeBetween;
    protected boolean yaxis;
    protected boolean autoRepaint = true;
    public boolean autoSetLimits = true;
    public boolean setYmax = false;
    protected Color fillColor;
    protected final int BOTTOM = 55;
    protected final int HADJ = 35;
    protected final int XOFFSET = 35;
    protected double MultConst;
    protected double Ymax;
    protected double range;
    protected int w;
    protected int h;
    protected int pinc;
    protected int lastX;
    protected int lastY;
    protected int numTicks;
    protected int ndec;
    protected int hh;
    protected int ndx;
    protected Font font;
    protected String title;
    protected String title2;
    protected double sx2p;
    protected double sp2x;
    protected double sp2y;
    protected double sy2p;
    protected double step = 1.0;

    public normalTdist() {
        this.initialize(9, -4.0, 4.0, 0.0, 1.0, -4.0, 4.0, true, "Normal Distribution", Color.blue);
    }

    public void setDf(double _df) {
        this.df = _df;
        this.title2 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.title))).append(" with df = ").append((int)this.df)));
        this.paramChange();
    }

    public void setMean(double mean) {
        this.mean = mean;
        this.paramChange();
    }

    public void setMeanDf(double mean1, double df1, boolean autoRepaint) {
        this.autoRepaint = autoRepaint;
        this.mean = mean1;
        this.df = df1;
        this.title2 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.title))).append(" with df = ").append((int)this.df)));
        this.paramChange();
    }

    public void setShade(boolean shade) {
        this.shade = shade;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public boolean isShade() {
        return this.shade;
    }

    public void setShadeBetween(boolean _between) {
        this.shadeBetween = _between;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public boolean isShadeBetween() {
        return this.shadeBetween;
    }

    public void setYaxis(boolean yaxis) {
        this.yaxis = yaxis;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public boolean isYaxis() {
        return this.yaxis;
    }

    public void setTitle(String title) {
        this.title = title;
        this.title2 = title;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void setUpLimit(double upLimit) {
        this.upLimit = upLimit;
        this.range = upLimit - this.lowLimit;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void setLowLimit(double lowLimit) {
        this.lowLimit = lowLimit;
        this.range = this.upLimit - lowLimit;
        this.firstTick = lowLimit;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void setUpCutoff(double upCutoff) {
        this.upCutoff = upCutoff;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public double getUpCutoff() {
        return this.upCutoff;
    }

    public void setLowCutoff(double lowCutoff) {
        this.lowCutoff = lowCutoff;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public double getLowCutoff() {
        return this.lowCutoff;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setLimits(double lowLimit, double upLimit, int numTicks, boolean autoRepaint) {
        this.autoRepaint = autoRepaint;
        this.lowLimit = lowLimit;
        this.upLimit = upLimit;
        this.range = upLimit - lowLimit;
        this.numTicks = numTicks;
        this.firstTick = lowLimit;
        if (autoRepaint) {
            this.repaint();
        }
    }

    public void setShadedArea(double lowCutoff, double upCutoff) {
        this.lowCutoff = lowCutoff;
        this.upCutoff = upCutoff;
        this.shade = true;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void setAutoRepaint(boolean autoRepaint) {
        this.autoRepaint = autoRepaint;
    }

    public boolean isAutoRepaint() {
        return this.autoRepaint;
    }

    public void initialize(int _numTicks, double _LL, double _UL, double _mean, double _sd, double _LC, double _UC, boolean _between, String _title, Color _fillColor) {
        this.ndx = 0;
        this.yaxis = false;
        this.shade = false;
        this.title = _title;
        this.fillColor = _fillColor;
        this.ndec = 0;
        this.numTicks = _numTicks - 1;
        this.pinc = 1;
        this.sd = _sd;
        this.mean = _mean;
        this.lowLimit = _LL;
        this.firstTick = _LL;
        this.upLimit = _UL;
        this.lowCutoff = _LC;
        this.upCutoff = _UC;
        this.shadeBetween = _between;
        this.range = _UL - _LL;
        this.w -= 70;
        this.Ymax = this.MultConst = 1.0 / (Math.sqrt(Math.PI * 2) * this.sd);
        this.font = new Font("TimesRoman", 0, 10);
    }

    public void paint(Graphics g) {
        int x;
        String num;
        Dimension dim = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, dim.width, dim.height);
        g.setColor(g.getColor());
        int y = 0;
        this.w = this.getSize().width - 70;
        this.h = this.getSize().height - 55;
        this.hh = this.h + 35;
        if (!this.setYmax) {
            this.Ymax = this.MultConst;
        }
        this.sp2x = this.range / (double)this.w;
        this.sx2p = 1.0 / this.sp2x;
        this.sp2y = this.Ymax / (double)this.h;
        this.sy2p = 1.0 / this.sp2y;
        g.setColor(Color.black);
        g.setFont(this.font);
        g.drawLine(35, this.hh, 35 + this.w, this.hh);
        FontMetrics met = g.getFontMetrics(this.font);
        int fh = met.getAscent();
        if (this.autoSetLimits) {
            this.step = (this.upLimit - this.lowLimit) / (double)this.numTicks;
        }
        double c = this.firstTick - this.step;
        int adj = (this.w - met.stringWidth(this.title2)) / 2;
        g.drawString(this.title2, 35 + adj, fh + 5);
        if (this.yaxis) {
            int yt;
            double[] r = new double[3];
            r = graphUtilities.intlabels(0.0, this.Ymax, 5);
            for (double yy = 0.0; yy <= this.Ymax + r[0] && (yt = (int)Math.round((double)this.hh - this.sy2p * yy)) > 5; yy += r[0]) {
                y = yt;
                g.drawLine(29, y, 32, y);
                num = graphUtilities.format(yy, 2);
                x = 35 - met.stringWidth(num) - 8;
                g.drawString(num, x, y + fh / 2);
            }
            g.drawLine(33, y, 33, this.hh);
        }
        if (this.autoSetLimits) {
            if (this.step >= 1.0) {
                this.ndx = 0;
            }
            if (this.step < 1.0) {
                this.ndx = 1;
            }
            if (Math.floor(this.sd) != this.sd) {
                this.ndx = 1;
            }
            if (this.step < 0.05) {
                this.ndx = 2;
            }
        }
        double tickAdj = this.sx2p * (this.firstTick - this.lowLimit);
        num = graphUtilities.format(this.upLimit, this.ndx);
        float SL = met.stringWidth(num);
        double w = this.step * this.sx2p;
        int r = (int)Math.ceil((double)SL / (w - (double)2));
        for (int i = 0; i <= this.numTicks; ++i) {
            c += this.step;
            if (i % r != 0) continue;
            x = (int)Math.rint((double)35 + this.sx2p * (double)i * this.step + tickAdj);
            num = graphUtilities.format(c, this.ndx);
            g.drawLine(x, this.hh, x, this.hh + 4);
            SL = met.stringWidth(num);
            adj = (int)Math.rint(SL / (float)2);
            g.drawString(num, x - adj, this.hh + fh + 6);
        }
        this.drawDist(g);
    }

    public void update(Graphics g) {
        Dimension dim = this.getSize();
        Image osi = this.createImage(dim.width, dim.height);
        Graphics osg = osi.getGraphics();
        osg.setColor(this.getBackground());
        osg.fillRect(0, 0, dim.width, dim.height);
        osg.setColor(g.getColor());
        this.paint(osg);
        g.drawImage(osi, 0, 0, this);
    }

    public void paramChange() {
        if (this.autoSetLimits) {
            this.firstTick = this.lowLimit = this.mean - 4.0 * this.sd;
            this.upLimit = this.mean + 4.0 * this.sd;
            this.range = this.upLimit - this.lowLimit;
        }
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void drawDist(Graphics g) {
        double x;
        int y;
        double x2;
        int h1 = this.hh - 1;
        g.setColor(Color.red);
        this.lastX = (int)Math.rint((this.mean - 5.0 * this.sd - this.lowLimit) / this.sp2x);
        this.lastX = Math.max(0, this.lastX);
        double density = this.getDensity1((double)this.lastX * this.sp2x + this.lowLimit);
        this.lastY = (int)Math.round((double)this.hh - this.sy2p * density);
        for (int i = this.lastX; i < this.w && !((x2 = this.sp2x * (double)i + this.lowLimit) > this.mean + 5.0 * this.sd); i += this.pinc) {
            density = this.getDensity1(x2);
            y = (int)Math.round((double)this.hh - this.sy2p * density);
            if (y > 15 && this.lastY > 15) {
                g.drawLine(35 + this.lastX, this.lastY, 35 + i, y);
            }
            this.lastX = i;
            this.lastY = y;
            if (!this.shade) continue;
            if (this.shadeBetween) {
                if (!(x2 >= this.lowCutoff) || !(x2 <= this.upCutoff)) continue;
                g.setColor(this.fillColor);
                g.drawLine(35 + this.lastX, h1, 35 + this.lastX, y);
                continue;
            }
            if (!(x2 <= this.lowCutoff) && !(x2 >= this.upCutoff)) continue;
            g.setColor(this.fillColor);
            g.drawLine(35 + this.lastX, h1, 35 + this.lastX, y);
        }
        g.setColor(Color.blue);
        this.lastX = (int)Math.rint((this.mean - 5.0 * Math.sqrt(this.df / (this.df - (double)2)) - this.lowLimit) / this.sp2x);
        this.lastX = Math.max(0, this.lastX);
        double b = this.Beta(0.5 * this.df, 0.5);
        density = this.getDensity2((double)this.lastX * this.sp2x + this.lowLimit, b);
        this.lastY = (int)Math.round((double)this.hh - this.sy2p * density);
        for (int i = this.lastX; i < this.w && !((x = this.sp2x * (double)i + this.lowLimit) > this.mean + 5.0 * Math.sqrt(this.df / (this.df - (double)2))); i += this.pinc) {
            density = this.getDensity2(x, b);
            y = (int)Math.round((double)this.hh - this.sy2p * density);
            if (y > 15 && this.lastY > 15) {
                g.drawLine(35 + this.lastX, this.lastY, 35 + i, y);
            }
            this.lastX = i;
            this.lastY = y;
            if (!this.shade) continue;
            if (this.shadeBetween) {
                if (!(x >= this.lowCutoff) || !(x <= this.upCutoff)) continue;
                g.setColor(this.fillColor);
                g.drawLine(35 + this.lastX, h1, 35 + this.lastX, y);
                continue;
            }
            if (!(x <= this.lowCutoff) && !(x >= this.upCutoff)) continue;
            g.setColor(this.fillColor);
            g.drawLine(35 + this.lastX, h1, 35 + this.lastX, y);
        }
    }

    public double getDensity1(double x) {
        double z = (x - this.mean) / this.sd;
        return this.MultConst * Math.exp(-z * z / (double)2);
    }

    public double getDensity2(double x, double b) {
        double z = x - this.mean;
        double p = Math.pow(1.0 + z * z / this.df, -0.5 * (this.df + 1.0)) / (Math.sqrt(this.df) * b);
        return p;
    }

    public double Beta(double a, double b) {
        double t = Sfun.gamma(a) * Sfun.gamma(b);
        double s = Sfun.gamma(a + b);
        return t / s;
    }

    public void setYmax(double ymax) {
        this.Ymax = ymax;
        this.setYmax = true;
        if (this.autoRepaint) {
            this.repaint();
        }
    }
}

