/*
 * Decompiled with CFR 0.152.
 */
package VisualNumerics.math;

import VisualNumerics.math.Sfun;

public class Statistics {
    static final double log_min_value = Math.log(Double.MIN_VALUE);
    private static final double con1 = 0.63661977236758;
    private static final double hpi = 1.5707963267948966;
    private static final double eps_normalInv = 1.0E-6;
    private static final double sqrt2 = 1.4142135623730951;
    private static final double e0_normalInv = -0.05668422;
    private static final double e1_normalInv = 0.3937021;
    private static final double e2_normalInv = -0.3166501;
    private static final double e3_normalInv = 0.06208963;
    private static final double g0_normalInv = 1.851159E-4;
    private static final double g1_normalInv = -0.002028152;
    private static final double g2_normalInv = -0.1498384;
    private static final double g3_normalInv = 0.01078639;
    private static final double h0_normalInv = 0.09952975;
    private static final double h1_normalInv = 0.5211733;
    private static final double h2_normalInv = -0.06888301;
    private static final double a1_normalInv = -0.5751703;
    private static final double a2_normalInv = -1.896513;
    private static final double a3_normalInv = -0.05496261;
    private static final double b0_normalInv = -0.113773;
    private static final double b1_normalInv = -3.293474;
    private static final double b2_normalInv = -2.374996;
    private static final double b3_normalInv = -1.187515;
    private static final double c0_normalInv = -0.1146666;
    private static final double c1_normalInv = -0.1314774;
    private static final double c2_normalInv = -0.2368201;
    private static final double c3_normalInv = 0.05073975;
    private static final double d0_normalInv = -44.27977;
    private static final double d1_normalInv = 21.98546;
    private static final double d2_normalInv = -7.586103;
    private static final double f0_normalInv = -6.266786;
    private static final double f1_normalInv = 4.666263;
    private static final double f2_normalInv = -2.962883;
    static final double log_epsilon_small = Math.log(1.11022302462515E-16);
    private static final double[] alnrcs = new double[]{1.037869356274377, -0.13364301504908918, 0.019408249135520562, -0.0030107551127535777, 4.869461479715485E-4, -8.105488189317536E-5, 1.3778847799559525E-5, -2.380221089435897E-6, 4.1640416213865184E-7, -7.359582837807599E-8, 1.3117611876241675E-8, -2.3546709317742423E-9, 4.2522773276035E-10, -7.71908941348408E-11, 1.407574648135907E-11, -2.5769072058024682E-12, 4.734240666629442E-13, -8.724901267474264E-14, 1.612461490274055E-14, -2.9875652015665774E-15, 5.548070120908289E-16, -1.0324619158271569E-16, 1.9250239203049852E-17, -3.595507346526515E-18};

    public static double FCdf(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            return Double.NaN;
        }
        if (d3 <= 0.0) {
            return Double.NaN;
        }
        if (d <= 0.0) {
            return 0.0;
        }
        double d4 = d3 / (d3 + d2 * d);
        return 1.0 - Statistics.beta_incomplete(d4, 0.5 * d3, 0.5 * d2);
    }

    public static double average(double[] dArray) {
        double d = 0.0;
        if (dArray.length == 0) {
            return Double.NaN;
        }
        int n = 0;
        while (n < dArray.length) {
            d += dArray[n];
            ++n;
        }
        return d / (double)dArray.length;
    }

    static double beta_incomplete(double d, double d2, double d3) {
        int n;
        int n2;
        double d4;
        double d5 = 0.95 * log_min_value;
        double d6 = Double.NaN;
        if (d < 0.0 || d > 1.0 || d2 <= 0.0 || d3 <= 0.0) {
            return d6;
        }
        double d7 = d;
        double d8 = d3;
        double d9 = d2;
        if ((d8 > d9 || d > 0.8) && d > 0.2) {
            d7 = 1.0 - d7;
            d9 = d3;
            d8 = d2;
        }
        if ((d9 + d8) * d7 / (d9 + 1.0) < 1.11022302462515E-16) {
            d6 = 0.0;
            double d10 = d9 * Math.log(Math.max(d7, Double.MIN_VALUE)) - Math.log(d9) - Statistics.log_beta(d9, d8);
            if (d10 > d5 && d7 != 0.0) {
                d6 = Math.exp(d10);
            }
            if (d7 != d || d9 != d2) {
                d6 = 1.0 - d6;
            }
            return d6;
        }
        double d11 = d8 - (double)((int)d8);
        if (d11 == 0.0) {
            d11 = 1.0;
        }
        double d12 = d9 * Math.log(d7) - Statistics.log_beta(d11, d9) - Math.log(d9);
        d6 = 0.0;
        if (d12 >= d5) {
            d6 = Math.exp(d12);
            d4 = d6 * d9;
            if (d11 != 1.0) {
                n2 = (int)Math.max(log_epsilon_small / Math.log(d7), 4.0);
                n = 1;
                while (n <= n2) {
                    d4 = d4 * ((double)n - d11) * d7 / (double)n;
                    d6 += d4 / (d9 + (double)n);
                    ++n;
                }
            }
        }
        if (d8 <= 1.0) {
            if (d7 != d || d9 != d2) {
                d6 = 1.0 - d6;
            }
            return Math.max(Math.min(d6, 1.0), 0.0);
        }
        d12 = d9 * Math.log(d7) + d8 * Math.log(1.0 - d7) - Statistics.log_beta(d9, d8) - Math.log(d8);
        int n3 = (int)Math.max(d12 / d5, 0.0);
        d4 = Math.exp(d12 - (double)n3 * d5);
        double d13 = 1.0 / (1.0 - d7);
        double d14 = d8 * d13 / (d9 + d8 - 1.0);
        double d15 = 0.0;
        n2 = (int)d8;
        if (d8 == (double)n2) {
            --n2;
        }
        n = 1;
        while (n <= n2) {
            if (d14 <= 1.0 && d4 / 1.11022302462515E-16 <= d15) break;
            if ((d4 = (d8 - (double)(n - 1)) * d13 * d4 / (d9 + d8 - (double)n)) > 1.0) {
                --n3;
                d4 *= Double.MIN_VALUE;
            }
            if (n3 == 0) {
                d15 += d4;
            }
            ++n;
        }
        d6 += d15;
        if (d7 != d || d9 != d2) {
            d6 = 1.0 - d6;
        }
        return Math.max(Math.min(d6, 1.0), 0.0);
    }

    private static double inverseBeta(double d, double d2, double d3) {
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9 = Double.NaN;
        if (d2 <= 0.0 || d3 <= 0.0 || d <= 0.0 || d >= 1.0) {
            return d9;
        }
        double d10 = Math.min(d2, d3);
        if (d10 > 1.0 && 10.0 * d10 > (d8 = Math.max(d2, d3))) {
            d10 = 0.0;
            d8 = 1.0;
            double d11 = -d;
            int n = 0;
            while (n < 30) {
                d7 = (d10 + d8) * 0.5;
                double d12 = Statistics.beta_incomplete(d7, d2, d3);
                double d13 = d12 - d;
                if (d13 * d11 <= 0.0) {
                    d8 = d7;
                } else {
                    d10 = d7;
                    d11 = d13;
                }
                double d14 = d8 - d10;
                if (d14 <= 2.2204460492503E-16 && Math.abs(d13) <= 2.2204460492503E-16) {
                    return d7;
                }
                ++n;
            }
        }
        if (d <= 0.5) {
            d6 = d2;
            d5 = d3;
            d4 = Math.log(d);
        } else {
            d4 = Math.log(1.0 - d);
            d6 = d3;
            d5 = d2;
        }
        double d15 = d6 / (d6 + d5);
        double d16 = Sfun.logGamma(d6 + d5) - Sfun.logGamma(d6) - Sfun.logGamma(d5);
        d16 += -(d6 + d5) * Math.log(d6 + d5) + (d6 - 0.5) * Math.log(d6) + (d5 - 0.5) * Math.log(d5);
        d16 += 0.5 * Math.log(d5 / d6) + d6 * Math.log(1.0 + d5 / d6) + d5 * Math.log(1.0 + d6 / d5);
        int n = 1;
        while (n <= 100) {
            double d17 = Math.log(15.0 + d6 + d5);
            double d18 = 0.7 * d17 * d17 + Math.max(d15 * (d6 + d5) - d6, 0.0);
            d17 = d6 + d18 + d18;
            double d19 = (int)d18 + 1;
            double d20 = 1.0 - (d6 + d5) * d15 / d17;
            double d21 = 2.0 / (d20 + Math.sqrt(d20 * d20 - 4.0 * d18 * (d18 - d5) * d15 / (d17 * d17)));
            d19 -= 1.0;
            while (d19 >= 0.5) {
                d17 = d6 + d19 + d19;
                d21 = (d17 - 2.0) * (d17 - 1.0 - d19 * (d19 - d5) * d15 * d21 / d17);
                d17 = d6 + d19 - 1.0;
                d21 = 1.0 / (1.0 - d17 * (d17 + d5) * d15 / d21);
                d19 -= 1.0;
            }
            double d22 = d21;
            d17 = Math.log(d15);
            if (d17 <= log_min_value + 10.0) {
                d7 = d <= 0.5 ? 0.0 : 1.0;
                return d7;
            }
            double d23 = d16 + d6 * d17 + d5 * Math.log(1.0 - d15) + Math.log(d22);
            double d24 = (d4 - d23) * (1.0 - d15) * d22 / d6;
            d24 = Math.max(d24, -0.99);
            d17 = 0.5 / d15 - 0.5;
            d24 = Math.min(d24, d17);
            d15 *= 1.0 + d24;
            if (Math.abs(d24) < 2.2204460492503E-16) {
                d7 = d <= 0.5 ? d15 : 1.0 - d15;
                return d7;
            }
            ++n;
        }
        d7 = d <= 0.5 ? d15 : 1.0 - d15;
        return d7;
    }

    public static double inverseFCdf(double d, double d2, double d3) {
        double d4;
        double d5 = d2;
        double d6 = d3;
        double d7 = Double.NaN;
        if (d <= 0.0 || d >= 1.0) {
            return d7;
        }
        if (d5 <= 0.0 || d6 <= 0.0) {
            return d7;
        }
        double d8 = 0.9999999999999998;
        double d9 = 0.5 * d5;
        double d10 = 0.5 * d6;
        if (d <= 0.5) {
            d4 = Statistics.inverseBeta(d, d9, d10);
            if (d4 >= d8) {
                return Double.POSITIVE_INFINITY;
            }
            d4 = d6 * d4 / (d5 * (1.0 - d4));
        } else {
            double d11 = 1.0 - d;
            d4 = Statistics.inverseBeta(d11, d10, d9);
            if (d4 == 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            d4 = (1.0 / d4 - 1.0) * d6 / d5;
        }
        return d4;
    }

    public static double inverseNormalCdf(double d) {
        double d2 = Double.NaN;
        if (d <= 0.0 || d >= 1.0) {
            return Double.NaN;
        }
        if (d > 1.0E-6 && d < 0.999997) {
            double d3;
            double d4 = Math.abs(1.0 - (d + d));
            if (d4 > 0.85) {
                double d5 = 1.0 - d4;
                double d6 = d4;
                double d7 = Math.sqrt(-Math.log(d5 + d5 * d6));
                if (d7 >= 2.5) {
                    if (d7 >= 4.0) {
                        double d8 = 1.0 / d7;
                        double d9 = ((0.01078639 * d8 + -0.1498384) * d8 + -0.002028152) * d8;
                        double d10 = ((d8 + -0.06888301) * d8 + 0.5211733) * d8 + 0.09952975;
                        d3 = d7 + d7 * (1.851159E-4 + d9 / d10);
                    } else {
                        double d11 = ((0.06208963 * d7 + -0.3166501) * d7 + 0.3937021) * d7;
                        double d12 = ((d7 + -2.962883) * d7 + 4.666263) * d7 + -6.266786;
                        d3 = d7 + d7 * (-0.05668422 + d11 / d12);
                    }
                } else {
                    double d13 = ((0.05073975 * d7 + -0.2368201) * d7 + -0.1314774) * d7;
                    double d14 = ((d7 + -7.586103) * d7 + 21.98546) * d7 + -44.27977;
                    d3 = d7 + d7 * (-0.1146666 + d13 / d14);
                }
            } else {
                double d15 = d4 * d4;
                d3 = d4 + d4 * (-0.113773 + -0.5751703 * d15 / (-3.293474 + d15 + -1.896513 / (-2.374996 + d15 + -0.05496261 / (-1.187515 + d15))));
            }
            d2 = d >= 0.5 ? 1.4142135623730951 * d3 : -1.4142135623730951 * d3;
        } else {
            double d16 = d >= 0.5 ? 2.0 * (1.0 - d) : d + d;
            double d17 = Math.sqrt(-Math.log(d16 + (d16 - d16 * d16)));
            double d18 = 1.0 / d17;
            double d19 = ((0.01078639 * d18 + -0.1498384) * d18 + -0.002028152) * d18;
            double d20 = ((d18 + -0.06888301) * d18 + 0.5211733) * d18 + 0.09952975;
            double d21 = d17 + d17 * (1.851159E-4 + d19 / d20);
            d2 = d >= 0.5 ? 1.4142135623730951 * d21 : -1.4142135623730951 * d21;
        }
        return d2;
    }

    public static double inverseTCdf(double d, double d2) {
        double d3;
        double d4 = Double.NaN;
        double d5 = d2;
        if (d5 < 1.0) {
            return d4;
        }
        if (d <= 0.0 || d >= 1.0) {
            return d4;
        }
        double d6 = 2.2204460492503E-16;
        if (d > 0.5 - d6 && d < 0.5 + d6) {
            return 0.0;
        }
        double d7 = d < 0.5 ? 2.0 * d : 2.0 * (1.0 - d);
        double d8 = Math.log(Double.MAX_VALUE);
        if (Math.abs(d5 - 2.0) <= 2.2204460492503E-16) {
            d3 = Math.sqrt(2.0 / (d7 * (2.0 - d7)) - 2.0);
        } else if (Math.abs(d5 - 1.0) <= 2.2204460492503E-16) {
            double d9 = d7 * 1.5707963267948966;
            d3 = Math.cos(d9) / Math.sin(d9);
        } else if (d5 <= 2.0) {
            double d10;
            double d11;
            double d12;
            double d13;
            double d14 = d < 0.5 ? 1.0 - 2.0 * d : -(1.0 - 2.0 * d);
            double d15 = 1.0 - d14;
            d3 = Statistics.inverseBeta(d15, d13 = 0.5 * (d12 = d5), d11 = 0.5 * (d10 = 1.0));
            if (d3 == 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            double d16 = (1.0 / d3 - 1.0) * d12 / d10;
            d3 = Math.sqrt(d16);
        } else {
            double d17 = 1.0 / (d5 - 0.5);
            double d18 = 48.0 / (d17 * d17);
            double d19 = ((20700.0 * d17 / d18 - 98.0) * d17 - 16.0) * d17 + 96.36;
            double d20 = ((94.5 / (d18 + d19) - 3.0) / d18 + 1.0) * Math.sqrt(d17 * 1.5707963267948966) * d5;
            double d21 = d20 * d7;
            double d22 = Math.pow(d21, 2.0 / d5);
            if (d22 <= d17 + 0.05) {
                d22 = ((1.0 / (((d5 + 6.0) / (d5 * d22) - 0.089 * d20 - 0.822) * (d5 + 2.0) * 3.0) + 0.5 / (d5 + 4.0)) * d22 - 1.0) * (d5 + 1.0) / (d5 + 2.0) + 1.0 / d22;
                d3 = Math.sqrt(d5 * d22);
            } else {
                d3 = 0.5 * d7;
                d21 = Statistics.inverseNormalCdf(d3);
                d22 = d21 * d21;
                if (d5 < 5.0) {
                    d19 += 0.3 * (d5 - 4.5) * (d21 + 0.6);
                }
                d22 = (((((0.4 * d22 + 6.3) * d22 + 36.0) * d22 + 94.5) / (d19 += (((0.05 * d20 * d21 - 5.0) * d21 - 7.0) * d21 - 2.0) * d21 + d18) - d22 - 3.0) / d18 + 1.0) * d21;
                if ((d20 = (d22 *= d17 * d22)) <= 0.002) {
                    d22 += 0.5 * d22 * d22;
                }
                if (d20 > 0.002) {
                    d22 = Math.exp(d22) - 1.0;
                }
                d3 = Math.sqrt(d5 * d22);
            }
        }
        if (d < 0.5) {
            d3 = -d3;
        }
        return d3;
    }

    public static double kurtosis(double[] dArray) {
        int n = dArray.length;
        double d = 0.0;
        int n2 = 0;
        while (n2 < n) {
            d += dArray[n2];
            ++n2;
        }
        d /= (double)n;
        double d2 = 0.0;
        n2 = 0;
        while (n2 < n) {
            d2 += (dArray[n2] - d) * (dArray[n2] - d);
            ++n2;
        }
        d2 /= (double)n;
        double d3 = 0.0;
        n2 = 0;
        while (n2 < n) {
            double d4 = dArray[n2] - d;
            d3 += d4 * d4 * d4 * d4;
            ++n2;
        }
        d3 /= (double)n * d2 * d2;
        return d3 -= 3.0;
    }

    public static double[] linearFit(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("number of x and y values are not equal");
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n = 0;
        while (n < dArray.length) {
            d += dArray[n];
            d2 += dArray2[n];
            d3 += dArray[n] * dArray2[n];
            d4 += dArray[n] * dArray[n];
            ++n;
        }
        double[] dArray3 = new double[2];
        double d5 = (double)dArray.length * d4 - d * d;
        if (d5 == 0.0) {
            dArray3[0] = d2 / (double)dArray.length;
            dArray3[1] = 0.0;
        } else {
            dArray3[0] = (d2 * d4 - d * d3) / d5;
            dArray3[1] = ((double)dArray.length * d3 - d * d2) / d5;
        }
        return dArray3;
    }

    private static double logRelative(double d) {
        if (d <= -1.0) {
            return Double.NaN;
        }
        return Math.abs(d) <= 0.375 ? d * (1.0 - d * Sfun.csevl(d / 0.375, alnrcs)) : Math.log(1.0 + d);
    }

    private static double log_beta(double d, double d2) {
        double d3 = 0.9189385332046728;
        double d4 = Double.NaN;
        double d5 = Math.min(d, d2);
        double d6 = Math.max(d, d2);
        if (d5 <= 0.0) {
            return d4;
        }
        if (d5 >= 10.0) {
            double d7 = Sfun.logGammaCorrection(d5) + Sfun.logGammaCorrection(d6) - Sfun.logGammaCorrection(d5 + d6);
            double d8 = Statistics.logRelative(-d5 / (d5 + d6));
            d4 = -0.5 * Math.log(d6) + d3 + d7 + (d5 - 0.5) * Math.log(d5 / (d5 + d6)) + d6 * d8;
        } else if (d6 >= 10.0) {
            double d9 = Sfun.logGammaCorrection(d6) - Sfun.logGammaCorrection(d5 + d6);
            d4 = Sfun.logGamma(d5) + d9 + d5 - d5 * Math.log(d5 + d6) + (d6 - 0.5) * Statistics.logRelative(-d5 / (d5 + d6));
        } else {
            d4 = Math.log(Sfun.gamma(d5) * (Sfun.gamma(d6) / Sfun.gamma(d5 + d6)));
        }
        return d4;
    }

    public static double maximum(double[] dArray) {
        if (dArray.length == 0) {
            return Double.NaN;
        }
        double d = dArray[0];
        int n = 1;
        while (n < dArray.length) {
            d = d > dArray[n] ? d : dArray[n];
            ++n;
        }
        return d;
    }

    public static double median(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        Statistics.sort(dArray2);
        double d = (double)(dArray2.length - 1) * 0.5;
        int n = (int)d;
        if (n >= dArray2.length - 1) {
            return dArray2[dArray2.length - 1];
        }
        double d2 = d - (double)n;
        return (1.0 - d2) * dArray2[n] + d2 * dArray2[n + 1];
    }

    public static double minimum(double[] dArray) {
        if (dArray.length == 0) {
            return Double.NaN;
        }
        double d = dArray[0];
        int n = 1;
        while (n < dArray.length) {
            d = d < dArray[n] ? d : dArray[n];
            ++n;
        }
        return d;
    }

    public static double normalCdf(double d) {
        return 0.5 * Sfun.erfc(-d * 0.7071067811865476);
    }

    public static double range(double[] dArray) {
        if (dArray.length == 0) {
            return Double.NaN;
        }
        double d = dArray[0];
        double d2 = dArray[0];
        int n = 1;
        while (n < dArray.length) {
            d = d < dArray[n] ? d : dArray[n];
            d2 = d2 > dArray[n] ? d2 : dArray[n];
            ++n;
        }
        return d2 - d;
    }

    public static double skew(double[] dArray) {
        double d = 0.0;
        int n = 0;
        while (n < dArray.length) {
            d += dArray[n];
            ++n;
        }
        d /= (double)dArray.length;
        double d2 = 0.0;
        n = 0;
        while (n < dArray.length) {
            d2 += (dArray[n] - d) * (dArray[n] - d);
            ++n;
        }
        d2 /= (double)dArray.length;
        double d3 = 0.0;
        n = 0;
        while (n < dArray.length) {
            double d4 = dArray[n] - d;
            d3 += d4 * d4 * d4;
            ++n;
        }
        return d3 *= Math.pow(d2, -1.5) / (double)dArray.length;
    }

    public static double slope(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("number of x and y values are not equal");
        }
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        while (n < dArray.length) {
            d += dArray[n] * dArray2[n];
            d2 += dArray[n] * dArray[n];
            ++n;
        }
        if (d2 == 0.0) {
            double d3 = 0.0;
            int n2 = 0;
            while (n2 < dArray.length) {
                d3 += dArray2[n2];
                ++n2;
            }
            return d3 / (double)dArray.length;
        }
        return d / d2;
    }

    private static void sort(double[] dArray) {
        int n = dArray.length;
        while (n != 0) {
            int n2 = -1;
            int n3 = 0;
            while (n3 < n - 1) {
                if (dArray[n3] > dArray[n3 + 1]) {
                    double d = dArray[n3 + 1];
                    dArray[n3 + 1] = dArray[n3];
                    dArray[n3] = d;
                    n2 = n3;
                }
                ++n3;
            }
            n = n2 + 1;
        }
    }

    public static double standardDeviation(double[] dArray) {
        return Math.sqrt(Statistics.variance(dArray));
    }

    public static double tCdf(double d, double d2) {
        double d3;
        double d4 = d2;
        double d5 = Double.NaN;
        if (Double.isNaN(d)) {
            return d5;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (d4 < 1.0) {
            return d5;
        }
        double d6 = d * d;
        if (d4 > d6) {
            d6 = d;
            double d7 = d4;
            int n = (int)d7;
            d6 *= d6;
            double d8 = d6 / d7;
            double d9 = 1.0 + d8;
            if (d7 != (double)n || d7 >= 20.0 || d7 > 200.0) {
                double d10 = d9 - 1.0;
                if (d10 != 0.0) {
                    d8 *= Math.log(d9) / d10;
                }
                double d11 = d7 - 0.5;
                d9 = 48.0 * d11 * d11;
                d8 *= d11;
                d3 = (d8 = (((((-0.4 * d8 - 3.3) * d8 - 24.0) * d8 - 85.5) / (0.8 * (d8 * d8) + 100.0 + d9) + d8 + 3.0) / d9 + 1.0) * Math.sqrt(d8)) < 18.8125 ? Sfun.erfc(d8 * Math.sqrt(0.5)) : 0.0;
            } else if (d7 < 20.0 && d6 < 4.0) {
                double d12 = d8 = Math.sqrt(d8);
                if (d7 == 1.0) {
                    d12 = 0.0;
                }
                d7 -= 2.0;
                while (d7 > 1.0) {
                    d12 = (d7 - 1.0) / (d9 * d7) * d12 + d8;
                    d7 -= 2.0;
                }
                if (d7 == 0.0) {
                    d12 /= Math.sqrt(d9);
                }
                if (d7 != 0.0) {
                    d12 = (Math.atan(d8) + d12 / d9) * 0.63661977236758;
                }
                d3 = 1.0 - d12;
            } else {
                double d13 = 1.0;
                d8 = d7;
                double d14 = 0.0;
                double d15 = 0.0;
                while (d13 != d15) {
                    d15 = d13;
                    d8 = d8 * ((d14 += 2.0) - 1.0) / (d9 * d14);
                    d13 += d8 / (d7 + d14);
                }
                while (d7 > 1.0 && d13 >= 1.0E-30) {
                    d13 *= (d7 - 1.0) / (d9 * d7);
                    d7 -= 2.0;
                }
                if (d7 != 0.0) {
                    d13 = Math.sqrt(d9) * 0.63661977236758 * d13 / d9;
                }
                d3 = d13;
            }
        } else {
            d6 = d4 / (d4 + d6);
            double d16 = 0.5 * d4;
            double d17 = 0.5;
            d3 = Statistics.beta_incomplete(d6, d16, d17);
        }
        d5 = d > 0.0 ? 1.0 - 0.5 * d3 : 0.5 * d3;
        return d5;
    }

    public static double variance(double[] dArray) {
        double d = 0.0;
        if (dArray.length < 2) {
            return Double.NaN;
        }
        int n = 0;
        while (n < dArray.length) {
            d += dArray[n];
            ++n;
        }
        d /= (double)dArray.length;
        double d2 = 0.0;
        n = 0;
        while (n < dArray.length) {
            d2 += (dArray[n] - d) * (dArray[n] - d);
            ++n;
        }
        return d2 / (double)(dArray.length - 1);
    }
}

